/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.appscan.sa.prefix.main.StringPrefix;
import com.ibm.appscan.sa.prefix.main.StringPrefixAnalysis;
import com.ibm.wala.andromeda.cg.TICallGraph;
import com.ibm.wala.andromeda.cg.util.TaintAnalysisCache;
import com.ibm.wala.andromeda.core.BFSPathsFinder;
import com.ibm.wala.andromeda.core.BasicPropagationWitness;
import com.ibm.wala.andromeda.core.DeadEndVariable;
import com.ibm.wala.andromeda.core.DependenceMap;
import com.ibm.wala.andromeda.core.FieldPropagationWitness;
import com.ibm.wala.andromeda.core.FunctionCallPropagationWitness;
import com.ibm.wala.andromeda.core.IPropagationWitness;
import com.ibm.wala.andromeda.core.InvocationKey;
import com.ibm.wala.andromeda.core.NullPropagationWitness;
import com.ibm.wala.andromeda.core.PartialPropagationWitness;
import com.ibm.wala.andromeda.core.RawAnalysisResult;
import com.ibm.wala.andromeda.core.SummaryPropagationWitness;
import com.ibm.wala.andromeda.core.TaintGraphUtils;
import com.ibm.wala.andromeda.core.TaintedLexicalAccesses;
import com.ibm.wala.andromeda.core.TransitivePropagationWitness;
import com.ibm.wala.andromeda.core.UnknownFieldPropagationWitness;
import com.ibm.wala.andromeda.core.UnknownInvokePropagationWitness;
import com.ibm.wala.andromeda.core.UnknownMethodObject;
import com.ibm.wala.andromeda.core.Variable;
import com.ibm.wala.andromeda.core.VariableRegistry;
import com.ibm.wala.andromeda.core.ViolationVariable;
import com.ibm.wala.andromeda.diagnostics.TimedSection;
import com.ibm.wala.andromeda.diagnostics.Timing;
import com.ibm.wala.andromeda.frameworks.FrameworkSupport;
import com.ibm.wala.andromeda.harness.TaintResult;
import com.ibm.wala.andromeda.harness.TaintRunner;
import com.ibm.wala.andromeda.incremental.BasicSupportGraph;
import com.ibm.wala.andromeda.incremental.ChangeSet;
import com.ibm.wala.andromeda.incremental.ISupportGraph;
import com.ibm.wala.andromeda.incremental.SummaryCache;
import com.ibm.wala.andromeda.lang.IAction;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.ObjectProperties;
import com.ibm.wala.andromeda.lang.OverwriteInfo;
import com.ibm.wala.andromeda.lang.SPAServices;
import com.ibm.wala.andromeda.management.AnalysisOptions;
import com.ibm.wala.andromeda.models.IOfflineSpecification;
import com.ibm.wala.andromeda.models.OfflineSpecification;
import com.ibm.wala.andromeda.modular.FlowAnalyzer;
import com.ibm.wala.andromeda.policy.IPropagationPolicy;
import com.ibm.wala.andromeda.policy.ReanalysisPropagationPolicy;
import com.ibm.wala.andromeda.rules.management.Field;
import com.ibm.wala.andromeda.rules.management.FullPathFieldsInformation;
import com.ibm.wala.andromeda.rules.management.MemberReferenceInfo;
import com.ibm.wala.andromeda.rules.management.Method;
import com.ibm.wala.andromeda.util.ErrorLog;
import com.ibm.wala.andromeda.util.Output;
import com.ibm.wala.andromeda.util.TaintFilter;
import com.ibm.wala.andromeda.util.Triple;
import com.ibm.wala.andromeda.util.io.TaintFileProvider;
import com.ibm.wala.andromeda.util.logging.DebugOutput;
import com.ibm.wala.cast.ir.ssa.AstAssertInstruction;
import com.ibm.wala.cast.ir.ssa.AstEchoInstruction;
import com.ibm.wala.cast.ir.ssa.AstGlobalRead;
import com.ibm.wala.cast.ir.ssa.AstGlobalWrite;
import com.ibm.wala.cast.ir.ssa.AstIsDefinedInstruction;
import com.ibm.wala.cast.ir.ssa.AstLexicalAccess;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.cast.ir.ssa.EachElementGetInstruction;
import com.ibm.wala.cast.ir.ssa.EachElementHasNextInstruction;
import com.ibm.wala.cast.js.ipa.summaries.JavaScriptSummarizedFunction;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.ssa.JSInstructionFactory;
import com.ibm.wala.cast.js.ssa.JavaScriptCheckReference;
import com.ibm.wala.cast.js.ssa.JavaScriptInstanceOf;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyRead;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyWrite;
import com.ibm.wala.cast.js.ssa.JavaScriptTypeOfInstruction;
import com.ibm.wala.cast.js.ssa.JavaScriptWithRegion;
import com.ibm.wala.cast.js.ssa.PrototypeLookup;
import com.ibm.wala.cast.js.ssa.SetPrototype;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.dataflow.IFDS.TabulationDomain;
import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DefaultPointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.rta.CallSite;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.ReflectiveMemberAccess;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAAbstractUnaryInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAFieldAccessInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.Filter;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.labeled.AbstractNumberedLabeledGraph;
import com.ibm.wala.util.graph.labeled.SlowSparseNumberedLabeledGraph;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.perf.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaintAnalyzer {
    private static final boolean DEFAULT_DEBUG = false;
    private static final boolean DEFAULT_DEBUG_ANALYZE_VARIABLE = false;
    private static Output fileOuts;
    private static boolean DEBUG;
    private static boolean DEBUG_ANALYZE_VARIABLE;
    private static final boolean RUN_BACKWARDS_PROPAGATION = true;
    public static boolean ENABLE_SPECIAL_TREATMENT_FOR_SESSION_OBJECTS;
    private static final boolean PARANOID = false;
    private static final boolean VERBOSE = false;
    private static final boolean PRINT_STATUS_MESSAGE = false;
    public static final String OFFLINE_CANDIDATES_PATH = "./candidates.txt";
    public static boolean GENERATE_CANDIDATES_FILE;
    public static final Set<IMethod> offlineCandidates;
    private static final boolean IS_VARIABLE_AGING_ENABLED = false;
    private static final boolean USE_BOUNDS = false;
    private static final boolean LOG_DEBUG_HOOK = false;
    private static final Filter<IMethod> LOG_DEBUG_FILTER;
    public static final int ARRAY_INDEX_USE_INDEX = 1;
    private static final int ARRAY_VALUE_USE_INDEX = 2;
    private static final int MAP_REF_USE_INDEX = 0;
    private static final int MAP_KEY_USE_INDEX = 1;
    private static final int MAP_VALUE_USE_INDEX = 2;
    private static final int FIELD_PUT_GET_REF_USE_INDEX = 0;
    private static final int FIELD_PUT_VALUE_USE_INDEX = 1;
    private static final int FIELD_GET_OBJECT_REF_USE_INDEX = 0;
    public static final int ARRAY_REF_USE_INDEX = 0;
    private static final int PROP_WRITE_OBJECT_REF_INDEX = 0;
    private static final int PROP_WRITE_MEMBER_REF_INDEX = 1;
    private static final int PROP_WRITE_VALUE_INDEX = 2;
    private static final int PROP_READ_OBJECT_REF_INDEX = 0;
    public static final MethodReference CTOR_NEW_INSTANCE;
    private static final Selector GET_SELECTOR;
    private static final Selector GET_ATTRIBUTE_SELECTOR;
    private static final Selector PUT_SELECTOR;
    private static final Selector SET_ATTRIBUTE_SELECTOR;
    private static final TypeReference HTTP_SESSION_TYPE_REF;
    private static final int MAX_PROPAGATION_STEPS_FOR_ONDEMAND_SUMMARY = 250000;
    private final int maxPropagationSteps;
    private final IClassHierarchy cha;
    private final VariableRegistry discovered;
    private final VariableRegistry explored;
    private final ISupportGraph supportGraph = new BasicSupportGraph();
    private final Map<Variable, Set<Variable>> waitingList = HashMapFactory.make();
    private final Map<FieldReference, Set<IMethod>> allStaticGetFields;
    private final Map<FieldReference, Set<Variable>> taintedStaticGetFields = HashMapFactory.make();
    private final AbstractNumberedLabeledGraph<Variable, IPropagationWitness> propagationGraph = new SlowSparseNumberedLabeledGraph((Object)NullPropagationWitness.soleInstance());
    private final DependenceMap<Variable> dependenceMap = new DependenceMap();
    private final TaintFilter sourcesFilter;
    private final TaintFilter sanitizersFilter;
    private final TaintFilter sinksFilter;
    private final Collection<Field> srcFields;
    private final Set<OverwriteInfo> methodOverwrites;
    private final FullPathFieldsInformation sanitizerSrcFieldRefs;
    private final FullPathFieldsInformation sanitizerSinkFieldRefs;
    private final FullPathFieldsInformation srcFieldRefs;
    private final FullPathFieldsInformation sinkFieldRefs;
    private final Map<InvocationKey, Set<MemberReferenceInfo>> srcMethodRefs;
    private final Map<InvocationKey, Set<MemberReferenceInfo>> sinkMethodRefs;
    private final Collection<CGNode> sanitizerNodes;
    private final Set<Variable> _seeds = HashSetFactory.make();
    private final IOfflineSpecification spec;
    private final TICallGraph cg;
    private final Filter<Pair<Variable, SSAAbstractInvokeInstruction>> shortCircuitFilter;
    private final ILanguageSpecificServicesForFastanalysis langServices;
    private final String originalURL;
    private final TaintedLexicalAccesses taintedLexicals;
    private static final boolean ANALYSIS_TIMEOUT_ENABLED = true;
    private static final int ANALYSIS_TIMEOUT_VALUE_MIN = 0;
    private static final int ANALYSIS_TIMEOUT_VAL_SEC = 40;
    private static final long ANALYSIS_TIMEOUT_VALUE_TOTAL_MS = 40000L;
    private final Stopwatch analysisTimeoutTimer;
    private static final boolean ENABLE_ACCOUNTED_FOR_SIDE_EFFECTS_HISTORY_CHECK = true;
    private final Set<Pair<Variable, Variable>> accountedForSideEffectsBetweenParams = HashSetFactory.make();
    private static final boolean ENABLE_RECORD_FLOW_HISTORY_CHECKING = true;
    private final Set<Pair<Pair<Variable, Variable>, Pair<IPropagationWitness, Boolean>>> recordFlowHistory = HashSetFactory.make();
    private IPropagationPolicy propagationPolicy = AnalysisOptions.getPropagationPolicy();
    private Filter<Variable> canSummarizeFilter = new Filter<Variable>(){

        public boolean accepts(Variable variable) {
            return TaintAnalyzer.this.langServices.isParameter(variable);
        }
    };
    private final boolean usingSPA;
    private final StringPrefixAnalysis spa;
    private TabulationResult<BasicBlockInContext<IExplodedBasicBlock>, CGNode, StringPrefix> spaResults;
    private final Set<Pair<Variable, Variable>> history = HashSetFactory.make();

    public static void setDebugging(boolean doDebugging) {
        if (doDebugging) {
            // empty if block
        }
        DEBUG = false;
        if (doDebugging) {
            // empty if block
        }
        DEBUG_ANALYZE_VARIABLE = false;
        TaintResult.DEBUG = doDebugging;
    }

    public static void setOutput(Output o) {
        fileOuts = o;
    }

    public TaintAnalyzer(IClassHierarchy cha, Collection<MethodReference> sources, Collection<MethodReference> sanitizers, Collection<MethodReference> sinks, ILanguageSpecificServicesForFastanalysis langServices, TICallGraph cg) throws ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException {
        this(cha, sources, sanitizers, sinks, langServices, OfflineSpecification.loadDefaultSpec(cha, langServices, langServices), cg);
    }

    public TaintAnalyzer(IClassHierarchy cha, Pair<Collection<Method>, Collection<Field>> srcs, Set<Variable> dynamicSourceFields, Collection<Method> sanitizers, Pair<Collection<Method>, Collection<Field>> sinks, FullPathFieldsInformation dynamicSinkFields, Map<InvocationKey, Set<MemberReferenceInfo>> dynamicSinkMethods, ILanguageSpecificServicesForFastanalysis langServices, IOfflineSpecification spec, TICallGraph cg, String originalURL, boolean runSPA) throws ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException {
        GENERATE_CANDIDATES_FILE = langServices.allowGenerateCandidatesFile();
        this.cha = cha;
        this.discovered = new VariableRegistry(this.cha);
        this.explored = new VariableRegistry(this.cha);
        this.shortCircuitFilter = this.createShortCircuitFilter();
        this.langServices = langServices;
        this.spec = spec;
        this.cg = cg;
        this.maxPropagationSteps = -1;
        this.srcFields = (Collection)srcs.snd;
        this.methodOverwrites = HashSetFactory.make();
        boolean findSrcMethodOverwrites = false;
        boolean findSinkMethodOverwrites = false;
        boolean findSanitizerMethodOverwrites = true;
        FindRefRet srcRefs = this.findRefs(srcs, false);
        FindRefRet sinkRefs = this.findRefs(sinks, false);
        this.sanitizerNodes = this.findJSNodes(sanitizers, true);
        this.sourcesFilter = null;
        this.sanitizersFilter = null;
        this.sinksFilter = null;
        this.srcMethodRefs = srcRefs.methodsMap;
        this.sinkMethodRefs = sinkRefs.methodsMap;
        this.sinkMethodRefs.putAll(dynamicSinkMethods);
        this.srcFieldRefs = srcRefs.fieldsMap;
        this.sinkFieldRefs = sinkRefs.fieldsMap;
        this.sinkFieldRefs.combine(dynamicSinkFields);
        this.sanitizerSrcFieldRefs = srcRefs.untaintedFieldsMap;
        this.sanitizerSinkFieldRefs = sinkRefs.untaintedFieldsMap;
        this.taintedLexicals = new TaintedLexicalAccesses(cg);
        this.taintedLexicals.findAccesses();
        this.allStaticGetFields = HashMapFactory.make();
        this.originalURL = originalURL;
        this.initialize(this.srcMethodRefs, dynamicSourceFields);
        this.usingSPA = runSPA;
        if (runSPA) {
            this.spa = this.langServices.runStringPrefixAnalysis(cg, langServices, this.originalURL);
            try {
                this.spaResults = this.spa.run();
            }
            catch (CancelException e) {
                e.printStackTrace();
                this.spaResults = null;
                Assertions.UNREACHABLE((String)"The SPA got canceled");
            }
        } else {
            this.spa = null;
            this.spaResults = null;
        }
        this.analysisTimeoutTimer = new Stopwatch();
        this.analysisTimeoutTimer.start();
    }

    public TaintAnalyzer(IClassHierarchy cha, Collection<MethodReference> sources, Collection<MethodReference> sanitizers, Collection<MethodReference> sinks, ILanguageSpecificServicesForFastanalysis langServices, IOfflineSpecification spec, TICallGraph cg) throws ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException {
        GENERATE_CANDIDATES_FILE = langServices.allowGenerateCandidatesFile();
        this.cha = cha;
        this.discovered = new VariableRegistry(this.cha);
        this.explored = new VariableRegistry(this.cha);
        this.shortCircuitFilter = this.createShortCircuitFilter();
        this.langServices = langServices;
        this.spec = spec;
        this.cg = cg;
        this.sourcesFilter = TaintFilter.createFilter((IClassHierarchy)this.cha, sources);
        this.sanitizersFilter = TaintFilter.createFilter((IClassHierarchy)this.cha, sanitizers);
        this.sinksFilter = TaintFilter.createFilter((IClassHierarchy)this.cha, sinks);
        this.maxPropagationSteps = -1;
        this.srcFieldRefs = new FullPathFieldsInformation();
        this.sinkFieldRefs = new FullPathFieldsInformation();
        this.srcMethodRefs = new HashMap<InvocationKey, Set<MemberReferenceInfo>>();
        this.sinkMethodRefs = new HashMap<InvocationKey, Set<MemberReferenceInfo>>();
        this.sanitizerSrcFieldRefs = new FullPathFieldsInformation();
        this.sanitizerSinkFieldRefs = new FullPathFieldsInformation();
        this.sanitizerNodes = HashSetFactory.make();
        this.srcFields = HashSetFactory.make();
        this.methodOverwrites = HashSetFactory.make();
        this.taintedLexicals = null;
        this.allStaticGetFields = HashMapFactory.make();
        this.originalURL = null;
        this.usingSPA = false;
        this.spa = null;
        this.spaResults = null;
        this.initialize(sources);
        this.analysisTimeoutTimer = new Stopwatch();
        this.analysisTimeoutTimer.start();
    }

    public TaintAnalyzer(IClassHierarchy cha, Collection<MethodReference> sources, Collection<MethodReference> sanitizers, Collection<MethodReference> sinks, ILanguageSpecificServicesForFastanalysis langServices, IOfflineSpecification spec, TICallGraph cg, Map<FieldReference, Set<IMethod>> allStaticGetFields) throws ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException {
        GENERATE_CANDIDATES_FILE = langServices.allowGenerateCandidatesFile();
        this.cha = cha;
        this.discovered = new VariableRegistry(this.cha);
        this.explored = new VariableRegistry(this.cha);
        this.shortCircuitFilter = this.createShortCircuitFilter();
        this.langServices = langServices;
        this.spec = spec;
        this.cg = cg;
        this.sourcesFilter = TaintFilter.createFilter((IClassHierarchy)this.cha, sources);
        this.sanitizersFilter = TaintFilter.createFilter((IClassHierarchy)this.cha, sanitizers);
        this.sinksFilter = TaintFilter.createFilter((IClassHierarchy)this.cha, sinks);
        this.maxPropagationSteps = -1;
        this.srcFieldRefs = new FullPathFieldsInformation();
        this.sinkFieldRefs = new FullPathFieldsInformation();
        this.srcMethodRefs = new HashMap<InvocationKey, Set<MemberReferenceInfo>>();
        this.sinkMethodRefs = new HashMap<InvocationKey, Set<MemberReferenceInfo>>();
        this.sanitizerSrcFieldRefs = new FullPathFieldsInformation();
        this.sanitizerSinkFieldRefs = new FullPathFieldsInformation();
        this.sanitizerNodes = HashSetFactory.make();
        this.srcFields = HashSetFactory.make();
        this.methodOverwrites = HashSetFactory.make();
        this.taintedLexicals = null;
        this.allStaticGetFields = allStaticGetFields;
        this.originalURL = null;
        this.usingSPA = false;
        this.spa = null;
        this.spaResults = null;
        this.initializeSources(sources);
        this.analysisTimeoutTimer = new Stopwatch();
        this.analysisTimeoutTimer.start();
    }

    public TaintAnalyzer(IClassHierarchy cha, TaintFilter sourcesFilter, TaintFilter sanitizersFilter, TaintFilter sinksFilter, ILanguageSpecificServicesForFastanalysis langServices, TICallGraph cg, IOfflineSpecification spec, Collection<Variable> additionalSeeds, Map<FieldReference, Set<IMethod>> allStaticGetFields, int maxPropagationSteps) {
        GENERATE_CANDIDATES_FILE = langServices.allowGenerateCandidatesFile();
        this.cha = cha;
        this.discovered = new VariableRegistry(this.cha);
        this.explored = new VariableRegistry(this.cha);
        this.shortCircuitFilter = this.createShortCircuitFilter();
        this.langServices = langServices;
        this.spec = spec;
        this.cg = cg;
        this.sourcesFilter = sourcesFilter;
        this.sanitizersFilter = sanitizersFilter;
        this.sinksFilter = sinksFilter;
        this.maxPropagationSteps = maxPropagationSteps;
        this.srcFieldRefs = new FullPathFieldsInformation();
        this.sinkFieldRefs = new FullPathFieldsInformation();
        this.srcMethodRefs = new HashMap<InvocationKey, Set<MemberReferenceInfo>>();
        this.sinkMethodRefs = new HashMap<InvocationKey, Set<MemberReferenceInfo>>();
        this.sanitizerSrcFieldRefs = new FullPathFieldsInformation();
        this.sanitizerSinkFieldRefs = new FullPathFieldsInformation();
        this.sanitizerNodes = HashSetFactory.make();
        this.srcFields = HashSetFactory.make();
        this.methodOverwrites = HashSetFactory.make();
        this.taintedLexicals = null;
        this.originalURL = null;
        this.usingSPA = false;
        this.spa = null;
        this.spaResults = null;
        this.canSummarizeFilter = new Filter<Variable>(){

            public boolean accepts(Variable o) {
                return false;
            }
        };
        this.allStaticGetFields = allStaticGetFields;
        this.initializeSources(this.sourcesFilter.getTaintAPIs());
        for (Variable v : additionalSeeds) {
            this.registerSeed(v);
        }
        this.analysisTimeoutTimer = new Stopwatch();
        this.analysisTimeoutTimer.start();
    }

    private TaintAnalyzer(IClassHierarchy cha, TaintFilter sourcesFilter, TaintFilter sanitizersFilter, TaintFilter sinksFilter, ILanguageSpecificServicesForFastanalysis langServices, TICallGraph cg, IOfflineSpecification spec, Collection<Variable> additionalSeeds, int maxPropagationSteps) {
        GENERATE_CANDIDATES_FILE = langServices.allowGenerateCandidatesFile();
        this.cha = cha;
        this.discovered = new VariableRegistry(this.cha);
        this.explored = new VariableRegistry(this.cha);
        this.shortCircuitFilter = this.createShortCircuitFilter();
        this.langServices = langServices;
        this.spec = spec;
        this.cg = cg;
        this.sourcesFilter = sourcesFilter;
        this.sanitizersFilter = sanitizersFilter;
        this.sinksFilter = sinksFilter;
        this.maxPropagationSteps = maxPropagationSteps;
        this.srcFieldRefs = new FullPathFieldsInformation();
        this.sinkFieldRefs = new FullPathFieldsInformation();
        this.srcMethodRefs = new HashMap<InvocationKey, Set<MemberReferenceInfo>>();
        this.sinkMethodRefs = new HashMap<InvocationKey, Set<MemberReferenceInfo>>();
        this.sanitizerSrcFieldRefs = new FullPathFieldsInformation();
        this.sanitizerSinkFieldRefs = new FullPathFieldsInformation();
        this.sanitizerNodes = HashSetFactory.make();
        this.srcFields = HashSetFactory.make();
        this.methodOverwrites = HashSetFactory.make();
        this.taintedLexicals = null;
        this.originalURL = null;
        this.usingSPA = false;
        this.spa = null;
        this.spaResults = null;
        this.canSummarizeFilter = new Filter<Variable>(){

            public boolean accepts(Variable o) {
                return false;
            }
        };
        this.allStaticGetFields = HashMapFactory.make();
        this.initialize(this.sourcesFilter.getTaintAPIs());
        for (Variable v : additionalSeeds) {
            this.registerSeed(v);
        }
        this.analysisTimeoutTimer = new Stopwatch();
        this.analysisTimeoutTimer.start();
    }

    protected void addSeed(Variable v) {
        this._seeds.add(v);
    }

    protected Set<Variable> getSeeds() {
        return this._seeds;
    }

    private Collection<CGNode> findJSNodes(Collection<Method> methods, boolean detectMethodOverwrites) {
        if (detectMethodOverwrites) {
            Pair<Collection<Method>, Collection<OverwriteInfo>> r = this.langServices.detectMethodOverwrites(methods, this.cg);
            this.methodOverwrites.addAll((Collection)r.snd);
            methods = (Collection)r.fst;
        }
        return this.langServices.getCGNodes((CallGraph)this.cg, methods);
    }

    private Map<InvocationKey, Set<MemberReferenceInfo>> findJSMethodRefs(Collection<Method> methods, boolean flagMethodOverwrites) {
        if (flagMethodOverwrites) {
            Pair<Collection<Method>, Collection<OverwriteInfo>> r = this.langServices.detectMethodOverwrites(methods, this.cg);
            this.methodOverwrites.addAll((Collection)r.snd);
            methods = (Collection)r.fst;
        }
        return this.langServices.getMethodRefsFromMethods(methods, this.cg);
    }

    private Pair<FullPathFieldsInformation, FullPathFieldsInformation> findFieldRefs(Collection<Field> fields) {
        return this.langServices.getFieldRefsFromSigs(fields, this.cg);
    }

    private FindRefRet findRefs(Pair<Collection<Method>, Collection<Field>> members, boolean detectMethodOverwrites) {
        Pair<FullPathFieldsInformation, FullPathFieldsInformation> fieldsAndSanitizers = this.findFieldRefs((Collection)members.snd);
        return new FindRefRet(this.findJSMethodRefs((Collection)members.fst, detectMethodOverwrites), (FullPathFieldsInformation)fieldsAndSanitizers.fst, (FullPathFieldsInformation)fieldsAndSanitizers.snd);
    }

    private void logDebugHook() {
    }

    private boolean findOrMaybeCreatePartialSummary(Variable variable) {
        if (this.langServices.isModularAnalysisEnabled()) {
            IMethod m = variable.getMethod();
            if (this.spec.hasPartialSpec(m, variable)) {
                return true;
            }
            if (this.canSummarizeFilter.accepts((Object)variable)) {
                return this.summarizeOnDemand(variable);
            }
            return false;
        }
        return false;
    }

    private boolean summarizeOnDemand(Variable cause) {
        IMethod m = cause.getMethod();
        TaintAnalyzer ta = new TaintAnalyzer(this.cha, this.sourcesFilter, this.sanitizersFilter, this.sinksFilter, this.langServices, this.cg, this.spec, Collections.singleton(cause), -1);
        RawAnalysisResult analysisResult = ta.run();
        Set<SummaryCache.TaintRelation> relations = SummaryCache.soleInstance().getMethodSummary(m);
        HashSet conditionalEffects = HashSetFactory.make();
        if (relations != null) {
            Context context = cause.getContext();
            for (SummaryCache.TaintRelation taintRelation : relations) {
                SummaryCache.TaintRelation.Kind kind = taintRelation.getKind();
                int summaryIndex = taintRelation.getPostcondition().getParameterIndex();
                if (kind == SummaryCache.TaintRelation.Kind.CONDITIONAL) {
                    conditionalEffects.add(Variable.failOrCreate(m, context, summaryIndex, taintRelation.getPostcondition().getAccessPath(), this.langServices));
                    continue;
                }
                if (kind == SummaryCache.TaintRelation.Kind.UNCONDITIONAL_CAUSE) {
                    Variable seed = ((SummaryCache.UnconditionalCauseRelation)taintRelation).getUnconditionalCause();
                    Set<CallSite> calls = this.cg.scanForCalls((Collection<IMethod>)Collections.singleton(m));
                    for (CallSite cs : calls) {
                        CGNode callerNode = cs.getNode();
                        IMethod callerMethod = callerNode.getMethod();
                        Context callerContext = callerNode.getContext();
                        IR ir = TaintAnalysisCache.soleInstance().getIR(callerNode);
                        if (ir == null) continue;
                        for (SSAAbstractInvokeInstruction invoke : ir.getCalls(cs.getSite())) {
                            int actual = summaryIndex == -1 ? invoke.getDef() : invoke.getUse(summaryIndex - 1);
                            Variable effect = Variable.failOrCreate(callerMethod, callerContext, actual, taintRelation.getPostcondition().getAccessPath(), this.langServices);
                            this.registerSeed(seed);
                            this.recordFlow(seed, effect, new PartialPropagationWitness(m, context));
                        }
                    }
                    continue;
                }
                assert (kind == SummaryCache.TaintRelation.Kind.UNCONDITIONAL_EFFECT) : "ERROR: expected taint-relation kind to be 'UNCONDITIONAL_EFFECT'!";
            }
        }
        this.spec.addPartialSummary(cause, conditionalEffects);
        Collection<List<Variable>> paths = TaintGraphUtils.solve(analysisResult.getPropagationGraph(), analysisResult.getPropagationSeeds());
        for (List list : paths) {
            for (int index = 0; index < list.size() - 1; ++index) {
                this.explored.add((Variable)list.get(index + 1));
                for (IPropagationWitness witness : analysisResult.getPropagationGraph().getEdgeLabels(list.get(index), list.get(index + 1))) {
                    this.recordFlow((Variable)list.get(index), (Variable)list.get(index + 1), witness, true);
                }
            }
        }
        TaintAnalysisCache.setCallGraph(this.cg);
        return true;
    }

    private String prettyPrint(Variable variable) {
        StringBuilder result = new StringBuilder();
        result.append(variable.getVarID());
        if (variable.getAccessPath() != null) {
            result.append('.');
            for (int index = 0; index < variable.getAccessPath().size(); ++index) {
                FieldReference fr = variable.getAccessPath().get(index);
                if (fr == null) continue;
                result.append(fr.equals((Object)Variable.DOT_STAR) ? Character.valueOf('*') : fr.getName().toString());
                if (index >= variable.getAccessPath().size() - 1) continue;
                result.append('.');
            }
        }
        return result.toString();
    }

    private Filter<Pair<Variable, SSAAbstractInvokeInstruction>> createShortCircuitFilter() {
        return new Filter<Pair<Variable, SSAAbstractInvokeInstruction>>(){

            public boolean accepts(Pair<Variable, SSAAbstractInvokeInstruction> pair) {
                Variable v = (Variable)pair.fst;
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)pair.snd;
                MethodReference mr = invoke.getDeclaredTarget();
                Set useIndices = TaintAnalyzer.this.getUseIndices((SSAInstruction)invoke, v.getVarID());
                if (useIndices.size() == 1) {
                    int useIndex = (Integer)useIndices.iterator().next();
                    boolean isInit = mr.isInit();
                    boolean isCollection = TaintAnalyzer.this.cha.getLeastCommonSuperclass(mr.getDeclaringClass(), TypeReference.JavaUtilCollection).getName().equals((Object)TypeReference.JavaUtilCollection.getName());
                    if (isCollection && isInit && useIndex == 0) {
                        return true;
                    }
                    boolean isMap = TaintAnalyzer.this.cha.getLeastCommonSuperclass(mr.getDeclaringClass(), TypeReference.JavaUtilMap).getName().equals((Object)TypeReference.JavaUtilMap.getName());
                    if (isMap && isInit && useIndex == 0) {
                        return true;
                    }
                    List<FieldReference> accessPath = v.getAccessPath();
                    if ((accessPath == null || accessPath.size() == 1 && accessPath.contains(Variable.DOT_STAR)) && isInit && useIndex == 0) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    private void initialize(Map<InvocationKey, Set<MemberReferenceInfo>> sources, Set<Variable> dynamicSourceFields) {
        TaintAnalysisCache.soleInstance().invalidateAll();
        DebugOutput.println((boolean)DEBUG, sources);
        DebugOutput.println((boolean)DEBUG, dynamicSourceFields);
        this.accountForSourceCalls(sources);
        for (CGNode n : this.cg) {
            IMethod m = n.getMethod();
            if (this.spec.hasSpecForMethod(m)) continue;
            Map<FieldReference, Set<IMethod>> temp = this.langServices.accountForStaticGetFields(n);
            for (Map.Entry<FieldReference, Set<IMethod>> e : temp.entrySet()) {
                MapUtil.findOrCreateSet(this.allStaticGetFields, (Object)e.getKey()).addAll((Collection)e.getValue());
            }
        }
        for (Variable dsf : dynamicSourceFields) {
            this.registerSeed(dsf);
        }
    }

    private void initialize(Collection<MethodReference> sources) {
        TaintAnalysisCache.soleInstance().invalidateAll();
        this.accountForSourceCalls(sources);
        for (CGNode n : this.cg) {
            IMethod m = n.getMethod();
            if (this.spec.hasSpecForMethod(m)) continue;
            Map<FieldReference, Set<IMethod>> temp = this.langServices.accountForStaticGetFields(n);
            for (Map.Entry<FieldReference, Set<IMethod>> e : temp.entrySet()) {
                MapUtil.findOrCreateSet(this.allStaticGetFields, (Object)e.getKey()).addAll((Collection)e.getValue());
            }
        }
    }

    private void initializeSources(Collection<MethodReference> sources) {
        TaintAnalysisCache.soleInstance().invalidateAll();
        this.accountForSourceCalls(sources);
    }

    private void accountForSourceCalls(Collection<MethodReference> sources) {
        HashSet sourceMethods = HashSetFactory.make();
        for (MethodReference mr : sources) {
            sourceMethods.add(this.cha.resolveMethod(mr));
            sourceMethods.addAll(this.cha.getPossibleTargets(mr));
        }
        Set<CallSite> calls = this.cg.scanForCalls(sourceMethods);
        for (CallSite call : calls) {
            CGNode n = call.getNode();
            IMethod m = n.getMethod();
            Context c = n.getContext();
            IClass declaringClass = m.getDeclaringClass();
            if (!this.propagationPolicy.allowsLibraryLevelSources() && !m.getClassHierarchy().getScope().isApplicationLoader(declaringClass.getClassLoader())) continue;
            CallSiteReference cs = call.getSite();
            MethodReference declaredTarget = cs.getDeclaredTarget();
            IR ir = TaintAnalysisCache.soleInstance().getIR(n);
            if (ir == null) continue;
            for (SSAAbstractInvokeInstruction invoke : ir.getCalls(cs)) {
                int varID = invoke.getDef();
                Variable v = Variable.failOrCreate(m, c, varID, declaredTarget.getReturnType().isPrimitiveType() ? null : Variable.dotStarAccessPath(), this.langServices);
                this.registerSeed(v);
            }
        }
        for (Variable v : this.langServices.augmentSources(this.cg, null)) {
            this.registerSeed(v);
        }
    }

    private void accountForSourceCalls(Map<InvocationKey, Set<MemberReferenceInfo>> sources) {
        HashSet calls = HashSetFactory.make();
        for (Map.Entry<InvocationKey, Set<MemberReferenceInfo>> sourceEntry : sources.entrySet()) {
            InvocationKey key = sourceEntry.getKey();
            CGNode n = key.getNode();
            ProgramCounter pc = new ProgramCounter(key.getPc());
            SSAInstruction instr = n.getIR().getPEI(pc);
            if (!(instr instanceof SSAAbstractInvokeInstruction)) {
                Assertions.UNREACHABLE((String)"We didn't get an invoke and we really wanted to");
            }
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instr;
            calls.add(new CallSite(invoke.getCallSite(), n));
        }
        this.findAndRegisterSeeds(calls);
    }

    private void findAndRegisterSeeds(Set<CallSite> calls) {
        for (CallSite call : calls) {
            CGNode n = call.getNode();
            IMethod m = n.getMethod();
            IClass declaringClass = m.getDeclaringClass();
            if (!this.propagationPolicy.allowsLibraryLevelSources() && !m.getClassHierarchy().getScope().isApplicationLoader(declaringClass.getClassLoader())) continue;
            CallSiteReference cs = call.getSite();
            MethodReference declaredTarget = cs.getDeclaredTarget();
            IR ir = TaintAnalysisCache.soleInstance().getIR(n);
            if (ir == null) continue;
            for (SSAAbstractInvokeInstruction invoke : ir.getCalls(cs)) {
                int varID = invoke.getDef();
                Variable v = Variable.failOrCreate(m, n.getContext(), varID, declaredTarget.getReturnType().isPrimitiveType() ? null : Variable.dotStarAccessPath(), this.langServices);
                this.registerSeed(v);
            }
        }
        for (Variable v : this.langServices.augmentSources(this.cg, this.srcFields)) {
            this.registerSeed(v);
        }
    }

    private void registerSeed(Variable v) {
        this.addSeed(v);
        this.dependenceMap.registerElement(v);
    }

    private boolean isSource(FieldReference f) {
        return this.srcFieldRefs.hasFR(f);
    }

    private boolean isSourceForUnknownField(ReflectiveMemberAccess rma, Set<CGNode> nodes) {
        for (CGNode n : nodes) {
            LocalPointerKey lpk = new LocalPointerKey(n, rma.getObjectRef());
            if (!this.sinkFieldRefs.hasIK(lpk)) continue;
            return true;
        }
        return false;
    }

    private boolean isSink(FieldReference f) {
        return this.sinkFieldRefs.hasFR(f);
    }

    private boolean isSanitizer(FieldReference f) {
        return this.sanitizerSrcFieldRefs.hasFR(f);
    }

    private boolean isSinkForUnkownField(ReflectiveMemberAccess rma, CGNode n) {
        LocalPointerKey lpk = new LocalPointerKey(n, rma.getObjectRef());
        return this.srcFieldRefs.hasIK(lpk);
    }

    public Set<MemberReferenceInfo> getMemberRefInfoForSource(FieldReference f) {
        return this.srcFieldRefs.getMRIs(f);
    }

    public Set<MemberReferenceInfo> getMemberRefInfoForSink(FieldReference f) {
        return this.sinkFieldRefs.getMRIs(f);
    }

    private Set<MemberReferenceInfo> getMRIsForUnknownFieldSink(ReflectiveMemberAccess rma, CGNode n) {
        HashSet ret = HashSetFactory.make();
        LocalPointerKey lpk = new LocalPointerKey(n, rma.getObjectRef());
        ret.addAll(this.sinkFieldRefs.getPartialPathMRIs(lpk));
        return ret;
    }

    public static boolean isJavaScript(IMethod m) {
        if (m instanceof JavaScriptSummarizedFunction) {
            return true;
        }
        return m instanceof JavaScriptLoader.JavaScriptMethodObject;
    }

    public Collection<Pair<IMethod, Context>> getPossibleTargets(IMethod caller, Context callerContext, CallSiteReference site, boolean applyCalleeSummary) {
        Collection<Pair<IMethod, Context>> result = null;
        if (TaintAnalyzer.isJavaScript(caller)) {
            result = this.langServices.getTargetsFromCallGraph(this.cg, caller, callerContext, site);
        } else {
            IMethod m;
            MethodReference mr = site.getDeclaredTarget();
            IClass k = this.cha.lookupClass(mr.getDeclaringClass());
            if (k != null && this.spec.hasSpecForMethod(m = k.getMethod(mr.getSelector()))) {
                Pair r = Pair.make((Object)m, (Object)Everywhere.EVERYWHERE);
                result = Collections.singleton(r);
            }
            if (result == null) {
                result = this.langServices.getTargetsFromCallGraph(this.cg, caller, callerContext, site);
            }
        }
        if (applyCalleeSummary) {
            for (Pair<IMethod, Context> target : result) {
                IMethod targetMethod = (IMethod)target.fst;
                Context targetContext = (Context)target.snd;
                this.applyCalleeSummary(caller, callerContext, site, targetMethod, targetContext);
            }
        }
        return result;
    }

    private void applyCalleeSummary(IMethod caller, Context callerContext, CallSiteReference site, IMethod target, Context targetContext) {
        Set<Variable> exploredFormals;
        Set<SummaryCache.TaintRelation> summary = SummaryCache.soleInstance().getMethodSummary(target);
        if (summary != null) {
            HashSet clone = HashSetFactory.make(summary);
            for (SummaryCache.TaintRelation tr : clone) {
                Set<Pair<Variable, Variable>> callerLevelConstraints = tr.apply(caller, callerContext, site);
                for (Pair<Variable, Variable> callerLevelConstraint : callerLevelConstraints) {
                    DebugOutput.println((boolean)DEBUG, (String)"Summaries use the target context for their prop. witness instead of everywhere.everywhere");
                    this.recordFlow((Variable)callerLevelConstraint.fst, (Variable)callerLevelConstraint.snd, new PartialPropagationWitness(target, targetContext));
                }
            }
        }
        if (this.spec.hasSpecForMethod(target) && (exploredFormals = this.explored.getVariables(target)) != null) {
            for (Variable exploredFormal : exploredFormals) {
                if (!this.langServices.isParameter(exploredFormal)) {
                    if (!DEBUG) continue;
                    System.err.println("We are exploring a variable inside a method that was summarized offline");
                    System.err.println("--- We think we are doing this because we did a search for globals and that used pointer analysis, so we may have found aliases inside summarized methods");
                    continue;
                }
                this.applyOfflineSummary(exploredFormal);
            }
        }
    }

    public RawAnalysisResult run() {
        SummaryCache.soleInstance().invalidateAll();
        HashSet discovered = HashSetFactory.make();
        for (Variable element : this.dependenceMap.getElements()) {
            discovered.add(element);
        }
        AnalysisTime solveTime = this.solve(discovered);
        this.logDebugHook();
        return new RawAnalysisResult(this.propagationGraph, this.supportGraph, this.getSeeds(), this.methodOverwrites, solveTime.getTime(), solveTime.getTimedOut());
    }

    public RawAnalysisResult analyze(ChangeSet cs) throws InvalidClassFileException {
        this.propagationPolicy = ReanalysisPropagationPolicy.recycleOrCreate(this.propagationPolicy);
        this.dependenceMap.clear();
        HashSet newVariables = HashSetFactory.make();
        for (ChangeSet.Entry e : cs) {
            assert (e instanceof ChangeSet.MethodEntry) : "ERROR: the only change-set entry currently supported is 'MethodEntry'.";
            ChangeSet.MethodEntry me = (ChangeSet.MethodEntry)e;
            IMethod m = this.cha.resolveMethod(me.getMethod());
            TaintAnalysisCache.soleInstance().invalidate(m);
            if (m != null) {
                switch (e.getKind()) {
                    case ADDITION: {
                        newVariables.addAll(this.handleMethodAddition(m));
                        break;
                    }
                    case REMOVAL: {
                        this.handleMethodRemoval(m);
                        break;
                    }
                    case MODIFICATION: {
                        this.handleMethodRemoval(m);
                        newVariables.addAll(this.handleMethodAddition(m));
                        break;
                    }
                    default: {
                        Assertions.UNREACHABLE();
                    }
                }
            }
            this.explored.removeAll(newVariables);
            this.langServices.removeFromBackwardsAliasExplored(newVariables);
            for (Variable newVariable : newVariables) {
                this.dependenceMap.registerElement(newVariable);
            }
        }
        this.solve(newVariables);
        return new RawAnalysisResult(this.propagationGraph, this.supportGraph, this.getSeeds());
    }

    private void handleMethodRemoval(IMethod m) {
        Set<IMethod> obsoleted = this.invalidateConstraints(m);
        for (IMethod obsolete : obsoleted) {
            TaintAnalysisCache.soleInstance().invalidate(obsolete);
        }
    }

    private Set<Variable> handleMethodAddition(IMethod m) throws InvalidClassFileException {
        return this.establishPreconditions(m);
    }

    private boolean analysisTimedOut() {
        boolean ret;
        this.analysisTimeoutTimer.stop();
        long time = this.analysisTimeoutTimer.getElapsedMillis();
        this.analysisTimeoutTimer.start();
        boolean bl = ret = time > 40000L;
        if (ret) {
            DebugOutput.println((String)"timed out during taint analysis");
        }
        return ret;
    }

    private AnalysisTime solve(Set<Variable> worklist) {
        int MAX_WORKLIST_SIZE_THRESHOLD = 10000;
        int MIN_WORKLIST_SIZE_THRESHOLD = 1000;
        HashSet blocked = HashSetFactory.make();
        Set<Variable> initialBlocked = this.guessSubset(worklist, worklist.size() - 10000);
        blocked.addAll(initialBlocked);
        worklist.removeAll(initialBlocked);
        int workListRefillCount = 0;
        while (!this.analysisTimedOut() && !worklist.isEmpty()) {
            DebugOutput.println((String)("Reupping work list: " + ++workListRefillCount));
            assert (worklist.size() <= 10000);
            Iterator<Variable> iter = worklist.iterator();
            worklist = HashSetFactory.make();
            while (iter.hasNext()) {
                Set<Variable> dependentsOnCurrent;
                Variable current = iter.next();
                if (this.analyze(current) && (dependentsOnCurrent = this.dependenceMap.getDependents(current)) != null) {
                    Set<Variable> subset = this.guessSubset(dependentsOnCurrent, 10000 - worklist.size());
                    worklist.addAll(subset);
                    dependentsOnCurrent.removeAll(subset);
                    blocked.addAll(dependentsOnCurrent);
                }
                if (worklist.size() > 1000) continue;
                Set<Variable> subset = this.guessSubset(blocked, 10000 - worklist.size());
                worklist.addAll(subset);
                blocked.removeAll(subset);
            }
        }
        this.analysisTimeoutTimer.stop();
        long t = this.analysisTimeoutTimer.getElapsedMillis();
        return new AnalysisTime(t, this.analysisTimedOut());
    }

    private Set<Variable> guessSubset(Set<Variable> set, int size) {
        if (size <= 0) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make();
        Iterator<Variable> iter = set.iterator();
        while (iter.hasNext() && size > 0) {
            result.add(iter.next());
            --size;
        }
        return result;
    }

    private boolean analyze(Variable variable) {
        this.discovered.clear();
        if (!this.explored.contains(variable)) {
            this.explored.add(variable);
            this.propagationGraph.addNode((Object)variable);
            if (!(variable instanceof ViolationVariable) && !(variable instanceof DeadEndVariable)) {
                this.analyzeVariable(variable);
                Set<Variable> waitingVariables = this.waitingList.get(variable);
                if (waitingVariables != null) {
                    this.discovered.addAll(waitingVariables);
                    this.waitingList.remove(variable);
                }
                for (Variable v : this.discovered) {
                    this.dependenceMap.registerDependence(variable, v);
                }
            }
        }
        return this.discovered.size() > 0;
    }

    private void handleJavaScritpCheckReference() {
    }

    private void handleJavaScriptInstanceOf() {
    }

    private void handleJavaScriptPropertyRead(final Variable variable, final IMethod m, final Context c, final JavaScriptPropertyRead read) {
        ObjectProperties possibleProperties = this.langServices.getProperties((ReflectiveMemberAccess)read, this.cg, m, c);
        final int objectRef = read.getObjectRef();
        final int result = read.getDef();
        this.langServices.handleObjectProperties(possibleProperties, null, new IAction<String>(){

            @Override
            public void handleKnownFieldString(String fieldName, String ignore) {
                JSInstructionFactory factory = (JSInstructionFactory)JavaScriptLoader.JS.instructionFactory();
                SSAGetInstruction get = factory.GetInstruction(-1, result, objectRef, fieldName);
                TaintAnalyzer.this.handleGetInstruction(variable, m, c, get, (SSAInstruction)read);
            }

            @Override
            public void handleNumbersProperties(String data) {
                this.handleUnknownFields(data);
            }

            @Override
            public void handleEmptyProperties(String ignore) {
                this.handleUnknownFields(ignore);
            }

            @Override
            public void handleUnknownField(Object field, String ignore) {
                Assertions.UNREACHABLE((String)"Unknown constant for property name");
                this.handleUnknownFields(ignore);
            }

            @Override
            public void handleUnknownFields(String ignore) {
                TaintAnalyzer.this.handleUnknownPropReadInstruction(variable, m, c, read);
            }
        });
    }

    private void handleJavaScriptPropertyWrite(final Variable variable, final IMethod m, final Context c, final JavaScriptPropertyWrite write) {
        ObjectProperties possibleProperties = this.langServices.getProperties((ReflectiveMemberAccess)write, this.cg, m, c);
        final int objectRef = write.getUse(0);
        final int value = write.getValue();
        this.langServices.handleObjectProperties(possibleProperties, null, new IAction<String>(){

            @Override
            public void handleEmptyProperties(String ignore) {
                this.handleUnknownFields(ignore);
            }

            @Override
            public void handleKnownFieldString(String fieldName, String ignore) {
                JSInstructionFactory factory = (JSInstructionFactory)JavaScriptLoader.JS.instructionFactory();
                SSAPutInstruction put = factory.PutInstruction(-1, objectRef, value, fieldName);
                TaintAnalyzer.this.handlePutInstruction(variable, m, c, put, (SSAInstruction)write);
            }

            @Override
            public void handleNumbersProperties(String data) {
                this.handleUnknownFields(data);
            }

            @Override
            public void handleUnknownField(Object field, String ignore) {
                Assertions.UNREACHABLE((String)"Unknown constant for property name");
                this.handleUnknownFields(ignore);
            }

            @Override
            public void handleUnknownFields(String ignore) {
                TaintAnalyzer.this.handleUnknownPropWriteInstruction(variable, m, c, (ReflectiveMemberAccess)write, TaintAnalyzer.this.langServices.getCGNode(TaintAnalyzer.this.cg, m, c));
            }
        });
    }

    private void handleJavaScriptTypeOfInstruction(SSAInstruction instr) {
        DebugOutput.println((boolean)DEBUG, (String)"killing flow at a JS type of instruction. Revisit this decision later");
    }

    private void handleJavaScriptWithRegion() {
    }

    private void handleAstAssertInstruction(SSAInstruction instr) {
        Assertions.UNREACHABLE((String)("ERROR: Unsupported instruction of type " + instr.getClass().getName()));
    }

    private void handleAstGlobalRead(SSAInstruction instr) {
        Assertions.UNREACHABLE((String)("ERROR: Unsupported instruction of type " + instr.getClass().getName()));
    }

    private void handleAstGlobalWrite(AstGlobalWrite write, Variable variable) {
        if (this.isSink(write.getDeclaredField())) {
            Assertions.UNREACHABLE((String)"We don't handle AstGlobalWrite sinks yet");
        } else if (TaintAnalyzer.isJavaScript(variable.getMethod())) {
            Collection<Variable> globalAliases = this.langServices.getGlobalAliasesWithAccessPath(this.cg, (SSAInstruction)write, variable.getAccessPath());
            for (Variable alias : globalAliases) {
                this.recordFlow(variable, alias, new BasicPropagationWitness(variable.getMethod(), variable.getContext(), (SSAInstruction)write));
            }
        } else {
            Assertions.UNREACHABLE((String)"Shouldn't be here in anything except JS");
        }
    }

    private void handleAstLexicalRead(AstLexicalRead read) {
        Assertions.UNREACHABLE((String)("ERROR: Unsupported instruction of type " + read.getClass().getName()));
    }

    private void handleAstLexicalWrite(AstLexicalWrite write, Variable v, IMethod m, Context c) {
        int varID = v.getVarID();
        Collection<Variable> lexicalEffects = this.langServices.handleASTLexicalWrite(this.cg, write, varID, m, c, v);
        for (Variable lexicalEffect : lexicalEffects) {
            this.recordFlow(v, lexicalEffect, new BasicPropagationWitness(v.getMethod(), v.getContext(), (SSAInstruction)write));
        }
    }

    private void handleEachElementGetInstruction(EachElementGetInstruction get, Variable variable, IMethod m, Context c) {
        Variable effect = Variable.failOrCreate(m, c, get.getDef(), Variable.dotStarAccessPath(), this.langServices);
        this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)get));
    }

    private void handleEachElementHasNextInstruction() {
    }

    private void handleAstEchoInstruction(SSAInstruction instr) {
        Assertions.UNREACHABLE((String)("ERROR: Unsupported instruction of type " + instr.getClass().getName()));
    }

    private void handleAstIsDefinedInstruction() {
    }

    private boolean contextsEqual(Context c1, Context c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null && c2.equals(Everywhere.EVERYWHERE)) {
            return true;
        }
        if (c2 == null && c1.equals(Everywhere.EVERYWHERE)) {
            return true;
        }
        return c1.equals(c2);
    }

    private void handleSSAAbstractInvokeInstruction(Variable variable, IMethod m, Context c, SSAAbstractInvokeInstruction invoke) {
        block22: {
            IMethod syntheticTarget;
            CallSiteReference callSite;
            block23: {
                Object method;
                callSite = invoke.getCallSite();
                syntheticTarget = null;
                if (TaintRunner.USE_FRAMEWORKS) {
                    syntheticTarget = FrameworkSupport.getSyntheticTarget(m.getReference(), callSite);
                }
                MethodReference mr = null;
                mr = syntheticTarget != null ? syntheticTarget.getReference() : invoke.getDeclaredTarget();
                if (GENERATE_CANDIDATES_FILE) {
                    IMethod mthd = syntheticTarget;
                    if (syntheticTarget == null) {
                        mthd = this.cha.resolveMethod(mr);
                    }
                    if (mthd != null) {
                        ClassLoaderReference loaderRef = mthd.getReference().getDeclaringClass().getClassLoader();
                        IClassLoader loader = this.cha.getLoader(loaderRef);
                        if (!this.cha.getScope().isApplicationLoader(loader)) {
                            boolean needed;
                            boolean bl = needed = offlineCandidates.add(mthd) && !this.spec.hasSpecForMethod(mthd);
                            if (DEBUG && needed) {
                                System.err.println("offlineCandidate needed");
                                System.err.println(mthd.getSignature());
                            }
                        }
                    }
                }
                CGNode n = this.langServices.getCGNode(this.cg, m, c);
                InvocationKey ik = new InvocationKey(n, invoke.getProgramCounter());
                boolean source = this.langServices.isSource(this.cg, m, invoke, mr, this.sourcesFilter, this.srcMethodRefs);
                if (source) break block22;
                boolean sink = this.langServices.isSink(mr, this.sinksFilter, ik, this.sinkMethodRefs);
                if (!sink) break block23;
                HashSet indices = HashSetFactory.make();
                Collection<MemberReferenceInfo> memberRefInfos = this.langServices.getMemberReferenceInfos(this.sinkMethodRefs, ik);
                if (memberRefInfos.isEmpty()) {
                    indices.addAll(this.getUseIndices((SSAInstruction)invoke, variable.getVarID()));
                } else {
                    for (MemberReferenceInfo memberRefInfo : memberRefInfos) {
                        method = (Method)memberRefInfo.member;
                        Set<Integer> interestingParameters = ((Method)method).getInterestingParameters();
                        if (interestingParameters != null && !interestingParameters.isEmpty()) {
                            for (int useIndex : this.getUseIndices((SSAInstruction)invoke, variable.getVarID())) {
                                if (!interestingParameters.contains(useIndex) && (interestingParameters.size() != 1 || !interestingParameters.contains(-1))) continue;
                                indices.add(useIndex);
                            }
                            continue;
                        }
                        indices.addAll(this.getUseIndices((SSAInstruction)invoke, variable.getVarID()));
                    }
                }
                Collection<IMethod> sinkMethods = this.langServices.getSinks(callSite, this.sinksFilter, this.cha, this.cg, n, this.sinkMethodRefs);
                if (sinkMethods.isEmpty()) {
                    UnknownMethodObject unknownMethod = new UnknownMethodObject();
                    method = indices.iterator();
                    while (method.hasNext()) {
                        int index = (Integer)method.next();
                        this.recordFlow(variable, ViolationVariable.failOrCreate(callSite, unknownMethod, c, index + 1, variable.getAccessPath()), new UnknownInvokePropagationWitness(memberRefInfos, m, c, (SSAInstruction)invoke));
                    }
                } else {
                    for (IMethod sinkMethod : sinkMethods) {
                        Iterator iterator = indices.iterator();
                        while (iterator.hasNext()) {
                            int index = (Integer)iterator.next();
                            boolean isJS = TaintAnalyzer.isJavaScript(sinkMethod);
                            FunctionCallPropagationWitness propWitness = new FunctionCallPropagationWitness(m, c, (SSAInstruction)invoke, sinkMethod, isJS);
                            this.recordFlow(variable, ViolationVariable.failOrCreate(callSite, sinkMethod, c, index + 1, variable.getAccessPath()), propWitness);
                        }
                    }
                }
                break block22;
            }
            if (this.shortCircuitFilter.accepts((Object)Pair.make((Object)variable, (Object)invoke))) break block22;
            Collection<Pair<IMethod, Context>> possibleTargets = null;
            if (syntheticTarget == null) {
                possibleTargets = this.getPossibleTargets(m, c, callSite, true);
            } else {
                Pair possibleTarget = Pair.make((Object)syntheticTarget, (Object)Everywhere.EVERYWHERE);
                possibleTargets = Collections.singleton(possibleTarget);
            }
            for (Pair<IMethod, Context> possibleTarget : possibleTargets) {
                if (possibleTarget == null) continue;
                IMethod possibleTargetMethod = (IMethod)possibleTarget.fst;
                Context possibleTargetContext = (Context)possibleTarget.snd;
                for (int useIndex : this.getUseIndices((SSAInstruction)invoke, variable.getVarID())) {
                    int useIndexVarNum = useIndex + 1;
                    if (this.langServices.isParameter(useIndexVarNum, invoke.getNumberOfParameters())) {
                        Variable effect = Variable.failOrCreate(possibleTargetMethod, possibleTargetContext, useIndexVarNum, variable.getAccessPath(), this.langServices);
                        this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)invoke));
                        continue;
                    }
                    if (invoke instanceof JavaScriptInvoke) {
                        Assertions.UNREACHABLE((String)"Lexical uses are no longer present, what should we do here?");
                        continue;
                    }
                    Assertions.UNREACHABLE((String)"Shouldn't get here unless we allow lexical reads/writes");
                }
            }
        }
    }

    private void handlePrototypeLookupInstruction(PrototypeLookup instr, Variable variable, IMethod m, Context c) {
        this.handleSSAAbstractUnaryInstruction((SSAInstruction)instr, variable, m, c);
    }

    private void handleSSAAbstractUnaryInstruction(SSAInstruction instr, Variable variable, IMethod m, Context c) {
        this.recordFlow(variable, Variable.failOrCreate(m, c, instr.getDef(), variable.getAccessPath(), this.langServices), new BasicPropagationWitness(m, c, instr));
    }

    private void handleSSAAbstratThrowInstruction() {
    }

    private void handleSSAArrayLengthInstruction() {
    }

    private void handleReflectiveMemberAccess() {
    }

    private void handleSSABinaryOpInstruction(SSAInstruction instr, Variable variable, IMethod m, Context c) {
        this.recordFlow(variable, Variable.failOrCreate(m, c, instr.getDef(), variable.getAccessPath(), this.langServices), new BasicPropagationWitness(m, c, instr));
    }

    private void handleSSACheckCastInstruction(SSAInstruction instr, Variable variable, IMethod m, Context c) {
        this.recordFlow(variable, Variable.failOrCreate(m, c, instr.getDef(), variable.getAccessPath(), this.langServices), new BasicPropagationWitness(m, c, instr));
    }

    private void handleSSAComparisonInstruction() {
    }

    private void handleSSAConditionalBranchInstruction() {
    }

    private void handleSSAConversionInstruction(SSAInstruction instr, Variable variable, IMethod m, Context c) {
        this.recordFlow(variable, Variable.failOrCreate(m, c, instr.getDef(), variable.getAccessPath(), this.langServices), new BasicPropagationWitness(m, c, instr));
    }

    private void handleSSAGetCaughtExceptionInstruction() {
    }

    private void handleSSAGotoInstruction() {
    }

    private void handleSSAInstanceofInstruction() {
    }

    private void handleSSALoadMetadataInstruction() {
    }

    private void handleSSAMonitorInstruction() {
    }

    private void handleSSANewInstruction() {
    }

    private void handleSSAPhiInstruction(SSAInstruction instr, Variable variable, IMethod m, Context c) {
        this.recordFlow(variable, Variable.failOrCreate(m, c, instr.getDef(), variable.getAccessPath(), this.langServices), new BasicPropagationWitness(m, c, instr));
    }

    private void handleSSAReturnInstruction(Variable variable, IMethod m) {
        boolean isSanitizer = this.langServices.isSanitizer(this.cg, m, this.sanitizerNodes, m.getReference(), this.sanitizersFilter);
        if (!isSanitizer) {
            if (TaintAnalyzer.isJavaScript(m)) {
                CGNode node = this.langServices.getCGNode(this.cg, m, variable.getContext());
                if (node != null) {
                    this.summarizeConstraintsForReturn(variable, node);
                } else {
                    Assertions.UNREACHABLE((String)("We did not expect no node for method " + m.toString()));
                }
            } else {
                this.summarizeConstraintsForReturn(variable);
            }
        }
    }

    private void handleSSASwitchInstruction() {
    }

    private void handleUnknownPropWriteInstruction(Variable cause, IMethod m, Context context, ReflectiveMemberAccess write, CGNode n) {
        boolean mightBeSink = this.isSinkForUnkownField(write, n);
        if (mightBeSink && !this.langServices.isInstructionInSystemFiles((SSAInstruction)write, m, context)) {
            List<FieldReference> accessPath = cause.getAccessPath();
            this.isSinkForUnkownField(write, n);
            Set<MemberReferenceInfo> mris = this.getMRIsForUnknownFieldSink(write, n);
            this.recordFlow(cause, ViolationVariable.failOrCreate(write, m, context, write.getObjectRef(), accessPath), new FieldPropagationWitness(mris, m, context, (SSAInstruction)write), false);
        } else {
            for (int useIndex : this.getUseIndices((SSAInstruction)write, cause.getVarID())) {
                if (useIndex == 2) {
                    List<FieldReference> varAccessPath = cause.getAccessPath();
                    ArrayList<FieldReference> effectAccessPath = new ArrayList<FieldReference>(varAccessPath == null ? 1 : varAccessPath.size() + 1);
                    effectAccessPath.add(Variable.ANONYMOUS);
                    if (varAccessPath != null) {
                        effectAccessPath.addAll(varAccessPath);
                    }
                    int refVarID = write.getObjectRef();
                    Variable objectVar = Variable.failOrCreate(m, context, refVarID, effectAccessPath, this.langServices);
                    this.recordFlow(cause, objectVar, new BasicPropagationWitness(m, context, (SSAInstruction)write));
                    this.summarizeConstraintsForSideEffect(cause, objectVar);
                    continue;
                }
                if (useIndex != 1) continue;
                int refVarID = write.getObjectRef();
                Variable objectVar = Variable.failOrCreate(m, context, refVarID, Variable.dotStarAccessPath(), this.langServices);
                this.recordFlow(cause, objectVar, new BasicPropagationWitness(m, context, (SSAInstruction)write));
                this.summarizeConstraintsForSideEffect(cause, objectVar);
            }
        }
    }

    private void handleUnknownPropReadInstruction(Variable variable, IMethod m, Context c, JavaScriptPropertyRead read) {
        for (int useIndex : this.getUseIndices((SSAInstruction)read, variable.getVarID())) {
            if (useIndex != 0) continue;
            List<FieldReference> accessPathSuffix = Variable.getAccessPathSegment(variable.getAccessPath(), 1);
            Variable defVar = Variable.failOrCreate(m, c, read.getDef(), accessPathSuffix, this.langServices);
            this.recordFlow(variable, defVar, new UnknownFieldPropagationWitness(m, c, (SSAInstruction)read));
        }
    }

    private void handleGetInstruction(Variable variable, IMethod m, Context c, SSAGetInstruction get, SSAInstruction originalInstruction) {
        List<FieldReference> accessPath = variable.getAccessPath();
        for (int useIndex : this.getUseIndices((SSAInstruction)get, variable.getVarID())) {
            if (useIndex != 0 || accessPath == null || accessPath.size() <= 0 || !this.langServices.areFieldReferencesCompatible(accessPath.get(0), get.getDeclaredField(), this.cha) || this.isSanitizer(get.getDeclaredField())) continue;
            List<FieldReference> accessPathSuffix = accessPath.size() == 1 && accessPath.get(0).equals((Object)Variable.DOT_STAR) ? accessPath : this.getAccessPathSegment(accessPath, 1);
            Variable defVar = Variable.failOrCreate(m, c, get.getDef(), accessPathSuffix, this.langServices);
            this.recordFlow(variable, defVar, new BasicPropagationWitness(m, c, originalInstruction));
        }
    }

    private void handleSetPrototypeInstruction() {
    }

    private void handlePutRefUse(Variable variable, IMethod m, Context c, SSAPutInstruction put, List<FieldReference> accessPath) {
        FieldReference declaredField = put.getDeclaredField();
        if (accessPath != null && accessPath.size() > 0) {
            IR ir = TaintAnalysisCache.soleInstance().getIR(variable.getMethod(), variable.getContext());
            SymbolTable sb = ir.getSymbolTable();
            if (!this.isWellKnownImmutableType(declaredField.getFieldType()) && !sb.isConstant(put.getUse(1)) && this.langServices.areFieldReferencesCompatible(declaredField, accessPath.get(0), this.cha)) {
                Variable effect = Variable.failOrCreate(m, c, put.getUse(1), this.getAccessPathSegment(accessPath, 1), this.langServices);
                BasicPropagationWitness witness = new BasicPropagationWitness(m, c, (SSAInstruction)put);
                this.recordFlow(variable, effect, witness);
                this.summarizeConstraintsForSideEffect(variable, effect);
            }
        }
    }

    private void handlePutInstruction(Variable variable, IMethod m, Context c, SSAPutInstruction put, SSAInstruction originalInstruction) {
        FieldReference declaredField = put.getDeclaredField();
        boolean fieldIsSink = this.isSink(declaredField);
        if (this.isSource(declaredField) && !fieldIsSink) {
            return;
        }
        if (put.isStatic()) {
            Collection<Variable> getVars = this.langServices.getStaticGetFieldVars(this.cg, (SSAInstruction)put, variable.getAccessPath(), this.allStaticGetFields);
            for (Variable getVar : getVars) {
                this.recordFlow(variable, getVar, new BasicPropagationWitness(m, c, originalInstruction));
            }
        } else {
            List<FieldReference> accessPath = variable.getAccessPath();
            Set<Integer> useIndices = this.getUseIndices((SSAInstruction)put, variable.getVarID());
            for (int useIndex : useIndices) {
                if (useIndex == 0) {
                    if (TaintAnalyzer.isJavaScript(m)) continue;
                    continue;
                }
                if (useIndex == 1) {
                    BasicPropagationWitness witness;
                    CGNode node = this.cg.getNode(m, c);
                    boolean isGlobalWrite = this.langServices.isAWriteToAGlobal(this.cg, node, (SSAInstruction)put);
                    boolean instructionInSystemFiles = this.langServices.isInstructionInSystemFiles((SSAInstruction)put, m, c);
                    if (fieldIsSink && !instructionInSystemFiles) {
                        String declaredFieldName;
                        TabulationDomain spaDomain;
                        ISSABasicBlock bb;
                        SPAServices.SPAExplodedBasicBlock ebb;
                        BasicBlockInContext bbic;
                        IntSet spaIntSetResults;
                        SPAServices.Result spaAttack;
                        if (this.usingSPA && (spaAttack = this.langServices.taintInURLParams(spaIntSetResults = this.spaResults.getResult((Object)(bbic = new BasicBlockInContext(node, (ISSABasicBlock)(ebb = new SPAServices.SPAExplodedBasicBlock(bb = node.getIR().getBasicBlockForInstruction(originalInstruction), originalInstruction))))), spaDomain = this.spaResults.getProblem().getDomain())).equals((Object)SPAServices.Result.NO)) {
                            DebugOutput.println((boolean)DEBUG, (String)"We canceled an attack because of SPA");
                            return;
                        }
                        DefaultPointerKeyFactory factory = new DefaultPointerKeyFactory();
                        CGNode n = this.langServices.getCGNode(this.cg, m, c);
                        LocalPointerKey objectLPK = (LocalPointerKey)factory.getPointerKeyForLocal(n, put.getRef());
                        if (this.langServices.fieldOnlyPointsToOneIK(this.cg, objectLPK, declaredFieldName = declaredField.getName().toString())) {
                            return;
                        }
                        Set<MemberReferenceInfo> mris = this.getMemberRefInfoForSink(declaredField);
                        this.recordFlow(variable, ViolationVariable.failOrCreate(put, m, variable.getContext(), put.getRef(), accessPath), new FieldPropagationWitness(mris, m, c, originalInstruction), false);
                        continue;
                    }
                    if (isGlobalWrite) {
                        Collection<Variable> aliases = this.langServices.getVariableAliasesForField(this.cg, node, (SSAFieldAccessInstruction)put, accessPath);
                        for (Variable alias : aliases) {
                            witness = new BasicPropagationWitness(m, c, originalInstruction);
                            this.recordFlow(variable, alias, witness);
                        }
                        continue;
                    }
                    ArrayList<FieldReference> effectAccessPath = new ArrayList<FieldReference>(accessPath == null ? 1 : accessPath.size() + 1);
                    effectAccessPath.add(declaredField);
                    if (accessPath != null) {
                        effectAccessPath.addAll(accessPath);
                    }
                    int refVarID = put.getRef();
                    Variable refVar = Variable.failOrCreate(m, variable.getContext(), refVarID, effectAccessPath, this.langServices);
                    witness = new BasicPropagationWitness(m, c, originalInstruction);
                    this.recordFlow(variable, refVar, witness);
                    this.summarizeConstraintsForSideEffect(variable, refVar);
                    continue;
                }
                assert (useIndex == 0);
            }
        }
    }

    private List<FieldReference> getAccessPathSegment(List<FieldReference> accessPath, int startIndex) {
        if (accessPath.size() > startIndex) {
            return Variable.getAccessPathSegment(accessPath, startIndex);
        }
        return Variable.dotStarAccessPath();
    }

    private void analyzeVariable(Variable variable) {
        if (DEBUG_ANALYZE_VARIABLE) {
            fileOuts.writeln("-- VAR " + variable.toString());
        }
        IMethod m = variable.getMethod();
        Context c = variable.getContext();
        if (this.spec.hasSpecForMethod(m) || this.findOrMaybeCreatePartialSummary(variable)) {
            if (this.langServices.isParameter(variable)) {
                this.applyOfflineSummary(variable);
            }
        } else if (this.propagationPolicy.allowsOnlineModels() && SummaryCache.soleInstance().hasSummary(variable)) {
            Set<SummaryCache.TaintRelation> summary = SummaryCache.soleInstance().getSummary(variable);
            HashMap summarizedEffects = HashMapFactory.make();
            for (SummaryCache.TaintRelation relation : summary) {
                Pair<Variable, Variable> outcome = relation.instantiate(variable.getMethod());
                Set varEffects = MapUtil.findOrCreateSet((Map)summarizedEffects, (Object)outcome.fst);
                varEffects.add(outcome.snd);
                if (!relation.hasSideEffects()) continue;
                this.summarizeConstraintsForSideEffect((Variable)outcome.fst, (Variable)outcome.snd);
            }
            for (Variable cause : summarizedEffects.keySet()) {
                if (!this.langServices.isParameter(cause)) continue;
                this.recordSummaryConstraintsOnCallSites(m, c, cause, (Set)summarizedEffects.get(cause));
            }
        } else {
            DefUse du = TaintAnalysisCache.soleInstance().getDefUse(m, c);
            if (du != null) {
                Iterator instrIter;
                int varID = variable.getVarID();
                try {
                    instrIter = du.getUses(varID);
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    DebugOutput.println((String)"Array out of bounds exception in Taint Analyzer");
                    DebugOutput.println((String)aioobe.toString());
                    DebugOutput.println((String)aioobe.getStackTrace().toString());
                    instrIter = EmptyIterator.instance();
                }
                while (instrIter.hasNext()) {
                    SSAInstruction instr = (SSAInstruction)instrIter.next();
                    if (DEBUG_ANALYZE_VARIABLE) {
                        fileOuts.writeln("-- INSTR " + instr.toString());
                    }
                    if (instr instanceof JavaScriptCheckReference) {
                        this.handleJavaScritpCheckReference();
                        continue;
                    }
                    if (instr instanceof JavaScriptInstanceOf) {
                        this.handleJavaScriptInstanceOf();
                        continue;
                    }
                    if (instr instanceof JavaScriptPropertyRead) {
                        this.handleJavaScriptPropertyRead(variable, m, c, (JavaScriptPropertyRead)instr);
                        continue;
                    }
                    if (instr instanceof JavaScriptPropertyWrite) {
                        this.handleJavaScriptPropertyWrite(variable, m, c, (JavaScriptPropertyWrite)instr);
                        continue;
                    }
                    if (instr instanceof JavaScriptTypeOfInstruction) {
                        this.handleJavaScriptTypeOfInstruction(instr);
                        continue;
                    }
                    if (instr instanceof JavaScriptWithRegion) {
                        this.handleJavaScriptWithRegion();
                        continue;
                    }
                    if (instr instanceof AstAssertInstruction) {
                        this.handleAstAssertInstruction(instr);
                        continue;
                    }
                    if (instr instanceof AstGlobalRead) {
                        this.handleAstGlobalRead(instr);
                        continue;
                    }
                    if (instr instanceof AstGlobalWrite) {
                        this.handleAstGlobalWrite((AstGlobalWrite)instr, variable);
                        continue;
                    }
                    if (instr instanceof AstLexicalRead) {
                        this.handleAstLexicalRead((AstLexicalRead)instr);
                        continue;
                    }
                    if (instr instanceof AstLexicalWrite) {
                        this.handleAstLexicalWrite((AstLexicalWrite)instr, variable, m, c);
                        continue;
                    }
                    if (instr instanceof EachElementGetInstruction) {
                        this.handleEachElementGetInstruction((EachElementGetInstruction)instr, variable, m, c);
                        continue;
                    }
                    if (instr instanceof EachElementHasNextInstruction) {
                        this.handleEachElementHasNextInstruction();
                        continue;
                    }
                    if (instr instanceof AstEchoInstruction) {
                        this.handleAstEchoInstruction(instr);
                        continue;
                    }
                    if (instr instanceof AstIsDefinedInstruction) {
                        this.handleAstIsDefinedInstruction();
                        continue;
                    }
                    if (instr instanceof PrototypeLookup) {
                        this.handlePrototypeLookupInstruction((PrototypeLookup)instr, variable, m, c);
                        continue;
                    }
                    if (instr instanceof SetPrototype) {
                        this.handleSetPrototypeInstruction();
                        continue;
                    }
                    if (instr instanceof SSAGetInstruction) {
                        this.handleGetInstruction(variable, m, c, (SSAGetInstruction)instr, instr);
                        continue;
                    }
                    if (instr instanceof SSAPutInstruction) {
                        this.handlePutInstruction(variable, m, c, (SSAPutInstruction)instr, instr);
                        continue;
                    }
                    if (this.canEnforceArrayLoadSemantics(instr)) {
                        if (instr instanceof SSAArrayLoadInstruction) {
                            this.handleArrayLoadPropagation(variable, m, c, (SSAArrayLoadInstruction)instr);
                            continue;
                        }
                        this.handleFakeArrayLoadPropagation(variable, m, c, (SSAAbstractInvokeInstruction)instr);
                        continue;
                    }
                    if (this.canEnforceArrayStoreSemantics(instr)) {
                        if (instr instanceof SSAArrayStoreInstruction) {
                            this.handleArrayStorePropagation(variable, m, c, (SSAArrayStoreInstruction)instr);
                            continue;
                        }
                        this.handleFakeArrayStorePropagation(variable, m, c, (SSAAbstractInvokeInstruction)instr);
                        continue;
                    }
                    if (instr instanceof SSAAbstractInvokeInstruction) {
                        this.handleSSAAbstractInvokeInstruction(variable, m, c, (SSAAbstractInvokeInstruction)instr);
                        continue;
                    }
                    if (instr instanceof SSAAbstractUnaryInstruction) {
                        this.handleSSAAbstractUnaryInstruction(instr, variable, m, c);
                        continue;
                    }
                    if (instr instanceof SSAAbstractThrowInstruction) {
                        this.handleSSAAbstratThrowInstruction();
                        continue;
                    }
                    if (instr instanceof SSAArrayLengthInstruction) {
                        this.handleSSAArrayLengthInstruction();
                        continue;
                    }
                    if (instr instanceof ReflectiveMemberAccess) {
                        this.handleReflectiveMemberAccess();
                        continue;
                    }
                    if (instr instanceof SSABinaryOpInstruction) {
                        this.handleSSABinaryOpInstruction(instr, variable, m, c);
                        continue;
                    }
                    if (instr instanceof SSACheckCastInstruction) {
                        this.handleSSACheckCastInstruction(instr, variable, m, c);
                        continue;
                    }
                    if (instr instanceof SSAComparisonInstruction) {
                        this.handleSSAComparisonInstruction();
                        continue;
                    }
                    if (instr instanceof SSAConditionalBranchInstruction) {
                        this.handleSSAConditionalBranchInstruction();
                        continue;
                    }
                    if (instr instanceof SSAConversionInstruction) {
                        this.handleSSAConversionInstruction(instr, variable, m, c);
                        continue;
                    }
                    if (instr instanceof SSAGetCaughtExceptionInstruction) {
                        this.handleSSAGetCaughtExceptionInstruction();
                        continue;
                    }
                    if (instr instanceof SSAGotoInstruction) {
                        this.handleSSAGotoInstruction();
                        continue;
                    }
                    if (instr instanceof SSAInstanceofInstruction) {
                        this.handleSSAInstanceofInstruction();
                        continue;
                    }
                    if (instr instanceof SSALoadMetadataInstruction) {
                        this.handleSSALoadMetadataInstruction();
                        continue;
                    }
                    if (instr instanceof SSAMonitorInstruction) {
                        this.handleSSAMonitorInstruction();
                        continue;
                    }
                    if (instr instanceof SSANewInstruction) {
                        this.handleSSANewInstruction();
                        continue;
                    }
                    if (instr instanceof SSAPhiInstruction) {
                        this.handleSSAPhiInstruction(instr, variable, m, c);
                        continue;
                    }
                    if (instr instanceof SSAReturnInstruction) {
                        this.handleSSAReturnInstruction(variable, m);
                        continue;
                    }
                    if (instr instanceof SSASwitchInstruction) {
                        this.handleSSASwitchInstruction();
                        continue;
                    }
                    Assertions.UNREACHABLE((String)("ERROR: Unsupported instruction of type " + instr.getClass().getName()));
                }
                this.langServices.handleBackwardsPropagation(this.cha, du, variable, this.cg, this.allStaticGetFields, this, this.sanitizersFilter, this.spec, -1);
            }
        }
    }

    private void applyOfflineSummary(Variable variable) {
        HashSet summarizedEffects = this.spec.getSummary(variable, this.langServices);
        if (summarizedEffects != null) {
            IMethod m = variable.getMethod();
            Context c = variable.getContext();
            boolean isSanitizer = this.langServices.isSanitizer(this.cg, m, this.sanitizerNodes, m.getReference(), this.sanitizersFilter);
            if (isSanitizer) {
                HashSet summarizedEffectsWithoutReturns = HashSetFactory.make();
                for (Variable v : summarizedEffects) {
                    if (v.getVarID() == -1) continue;
                    summarizedEffectsWithoutReturns.add(v);
                }
                summarizedEffects = summarizedEffectsWithoutReturns;
            }
            HashSet summarizedConditionalEffects = HashSetFactory.make();
            for (Variable effect : summarizedEffects) {
                if (this.langServices.areMethodsCompatible(this.cha, m, effect.getMethod())) {
                    summarizedConditionalEffects.add(effect);
                    continue;
                }
                assert (effect instanceof ViolationVariable) : "ERROR: expected unconditional effect to be a violation variable!";
                if (!this.langServices.isSink(effect.getMethodRef(), this.sinksFilter, null, null)) continue;
                this.recordFlow(variable, effect, new SummaryPropagationWitness(m, c, effect.getMethod()));
            }
            this.recordSummaryConstraintsOnCallSites(m, c, variable, summarizedConditionalEffects);
            for (Variable effect : summarizedConditionalEffects) {
                if (!this.spec.createsSideEffectsOnTarget(variable, effect)) continue;
                this.summarizeConstraintsForSideEffect(variable, effect);
            }
        }
    }

    private Set<Variable> establishPreconditions(IMethod m) throws InvalidClassFileException {
        HashSet result = HashSetFactory.make();
        IR ir = TaintAnalysisCache.soleInstance().getIR(m);
        if (ir != null) {
            for (SSAInstruction instr : ir.getInstructions()) {
                if (instr instanceof SSAGetInstruction) {
                    Set<Variable> vars;
                    SSAGetInstruction get = (SSAGetInstruction)instr;
                    if (!get.isStatic() || (vars = this.taintedStaticGetFields.get(get.getDeclaredField())) == null) continue;
                    for (Variable v : vars) {
                        Variable taintedGetStatic = Variable.failOrCreate(m, instr.getDef(), v.getAccessPath(), this.langServices);
                        this.recordFlow(v, taintedGetStatic, new BasicPropagationWitness(m, (Context)Everywhere.EVERYWHERE, instr));
                        result.add(taintedGetStatic);
                    }
                    continue;
                }
                if (!(instr instanceof SSAAbstractInvokeInstruction)) continue;
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instr;
                MethodReference declaredTarget = invoke.getDeclaredTarget();
                boolean source = this.langServices.isSource(this.cg, m, invoke, declaredTarget, this.sourcesFilter, this.srcMethodRefs);
                if (source) {
                    Variable sourceCallResult = Variable.failOrCreate(m, invoke.getDef(), declaredTarget.getReturnType().isPrimitiveType() ? null : Variable.dotStarAccessPath(), this.langServices);
                    this.addSeed(sourceCallResult);
                    result.add(sourceCallResult);
                    continue;
                }
                CallSiteReference callSite = invoke.getCallSite();
                Collection<Pair<IMethod, Context>> resolutions = this.getPossibleTargets(m, (Context)Everywhere.EVERYWHERE, callSite, false);
                for (Pair<IMethod, Context> resolution : resolutions) {
                    IMethod resolutionMethod = (IMethod)resolution.fst;
                    Set<SummaryCache.UnconditionalCauseRelation> relations = SummaryCache.soleInstance().getUnconditionalCauseRelations(resolutionMethod);
                    if (relations.size() <= 0) continue;
                    for (SummaryCache.UnconditionalCauseRelation relation : relations) {
                        SummaryCache.TaintFact fact = relation.getPostcondition();
                        int paramIndex = fact.getParameterIndex();
                        Variable unconditionalEffect = paramIndex == -1 ? Variable.failOrCreate(m, invoke.getDef(), fact.getAccessPath(), this.langServices) : Variable.failOrCreate(m, invoke.getUse(paramIndex - 1), fact.getAccessPath(), this.langServices);
                        this.recordFlow(relation.getUnconditionalCause(), unconditionalEffect, new PartialPropagationWitness(resolutionMethod, (Context)Everywhere.EVERYWHERE));
                        result.add(unconditionalEffect);
                    }
                }
            }
            Set<Variable> taintedFormals = this.computeActual2FormalFlow(m);
            result.addAll(taintedFormals);
        }
        if (DEBUG) {
            fileOuts.writeln("INFO: New preconditions for method '" + m.getDeclaringClass().getName().toString() + "." + m.getName().toString() + "':");
            for (Variable v : result) {
                fileOuts.writeln("\t" + v);
            }
        }
        return result;
    }

    private Set<Variable> computeActual2FormalFlow(IMethod m) {
        HashSet result = HashSetFactory.make();
        CGNode n = this.cg.getNode(m, (Context)Everywhere.EVERYWHERE);
        assert (n != null) : "ERROR: expected method to be represented in call graph!";
        Iterator<CGNode> predIter = this.cg.getPredNodes(n);
        while (predIter.hasNext()) {
            CGNode pred = predIter.next();
            IMethod predMethod = pred.getMethod();
            Set<Variable> exploredPredVariables = this.explored.getVariables(predMethod);
            if (exploredPredVariables == null || exploredPredVariables.size() <= 0) continue;
            HashMap exploredVarsByIndex = HashMapFactory.make();
            for (Variable v : exploredPredVariables) {
                Set S = MapUtil.findOrCreateSet((Map)exploredVarsByIndex, (Object)v.getVarID());
                S.add(v);
            }
            Iterator<CallSiteReference> siteIter = this.cg.getPossibleSites(pred, n);
            while (siteIter.hasNext()) {
                CallSiteReference site = siteIter.next();
                IR predIR = TaintAnalysisCache.soleInstance().getIR(predMethod);
                for (SSAAbstractInvokeInstruction invoke : predIR.getCalls(site)) {
                    for (int useIndex = 0; useIndex < invoke.getNumberOfUses(); ++useIndex) {
                        int use = invoke.getUse(useIndex);
                        Set image = (Set)exploredVarsByIndex.get(use);
                        if (image == null) continue;
                        for (Variable imageVar : image) {
                            Variable taintedFormal = Variable.failOrCreate(m, useIndex + 1, imageVar.getAccessPath(), this.langServices);
                            this.recordFlow(imageVar, taintedFormal, new BasicPropagationWitness(predMethod, (Context)Everywhere.EVERYWHERE, (SSAInstruction)invoke));
                            result.add(taintedFormal);
                        }
                    }
                }
            }
        }
        return result;
    }

    private Set<IMethod> invalidateConstraints(IMethod oldMethod) {
        HashSet result = HashSetFactory.make(Collections.singleton(oldMethod));
        Set<ISupportGraph.Fact> boundedFacts = this.supportGraph.getBoundedFacts(oldMethod);
        HashSet invalidSummaries = HashSetFactory.make();
        if (boundedFacts != null) {
            HashSet toRemove = HashSetFactory.make();
            Set<ISupportGraph.Fact> invalidatedFacts = this.supportGraph.invalidateAll(boundedFacts);
            for (ISupportGraph.Fact f : invalidatedFacts) {
                invalidSummaries.add(f.getBindings());
                if (f instanceof ISupportGraph.BinaryFact) {
                    ISupportGraph.BinaryFact bf = (ISupportGraph.BinaryFact)f;
                    Variable lhs = bf.getLHS();
                    Variable rhs = bf.getRHS();
                    if (this.propagationGraph.containsNode((Object)lhs) && this.propagationGraph.containsNode((Object)rhs)) {
                        Set labels = this.propagationGraph.getEdgeLabels((Object)lhs, (Object)rhs);
                        for (IPropagationWitness label : labels) {
                            this.propagationGraph.removeEdge((Object)lhs, (Object)rhs, (Object)label);
                            if (!DEBUG) continue;
                            fileOuts.writeln("INFO: Witness '" + label + "' eliminated from propagation graph.");
                        }
                    }
                    this.explored.remove(rhs);
                    continue;
                }
                if (f instanceof ISupportGraph.UnaryFact) {
                    ISupportGraph.UnaryFact uf = (ISupportGraph.UnaryFact)f;
                    Variable v = uf.getVariable();
                    toRemove.add(v);
                    continue;
                }
                Assertions.UNREACHABLE();
            }
            for (Variable v : toRemove) {
                if (this.propagationGraph.containsNode((Object)v)) {
                    this.propagationGraph.removeNodeAndEdges((Object)v);
                    if (DEBUG) {
                        fileOuts.writeln("INFO: Variable '" + v + "' eliminated from propagation graph.");
                    }
                } else if (DEBUG) {
                    fileOuts.writeln("INFO: Variable '" + v + "' not found in propagation graph, and thus couldn't be eliminated.");
                }
                this.explored.remove(v);
            }
        }
        for (IMethod m : invalidSummaries) {
            SummaryCache.soleInstance().markAsVolatile(m);
            result.add(m);
        }
        return result;
    }

    private static boolean isValidParameter(SSAAbstractInvokeInstruction invoke, int useIndex) {
        return invoke.getNumberOfParameters() > useIndex;
    }

    private void summarizeConstraintsForSideEffect(Variable cause, Variable effect) {
        Timing.i().startedSection(TimedSection.SideEffectPropagation);
        if (cause.getVarID() != effect.getVarID()) {
            Set witnesses = this.propagationGraph.getEdgeLabels((Object)cause, (Object)effect);
            IPropagationWitness witness = witnesses.size() > 0 ? (IPropagationWitness)witnesses.iterator().next() : new PartialPropagationWitness(cause.getMethod(), cause.getContext());
            Set<Variable> taintAncestors = this.findTaintAncestors(cause);
            Set<Variable> ancestors = this.langServices.findAncestors(this.cg, effect);
            if (DEBUG) {
                if (taintAncestors == null || taintAncestors.isEmpty()) {
                    fileOuts.writeln("-- taintAncestors was null or empty");
                }
                if (ancestors == null || ancestors.isEmpty()) {
                    fileOuts.writeln("-- ancestors was null or empty");
                }
            }
            HashSet taintAncestorAndAncestorPairs = HashSetFactory.make();
            for (Variable taintAncestor : taintAncestors) {
                for (final Variable ancestor : ancestors) {
                    this.supportGraph.addSupport(new ISupportGraph.BinaryFact(cause, effect), new ISupportGraph.BinaryFact(taintAncestor, ancestor));
                    taintAncestorAndAncestorPairs.add(Pair.make((Object)taintAncestor, (Object)ancestor));
                }
            }
            for (Pair current : taintAncestorAndAncestorPairs) {
                SSAAbstractInvokeInstruction invoke;
                boolean newlyExamined;
                Variable ancestor;
                Variable taintAncestor = (Variable)current.fst;
                ancestor = (Variable)current.snd;
                if (taintAncestor == null || ancestor == null || !(newlyExamined = this.history.add((Pair<Variable, Variable>)current))) continue;
                boolean isTaintAncestorParameter = this.langServices.isParameter(taintAncestor);
                boolean isAncestorParameter = this.langServices.isParameter(ancestor);
                boolean isAncestorLexicalAccess = this.langServices.isLexicalAccess(ancestor);
                int taintAncestorUseIndex = taintAncestor.getVarID() - this.langServices.getInvokeUseOffset();
                int ancestorUseIndex = ancestor.getVarID() - this.langServices.getInvokeUseOffset();
                IMethod ancestorMethod = ancestor.getMethod();
                if (isAncestorLexicalAccess) {
                    SSAInstruction def = TaintAnalysisCache.soleInstance().getDefUse(ancestorMethod, ancestor.getContext()).getDef(ancestor.getVarID());
                    if (!(def instanceof AstLexicalAccess)) continue;
                    AstLexicalAccess astLexicalAccess = (AstLexicalAccess)def;
                    for (AstLexicalAccess.Access a : astLexicalAccess.getAccesses()) {
                        if (a.valueNumber != ancestor.getVarID()) continue;
                        for (final Triple<IMethod, Context, SSAAbstractInvokeInstruction> call : this.langServices.getCalls(this.cg, ancestorMethod, ancestor.getContext())) {
                            this.taintedLexicals.notify(ancestor, a, this.langServices, new TaintedLexicalAccesses.IFlowHandler(){

                                @Override
                                public void act(Variable effect) {
                                    TaintAnalyzer.this.recordFlow(ancestor, effect, new BasicPropagationWitness((IMethod)call.first, (Context)call.second, (SSAInstruction)call.third));
                                }
                            });
                        }
                    }
                    continue;
                }
                if (isAncestorParameter && isTaintAncestorParameter) {
                    SummaryCache.soleInstance().summarizeConditionalConstraintForSideEffect(ancestorMethod, taintAncestor.getVarID(), taintAncestor.getAccessPath(), ancestor.getVarID(), ancestor.getAccessPath(), this.langServices);
                    for (Triple triple : this.langServices.getCalls(this.cg, ancestorMethod, ancestor.getContext())) {
                        invoke = (SSAAbstractInvokeInstruction)triple.third;
                        if (TaintAnalyzer.isValidParameter(invoke, taintAncestorUseIndex) && TaintAnalyzer.isValidParameter(invoke, ancestorUseIndex)) {
                            Variable callSiteCause = Variable.failOrCreate((IMethod)triple.first, (Context)triple.second, invoke.getUse(taintAncestorUseIndex), taintAncestor.getAccessPath(), this.langServices);
                            Variable callSiteEffect = Variable.failOrCreate((IMethod)triple.first, (Context)triple.second, invoke.getUse(ancestorUseIndex), ancestor.getAccessPath(), this.langServices);
                            this.recordFlow(callSiteCause, callSiteEffect, new BasicPropagationWitness(callSiteCause.getMethod(), callSiteCause.getContext(), (SSAInstruction)invoke));
                            this.supportGraph.addSupport(new ISupportGraph.BinaryFact(taintAncestor, ancestor), new ISupportGraph.BinaryFact(callSiteCause, callSiteEffect));
                            continue;
                        }
                        fileOuts.writeln("ERROR: We just encountered a non-valid parameter :: parameters for invoke: " + invoke.getNumberOfParameters() + " parameter index: " + ancestorUseIndex + " or " + taintAncestorUseIndex);
                    }
                    continue;
                }
                if (isAncestorParameter && !isTaintAncestorParameter) {
                    if (taintAncestor.getMethod().equals(cause.getMethod())) {
                        SummaryCache.soleInstance().summarizeUnconditionalConstraintForSideEffect(taintAncestor, ancestorMethod, ancestor.getVarID(), ancestor.getAccessPath(), this.langServices);
                    }
                    Collection<Triple<IMethod, Context, SSAAbstractInvokeInstruction>> ancestorCalls = this.langServices.getCalls(this.cg, ancestorMethod, ancestor.getContext());
                    for (Triple<IMethod, Context, SSAAbstractInvokeInstruction> call : ancestorCalls) {
                        SSAAbstractInvokeInstruction invoke2 = (SSAAbstractInvokeInstruction)call.third;
                        if (TaintAnalyzer.isValidParameter(invoke2, ancestorUseIndex)) {
                            Variable callSiteEffect = Variable.failOrCreate((IMethod)call.first, (Context)call.second, invoke2.getUse(ancestorUseIndex), ancestor.getAccessPath(), this.langServices);
                            this.recordFlow(taintAncestor, callSiteEffect, new TransitivePropagationWitness(witness));
                            this.supportGraph.addSupport(new ISupportGraph.BinaryFact(taintAncestor, ancestor), new ISupportGraph.BinaryFact(taintAncestor, callSiteEffect));
                            continue;
                        }
                        fileOuts.writeln("ERROR: We just encountered a non-valid parameter :: parameters for invoke: " + invoke2.getNumberOfParameters() + " parameter index: " + ancestorUseIndex);
                    }
                    continue;
                }
                if (!isAncestorParameter && isTaintAncestorParameter) {
                    for (Triple<IMethod, Context, SSAAbstractInvokeInstruction> triple : this.langServices.getCalls(this.cg, taintAncestor.getMethod(), taintAncestor.getContext())) {
                        invoke = (SSAAbstractInvokeInstruction)triple.third;
                        if (TaintAnalyzer.isValidParameter(invoke, taintAncestorUseIndex)) {
                            Variable callSiteCause = Variable.failOrCreate((IMethod)triple.first, (Context)triple.second, invoke.getUse(taintAncestorUseIndex), taintAncestor.getAccessPath(), this.langServices);
                            this.recordFlow(callSiteCause, ancestor, new BasicPropagationWitness(callSiteCause.getMethod(), callSiteCause.getContext(), (SSAInstruction)invoke));
                            this.supportGraph.addSupport(new ISupportGraph.BinaryFact(taintAncestor, ancestor), new ISupportGraph.BinaryFact(callSiteCause, ancestor));
                            this.accountForTaintOnStaticField(callSiteCause, ancestor);
                            continue;
                        }
                        fileOuts.writeln("ERROR: We just encountered a non-valid parameter :: parameters for invoke: " + invoke.getNumberOfParameters() + " parameter index: " + taintAncestorUseIndex);
                    }
                    continue;
                }
                this.recordFlow(taintAncestor, ancestor, new TransitivePropagationWitness(witness));
                this.accountForTaintOnStaticField(taintAncestor, ancestor);
            }
        }
        Timing.i().finishedSection(TimedSection.SideEffectPropagation);
    }

    private void recordFlows(Variable variable, IMethod varMethod, List<FieldReference> varAccessPath, Collection<Variable> taintAncestors, Collection<Triple<IMethod, Context, SSAAbstractInvokeInstruction>> calls) {
        for (Variable taintAncestor : taintAncestors) {
            boolean isTaintAncestorParameter = this.langServices.isParameter(taintAncestor);
            if (isTaintAncestorParameter) {
                SummaryCache.soleInstance().summarizeConditionalConstraintForReturn(varMethod, taintAncestor.getVarID(), taintAncestor.getAccessPath(), varAccessPath, this.langServices);
            } else {
                SummaryCache.soleInstance().summarizeUnconditionalConstraintForReturn(taintAncestor, varMethod, varAccessPath, this.langServices);
            }
            for (Triple<IMethod, Context, SSAAbstractInvokeInstruction> call : calls) {
                Variable effect = Variable.failOrCreate((IMethod)call.first, (Context)call.second, ((SSAAbstractInvokeInstruction)call.third).getDef(), variable.getAccessPath(), this.langServices);
                try {
                    Variable cause;
                    if (isTaintAncestorParameter) {
                        int getUseIndex = taintAncestor.getVarID() - this.langServices.getInvokeUseOffset();
                        int useVarId = ((SSAAbstractInvokeInstruction)call.third).getUse(getUseIndex);
                        cause = Variable.failOrCreate((IMethod)call.first, (Context)call.second, useVarId, taintAncestor.getAccessPath(), this.langServices);
                    } else {
                        cause = taintAncestor;
                    }
                    this.recordFlow(cause, effect, new BasicPropagationWitness((IMethod)call.first, (Context)call.second, (SSAInstruction)call.third));
                    this.supportGraph.addSupport(new ISupportGraph.UnaryFact(variable), new ISupportGraph.BinaryFact(cause, effect));
                }
                catch (NullPointerException npe) {
                    DebugOutput.println((String)"Null Pointer Exception in Taint Analyze recordFlows");
                    DebugOutput.println((String)npe.toString());
                    DebugOutput.println((String)npe.getStackTrace().toString());
                }
            }
        }
    }

    private void summarizeConstraintsForReturn(Variable variable, CGNode n) {
        IMethod varMethod = variable.getMethod();
        List<FieldReference> varAccessPath = variable.getAccessPath();
        Set<Variable> taintAncestors = this.findTaintAncestors(variable);
        HashSet calls = HashSetFactory.make();
        calls.addAll(this.langServices.getCalls(this.cg, n));
        this.recordFlows(variable, varMethod, varAccessPath, taintAncestors, calls);
    }

    private void summarizeConstraintsForReturn(Variable variable) {
        IMethod varMethod = variable.getMethod();
        Context varContext = variable.getContext();
        List<FieldReference> varAccessPath = variable.getAccessPath();
        Set<Variable> taintAncestors = this.findTaintAncestors(variable);
        Collection<Triple<IMethod, Context, SSAAbstractInvokeInstruction>> calls = this.langServices.getCalls(this.cg, varMethod, varContext);
        this.recordFlows(variable, varMethod, varAccessPath, taintAncestors, calls);
    }

    private void accountForTaintOnStaticField(Variable taintAncestor, Variable ancestor) {
        if (Variable.isStaticField(ancestor) && taintAncestor != null && ancestor != null) {
            DefUse du = TaintAnalysisCache.soleInstance().getDefUse(ancestor.getMethod(), ancestor.getContext());
            SSAGetInstruction getInstr = (SSAGetInstruction)du.getDef(ancestor.getVarID());
            for (Variable otherStaticGet : this.langServices.getStaticGetFieldVars(this.cg, (SSAInstruction)getInstr, ancestor.getAccessPath(), this.allStaticGetFields)) {
                Set labels = this.propagationGraph.getEdgeLabels((Object)taintAncestor, (Object)ancestor);
                if (labels.size() > 0) {
                    this.recordFlow(taintAncestor, otherStaticGet, (IPropagationWitness)labels.iterator().next());
                } else {
                    this.recordFlow(taintAncestor, otherStaticGet, NullPropagationWitness.soleInstance());
                }
                this.supportGraph.addSupport(new ISupportGraph.BinaryFact(taintAncestor, ancestor), new ISupportGraph.BinaryFact(taintAncestor, otherStaticGet));
            }
        }
    }

    private Set<Variable> findTaintAncestors(Variable variable) {
        final IMethod varMethod = variable.getMethod();
        Filter<Variable> filter = new Filter<Variable>(){

            public boolean accepts(Variable v) {
                IMethod m = v.getMethod();
                if (TaintAnalyzer.this.langServices.isParameter(v) && m.equals(varMethod)) {
                    return true;
                }
                DefUse du = TaintAnalysisCache.soleInstance().getDefUse(m, v.getContext());
                int vID = v.getVarID();
                if (du != null) {
                    SSAInstruction defInstr = du.getDef(vID);
                    if (defInstr instanceof SSAAbstractInvokeInstruction) {
                        SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)defInstr;
                        if (TaintAnalyzer.this.langServices.isSource(TaintAnalyzer.this.cg, m, invoke, invoke.getDeclaredTarget(), TaintAnalyzer.this.sourcesFilter, TaintAnalyzer.this.srcMethodRefs)) {
                            return true;
                        }
                    } else if (defInstr instanceof SSAGetInstruction) {
                        SSAGetInstruction getInstr = (SSAGetInstruction)defInstr;
                        if (TaintAnalyzer.this.isSource(getInstr.getDeclaredField())) {
                            return true;
                        }
                        if (getInstr.isStatic()) {
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        if (filter.accepts((Object)variable)) {
            HashSet result = HashSetFactory.make();
            result.add(variable);
            return result;
        }
        Graph<Variable> inverseGraph = new Graph<Variable>(){

            public void removeNodeAndEdges(Variable N) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            public void addNode(Variable n) {
                Assertions.UNREACHABLE();
            }

            public boolean containsNode(Variable N) {
                return TaintAnalyzer.this.propagationGraph.containsNode((Object)N);
            }

            public int getNumberOfNodes() {
                return TaintAnalyzer.this.propagationGraph.getNumberOfNodes();
            }

            public Iterator<Variable> iterator() {
                return TaintAnalyzer.this.propagationGraph.iterator();
            }

            public void removeNode(Variable n) {
                Assertions.UNREACHABLE();
            }

            public void addEdge(Variable src, Variable dst) {
                Assertions.UNREACHABLE();
            }

            public int getPredNodeCount(Variable N) {
                return TaintAnalyzer.this.propagationGraph.getSuccNodeCount((Object)N);
            }

            public Iterator<Variable> getPredNodes(Variable N) {
                return TaintAnalyzer.this.propagationGraph.getSuccNodes((Object)N);
            }

            public int getSuccNodeCount(Variable N) {
                return TaintAnalyzer.this.propagationGraph.getPredNodeCount((Object)N);
            }

            public Iterator<Variable> getSuccNodes(Variable N) {
                return TaintAnalyzer.this.propagationGraph.getPredNodes((Object)N);
            }

            public boolean hasEdge(Variable src, Variable dst) {
                return TaintAnalyzer.this.propagationGraph.hasEdge((Object)dst, (Object)src);
            }

            public void removeAllIncidentEdges(Variable node) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            public void removeEdge(Variable src, Variable dst) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            public void removeIncomingEdges(Variable node) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }

            public void removeOutgoingEdges(Variable node) throws UnsupportedOperationException {
                Assertions.UNREACHABLE();
            }
        };
        return BFSPathsFinder.findPathsFromMultipleSources(inverseGraph, Collections.singleton(variable), filter, true).keySet();
    }

    private boolean isWellKnownImmutableType(TypeReference t) {
        return this.isPrimitiveOrString(t);
    }

    private boolean isPrimitiveOrString(TypeReference t) {
        if (t.isPrimitiveType()) {
            return true;
        }
        TypeName name = t.getName();
        if (name.equals((Object)TypeReference.JavaLangString.getName())) {
            return true;
        }
        if (name.equals((Object)TypeReference.JavaLangCharacter.getName())) {
            return true;
        }
        return name.equals((Object)TypeReference.JavaLangBoolean.getName());
    }

    private void handleFakeArrayStorePropagation(Variable variable, IMethod m, Context c, SSAAbstractInvokeInstruction invoke) {
        int useIndex = this.getUseIndex((SSAInstruction)invoke, variable.getVarID());
        if (useIndex == 0) {
            IR ir = TaintAnalysisCache.soleInstance().getIR(m, c);
            SymbolTable sb = ir.getSymbolTable();
            if (!this.isWellKnownImmutableType(invoke.getDeclaredTarget().getParameterType(1)) && !sb.isConstant(invoke.getUse(1))) {
                List<FieldReference> accessPath = variable.getAccessPath();
                if (accessPath == null || !Variable.isMapAccessQualifier(accessPath.get(0))) {
                    ErrorLog.i().register("Variable " + variable + " is of type Map, but doesn't have an appropriate access path.");
                    Variable effect = Variable.failOrCreate(m, c, invoke.getUse(2), accessPath, this.langServices);
                    BasicPropagationWitness witness = new BasicPropagationWitness(m, c, (SSAInstruction)invoke);
                    this.recordFlow(variable, effect, witness);
                    this.summarizeConstraintsForSideEffect(variable, effect);
                } else if (accessPath.get(0).equals((Object)Variable.ANONYMOUS)) {
                    List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(accessPath, 1);
                    Variable effect = Variable.failOrCreate(m, c, invoke.getUse(2), effectAccessPath, this.langServices);
                    BasicPropagationWitness witness = new BasicPropagationWitness(m, c, (SSAInstruction)invoke);
                    this.recordFlow(variable, effect, witness);
                    this.summarizeConstraintsForSideEffect(variable, effect);
                } else if (sb.isConstant(invoke.getUse(1))) {
                    String accessQualifier;
                    String keyName = sb.getStringValue(invoke.getUse(1));
                    if (keyName.equals(accessQualifier = accessPath.get(0).getName().toString())) {
                        List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(accessPath, 1);
                        Variable effect = Variable.failOrCreate(m, c, invoke.getUse(2), effectAccessPath, this.langServices);
                        this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)invoke));
                        this.summarizeConstraintsForSideEffect(variable, effect);
                    }
                } else {
                    List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(accessPath, 1);
                    Variable effect = Variable.failOrCreate(m, c, invoke.getUse(2), effectAccessPath, this.langServices);
                    this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)invoke));
                    this.summarizeConstraintsForSideEffect(variable, effect);
                }
            }
        } else if (useIndex != 1) {
            assert (useIndex == 2);
            List<FieldReference> accessPath = variable.getAccessPath();
            IR ir = TaintAnalysisCache.soleInstance().getIR(m);
            ArrayList<FieldReference> effectAccessPath = new ArrayList<FieldReference>(accessPath == null ? 1 : accessPath.size() + 1);
            SymbolTable sb = ir.getSymbolTable();
            if (sb.isConstant(invoke.getUse(1))) {
                String keyName = sb.getStringValue(invoke.getUse(1));
                effectAccessPath.add(Variable.getMapAccessQualifier(keyName));
            } else {
                effectAccessPath.add(Variable.ANONYMOUS);
            }
            if (accessPath != null) {
                effectAccessPath.addAll(accessPath);
            }
            Variable fakeArrayVar = Variable.failOrCreate(m, c, invoke.getUse(0), effectAccessPath, this.langServices);
            this.recordFlow(variable, fakeArrayVar, new BasicPropagationWitness(m, c, (SSAInstruction)invoke));
            this.summarizeConstraintsForSideEffect(variable, fakeArrayVar);
        }
    }

    private void handleArrayStorePropagation(Variable variable, IMethod m, Context c, SSAArrayStoreInstruction instr) {
        int useIndex = this.getUseIndex((SSAInstruction)instr, variable.getVarID());
        if (useIndex == 0) {
            IR ir = TaintAnalysisCache.soleInstance().getIR(m, c);
            SymbolTable sb = ir.getSymbolTable();
            if (!this.isWellKnownImmutableType(instr.getElementType()) && !sb.isConstant(instr.getUse(2))) {
                List<FieldReference> varAccessPath = variable.getAccessPath();
                if (varAccessPath == null || !Variable.isArrayAccessQualifier(varAccessPath.get(0))) {
                    ErrorLog.i().register("Variable " + variable + " is an array, but doesn't have an appropriate access path.");
                    Variable effect = Variable.failOrCreate(m, c, instr.getUse(2), varAccessPath, this.langServices);
                    this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)instr));
                    this.summarizeConstraintsForSideEffect(variable, effect);
                } else if (varAccessPath.get(0).equals((Object)Variable.ANONYMOUS)) {
                    List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                    Variable effect = Variable.failOrCreate(m, c, instr.getUse(2), effectAccessPath, this.langServices);
                    this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)instr));
                    this.summarizeConstraintsForSideEffect(variable, effect);
                } else if (sb.isConstant(instr.getUse(1))) {
                    int accessQualifier;
                    int arrayIndex = sb.getIntValue(instr.getUse(1));
                    if (arrayIndex == (accessQualifier = Integer.parseInt(varAccessPath.get(0).getName().toString()))) {
                        List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                        Variable effect = Variable.failOrCreate(m, c, instr.getUse(2), effectAccessPath, this.langServices);
                        this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)instr));
                        this.summarizeConstraintsForSideEffect(variable, effect);
                    }
                } else {
                    List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                    Variable effect = Variable.failOrCreate(m, c, instr.getUse(2), effectAccessPath, this.langServices);
                    this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)instr));
                    this.summarizeConstraintsForSideEffect(variable, effect);
                }
            }
        } else if (useIndex != 1) {
            assert (useIndex == 2);
            IR ir = TaintAnalysisCache.soleInstance().getIR(m);
            SymbolTable sb = ir.getSymbolTable();
            List<FieldReference> varAccessPath = variable.getAccessPath();
            ArrayList<FieldReference> effectAccessPath = new ArrayList<FieldReference>(varAccessPath == null ? 1 : varAccessPath.size() + 1);
            if (sb.isConstant(instr.getUse(1))) {
                int arrayIndex = sb.getIntValue(instr.getUse(1));
                effectAccessPath.add(Variable.getArrayAccessQualifier(arrayIndex));
            } else {
                effectAccessPath.add(Variable.ANONYMOUS);
            }
            if (varAccessPath != null) {
                effectAccessPath.addAll(varAccessPath);
            }
            Variable arrayVar = Variable.failOrCreate(m, c, instr.getUse(0), effectAccessPath, this.langServices);
            this.recordFlow(variable, arrayVar, new BasicPropagationWitness(m, c, (SSAInstruction)instr));
            this.summarizeConstraintsForSideEffect(variable, arrayVar);
        }
    }

    private void handleFakeArrayLoadPropagation(Variable variable, IMethod m, Context c, SSAAbstractInvokeInstruction invoke) {
        int useIndex = this.getUseIndex((SSAInstruction)invoke, variable.getVarID());
        if (useIndex == 0) {
            List<FieldReference> varAccessPath = variable.getAccessPath();
            if (varAccessPath == null || !Variable.isMapAccessQualifier(varAccessPath.get(0))) {
                ErrorLog.i().register("Variable " + variable + " is of type Map, but doesn't have an appropriate access path.");
                Variable effect = Variable.failOrCreate(m, c, invoke.getDef(), varAccessPath, this.langServices);
                this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)invoke));
            } else if (varAccessPath.get(0).equals((Object)Variable.ANONYMOUS)) {
                List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                Variable effect = Variable.failOrCreate(m, c, invoke.getDef(), effectAccessPath, this.langServices);
                this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)invoke));
            } else {
                IR ir = TaintAnalysisCache.soleInstance().getIR(m, c);
                SymbolTable sb = ir.getSymbolTable();
                if (sb.isConstant(invoke.getUse(1))) {
                    String accessQualifier;
                    String keyName = sb.getStringValue(invoke.getUse(1));
                    if (keyName.equals(accessQualifier = varAccessPath.get(0).getName().toString())) {
                        List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                        Variable effect = Variable.failOrCreate(m, c, invoke.getDef(), effectAccessPath, this.langServices);
                        this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)invoke));
                    }
                } else {
                    List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                    Variable effect = Variable.failOrCreate(m, c, invoke.getDef(), effectAccessPath, this.langServices);
                    this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)invoke));
                }
            }
        } else assert (useIndex == 1);
    }

    private void handleArrayLoadPropagation(Variable variable, IMethod m, Context c, SSAArrayLoadInstruction instr) {
        int useIndex = this.getUseIndex((SSAInstruction)instr, variable.getVarID());
        if (useIndex == 0) {
            List<FieldReference> varAccessPath = variable.getAccessPath();
            if (varAccessPath == null || !Variable.isArrayAccessQualifier(varAccessPath.get(0))) {
                ErrorLog.i().register("Variable " + variable + " is an array, but doesn't have an appropriate access path.");
                Variable effect = Variable.failOrCreate(m, c, instr.getDef(), varAccessPath, this.langServices);
                this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)instr));
            } else if (varAccessPath.get(0).equals((Object)Variable.ANONYMOUS)) {
                List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                Variable effect = Variable.failOrCreate(m, c, instr.getDef(), effectAccessPath, this.langServices);
                this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)instr));
            } else {
                IR ir = TaintAnalysisCache.soleInstance().getIR(m, c);
                SymbolTable sb = ir.getSymbolTable();
                if (sb.isConstant(instr.getUse(1))) {
                    int accessQualifier;
                    int arrayIndex = sb.getIntValue(instr.getUse(1));
                    if (arrayIndex == (accessQualifier = Integer.parseInt(varAccessPath.get(0).getName().toString()))) {
                        List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                        Variable effect = Variable.failOrCreate(m, c, instr.getDef(), effectAccessPath, this.langServices);
                        this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)instr));
                    }
                } else {
                    List<FieldReference> effectAccessPath = Variable.getAccessPathSegment(varAccessPath, 1);
                    Variable effect = Variable.failOrCreate(m, c, instr.getDef(), effectAccessPath, this.langServices);
                    this.recordFlow(variable, effect, new BasicPropagationWitness(m, c, (SSAInstruction)instr));
                }
            }
        } else assert (useIndex == 1);
    }

    private boolean canEnforceArrayStoreSemantics(SSAInstruction instr) {
        SSAAbstractInvokeInstruction invoke;
        MethodReference target;
        TypeReference declaringClassTypeRef;
        IClass c;
        if (instr instanceof SSAArrayStoreInstruction) {
            return true;
        }
        if (instr instanceof SSAAbstractInvokeInstruction && (c = this.cha.lookupClass(declaringClassTypeRef = (target = (invoke = (SSAAbstractInvokeInstruction)instr).getDeclaredTarget()).getDeclaringClass())) != null) {
            if (target.getSelector().equals((Object)PUT_SELECTOR) && this.cha.getLeastCommonSuperclass(TypeReference.JavaUtilMap, declaringClassTypeRef).equals((Object)TypeReference.JavaUtilMap)) {
                return true;
            }
            if (ENABLE_SPECIAL_TREATMENT_FOR_SESSION_OBJECTS && target.getSelector().equals((Object)SET_ATTRIBUTE_SELECTOR) && this.cha.getLeastCommonSuperclass(HTTP_SESSION_TYPE_REF, declaringClassTypeRef).equals((Object)HTTP_SESSION_TYPE_REF)) {
                return true;
            }
        }
        return false;
    }

    private boolean canEnforceArrayLoadSemantics(SSAInstruction instr) {
        SSAAbstractInvokeInstruction invoke;
        MethodReference target;
        TypeReference declaringClassTypeRef;
        IClass c;
        if (instr instanceof SSAArrayLoadInstruction) {
            return true;
        }
        if (instr instanceof SSAAbstractInvokeInstruction && (c = this.cha.lookupClass(declaringClassTypeRef = (target = (invoke = (SSAAbstractInvokeInstruction)instr).getDeclaredTarget()).getDeclaringClass())) != null) {
            if (target.getSelector().equals((Object)GET_SELECTOR) && this.cha.getLeastCommonSuperclass(TypeReference.JavaUtilMap, declaringClassTypeRef).equals((Object)TypeReference.JavaUtilMap)) {
                return true;
            }
            if (ENABLE_SPECIAL_TREATMENT_FOR_SESSION_OBJECTS && target.getSelector().equals((Object)GET_ATTRIBUTE_SELECTOR) && this.cha.getLeastCommonSuperclass(HTTP_SESSION_TYPE_REF, declaringClassTypeRef).equals((Object)HTTP_SESSION_TYPE_REF)) {
                return true;
            }
        }
        return false;
    }

    private void recordSummaryConstraintsOnCallSites(IMethod m, Context c, Variable variable, Set<Variable> summarizedEffects) {
        for (Triple<IMethod, Context, SSAAbstractInvokeInstruction> invoke : this.langServices.getCalls(this.cg, m, c)) {
            this.recordSummaryConstraintsOnCallSite(variable, summarizedEffects, invoke);
        }
    }

    private void recordSummaryConstraintsOnCallSite(Variable variable, Set<Variable> summarizedEffects, Triple<IMethod, Context, SSAAbstractInvokeInstruction> invoke) {
        if (((SSAAbstractInvokeInstruction)invoke.third).getNumberOfParameters() <= variable.getVarID() - 1) {
            DebugOutput.println((boolean)DEBUG, (String)"invoke didn't have enough params... FIX THIS IN THE FUTURE");
            return;
        }
        Variable cause = Variable.failOrCreate((IMethod)invoke.first, (Context)invoke.second, ((SSAAbstractInvokeInstruction)invoke.third).getUse(variable.getVarID() - 1), variable.getAccessPath(), this.langServices);
        for (Variable varInSummary : summarizedEffects) {
            Variable effect = varInSummary.getVarID() == -1 ? Variable.failOrCreate((IMethod)invoke.first, (Context)invoke.second, ((SSAAbstractInvokeInstruction)invoke.third).getDef(), varInSummary.getAccessPath(), this.langServices) : Variable.failOrCreate((IMethod)invoke.first, (Context)invoke.second, ((SSAAbstractInvokeInstruction)invoke.third).getUse(varInSummary.getVarID() - this.langServices.getInvokeUseOffset()), varInSummary.getAccessPath(), this.langServices);
            this.recordFlow(cause, effect, new BasicPropagationWitness(cause.getMethod(), cause.getContext(), (SSAInstruction)invoke.third));
            this.supportGraph.addSupport(new ISupportGraph.BinaryFact(variable, varInSummary), new ISupportGraph.BinaryFact(cause, effect));
        }
    }

    private int getUseIndex(SSAInstruction instr, int varID) {
        Set<Integer> useIndices = this.getUseIndices(instr, varID);
        assert (useIndices.size() >= 1) : "ERROR: expected " + varID + " to be used at least once in " + instr + "!";
        return useIndices.iterator().next();
    }

    private Set<Integer> getUseIndices(SSAInstruction instr, int varID) {
        HashSet result = HashSetFactory.make();
        for (int index = 0; index < instr.getNumberOfUses(); ++index) {
            int currentUse = instr.getUse(index);
            if (currentUse != varID) continue;
            result.add(index);
        }
        return result;
    }

    private void accountForSideEffectsBetweenParameters(Variable v, Variable w) {
        Set<Variable> taintAncestors = this.findTaintAncestors(v);
        if (taintAncestors != null && taintAncestors.size() > 0) {
            HashSet taintParams = HashSetFactory.make();
            for (Variable t : taintAncestors) {
                if (!this.langServices.isParameter(t)) continue;
                taintParams.add(t);
            }
            if (taintParams.size() > 0) {
                Set<Variable> ancestors = this.langServices.findAncestors(this.cg, w);
                for (Variable ancestor : ancestors) {
                    if (!this.langServices.isParameter(ancestor)) continue;
                    for (Variable taintParam : taintParams) {
                        if (!this.langServices.areMethodsCompatible(this.cha, taintParam.getMethod(), ancestor.getMethod())) continue;
                        this.summarizeConstraintsForSideEffect(taintParam, ancestor);
                    }
                }
            }
        }
    }

    public void recordFlow(Variable cause, Variable effect, IPropagationWitness witness) {
        HashSet recursionHistory = HashSetFactory.make();
        this.recordFlow(cause, effect, witness, false, recursionHistory);
    }

    private void recordGetBackflow(Variable cause, Variable effect, IPropagationWitness witness, boolean ignoreSideEffects, Set<Variable> recursionHistory) {
        if (recursionHistory.add(effect)) {
            this.summarizeConstraintsForSideEffect(cause, effect);
            this.recordFlow(cause, effect, witness, ignoreSideEffects, recursionHistory);
        }
    }

    private void recordFlow(Variable cause, Variable effect, IPropagationWitness witness, boolean ignoreSideEffects) {
        HashSet recursionHistory = HashSetFactory.make();
        this.recordFlow(cause, effect, witness, ignoreSideEffects, recursionHistory);
    }

    private void recordFlow(Variable cause, Variable effect, IPropagationWitness witness, boolean ignoreSideEffects, Set<Variable> recursionHistory) {
        if (this.analysisTimedOut()) {
            return;
        }
        Pair recordFlowKey = Pair.make((Object)Pair.make((Object)cause, (Object)effect), (Object)Pair.make((Object)witness, (Object)ignoreSideEffects));
        if (!this.recordFlowHistory.add((Pair<Pair<Variable, Variable>, Pair<IPropagationWitness, Boolean>>)recordFlowKey)) {
            return;
        }
        if (this.maxPropagationSteps == -1 || this.explored.size() < this.maxPropagationSteps) {
            int effectAge;
            assert (witness != null);
            if (cause != null && effect != null && !(cause instanceof DeadEndVariable) && (effectAge = this.computeEffectAge(cause, witness)) >= 0 && this.supportGraph.addSupport(new ISupportGraph.UnaryFact(cause), new ISupportGraph.UnaryFact(effect))) {
                Pair key;
                effect.setAge(effectAge);
                this.propagationGraph.addNode((Object)cause);
                this.propagationGraph.addNode((Object)effect);
                this.propagationGraph.addEdge((Object)cause, (Object)effect, (Object)witness);
                IMethod effectMethod = effect.getMethod();
                if (!ignoreSideEffects && cause.getMethod().equals(effectMethod) && this.accountedForSideEffectsBetweenParams.add((Pair<Variable, Variable>)(key = Pair.make((Object)cause, (Object)effect)))) {
                    this.accountForSideEffectsBetweenParameters(cause, effect);
                }
                Context effectContext = effect.getContext();
                int effectVarID = effect.getVarID();
                DefUse defUse = TaintAnalysisCache.soleInstance().getDefUse(effectMethod, effectContext);
                if (defUse != null) {
                    SSAInstruction effectDef = defUse.getDef(effectVarID);
                    List<FieldReference> effectAccessPath = effect.getAccessPath();
                    if (effectDef instanceof SSAGetInstruction) {
                        SSAGetInstruction getInstr = (SSAGetInstruction)effectDef;
                        LinkedList<FieldReference> newAccessPath = new LinkedList<FieldReference>();
                        newAccessPath.add(getInstr.getDeclaredField());
                        if (effectAccessPath != null) {
                            newAccessPath.addAll(effectAccessPath);
                        }
                        if (getInstr.isStatic()) {
                            Collection<Variable> getVars = this.langServices.getStaticGetFieldVars(this.cg, (SSAInstruction)getInstr, newAccessPath, this.allStaticGetFields);
                            for (Variable getVar : getVars) {
                                this.recordGetBackflow(cause, getVar, new BasicPropagationWitness(effectMethod, effectContext, (SSAInstruction)getInstr), ignoreSideEffects, recursionHistory);
                            }
                        } else {
                            int varID = getInstr.getRef();
                            Variable parentEffect = Variable.failOrCreate(effectMethod, varID, newAccessPath, this.langServices);
                            this.recordGetBackflow(cause, parentEffect, new BasicPropagationWitness(effectMethod, effectContext, (SSAInstruction)getInstr), ignoreSideEffects, recursionHistory);
                        }
                    } else if (effectDef instanceof JavaScriptPropertyRead) {
                        // empty if block
                    }
                }
                if (Variable.isStaticField(effect)) {
                    SSAGetInstruction get = (SSAGetInstruction)TaintAnalysisCache.soleInstance().getDefUse(effectMethod, effectContext).getDef(effectVarID);
                    assert (get.isStatic());
                    FieldReference staticFieldRef = get.getDeclaredField();
                    Set correspondingVars = MapUtil.findOrCreateSet(this.taintedStaticGetFields, (Object)staticFieldRef);
                    correspondingVars.add(effect);
                }
                if (!this.explored.contains(effect)) {
                    if (this.explored.contains(cause)) {
                        this.discovered.add(effect);
                    } else {
                        Set effects = MapUtil.findOrCreateSet(this.waitingList, (Object)cause);
                        effects.add(effect);
                    }
                }
            }
        }
    }

    private int computeEffectAge(Variable cause, IPropagationWitness witness) {
        return Integer.MAX_VALUE;
    }

    private static IOfflineSpecification loadOfflineSpecification(IClassHierarchy cha, ILangServices langServices, ILanguageSpecificServicesForFastanalysis fastLangServices) {
        String offlineSpecFile = langServices.getOfflineSpecificationFile();
        try {
            File f = TaintFileProvider.getFile((String)offlineSpecFile);
            File autoSummariesFile = new File(FlowAnalyzer.AUTO_SUMMARIES_FILE_NAME);
            return OfflineSpecification.load(f, autoSummariesFile, cha, langServices.getLanguage(), fastLangServices);
        }
        catch (IOException e) {
            fileOuts.writeln("Failed to load offline specification " + offlineSpecFile + ": " + e);
            return null;
        }
    }

    static {
        TaintResult.DEBUG = false;
        fileOuts = Output.makeStdOutOutput((boolean)false);
        DEBUG = false;
        DEBUG_ANALYZE_VARIABLE = false;
        ENABLE_SPECIAL_TREATMENT_FOR_SESSION_OBJECTS = false;
        offlineCandidates = HashSetFactory.make();
        LOG_DEBUG_FILTER = new Filter<IMethod>(){

            public boolean accepts(IMethod o) {
                return o.getDeclaringClass().getName().toString().contains("write_to_dom") || o.getName().toString().contains("write_to_dom");
            }
        };
        CTOR_NEW_INSTANCE = MethodReference.findOrCreate((TypeReference)TypeReference.JavaLangReflectConstructor, (String)"newInstance", (String)"([Ljava/lang/Object;)Ljava/lang/Object;");
        GET_SELECTOR = Selector.make((String)"get(Ljava/lang/Object;)Ljava/lang/Object;");
        GET_ATTRIBUTE_SELECTOR = Selector.make((String)"getAttribute(Ljava/lang/String;)Ljava/lang/Object;");
        PUT_SELECTOR = Selector.make((String)"put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        SET_ATTRIBUTE_SELECTOR = Selector.make((String)"setAttribute(Ljava/lang/String;Ljava/lang/Object;)V");
        HTTP_SESSION_TYPE_REF = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Extension, (TypeName)TypeName.string2TypeName((String)"Ljavax/servlet/http/HttpSession"));
    }

    public static class AnalysisTime {
        private final long time;
        private final boolean timedOut;

        public AnalysisTime(long time, boolean timedOut) {
            this.time = time;
            this.timedOut = timedOut;
        }

        public long getTime() {
            return this.time;
        }

        public boolean getTimedOut() {
            return this.timedOut;
        }
    }

    private class FindRefRet {
        public Map<InvocationKey, Set<MemberReferenceInfo>> methodsMap;
        public FullPathFieldsInformation fieldsMap;
        public FullPathFieldsInformation untaintedFieldsMap;

        public FindRefRet(Map<InvocationKey, Set<MemberReferenceInfo>> methods_map, FullPathFieldsInformation fields_map, FullPathFieldsInformation untainted_fields_map) {
            this.methodsMap = methods_map;
            this.fieldsMap = fields_map;
            this.untaintedFieldsMap = untainted_fields_map;
        }
    }
}

