/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.diagnostics;

import com.ibm.wala.andromeda.cg.util.UserLog;
import com.ibm.wala.andromeda.diagnostics.ITiming;
import com.ibm.wala.andromeda.diagnostics.TimedSection;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.perf.Stopwatch;
import com.ibm.wala.util.perf.StopwatchGC;
import java.util.HashMap;
import java.util.Map;

public class Timing
implements ITiming {
    private static Timing _i = new Timing();
    private Map<TimedSection, Stopwatch> stopwatches;

    public static ITiming i() {
        return _i;
    }

    public Timing() {
        this.init();
    }

    private void init() {
        this.stopwatches = new HashMap<TimedSection, Stopwatch>(TimedSection.values().length);
        for (TimedSection timedSection : TimedSection.values()) {
            Object stopWatch = this.probMemory(timedSection) ? new StopwatchGC(timedSection.toString()) : new Stopwatch();
            this.stopwatches.put(timedSection, (Stopwatch)stopWatch);
        }
    }

    private boolean probMemory(TimedSection timedSection) {
        return false;
    }

    @Override
    public void startedSection(TimedSection section) {
        Stopwatch swOfSecion = this.stopwatches.get((Object)section);
        swOfSecion.start();
    }

    @Override
    public void finishedSection(TimedSection section) {
        Stopwatch swOfSecion = this.stopwatches.get((Object)section);
        swOfSecion.stop();
    }

    @Override
    public void logReportFull() {
        UserLog.logger.info((Object)"Timing:");
        for (TimedSection timedSection : TimedSection.values()) {
            Stopwatch swOfSecion = this.stopwatches.get((Object)timedSection);
            UserLog.logger.info((Object)("\t" + timedSection.toString() + ": " + swOfSecion));
        }
    }

    @Override
    public void logReport() {
        UserLog.logger.info((Object)"Timing:");
        TimedSection[] interestingTimers = this.stopwatches.get((Object)TimedSection.StringAnalysis).getElapsedMillis() > 0L ? new TimedSection[]{TimedSection.ClassHierarchyBuilding, TimedSection.StorelessCallGraph, TimedSection.AbstractInterpretation, TimedSection.SideEffectPropagation, TimedSection.WitnessExtraction, TimedSection.StringAnalysis, TimedSection.StringAnalysisFilterCandidates, TimedSection.StringAnalysisEncoding, TimedSection.StringAnalysisInference, TimedSection.DbSupportForSummariesSig, TimedSection.DbSupportForSummariesSel} : new TimedSection[]{TimedSection.ClassHierarchyBuilding, TimedSection.StorelessCallGraph, TimedSection.AbstractInterpretation, TimedSection.SideEffectPropagation, TimedSection.WitnessExtraction, TimedSection.DbSupportForSummariesSig, TimedSection.DbSupportForSummariesSel};
        long sum = 0L;
        for (TimedSection timedSection : interestingTimers) {
            UserLog.logger.info((Object)("\t" + timedSection.toString() + ": " + this.stopwatches.get((Object)timedSection)));
            sum += this.stopwatches.get((Object)timedSection).getElapsedMillis();
        }
        UserLog.logger.info((Object)("\t(sum: " + sum + ")"));
        UserLog.logger.info((Object)("\t" + TimedSection.Total.toString() + ": " + this.stopwatches.get((Object)TimedSection.Total)));
    }

    @Override
    public void clearTimers() {
        this.init();
    }

    @Override
    public Map<String, String> getResults() {
        HashMap ret = HashMapFactory.make();
        for (TimedSection ts : this.stopwatches.keySet()) {
            Stopwatch stopwatch = this.stopwatches.get((Object)ts);
            ret.put(ts.toString(), "" + stopwatch.getElapsedMillis());
        }
        return ret;
    }
}

