/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.jsp;

import com.ibm.wala.andromeda.cg.util.UserLog;
import com.ibm.wala.andromeda.jsp.JSPFileInfo;
import com.ibm.wala.andromeda.jsp.JSPMapping;
import com.ibm.wala.andromeda.jsp.LineInfo;
import com.ibm.wala.classLoader.FileModule;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashCodeComparator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class JSPUtil {
    private static final TypeReference JSP_BASE = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Extension, (String)"Lorg/apache/jasper/runtime/HttpJspBase");
    private static final boolean VERBOSE = false;
    private static final boolean PARANOID = false;
    private static Map<AnalysisScope, Map<JSPFileInfo, Set<LineInfo>>> scope2jspFileInfos = HashMapFactory.make();
    private static Map<AnalysisScope, Map<String, Set<LineInfo>>> scope2classNames = HashMapFactory.make();

    public static boolean isJSP(IMethod method) {
        IClass base = method.getClassHierarchy().lookupClass(JSP_BASE);
        return base != null && method.getClassHierarchy().isSubclassOf(method.getDeclaringClass(), base);
    }

    public static boolean hasJSPOrigin(AnalysisScope context, String className) {
        Map<String, Set<LineInfo>> M = scope2classNames.get(context);
        return M == null ? false : M.containsKey(className);
    }

    public static JSPMapping getJSPMapping(AnalysisScope context, String className, int javaLineNo) {
        Collection lineInfos;
        Map<String, Set<LineInfo>> M = scope2classNames.get(context);
        if (M != null && null != (lineInfos = (Collection)M.get(className))) {
            JSPFileInfo jfi;
            for (LineInfo li : lineInfos) {
                String fileName;
                JSPFileInfo jfi2;
                Map<Integer, Set<Integer>> mappingTable = li.getJavaToJSPMappings();
                Set mappedJSPLines = (Set)mappingTable.get(javaLineNo);
                if (mappedJSPLines == null || (jfi2 = li.getSourceFile()) == null || (fileName = jfi2.getPath() == null ? jfi2.getName() : jfi2.getPath()) == null) continue;
                return new JSPMapping(fileName, JSPUtil.getFirstLine(mappedJSPLines));
            }
            int closestLine = -1;
            LineInfo bestMatch = null;
            for (LineInfo li : lineInfos) {
                Map<Integer, Set<Integer>> mappingTable = li.getJavaToJSPMappings();
                Set<Integer> javaLines = mappingTable.keySet();
                for (int javaLine : javaLines) {
                    if (javaLine >= javaLineNo || closestLine >= javaLine) continue;
                    closestLine = javaLine;
                    bestMatch = li;
                }
            }
            if (bestMatch != null && closestLine >= 0 && (jfi = bestMatch.getSourceFile()) != null) {
                String fileName;
                String string = fileName = jfi.getPath() == null ? jfi.getName() : jfi.getPath();
                if (fileName != null) {
                    return new JSPMapping(fileName, JSPUtil.getFirstLine(bestMatch.getJavaToJSPMappings().get(closestLine)));
                }
            }
        }
        return null;
    }

    private static int getFirstLine(Set<Integer> lineNumbers) {
        assert (lineNumbers.size() > 0);
        int result = Integer.MAX_VALUE;
        for (int lineNo : lineNumbers) {
            if (lineNo >= result) continue;
            result = lineNo;
        }
        return result;
    }

    private static void removeClassFiles(Set<ModuleEntry> s, Set<ModuleEntry> t) {
        HashSet old = HashSetFactory.make();
        for (ModuleEntry m : t) {
            old.add(m.getClassName());
        }
        HashSet toRemove = HashSetFactory.make();
        for (ModuleEntry m : s) {
            if (!old.contains(m.getClassName())) continue;
            toRemove.add(m);
        }
        s.removeAll(toRemove);
    }

    private static Set<ModuleEntry> getClassFiles(Module M) throws IOException {
        TreeSet sortedEntries = new TreeSet(HashCodeComparator.instance());
        sortedEntries.addAll(Iterator2Collection.toSet((Iterator)M.getEntries()));
        HashSet result = HashSetFactory.make();
        for (ModuleEntry entry : sortedEntries) {
            if (entry.isClassFile()) {
                result.add(entry);
                continue;
            }
            if (!entry.isModuleFile()) continue;
            Set<ModuleEntry> s = JSPUtil.getClassFiles(entry.asModule());
            JSPUtil.removeClassFiles(s, result);
            result.addAll(s);
        }
        return result;
    }

    private static void addClassNameVariants(AnalysisScope context, FileModule classModuleEntry, JSPFileInfo jfi, Map<JSPFileInfo, Collection<LineInfo>> lineInfos) {
        int classes;
        int lastDot;
        String classPath = classModuleEntry.getFile().getAbsolutePath();
        if (!classPath.endsWith(".class")) {
            return;
        }
        classPath = classPath.substring(0, classPath.length() - 6);
        classPath = (classPath = classPath.replace(File.separatorChar, '.')).contains("org.apache.jsp") ? classPath.substring(classPath.lastIndexOf("org.apache.jsp")) : ((lastDot = classPath.lastIndexOf(".")) < 0 ? "com.ibm._jsp" + classPath : ((classes = classPath.lastIndexOf("classes")) < 0 ? "com.ibm._jsp" + classPath.substring(lastDot + 1) : "com.ibm._jsp" + classPath.substring(classes + "classes".length())));
        Map M = MapUtil.findOrCreateMap(scope2classNames, (Object)context);
        Set image = MapUtil.findOrCreateSet((Map)M, (Object)classPath);
        image.addAll(lineInfos.get(jfi));
    }

    public static void registerScope(AnalysisScope scope) {
        Map<String, Set<LineInfo>> old2;
        Map<JSPFileInfo, Set<LineInfo>> old1 = scope2jspFileInfos.get(scope);
        if (old1 != null) {
            old1.clear();
        }
        if ((old2 = scope2classNames.get(scope)) != null) {
            old2.clear();
        }
        HashSet allClasses = HashSetFactory.make();
        for (Module M : scope.getModules(ClassLoaderReference.Application)) {
            try {
                allClasses.addAll(JSPUtil.getClassFiles(M));
            }
            catch (IOException iOException) {}
        }
        for (ModuleEntry entry : allClasses) {
            assert (entry.isClassFile());
            DataInputStream inputStream = new DataInputStream(new BufferedInputStream(entry.getInputStream()));
            Map<JSPFileInfo, Collection<LineInfo>> lineInfos = JSPUtil.getLineInfos(inputStream);
            if (lineInfos == null) continue;
            Map M = MapUtil.findOrCreateMap(scope2jspFileInfos, (Object)scope);
            for (Map.Entry<JSPFileInfo, Collection<LineInfo>> mapEntry : lineInfos.entrySet()) {
                JSPFileInfo jfi = mapEntry.getKey();
                Collection<LineInfo> lines = mapEntry.getValue();
                Set image = MapUtil.findOrCreateSet((Map)M, (Object)jfi);
                image.addAll(lines);
                assert (entry instanceof FileModule);
                JSPUtil.addClassNameVariants(scope, (FileModule)entry, jfi, lineInfos);
            }
        }
    }

    private static String getSourceDebugExtensionText(DataInputStream classInputStream) throws IOException {
        StringBuffer sb = new StringBuffer();
        try {
            int indexOfSMAPEnd;
            int indexOfSMAP;
            String currentContent;
            char c;
            do {
                c = (char)classInputStream.readByte();
                sb.append(c);
            } while (c != 'E' || !(currentContent = sb.toString()).endsWith("*E") || (indexOfSMAP = currentContent.indexOf("SMAP")) <= -1 || (indexOfSMAPEnd = currentContent.indexOf("*E") + "*E".length()) <= -1);
            return currentContent.substring(indexOfSMAP, indexOfSMAPEnd);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Map<JSPFileInfo, Collection<LineInfo>> getLineInfos(DataInputStream classInputStream) {
        try {
            String sourceDebugExtensionText = JSPUtil.getSourceDebugExtensionText(classInputStream);
            if (sourceDebugExtensionText != null) {
                return JSPUtil.getLineMappings(sourceDebugExtensionText);
            }
            JSPUtil.report("SourceDebugExtension class attribute not found !!");
        }
        catch (IOException iox) {
            JSPUtil.report("Problem reading/closing class file.");
        }
        catch (Exception e) {
            JSPUtil.report("Problem generating line info.: " + e.toString() + ".");
        }
        return null;
    }

    private static void report(String msg) {
    }

    public static void main(String[] args) {
        String classFileName = args[0];
        try {
            DataInputStream classInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(classFileName)));
            Map<JSPFileInfo, Collection<LineInfo>> lineInfos = JSPUtil.getLineInfos(classInputStream);
            for (Map.Entry<JSPFileInfo, Collection<LineInfo>> entry : lineInfos.entrySet()) {
                JSPFileInfo jfi = entry.getKey();
                Collection<LineInfo> c = entry.getValue();
                String jfiString = jfi.toString();
                System.out.println(jfiString);
                for (int index = 0; index < jfiString.length(); ++index) {
                    System.out.print('-');
                }
                System.out.println();
                for (LineInfo li : c) {
                    Map<Integer, Set<Integer>> mappingsTable = li.getJSPToJavaMappings();
                    for (int i : mappingsTable.keySet()) {
                        System.out.println("From " + i + " to " + Arrays.toString(mappingsTable.get(i).toArray()) + ".");
                    }
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        System.out.println("All done!!");
    }

    private static Map<Integer, JSPFileInfo> getSourceFileMappings(String[] smapLines, String resultantJavaFileName) {
        boolean inFileSection = false;
        HashMap<Integer, JSPFileInfo> result = new HashMap<Integer, JSPFileInfo>();
        for (int index = 0; index < smapLines.length; ++index) {
            String trimmedLine = smapLines[index].trim();
            if (trimmedLine.equals("*L")) {
                inFileSection = false;
            }
            if (inFileSection) {
                if (trimmedLine.startsWith("+")) {
                    int indexOfIDStart = trimmedLine.indexOf(32) + 1;
                    int indexOfIDEnd = trimmedLine.indexOf(32, indexOfIDStart + 1);
                    int id = Integer.parseInt(trimmedLine.substring(indexOfIDStart, indexOfIDEnd));
                    String fileName = trimmedLine.substring(indexOfIDEnd + 1);
                    String path = smapLines[index + 1].trim();
                    result.put(id, new JSPFileInfo(fileName, path, id, resultantJavaFileName));
                } else if (index <= 0 || !smapLines[index - 1].startsWith("+")) {
                    int id = Integer.parseInt(trimmedLine.substring(0, trimmedLine.indexOf(32)));
                    String name = trimmedLine.substring(trimmedLine.indexOf(32) + 1);
                    result.put(id, new JSPFileInfo(name, null, id, resultantJavaFileName));
                }
            }
            if (!trimmedLine.equals("*F")) continue;
            inFileSection = true;
        }
        return result;
    }

    private static Collection<LineInfo> getLineInfos(String[] smapLines, Map<Integer, JSPFileInfo> sourceFilesByID) {
        boolean inLineSection = false;
        HashSet<LineInfo> result = new HashSet<LineInfo>();
        int lastFileID = 0;
        for (int index = 0; index < smapLines.length; ++index) {
            String trimmedLine = smapLines[index].trim();
            if (trimmedLine.equals("*E")) {
                inLineSection = false;
            }
            if (inLineSection) {
                Pair<LineInfo, Integer> parseResult = LineInfo.parse(trimmedLine, sourceFilesByID, lastFileID);
                result.add((LineInfo)parseResult.fst);
                lastFileID = (Integer)parseResult.snd;
            }
            if (!trimmedLine.equals("*L")) continue;
            inLineSection = true;
        }
        return result;
    }

    private static String getResultantJavaFileName(String[] smapLines) {
        boolean isJavaFileNameLine = false;
        String trimmedLine = null;
        for (int index = 0; index < smapLines.length; ++index) {
            trimmedLine = smapLines[index].trim();
            if (isJavaFileNameLine) {
                if (trimmedLine.endsWith(".java")) break;
                UserLog.logger.warn((Object)"Line should contain the name of a java file.");
                trimmedLine = null;
                break;
            }
            if (!trimmedLine.equals("SMAP")) continue;
            isJavaFileNameLine = true;
        }
        return trimmedLine;
    }

    private static Map<JSPFileInfo, Collection<LineInfo>> getLineMappings(String sourceDebugExtensionText) {
        String[] lines = sourceDebugExtensionText.split("\n");
        String resultantJavaFileName = JSPUtil.getResultantJavaFileName(lines);
        Map<Integer, JSPFileInfo> sourceFilesByID = JSPUtil.getSourceFileMappings(lines, resultantJavaFileName);
        Collection<LineInfo> lineInfos = JSPUtil.getLineInfos(lines, sourceFilesByID);
        HashMap<JSPFileInfo, Collection<LineInfo>> result = new HashMap<JSPFileInfo, Collection<LineInfo>>();
        for (LineInfo lf : lineInfos) {
            JSPFileInfo jfi = lf.getSourceFile();
            if (!result.containsKey(jfi)) {
                result.put(jfi, new HashSet(1));
            }
            ((Collection)result.get(jfi)).add(lf);
        }
        return result;
    }
}

