/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.progress;

import com.ibm.wala.andromeda.progress.ITaintRunnerDebug;
import com.ibm.wala.andromeda.progress.Step;
import com.ibm.wala.andromeda.rules.ITaintResult;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.HashSet;
import java.util.Iterator;

public class ProgressManager {
    private static final int FIXED_NUMBER_OF_WORK_UNITS = 1000000;
    private final Step<String> root;
    private final ITaintRunnerDebug.ITaintRunnerEventHandler handler;

    public ProgressManager() {
        this(DefaultTaintRunnerEventHandler.instance());
    }

    public ProgressManager(ITaintRunnerDebug.ITaintRunnerEventHandler handler) {
        this(handler, 1000000);
    }

    public ProgressManager(ITaintRunnerDebug.ITaintRunnerEventHandler handler, int totalWeight) {
        this.handler = handler;
        this.handler.starting(totalWeight);
        this.root = new Step.Root<String>(this, "Taint analysis.", Step.StepSize.LONG, totalWeight);
    }

    public Step<String> getRootStep() {
        return this.root;
    }

    void increment(double progress) {
        if (this.handler.isCanceled()) {
            throw new TaintAnalysisCancelException();
        }
        this.handler.finishedWorkUnits((int)Math.floor(progress));
    }

    public static void main(String[] args) {
        ITaintRunnerDebug.ITaintRunnerEventHandler handler = new ITaintRunnerDebug.ITaintRunnerEventHandler(){
            private boolean isCanceled = false;
            private int numWorkUnits;
            private int numWorkUnitsProcessed = 0;

            @Override
            public void done() {
            }

            @Override
            public void finishedWorkUnits(int howMany) {
                this.numWorkUnitsProcessed += howMany;
                System.out.println("Finished " + this.numWorkUnitsProcessed + "/" + this.numWorkUnits + " work units.");
            }

            @Override
            public boolean isCanceled() {
                return this.isCanceled;
            }

            @Override
            public void newResult(ITaintResult result) {
            }

            @Override
            public void setCanceled(boolean isCanceled) {
                this.isCanceled = isCanceled;
            }

            @Override
            public void starting(int numWorkUnits) {
                this.numWorkUnits = numWorkUnits;
            }
        };
        try {
            ProgressManager p = new ProgressManager(handler);
            Step<String> root = p.getRootStep();
            HashSet steps = HashSetFactory.make();
            for (int index = 0; index < 1003; ++index) {
                steps.add(new Step<String>(String.valueOf(index), Step.StepSize.MEDIUM));
            }
            root.refine(steps);
            Iterator iter = steps.iterator();
            int index = 0;
            while (iter.hasNext()) {
                Step step = (Step)iter.next();
                step.done();
                if (++index != 5) continue;
                handler.setCanceled(true);
            }
        }
        catch (TaintAnalysisCancelException e) {
            System.out.println(e.getMessage());
        }
    }

    private static final class DefaultTaintRunnerEventHandler
    implements ITaintRunnerDebug.ITaintRunnerEventHandler {
        private static DefaultTaintRunnerEventHandler instance;

        private DefaultTaintRunnerEventHandler() {
        }

        public static DefaultTaintRunnerEventHandler instance() {
            if (instance == null) {
                instance = new DefaultTaintRunnerEventHandler();
            }
            return instance;
        }

        @Override
        public void done() {
        }

        public void finishedWorkUnit() {
        }

        @Override
        public void finishedWorkUnits(int howMany) {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        public void newResult(ITaintResult result) {
        }

        @Override
        public void setCanceled(boolean isCanceled) {
        }

        @Override
        public void starting(int numWorkUnits) {
        }
    }

    public static final class TaintAnalysisCancelException
    extends RuntimeException {
        @Override
        public String getMessage() {
            return "Taint analysis was canceled by user.";
        }
    }
}

