/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.rules.management;

import com.ibm.wala.andromeda.rules.management.IMember;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;

public class CodePatternGroup
implements Serializable {
    private static final long serialVersionUID = -3256390509887654361L;
    private final String id;
    private final String internalName;
    private final String nameTextID;
    private final String descTextID;
    private final Collection<IMember> codePatterns;
    private final Collection<CodePatternGroup> subGroups;

    public CodePatternGroup(String id, String internalName, String nameTextID, String descTextID, Collection<IMember> codePatterns, Collection<CodePatternGroup> subGroups) {
        this.id = id;
        this.internalName = internalName;
        this.nameTextID = nameTextID;
        this.descTextID = descTextID;
        this.codePatterns = codePatterns;
        this.subGroups = subGroups;
    }

    public CodePatternGroup(String id, String internalName, String nameTextID, String descTextID) {
        this(id, internalName, nameTextID, descTextID, HashSetFactory.make(), HashSetFactory.make());
    }

    public String getID() {
        return this.id;
    }

    @Deprecated
    public String getName() {
        return this.internalName;
    }

    @Deprecated
    public String getDescription() {
        return "N/A";
    }

    public String getDescriptionTextID() {
        return this.descTextID;
    }

    public String getNameTextID() {
        return this.nameTextID;
    }

    public void addCodePattern(IMember cp) {
        this.codePatterns.add(cp);
    }

    public void removeCodePattern(IMember cp) {
        this.codePatterns.remove(cp);
    }

    public void addSubGroup(CodePatternGroup mg) {
        this.subGroups.add(mg);
    }

    public void removeSubGroup(CodePatternGroup mg) {
        this.subGroups.remove(mg);
    }

    public Collection<IMember> getCodePatterns() {
        return this.codePatterns;
    }

    public Collection<CodePatternGroup> getSubGroups() {
        return this.subGroups;
    }

    public Collection<IMember> getAllCodePatterns() {
        HashSet result = HashSetFactory.make();
        result.addAll(this.getCodePatterns());
        for (CodePatternGroup mg : this.subGroups) {
            result.addAll(mg.getAllCodePatterns());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("com.ibm.wala.taint.rules.MethodGroup[");
        sb.append("id=");
        sb.append(this.id);
        sb.append("; ");
        sb.append("internalName=");
        sb.append(this.internalName);
        sb.append("; ");
        sb.append("nameTextID=");
        sb.append(this.nameTextID);
        sb.append("; ");
        sb.append("descTextID=");
        sb.append(this.descTextID);
        sb.append("; ");
        sb.append("codePatterns=");
        sb.append(this.codePatterns);
        sb.append("; ");
        sb.append("subGroups=");
        sb.append(this.subGroups);
        sb.append("; ");
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodePatternGroup other = (CodePatternGroup)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

