/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.sa.prefix.transducer;

import com.ibm.appscan.sa.prefix.main.ISPALangServices;
import com.ibm.appscan.sa.prefix.main.StringPrefix;
import com.ibm.appscan.sa.prefix.transducer.ConcatTransducer;
import com.ibm.appscan.sa.prefix.transducer.CopyTransducer;
import com.ibm.appscan.sa.prefix.transducer.EscapeTransducer;
import com.ibm.appscan.sa.prefix.transducer.IndexOfTransducer;
import com.ibm.appscan.sa.prefix.transducer.LastIndexOfTransducer;
import com.ibm.appscan.sa.prefix.transducer.MatchTransducer;
import com.ibm.appscan.sa.prefix.transducer.ReplaceTransducer;
import com.ibm.appscan.sa.prefix.transducer.SplitTransducer;
import com.ibm.appscan.sa.prefix.transducer.SubstrTransducer;
import com.ibm.appscan.sa.prefix.transducer.SubstringTransducer;
import com.ibm.appscan.sa.prefix.transducer.ToLowerCaseTransducer;
import com.ibm.appscan.sa.prefix.transducer.ToUpperCaseTransducer;
import com.ibm.appscan.sa.prefix.transducer.UnescapeTransducer;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.dataflow.IFDS.ICFGSupergraph;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.rta.CallSite;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class StringTransducer {
    private static final Map<StringOperation, StringTransducer> transducers;
    private static final StringTransducer DEFAULT_TRANSDUCER;

    public static boolean isStringTransducer(BasicBlockInContext<IExplodedBasicBlock> src, ICFGSupergraph supergraph, ISPALangServices langServices) {
        CGNode caller = src.getNode();
        SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)src.getLastInstruction();
        CallGraph cg = (CallGraph)supergraph.getProcedureGraph();
        StringOperation op = StringTransducer.resolve(cg, caller, call, langServices);
        return op != StringOperation.OTHER;
    }

    public static Set<StringPrefix> apply(CallGraph cg, BasicBlockInContext<IExplodedBasicBlock> bb, CGNode caller, SSAAbstractInvokeInstruction call, ISPALangServices langServices, StringPrefix sp) {
        StringOperation op = StringTransducer.resolve(cg, caller, call, langServices);
        if (op == StringOperation.OTHER) {
            return null;
        }
        StringTransducer transducer = transducers.get((Object)op);
        int strIdx = op.getStrIdx() + (call instanceof JavaScriptInvoke ? 1 : 0);
        if (call.getNumberOfUses() <= strIdx) {
            return null;
        }
        int strPtr = call.getUse(strIdx);
        if (!sp.getEnvPtrs().contains(strPtr)) {
            return null;
        }
        Set<StringPrefix> S = transducer.transduce(sp, bb, cg, call, langServices);
        if (S == null) {
            return Collections.singleton(sp);
        }
        HashSet result = HashSetFactory.make(S);
        if (!transducer.killIncomingString()) {
            result.add(sp);
        }
        return result;
    }

    private static StringOperation resolve(CallGraph cg, CGNode caller, SSAAbstractInvokeInstruction call, ISPALangServices langServices) {
        CallSiteReference callSite = call.getCallSite();
        MethodReference declaredTarget = callSite.getDeclaredTarget();
        TypeReference classRef = declaredTarget.getDeclaringClass();
        Set<String> targetNames = langServices.getTargetNames(cg, new CallSite(callSite, caller), call);
        if (targetNames != null) {
            for (String t : targetNames) {
                String trgtName = t.toLowerCase();
                boolean isJavaScriptStringAPI = StringTransducer.isJavaScriptStringAPI(trgtName);
                String simpleTrgtName = StringTransducer.simplify(trgtName);
                if (!isJavaScriptStringAPI && !StringTransducer.isStringClass(classRef, langServices)) continue;
                if (simpleTrgtName.equals("substring")) {
                    return StringOperation.SUBSTRING;
                }
                if (simpleTrgtName.equals("substr")) {
                    return StringOperation.SUBSTR;
                }
                if (simpleTrgtName.equals("tolowercase")) {
                    return StringOperation.TO_LOWER_CASE;
                }
                if (simpleTrgtName.equals("touppercase")) {
                    return StringOperation.TO_UPPER_CASE;
                }
                if (simpleTrgtName.equals("match")) {
                    return StringOperation.MATCH;
                }
                if (simpleTrgtName.equals("replace")) {
                    return StringOperation.REPLACE;
                }
                if (simpleTrgtName.equals("indexof")) {
                    return StringOperation.INDEX_OF;
                }
                if (simpleTrgtName.equals("lastindexof")) {
                    return StringOperation.LAST_INDEX_OF;
                }
                if (simpleTrgtName.equals("concat")) {
                    return StringOperation.CONCAT;
                }
                if (simpleTrgtName.equals("split")) {
                    return StringOperation.SPLIT;
                }
                if (simpleTrgtName.equals("charat")) {
                    return StringOperation.CHAR_AT;
                }
                if (simpleTrgtName.equals("string")) {
                    return StringOperation.COPY;
                }
                if (simpleTrgtName.equals("constructor")) {
                    return StringOperation.COPY;
                }
                if (simpleTrgtName.equals("escape")) {
                    return StringOperation.ESCAPE;
                }
                if (simpleTrgtName.equals("unescape")) {
                    return StringOperation.UNESCAPE;
                }
                if (StringTransducer.isInvalidTarget(trgtName)) {
                    return StringOperation.OTHER;
                }
                Assertions.UNREACHABLE((String)("ERROR: unexpected string operation: " + trgtName));
                return null;
            }
        }
        return StringOperation.OTHER;
    }

    private static boolean isJavaScriptStringAPI(String s) {
        return s.startsWith("string.");
    }

    private static String simplify(String trgtName) {
        String result = trgtName.replace("string.", "");
        result = result.replace("prototype.", "");
        return result;
    }

    private static boolean isInvalidTarget(String trgtName) {
        return trgtName.equals("string.getelementbyid") || trgtName.equals("string.note_url");
    }

    private static boolean isStringClass(TypeReference classRef, ISPALangServices langServices) {
        return langServices.getLanguage().getStringType().getName().equals((Object)classRef.getName());
    }

    protected boolean killIncomingString() {
        return false;
    }

    protected int getUse(SSAAbstractInvokeInstruction invoke, int idx) {
        int numUses;
        int normalizedIdx = invoke instanceof JavaScriptInvoke ? idx + 1 : idx;
        int n = numUses = invoke instanceof JavaScriptInvoke ? ((JavaScriptInvoke)invoke).getNumberOfParameters() : invoke.getNumberOfUses();
        if (normalizedIdx >= numUses) {
            return -1;
        }
        return invoke.getUse(normalizedIdx);
    }

    public abstract Set<StringPrefix> transduce(StringPrefix var1, BasicBlockInContext<IExplodedBasicBlock> var2, CallGraph var3, SSAAbstractInvokeInstruction var4, ISPALangServices var5);

    static {
        DEFAULT_TRANSDUCER = new StringTransducer(){

            @Override
            public Set<StringPrefix> transduce(StringPrefix sp, BasicBlockInContext<IExplodedBasicBlock> bb, CallGraph cg, SSAAbstractInvokeInstruction op, ISPALangServices langServices) {
                return null;
            }
        };
        transducers = HashMapFactory.make();
        transducers.put(StringOperation.SUBSTRING, new SubstringTransducer());
        transducers.put(StringOperation.SUBSTR, new SubstrTransducer());
        transducers.put(StringOperation.TO_LOWER_CASE, new ToLowerCaseTransducer());
        transducers.put(StringOperation.TO_UPPER_CASE, new ToUpperCaseTransducer());
        transducers.put(StringOperation.MATCH, new MatchTransducer());
        transducers.put(StringOperation.INDEX_OF, new IndexOfTransducer());
        transducers.put(StringOperation.LAST_INDEX_OF, new LastIndexOfTransducer());
        transducers.put(StringOperation.SPLIT, new SplitTransducer());
        transducers.put(StringOperation.REPLACE, new ReplaceTransducer());
        transducers.put(StringOperation.CONCAT, new ConcatTransducer());
        transducers.put(StringOperation.COPY, new CopyTransducer());
        transducers.put(StringOperation.ESCAPE, new EscapeTransducer());
        transducers.put(StringOperation.UNESCAPE, new UnescapeTransducer());
        transducers.put(StringOperation.CHAR_AT, DEFAULT_TRANSDUCER);
        transducers.put(StringOperation.OTHER, DEFAULT_TRANSDUCER);
    }

    static enum StringOperation {
        SUBSTRING(0),
        TO_LOWER_CASE(0),
        TO_UPPER_CASE(0),
        MATCH(0),
        SUBSTR(0),
        CHAR_AT(0),
        REPLACE(0),
        SPLIT(0),
        CONCAT(0),
        INDEX_OF(0),
        LAST_INDEX_OF(0),
        COPY(0),
        ESCAPE(1),
        UNESCAPE(1),
        OTHER(-1);

        private int strIdx;

        private StringOperation(int strIdx) {
            this.strIdx = strIdx;
        }

        public int getStrIdx() {
            return this.strIdx;
        }
    }
}

