/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.translator.dotnet;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.translator.repository.ConcatTemplate;
import com.ibm.wala.samso.translator.repository.ContainsConstraint;
import com.ibm.wala.samso.translator.repository.DefaultTemplate;
import com.ibm.wala.samso.translator.repository.IM2LConstraint;
import com.ibm.wala.samso.translator.repository.M2LTranslatorRepository;
import com.ibm.wala.samso.translator.repository.NotContainsConstraint;
import com.ibm.wala.samso.translator.repository.NotTemplate;
import com.ibm.wala.samso.translator.repository.ReplaceByRegexTemplate;
import com.ibm.wala.samso.translator.repository.ReplaceStrTemplate;
import com.ibm.wala.samso.translator.repository.RetEmptyTemplate;
import com.ibm.wala.samso.translator.repository.RetFixedStringTemplate;
import com.ibm.wala.samso.translator.repository.RetNthParameterTemplate;
import com.ibm.wala.samso.translator.repository.StringEqualsConstraint;
import com.ibm.wala.samso.translator.repository.SubstringTemplate;
import com.ibm.wala.samso.translator.repository.ToLowerCaseTemplate;
import com.ibm.wala.samso.translator.repository.ToUpperCaseTemplate;
import com.ibm.wala.samso.translator.repository.URLEncodeTemplate;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.stringAnalysis.dotnet.translator.RepositoryUtil;
import com.ibm.wala.stringAnalysis.translator.DefUseChainBasedComposer;
import com.ibm.wala.stringAnalysis.translator.IInvocationSymbolComposer;
import com.ibm.wala.stringAnalysis.translator.IRegexParser;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.types.ClassLoaderReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DotnetM2LTranslatorRepository
extends M2LTranslatorRepository {
    private static String[] defaultStringClasses = new String[]{"LSystem/String", "LSystem/Text/StringBuilder", "LSystem/Text/RegularExpressions/Regex"};
    private ClassLoader loader = null;
    private Set<String> stringClasses;
    private static String[] builtinPackages = new String[]{"System."};

    public DotnetM2LTranslatorRepository(ClassLoader loader, IExtendedFormulaFactory ffactory) {
        super(ffactory);
        this.loader = loader;
        this.stringClasses = new HashSet<String>();
        this.initTranslators();
        this.initMapTranslators();
        this.initStringClasses();
        this.initComposers();
    }

    public DotnetM2LTranslatorRepository(IExtendedFormulaFactory ffactory) {
        this(null, ffactory);
    }

    public void initComposers() {
        this.putComposer("System.String.Substring(II)LSystem/String;", (IInvocationSymbolComposer)new DefUseChainBasedComposer(2, Arrays.asList("System.String.IndexOf(Ljava/lang/String;)I", "System.String.IndexOf(Ljava/lang/String;I)I")));
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    protected void initTranslators() {
        DefaultTemplate ANY = new DefaultTemplate();
        RetEmptyTemplate EMPTY = new RetEmptyTemplate();
        this.translatorMap.put("op(add)", new ConcatTemplate());
        this.translatorMap.put("System.Int32.ToString()LSystem/String;", RetFixedStringTemplate.makeFromRegex((String)"(-?[0-9]+\\.[0-9]+)", (int)-1));
        this.translatorMap.put("System.Object.ToString()LSystem/String;", new RetNthParameterTemplate(0));
        this.translatorMap.put("System.String.Substring(Pint;Pint;)LSystem/String;", new SubstringTemplate(0, 1, 2));
        this.translatorMap.put("System.String.Substring(Pint;)LSystem/String;", new SubstringTemplate(0, 1));
        this.translatorMap.put("System.String.ToUpper()Ljava/lang/String;", new ToUpperCaseTemplate(0));
        this.translatorMap.put("System.String.ToLower()Ljava/lang/String;", new ToLowerCaseTemplate(0));
        this.translatorMap.put("System.String.Concat(LSystem/String;)LSystem/String;", new ConcatTemplate());
        this.translatorMap.put("System.String.Concat(LSystem/String;LSystem/String;)LSystem/String;", new ConcatTemplate());
        this.translatorMap.put("System.String.Concat(LSystem/String;LSystem/String;LSystem/String;)LSystem/String;", new ConcatTemplate());
        this.translatorMap.put("System.String.Concat(LSystem/String;LSystem/String;LSystem/String;LSystem/String;)LSystem/String;", new ConcatTemplate());
        this.translatorMap.put("System.String.Replace(LSystem/String;LSystem/String;)LSystem/String;", new ReplaceStrTemplate(0, 1, 2));
        this.translatorMap.put("System.Text.RegularExpressions.Regex.Replace(LSystem/String;LSystem/String;)LSystem/String;", new ReplaceByRegexTemplate(1, 0, 2));
        this.translatorMap.put("System.Text.RegularExpressions.Regex.Replace(LSystem/String;LSystem/String;LSystem/String;)LSystem/String;", new ReplaceByRegexTemplate(1, 2, 3));
        this.translatorMap.put("System.Text.StringBuilder..ctor()Pvoid;", EMPTY);
        this.translatorMap.put("System.Text.StringBuilder.Append(LSystem/String;)LSystem/Text/StringBuilder;", new ConcatTemplate());
        this.translatorMap.put("System.Text.StringBuilder.Replace(LSystem/String;LSystem/String;)LSystem/Text/StringBuilder;", new ReplaceStrTemplate(0, 1, 2));
        this.translatorMap.put("System.Text.StringBuilder.ToString()LSystem/String;", new RetNthParameterTemplate(0));
        this.translatorMap.put("System.Web.HttpUtility.UrlEncode(LSystem/String;)LSystem/String;", new URLEncodeTemplate());
        this.translatorMap.put("&System.String.Equals(LSystem/Object;)Z", new StringEqualsConstraint(0, 1));
        this.translatorMap.put("!System.String.Equals(LSystem/Object;)Z", new NotTemplate((IM2LConstraint)new StringEqualsConstraint(0, 1)));
        this.translatorMap.put("&System.String.Equals(LSystem/String;)Z", new StringEqualsConstraint(0, 1));
        this.translatorMap.put("!System.String.Equals(LSystem/String;)Z", new NotTemplate((IM2LConstraint)new StringEqualsConstraint(0, 1)));
        this.translatorMap.put("&System.String.Contains(LSystem/String;)Z", new ContainsConstraint(0, 1));
        this.translatorMap.put("!System.String.Contains(LSystem/String;)Z", new NotContainsConstraint(0, 1));
        this.translatorMap.put("System.Text.RegularExpressions.Regex..ctor(LSystem/String;)Pvoid;", new RetNthParameterTemplate(1));
        this.translatorMap.put("System.Text.RegularExpressions.Regex..ctor(LSystem/String;LSystem/Text/RegularExpressions/RegexOptions;)Pvoid;", new RetNthParameterTemplate(1));
    }

    protected void initMapTranslators() {
    }

    protected void initStringClasses() {
        for (int i = 0; i < defaultStringClasses.length; ++i) {
            this.stringClasses.add(defaultStringClasses[i]);
        }
    }

    public boolean isStringClass(String classSignature) {
        return this.stringClasses.contains(classSignature);
    }

    public int[] getParams(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        int[] params;
        if (invoke.isStatic()) {
            params = new int[invoke.getNumberOfParameters()];
            for (int i = 0; i < params.length; ++i) {
                params[i] = invoke.getUse(i);
            }
        } else {
            params = new int[invoke.getNumberOfParameters() - 1];
            for (int i = 0; i < params.length; ++i) {
                params[i] = invoke.getUse(i + 1);
            }
        }
        return params;
    }

    public int getReceiver(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        if (invoke.isStatic()) {
            return -1;
        }
        return invoke.getReceiver();
    }

    public int[] getParams(IR ir) {
        int[] p = ir.getParameterValueNumbers();
        if (ir.getMethod().isStatic()) {
            return p;
        }
        int[] r = new int[p.length - 1];
        for (int i = 0; i < r.length; ++i) {
            r[i] = p[i + 1];
        }
        return r;
    }

    public int getReceiver(IR ir) {
        if (ir.getMethod().isStatic()) {
            return -1;
        }
        if (ir.getNumberOfParameters() > 0) {
            return ir.getParameter(0);
        }
        return -1;
    }

    public Set<String> getSignature(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        return RepositoryUtil.getSignature((SSAAbstractInvokeInstruction)invoke, (TranslationContext)ctx, (ITranslatorRepository)this);
    }

    private boolean containsBuiltinPackageName(String s) {
        for (String b : builtinPackages) {
            if (!s.startsWith(b)) continue;
            return true;
        }
        return false;
    }

    public boolean isBuiltin(String signature, SSAAbstractInvokeInstruction instruction, CallGraph cg) {
        if (this.containsBuiltinPackageName(signature)) {
            return true;
        }
        Set nodes = cg.getNodes(instruction.getDeclaredTarget());
        if (nodes.isEmpty()) {
            return true;
        }
        if (this.hasSignature(signature)) {
            return true;
        }
        for (CGNode node : nodes) {
            if (this.isBuiltin(node, node.getMethod().getDeclaringClass().getClassLoader().getReference())) continue;
            return false;
        }
        return true;
    }

    public boolean isBuiltin(CGNode node, ClassLoaderReference loader) {
        return loader.equals((Object)ClassLoaderReference.Primordial) || this.containsBuiltinPackageName(node.getMethod().getSignature());
    }

    public IRegexParser getRegexParser() {
        return RepositoryUtil.getRegexParser();
    }

    public String getClassInitSignature() {
        return ".cctor";
    }

    public String getInitSignature() {
        return ".ctor";
    }
}

