/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public class InvokeInstruction
extends Instruction
implements IInvokeInstruction {
    protected String type;
    protected String classType;
    protected String methodName;

    InvokeInstruction(short opcode, String type, String classType, String methodName) {
        super(opcode);
        this.type = type;
        this.classType = classType;
        this.methodName = methodName;
    }

    public static InvokeInstruction make(String type, String className, String methodName, IInvokeInstruction.Dispatch mode) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        if (className == null) {
            throw new NullPointerException("className must not be null");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName must not be null");
        }
        if (mode == null) {
            throw new NullPointerException("mode must not be null");
        }
        short opcode = 0;
        switch (mode) {
            case VIRTUAL: {
                opcode = 182;
                break;
            }
            case SPECIAL: {
                opcode = 183;
                break;
            }
            case STATIC: {
                opcode = 184;
                break;
            }
            case INTERFACE: {
                opcode = 185;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return new InvokeInstruction(opcode, type, className, methodName);
    }

    ConstantPoolReader getLazyConstantPool() {
        return null;
    }

    static InvokeInstruction make(ConstantPoolReader cp, int index, int mode) {
        if (mode < 182 || mode > 185) {
            throw new IllegalArgumentException("Unknown mode: " + mode);
        }
        return new Lazy((short)mode, cp, index);
    }

    public final boolean equals(Object o) {
        if (o instanceof InvokeInstruction) {
            InvokeInstruction i = (InvokeInstruction)o;
            return i.getMethodSignature().equals(this.getMethodSignature()) && i.getClassType().equals(this.getClassType()) && i.getMethodName().equals(this.getMethodName()) && i.opcode == this.opcode;
        }
        return false;
    }

    @Override
    public String getClassType() {
        return this.classType;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getMethodSignature() {
        return this.type;
    }

    public final int getInvocationMode() {
        return this.opcode;
    }

    public final String getInvocationModeString() {
        switch (this.opcode) {
            case 184: {
                return "STATIC";
            }
            case 185: {
                return "INTERFACE";
            }
            case 183: {
                return "SPECIAL";
            }
            case 182: {
                return "VIRTUAL";
            }
        }
        throw new Error("Unknown mode: " + this.opcode);
    }

    public final int hashCode() {
        return this.getMethodSignature().hashCode() + 9011 * this.getClassType().hashCode() + 317 * this.getMethodName().hashCode() + this.opcode * 3188;
    }

    @Override
    public final int getPoppedCount() {
        return (this.opcode == 184 ? 0 : 1) + Util.getParamsCount(this.getMethodSignature());
    }

    @Override
    public final String getPushedType(String[] types) {
        String t = Util.getReturnType(this.getMethodSignature());
        if (t.equals("V")) {
            return null;
        }
        return t;
    }

    @Override
    public final byte getPushedWordSize() {
        String t = this.getMethodSignature();
        int index = t.lastIndexOf(41);
        return Util.getWordSize(t, index + 1);
    }

    @Override
    public final void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitInvoke(this);
    }

    @Override
    public final String toString() {
        return "Invoke(" + this.getInvocationModeString() + "," + this.getClassType() + "," + this.getMethodName() + "," + this.getMethodSignature() + ")";
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public IInvokeInstruction.Dispatch getInvocationCode() {
        switch (this.opcode) {
            case 184: {
                return IInvokeInstruction.Dispatch.STATIC;
            }
            case 185: {
                return IInvokeInstruction.Dispatch.INTERFACE;
            }
            case 183: {
                return IInvokeInstruction.Dispatch.SPECIAL;
            }
            case 182: {
                return IInvokeInstruction.Dispatch.VIRTUAL;
            }
        }
        throw new Error("Unknown mode: " + this.opcode);
    }

    static final class Lazy
    extends InvokeInstruction {
        private final ConstantPoolReader cp;
        private final int index;

        Lazy(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, null, null, null);
            this.index = index;
            this.cp = cp;
        }

        @Override
        ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        int getCPIndex() {
            return this.index;
        }

        @Override
        public String getClassType() {
            if (this.classType == null) {
                this.classType = this.cp.getConstantPoolMemberClassType(this.index);
            }
            return this.classType;
        }

        @Override
        public String getMethodName() {
            if (this.methodName == null) {
                this.methodName = this.cp.getConstantPoolMemberName(this.index);
            }
            return this.methodName;
        }

        @Override
        public String getMethodSignature() {
            if (this.type == null) {
                this.type = this.cp.getConstantPoolMemberType(this.index);
            }
            return this.type;
        }
    }
}

