/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.m2lstr;

import com.ibm.wala.automaton.parser.JavaRegexParser;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.samso.m2lstr.CommentedPredicateDeclaration;
import com.ibm.wala.samso.m2lstr.DeclarationSet;
import com.ibm.wala.samso.m2lstr.IBoolean;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.IFormula;
import com.ibm.wala.samso.m2lstr.ILambdaFormula;
import com.ibm.wala.samso.m2lstr.IPositionSetTerm;
import com.ibm.wala.samso.m2lstr.IPositionSetVariable;
import com.ibm.wala.samso.m2lstr.IPositionVariable;
import com.ibm.wala.samso.m2lstr.IPredicate;
import com.ibm.wala.samso.m2lstr.IPredicateDeclaration;
import com.ibm.wala.samso.m2lstr.LambdaFormula;
import com.ibm.wala.samso.m2lstr.RegexpToM2L;
import com.ibm.wala.samso.m2lstr.RegexpToM2LFormula;
import com.ibm.wala.samso.translator.IDeclarationSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DeclarationSets {
    public static final int MAX_POSITION = 8;
    public static final int MAX_STRLEN = 8;
    public static final int SPLIT_LEN = 8;
    public static final IBinaryOperation orOperation = new IBinaryOperation(){

        @Override
        public IFormula create(IFormula f1, IFormula f2, IExtendedFormulaFactory ffactory) {
            return ffactory.createOr(f1, f2);
        }
    };
    public static final IBinaryOperation andOperation = new IBinaryOperation(){

        @Override
        public IFormula create(IFormula f1, IFormula f2, IExtendedFormulaFactory ffactory) {
            return ffactory.createAnd(f1, f2);
        }
    };
    public static final IBinaryOperation implyOperation = new IBinaryOperation(){

        @Override
        public IFormula create(IFormula f1, IFormula f2, IExtendedFormulaFactory ffactory) {
            return ffactory.createImply(f1, f2);
        }
    };
    private static JavaRegexParser regexpParser = new JavaRegexParser();

    public static IDeclarationSet createConcatenation(List<? extends IDeclarationSet> declSets, IExtendedFormulaFactory ffactory) {
        if (declSets.size() == 1) {
            return declSets.iterator().next();
        }
        if (declSets.size() == 0) {
            return DeclarationSets.createEmpty(ffactory);
        }
        IDeclarationSet[] decls = declSets.toArray(new IDeclarationSet[declSets.size()]);
        IPositionSetTerm[] Ps = new IPositionSetVariable[declSets.size()];
        for (int i = 0; i < Ps.length; ++i) {
            Ps[i] = ffactory.createPositionSetVariable();
        }
        IPositionSetVariable R = ffactory.createPositionSetVariable();
        IFormula body = ffactory.createIsConcat(R, Ps);
        for (int i = 0; i < Ps.length; ++i) {
            body = ffactory.createAnd(ffactory.createApplyPredicate(decls[i].getTarget(), Ps[i]), body);
            body = ffactory.createExists((IPositionSetVariable)Ps[i], body);
        }
        IPredicate pred = ffactory.createPredicate(1, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION_SET});
        IPredicateDeclaration decl = ffactory.createPredicateDeclaration(pred, body, R);
        DeclarationSet declSet = new DeclarationSet(pred);
        for (IDeclarationSet iDeclarationSet : declSets) {
            declSet.addAll(iDeclarationSet);
        }
        declSet.add(decl);
        return declSet;
    }

    public static IDeclarationSet createBinOp(Collection<? extends IDeclarationSet> declSets, IExtendedFormulaFactory ffactory, IBinaryOperation binOp) {
        int size = declSets.size();
        if (size == 1) {
            return declSets.iterator().next();
        }
        IPositionSetVariable R = ffactory.createPositionSetVariable();
        Iterator<? extends IDeclarationSet> i = declSets.iterator();
        assert (size > 1);
        IPredicate declPred = i.next().getTarget();
        IFormula body = ffactory.createApplyPredicate(declPred, R);
        while (i.hasNext()) {
            declPred = i.next().getTarget();
            body = binOp.create(body, ffactory.createApplyPredicate(declPred, R), ffactory);
        }
        IPredicate pred = ffactory.createPredicate(1, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION_SET});
        IPredicateDeclaration decl = ffactory.createPredicateDeclaration(pred, body, R);
        DeclarationSet declSet = new DeclarationSet(pred);
        for (IDeclarationSet iDeclarationSet : declSets) {
            declSet.addAll(iDeclarationSet);
        }
        declSet.add(decl);
        return declSet;
    }

    public static IDeclarationSet createBinOpForPosition(Collection<? extends IDeclarationSet> declSets, IExtendedFormulaFactory ffactory, IBinaryOperation binOp) {
        int size = declSets.size();
        if (size == 1) {
            return declSets.iterator().next();
        }
        if (declSets.size() == 0) {
            return DeclarationSets.createEmpty(ffactory);
        }
        IPositionSetVariable R = ffactory.createPositionSetVariable();
        IPositionVariable r = ffactory.createPositionVariable();
        Iterator<? extends IDeclarationSet> i = declSets.iterator();
        IPredicate declPred = i.next().getTarget();
        IFormula body = ffactory.createApplyPredicate(declPred, r, R);
        while (i.hasNext()) {
            declPred = i.next().getTarget();
            body = binOp.create(body, ffactory.createApplyPredicate(declPred, r, R), ffactory);
        }
        IPredicate pred = ffactory.createPredicate(2, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION, IPredicate.ArgType.POSITION_SET});
        IPredicateDeclaration decl = ffactory.createPredicateDeclaration(pred, body, r, R);
        DeclarationSet declSet = new DeclarationSet(pred);
        for (IDeclarationSet iDeclarationSet : declSets) {
            declSet.addAll(iDeclarationSet);
        }
        declSet.add(decl);
        return declSet;
    }

    public static IDeclarationSet createUnion(Collection<? extends IDeclarationSet> declSets, IExtendedFormulaFactory ffactory) {
        return DeclarationSets.createBinOp(declSets, ffactory, orOperation);
    }

    public static IDeclarationSet createUnionForPosition(Collection<? extends IDeclarationSet> declSets, IExtendedFormulaFactory ffactory) {
        return DeclarationSets.createBinOpForPosition(declSets, ffactory, orOperation);
    }

    public static IDeclarationSet createIntersection(Collection<? extends IDeclarationSet> declSets, IExtendedFormulaFactory ffactory) {
        return DeclarationSets.createBinOp(declSets, ffactory, andOperation);
    }

    public static IDeclarationSet createIntersectionForPosition(Collection<? extends IDeclarationSet> declSets, IExtendedFormulaFactory ffactory) {
        return DeclarationSets.createBinOpForPosition(declSets, ffactory, andOperation);
    }

    public static IDeclarationSet createImply(List<? extends IDeclarationSet> declSets, IExtendedFormulaFactory ffactory) {
        return DeclarationSets.createBinOp(declSets, ffactory, implyOperation);
    }

    public static IDeclarationSet createImplyForPosition(List<? extends IDeclarationSet> declSets, IExtendedFormulaFactory ffactory) {
        return DeclarationSets.createBinOpForPosition(declSets, ffactory, implyOperation);
    }

    public static IDeclarationSet createImply(IDeclarationSet declSet1, IDeclarationSet declSet2, IExtendedFormulaFactory ffactory) {
        return DeclarationSets.createImply(Arrays.asList(declSet1, declSet2), ffactory);
    }

    public static IDeclarationSet createImplyForPosition(IDeclarationSet declSet1, IDeclarationSet declSet2, IExtendedFormulaFactory ffactory) {
        return DeclarationSets.createImplyForPosition(Arrays.asList(declSet1, declSet2), ffactory);
    }

    public static IDeclarationSet createComplement(IDeclarationSet declSet, IExtendedFormulaFactory ffactory) {
        IPredicate pred = ffactory.createPredicate(1, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION_SET});
        IPositionSetVariable R = ffactory.createPositionSetVariable();
        IFormula body = ffactory.createNot(ffactory.createApplyPredicate(declSet.getTarget(), R));
        IPredicateDeclaration decl = ffactory.createPredicateDeclaration(pred, body, R);
        DeclarationSet declSet2 = new DeclarationSet(pred);
        declSet2.addAll(declSet);
        declSet2.add(decl);
        return declSet2;
    }

    public static IDeclarationSet createComplementForPosition(IDeclarationSet declSet, IExtendedFormulaFactory ffactory) {
        IPredicate pred = ffactory.createPredicate(2, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION, IPredicate.ArgType.POSITION_SET});
        IPositionSetVariable R = ffactory.createPositionSetVariable();
        IPositionVariable r = ffactory.createPositionVariable();
        IFormula body = ffactory.createNot(ffactory.createApplyPredicate(declSet.getTarget(), r, R));
        IPredicateDeclaration decl = ffactory.createPredicateDeclaration(pred, body, r, R);
        DeclarationSet declSet2 = new DeclarationSet(pred);
        declSet2.addAll(declSet);
        declSet2.add(decl);
        return declSet2;
    }

    public static IDeclarationSet createEmpty(IExtendedFormulaFactory ffactory) {
        IPredicate pred = ffactory.createPredicate(1, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION_SET});
        IPositionSetVariable R = ffactory.createPositionSetVariable();
        IFormula body = ffactory.createIsEmpty(R);
        IPredicateDeclaration decl = ffactory.createPredicateDeclaration(pred, body, R);
        DeclarationSet declSet = new DeclarationSet(pred);
        declSet.add(decl);
        return declSet;
    }

    public static IDeclarationSet createAny(IExtendedFormulaFactory ffactory) {
        IPredicate pred = ffactory.createPredicate(1, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION_SET});
        IPositionSetVariable R = ffactory.createPositionSetVariable();
        IBoolean body = ffactory.createTrue();
        IPredicateDeclaration decl = ffactory.createPredicateDeclaration(pred, body, R);
        DeclarationSet declSet = new DeclarationSet(pred);
        declSet.add(decl);
        return declSet;
    }

    public static IDeclarationSet createAnyForPosition(IExtendedFormulaFactory ffactory) {
        IPredicate pred = ffactory.createPredicate(2, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION, IPredicate.ArgType.POSITION_SET});
        IPositionSetVariable R = ffactory.createPositionSetVariable("R");
        IPositionVariable r = ffactory.createPositionVariable("r");
        IFormula body = ffactory.createIn(r, R);
        IPredicateDeclaration decl = ffactory.createPredicateDeclaration(pred, body, r, R);
        DeclarationSet declSet = new DeclarationSet(pred);
        declSet.add(decl);
        return declSet;
    }

    public static IDeclarationSet createIteration(IDeclarationSet declSet1, IExtendedFormulaFactory ffactory) {
        IPositionSetVariable R = ffactory.createPositionSetVariable();
        IPositionSetVariable S = ffactory.createPositionSetVariable();
        IPositionSetVariable P = ffactory.createPositionSetVariable();
        IPositionVariable r1 = ffactory.createPositionVariable();
        IPositionVariable r2 = ffactory.createPositionVariable();
        IFormula min = ffactory.createIn(ffactory.createApplyPositionFunction(ffactory.createMinFunction(), R), P);
        IFormula max = ffactory.createIn(ffactory.createPositionPlus(ffactory.createApplyPositionFunction(ffactory.createMaxFunction(), R), 1), P);
        IFormula con = ffactory.createIsConsecutive(r1, r2, P);
        IFormula strr = ffactory.createIsStrr(S, R, r1, r2);
        IFormula target = ffactory.createApplyPredicate(declSet1.getTarget(), S);
        IFormula impl = ffactory.createImply(con, ffactory.createExists(S, ffactory.createAnd(strr, target)));
        IFormula impl2 = ffactory.createForall(r1, ffactory.createForall(r2, impl));
        IFormula body = ffactory.createExists(P, ffactory.createAnd(ffactory.createAnd(min, max), impl2));
        IPredicate pred = ffactory.createPredicate(1, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION_SET});
        IPredicateDeclaration decl = ffactory.createPredicateDeclaration(pred, body, R);
        DeclarationSet declSet = new DeclarationSet(pred);
        declSet.addAll(declSet1);
        declSet.add(decl);
        return declSet;
    }

    public static IDeclarationSet createDeclarationSetForPosition(int n, IExtendedFormulaFactory ffactory) {
        IPredicate pred = ffactory.createPredicate(2, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION, IPredicate.ArgType.POSITION_SET});
        IPositionVariable p = ffactory.createPositionVariable("p");
        IPositionSetVariable P = ffactory.createPositionSetVariable("P");
        IFormula body = n < 8 & n >= 0 ? ffactory.createPos(n, p, P) : ffactory.createIn(p, P);
        IPredicateDeclaration decl = ffactory.createPredicateDeclaration(pred, body, p, P);
        decl = new CommentedPredicateDeclaration(decl, "position " + n);
        DeclarationSet declSet = new DeclarationSet(pred);
        declSet.add(decl);
        return declSet;
    }

    public static IDeclarationSet createUnorderedDeclarationSet(char[] cs, int len, IExtendedFormulaFactory ffactory) {
        IPositionSetVariable R = ffactory.createPositionSetVariable();
        IFormula body = null;
        int cslen = cs.length;
        for (int i = 0; i < cslen; i += len) {
            String str = new String(cs, i, i + len <= cslen ? len : cslen - i);
            IFormula f = ffactory.createIsStr(str, R);
            body = body == null ? f : ffactory.createOr(f, body);
        }
        IDeclarationSet declSet = DeclarationSets.createDeclarationSet("splitted string " + String.copyValueOf(cs), R, body, ffactory);
        return DeclarationSets.createIteration(declSet, ffactory);
    }

    public static IDeclarationSet createUnorderedDeclarationSet(char[] cs, IExtendedFormulaFactory ffactory) {
        IPositionSetVariable R = ffactory.createPositionSetVariable();
        IPositionVariable p = ffactory.createPositionVariable();
        IFormula body = null;
        for (char c : cs) {
            IFormula f = ffactory.createIsChar(c, p);
            body = body == null ? f : ffactory.createOr(f, body);
        }
        body = ffactory.createExists(p, ffactory.createImply(ffactory.createIn(p, R), body));
        return DeclarationSets.createDeclarationSet("string " + String.copyValueOf(cs), R, body, ffactory);
    }

    public static IDeclarationSet createDeclarationSet(String s, IExtendedFormulaFactory ffactory) {
        if (s.length() < 8) {
            IPositionSetVariable R = ffactory.createPositionSetVariable();
            IFormula body = ffactory.createIsStr(s, R);
            return DeclarationSets.createDeclarationSet("set of characters " + s, R, body, ffactory);
        }
        return DeclarationSets.createUnorderedDeclarationSet(s.toCharArray(), 8, ffactory);
    }

    public static IDeclarationSet createDeclarationSet(IPositionSetVariable R, IFormula body, IExtendedFormulaFactory ffactory) {
        return DeclarationSets.createDeclarationSet("", R, body, ffactory);
    }

    public static IDeclarationSet createDeclarationSet(String comment, IPositionSetVariable R, IFormula body, IExtendedFormulaFactory ffactory) {
        IPredicate pred = ffactory.createPredicate(1, new IPredicate.ArgType[]{IPredicate.ArgType.POSITION_SET});
        IPredicateDeclaration decl = ffactory.createPredicateDeclaration(pred, body, R);
        decl = new CommentedPredicateDeclaration(decl, comment);
        DeclarationSet declSet = new DeclarationSet(pred);
        declSet.add(decl);
        return declSet;
    }

    public static IDeclarationSet createDeclarationSetForRegexp(String regexp, IExtendedFormulaFactory ffactory) {
        RegexpToM2L comp = new RegexpToM2L(ffactory);
        IPattern pat = regexpParser.parse(regexp);
        if (pat == null) {
            System.err.println("parsing error of the regular expression: " + regexp);
            return DeclarationSets.createAny(ffactory);
        }
        IDeclarationSet declSet = (IDeclarationSet)comp.compile(pat);
        return declSet;
    }

    public static ILambdaFormula createFormulaForRegexp(IPattern pat, IExtendedFormulaFactory ffactory) {
        RegexpToM2LFormula comp = new RegexpToM2LFormula(ffactory);
        return (ILambdaFormula)comp.compile(pat);
    }

    public static ILambdaFormula createFormulaForRegexp(String regexp, IExtendedFormulaFactory ffactory) {
        IPattern pat = regexpParser.parse(regexp);
        if (pat == null) {
            System.err.println("parsing error of the regular expression: " + regexp);
            return null;
        }
        return DeclarationSets.createFormulaForRegexp(pat, ffactory);
    }

    public static ILambdaFormula createIteration(ILambdaFormula pred, IExtendedFormulaFactory ffactory) {
        IPositionSetVariable S = (IPositionSetVariable)pred.getVariable(0);
        IPositionSetVariable R = ffactory.createPositionSetVariable();
        IPositionSetVariable P = ffactory.createPositionSetVariable();
        IPositionVariable r1 = ffactory.createPositionVariable();
        IPositionVariable r2 = ffactory.createPositionVariable();
        IFormula min = ffactory.createIn(ffactory.createApplyPositionFunction(ffactory.createMinFunction(), R), P);
        IFormula max = ffactory.createIn(ffactory.createPositionPlus(ffactory.createApplyPositionFunction(ffactory.createMaxFunction(), R), 1), P);
        IFormula con = ffactory.createIsConsecutive(r1, r2, P);
        IFormula strr = ffactory.createIsStrr(S, R, r1, r2);
        IFormula impl = ffactory.createImply(con, ffactory.createExists(S, ffactory.createAnd(strr, pred.getFormula())));
        IFormula impl2 = ffactory.createForall(r1, ffactory.createForall(r2, impl));
        IFormula body = ffactory.createExists(P, ffactory.createAnd(ffactory.createAnd(min, max), impl2));
        return LambdaFormula.make(body, R);
    }

    public static ILambdaFormula createIterationInSet(ILambdaFormula pred, IPositionSetVariable W, IExtendedFormulaFactory ffactory) {
        IFormula substr = ffactory.createIsSubstr((IPositionSetVariable)pred.getVariable(0), W);
        IFormula body = ffactory.createAnd(substr, pred.getFormula());
        return DeclarationSets.createIteration(LambdaFormula.make(body, pred.getVariable(0)), ffactory);
    }

    public static interface IBinaryOperation {
        public IFormula create(IFormula var1, IFormula var2, IExtendedFormulaFactory var3);
    }
}

