/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.m2lstr.mona;

import com.ibm.wala.samso.m2lstr.AbstractExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.BinEncoder;
import com.ibm.wala.samso.m2lstr.BoundVariableFilter;
import com.ibm.wala.samso.m2lstr.IApplyPredicateFormula;
import com.ibm.wala.samso.m2lstr.IBoolean;
import com.ibm.wala.samso.m2lstr.IDeclaration;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.IFormula;
import com.ibm.wala.samso.m2lstr.IFormulaDeclaration;
import com.ibm.wala.samso.m2lstr.IPosition;
import com.ibm.wala.samso.m2lstr.IPositionFunction;
import com.ibm.wala.samso.m2lstr.IPositionSet;
import com.ibm.wala.samso.m2lstr.IPositionSetFunction;
import com.ibm.wala.samso.m2lstr.IPositionSetTerm;
import com.ibm.wala.samso.m2lstr.IPositionSetVariable;
import com.ibm.wala.samso.m2lstr.IPositionSetVariableDefinition;
import com.ibm.wala.samso.m2lstr.IPositionTerm;
import com.ibm.wala.samso.m2lstr.IPositionVariable;
import com.ibm.wala.samso.m2lstr.IPositionVariableDefinition;
import com.ibm.wala.samso.m2lstr.IPredicate;
import com.ibm.wala.samso.m2lstr.IPredicateDeclaration;
import com.ibm.wala.samso.m2lstr.ITerm;
import com.ibm.wala.samso.m2lstr.IVariable;
import com.ibm.wala.samso.parser.M2LParser;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.functions.Function;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MONAFormulaFactory
implements IExtendedFormulaFactory {
    private int N = 0;
    private int predN = 0;
    private static final IPositionSetVariable[] bitVar = new IPositionSetVariable[BinEncoder.BitN];
    private static final IPredicateDeclaration[] charDecl = new IPredicateDeclaration[BinEncoder.MAX_VALUE + 1];
    private static List<IDeclaration> prologue = null;
    public static final int numberOfPredefinedVars = 9;
    private final IPredicate concatPredicate;
    private final IPredicate consecutivePredicate;
    private final IPredicate strrPredicate;
    private final IPredicate substrPredicate;
    private final IPredicate substrrPredicate;
    private final IPredicate choicePredicate;
    private final IPredicate separatorPredicate;
    private final IExtendedFormulaFactory ext;
    private final M2LParser parser = new M2LParser(this);
    private static Set<String> predefinedVariables;
    private static String FALSE;
    private static String TRUE;

    public MONAFormulaFactory() {
        this.concatPredicate = this.createPredicate("concat", 3, IPredicate.ArgType.fromString("222"));
        this.consecutivePredicate = this.createPredicate("consecutive", 3, IPredicate.ArgType.fromString("112"));
        this.strrPredicate = this.createPredicate("strr", 4, IPredicate.ArgType.fromString("2211"));
        this.substrPredicate = this.createPredicate("substr", 2, IPredicate.ArgType.fromString("22"));
        this.substrrPredicate = this.createPredicate("substrr", 4, IPredicate.ArgType.fromString("2211"));
        this.choicePredicate = this.createPredicate("choice", 2, IPredicate.ArgType.fromString("22"));
        this.separatorPredicate = this.createPredicate("separator", 1, IPredicate.ArgType.fromString("1"));
        this.ext = new AbstractExtendedFormulaFactory(this){

            @Override
            protected IPredicate getConcatPredicate() {
                return MONAFormulaFactory.this.concatPredicate;
            }

            @Override
            protected IPredicate getConsecutivePredicate() {
                return MONAFormulaFactory.this.consecutivePredicate;
            }

            @Override
            protected IPredicate getStrrPredicate() {
                return MONAFormulaFactory.this.strrPredicate;
            }

            @Override
            protected IPredicate getSubstrPredicate() {
                return MONAFormulaFactory.this.substrPredicate;
            }

            @Override
            protected IPredicate getSubstrrPredicate() {
                return MONAFormulaFactory.this.substrrPredicate;
            }

            @Override
            protected IPredicate getChoicePredicate() {
                return MONAFormulaFactory.this.choicePredicate;
            }

            @Override
            protected IPredicate getSeparatorPredicate() {
                return MONAFormulaFactory.this.separatorPredicate;
            }

            @Override
            protected IFormula createInBit(IPositionTerm p, int bitN) {
                return this.createIn(p, bitVar[bitN]);
            }
        };
    }

    private static void initBitVars() {
        for (int i = 0; i < BinEncoder.BitN; ++i) {
            final int n = i;
            MONAFormulaFactory.bitVar[i] = new IPositionSetVariable(){

                @Override
                public String getName() {
                    return "Bit" + n;
                }

                public String toString() {
                    return this.getName();
                }

                @Override
                public ITerm replace(Function<IVariable, ITerm> m) {
                    return (ITerm)m.apply((Object)this);
                }
            };
        }
    }

    public static Collection<String> getPredefinedVariables() {
        if (predefinedVariables == null) {
            HashSet<String> l = new HashSet<String>();
            for (IPositionSetVariable v : bitVar) {
                l.add(v.getName());
            }
            predefinedVariables = Collections.unmodifiableSet(l);
        }
        return predefinedVariables;
    }

    public M2LParser getParser() {
        return this.parser;
    }

    @Override
    public List<IDeclaration> prologue() {
        if (prologue == null) {
            InputStream is = ClassLoader.getSystemResourceAsStream("sa.mona");
            List<IDeclaration> decls = this.parser.parse(is);
            prologue = new ArrayList<IDeclaration>(decls);
            for (int i = 0; i < charDecl.length; ++i) {
                String binStr = BinEncoder.encodeChar(i);
                char[] bit = binStr.toCharArray();
                String predNameC = "is_c" + binStr;
                String predNameS = "is_s" + binStr;
                String p = "p";
                String P = "P";
                StringBuffer body = new StringBuffer();
                for (int j = 0; j < bitVar.length; ++j) {
                    body.append("p" + (bit[j] == '0' ? " notin " : " in ") + bitVar[j]);
                    if (j >= bitVar.length - 1) continue;
                    body.append(" & ");
                }
                String formulaC = body.toString();
                String formulaS = "ex1 p: P = {p} & " + body;
                String declStrC = "pred " + predNameC + "(var1 " + "p" + ") = " + formulaC + ";";
                String declStrS = "pred " + predNameS + "(var2 " + "P" + ") = " + formulaS + ";";
                IDeclaration declC = this.parser.parse(declStrC).get(0);
                IDeclaration declS = this.parser.parse(declStrS).get(0);
                MONAFormulaFactory.charDecl[i] = (IPredicateDeclaration)declS;
                prologue.add(declC);
                prologue.add(declS);
            }
        }
        return Collections.unmodifiableList(prologue);
    }

    @Override
    public IFormula createAnd(final IFormula f1, final IFormula f2) {
        return new IFormula(){

            public String toString() {
                return "(" + f1.toString() + " & " + f2.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createAnd(f1.replaceTerm(m), f2.replaceTerm(m));
            }
        };
    }

    @Override
    public IPositionTerm createApplyPositionFunction(final IPositionFunction func, final ITerm ... args) {
        final StringBuffer buff = new StringBuffer();
        buff.append(func.toString());
        buff.append("(");
        for (int i = 0; i < args.length; ++i) {
            buff.append(args[i].toString());
            if (i == args.length - 1) continue;
            buff.append(",");
        }
        buff.append(")");
        return new IPositionTerm(){

            public String toString() {
                return buff.toString();
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                ITerm[] args2 = new ITerm[args.length];
                for (int i = 0; i < args2.length; ++i) {
                    args2[i] = args[i].replace(m);
                }
                return MONAFormulaFactory.this.createApplyPositionFunction(func, args2);
            }
        };
    }

    @Override
    public IPositionSetTerm createApplyPositionSetFunction(final IPositionSetFunction func, final ITerm ... args) {
        final StringBuffer buff = new StringBuffer();
        buff.append(func.toString());
        buff.append("(");
        for (int i = 0; i < args.length; ++i) {
            buff.append(args[i].toString());
            if (i == args.length - 1) continue;
            buff.append(",");
        }
        buff.append(")");
        return new IPositionSetTerm(){

            public String toString() {
                return buff.toString();
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                ITerm[] args2 = new ITerm[args.length];
                for (int i = 0; i < args2.length; ++i) {
                    args2[i] = args[i].replace(m);
                }
                return MONAFormulaFactory.this.createApplyPositionSetFunction(func, args2);
            }
        };
    }

    @Override
    public IFormula createApplyPredicate(final IPredicate pred, final ITerm ... args) {
        if (pred == null) {
            throw new RuntimeException("PANIC! pred is null.");
        }
        if (pred.getArity() != args.length) {
            SAUtil.println((Object)("PANIC! inconsistent arguments: " + pred));
            return this.createTrue();
        }
        final StringBuffer buff = new StringBuffer();
        buff.append(pred.toString());
        buff.append("(");
        for (int i = 0; i < args.length; ++i) {
            buff.append(args[i].toString());
            if (i == args.length - 1) continue;
            buff.append(",");
        }
        buff.append(")");
        return new IApplyPredicateFormula(){

            public String toString() {
                return buff.toString();
            }

            @Override
            public IPredicate getPredicate() {
                return pred;
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                ITerm[] args2 = new ITerm[args.length];
                for (int i = 0; i < args2.length; ++i) {
                    args2[i] = args[i].replace(m);
                }
                return MONAFormulaFactory.this.createApplyPredicate(pred, args2);
            }
        };
    }

    @Override
    public IFormula createExists(final IPositionVariable v, final IFormula body) {
        return new IFormula(){

            public String toString() {
                return "(ex1 " + v.toString() + ": " + body.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createExists(v, body.replaceTerm(new BoundVariableFilter(v, m)));
            }
        };
    }

    @Override
    public IFormula createExistsWhere(final IPositionVariable v, final IFormula where, final IFormula body) {
        return new IFormula(){

            public String toString() {
                return "(ex1 " + v.toString() + " where " + where.toString() + ": " + body.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                m = new BoundVariableFilter(v, m);
                return MONAFormulaFactory.this.createExistsWhere(v, where.replaceTerm(m), body.replaceTerm(m));
            }
        };
    }

    @Override
    public IFormula createForall(final IPositionVariable v, final IFormula body) {
        return new IFormula(){

            public String toString() {
                return "(all1 " + v.toString() + ": " + body.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                m = new BoundVariableFilter(v, m);
                return MONAFormulaFactory.this.createForall(v, body.replaceTerm(m));
            }
        };
    }

    @Override
    public IFormula createForallWhere(final IPositionVariable v, final IFormula where, final IFormula body) {
        return new IFormula(){

            public String toString() {
                return "(all1 " + v.toString() + " where " + where.toString() + ": " + body.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                m = new BoundVariableFilter(v, m);
                return MONAFormulaFactory.this.createForallWhere(v, where.replaceTerm(m), body.replaceTerm(m));
            }
        };
    }

    @Override
    public IFormula createExists(final IPositionSetVariable v, final IFormula body) {
        return new IFormula(){

            public String toString() {
                return "(ex2 " + v.toString() + ": " + body.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                m = new BoundVariableFilter(v, m);
                return MONAFormulaFactory.this.createExists(v, body.replaceTerm(m));
            }
        };
    }

    @Override
    public IFormula createExistsWhere(final IPositionSetVariable v, final IFormula where, final IFormula body) {
        return new IFormula(){

            public String toString() {
                return "(ex2 " + v.toString() + " where " + where.toString() + ": " + body.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                m = new BoundVariableFilter(v, m);
                return MONAFormulaFactory.this.createExistsWhere(v, where.replaceTerm(m), body.replaceTerm(m));
            }
        };
    }

    @Override
    public IFormula createForall(final IPositionSetVariable v, final IFormula body) {
        return new IFormula(){

            public String toString() {
                return "(all2 " + v.toString() + ": " + body.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                m = new BoundVariableFilter(v, m);
                return MONAFormulaFactory.this.createForall(v, body.replaceTerm(m));
            }
        };
    }

    @Override
    public IFormula createForallWhere(final IPositionSetVariable v, final IFormula where, final IFormula body) {
        return new IFormula(){

            public String toString() {
                return "(all2 " + v.toString() + " where " + where.toString() + ": " + body.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                m = new BoundVariableFilter(v, m);
                return MONAFormulaFactory.this.createForallWhere(v, where.replaceTerm(m), body.replaceTerm(m));
            }
        };
    }

    @Override
    public IFormula createIsChar(final char ch, final IPositionTerm pos) {
        return new IFormula(){

            public String toString() {
                return "is_c" + BinEncoder.encodeChar(ch) + "(" + pos.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createIsChar(ch, (IPositionTerm)pos.replace(m));
            }
        };
    }

    @Override
    public IPositionTerm createLastPosition() {
        return new IPositionTerm(){

            public String toString() {
                return "max($)";
            }

            @Override
            public IPositionTerm replace(Function<IVariable, ITerm> m) {
                return this;
            }
        };
    }

    @Override
    public IPositionFunction createMaxFunction() {
        return new IPositionFunction(){

            public String toString() {
                return "max";
            }

            @Override
            public int getArity() {
                return 1;
            }

            @Override
            public String getName() {
                return "max";
            }
        };
    }

    @Override
    public IPositionFunction createMinFunction() {
        return new IPositionFunction(){

            public String toString() {
                return "min";
            }

            @Override
            public int getArity() {
                return 1;
            }

            @Override
            public String getName() {
                return "min";
            }
        };
    }

    @Override
    public IPositionTerm createPositionMinus(final IPositionTerm pos, final int n) {
        return new IPositionTerm(){

            public String toString() {
                return "(" + pos.toString() + " - " + n + ")";
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createPositionMinus((IPositionTerm)pos.replace(m), n);
            }
        };
    }

    @Override
    public IFormula createNot(final IFormula body) {
        return new IFormula(){

            public String toString() {
                return "(~ " + body.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createNot(body.replaceTerm(m));
            }
        };
    }

    @Override
    public IFormula createOr(final IFormula f1, final IFormula f2) {
        return new IFormula(){

            public String toString() {
                return "(" + f1.toString() + " | " + f2.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createOr(f1.replaceTerm(m), f2.replaceTerm(m));
            }
        };
    }

    @Override
    public IFormula createImply(final IFormula f1, final IFormula f2) {
        return new IFormula(){

            public String toString() {
                return "(" + f1.toString() + " => " + f2.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createImply(f1.replaceTerm(m), f2.replaceTerm(m));
            }
        };
    }

    @Override
    public IPositionTerm createPositionPlus(final IPositionTerm pos, final int n) {
        return new IPositionTerm(){

            public String toString() {
                return "(" + pos.toString() + " + " + n + ")";
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createPositionPlus((IPositionTerm)pos.replace(m), n);
            }
        };
    }

    @Override
    public IPosition createPosition(final int pos) {
        final String n = Integer.toString(pos);
        return new IPosition(){

            public String toString() {
                return n;
            }

            @Override
            public int intValue() {
                return pos;
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return this;
            }
        };
    }

    @Override
    public IPositionFunction createPositionFunction(final String name, final int arity) {
        return new IPositionFunction(){

            public String toString() {
                return name;
            }

            @Override
            public int getArity() {
                return arity;
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    @Override
    public IPositionSet createPositionSet(final IPositionTerm ... pos) {
        final StringBuffer buff = new StringBuffer();
        buff.append("{");
        for (int i = 0; i < pos.length; ++i) {
            buff.append(pos[i].toString());
            if (i == pos.length - 1) continue;
            buff.append(",");
        }
        buff.append("}");
        return new IPositionSet(){

            public String toString() {
                return buff.toString();
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                IPositionTerm[] pos2 = new IPositionTerm[pos.length];
                for (int i = 0; i < pos.length; ++i) {
                    pos2[i] = (IPositionTerm)pos[i].replace(m);
                }
                return MONAFormulaFactory.this.createPositionSet(pos2);
            }
        };
    }

    @Override
    public IPositionSetFunction createPositionSetFunction(final String name, final int arity) {
        return new IPositionSetFunction(){

            public String toString() {
                return name;
            }

            @Override
            public int getArity() {
                return arity;
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    @Override
    public IPredicate createPredicate(final String name, final int arity, final IPredicate.ArgType[] argTypes) {
        return new IPredicate(){

            public String toString() {
                return name;
            }

            @Override
            public int getArity() {
                return arity;
            }

            @Override
            public IPredicate.ArgType getArgumentType(int n) {
                return argTypes[n];
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    @Override
    public IPredicate createPredicate(int arity, IPredicate.ArgType[] argTypes) {
        String name = "pred" + this.predN;
        ++this.predN;
        return this.createPredicate(name, arity, argTypes);
    }

    @Override
    public IPredicateDeclaration createPredicateDeclaration(final IPredicate pred, final IFormula body, final IVariable ... vars) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i] instanceof IPositionVariable) {
                buff.append("var1 ");
            } else if (vars[i] instanceof IPositionSetVariable) {
                buff.append("var2 ");
            }
            buff.append(vars[i].toString());
            if (i == vars.length - 1) continue;
            buff.append(",");
        }
        final String varsStr = buff.toString();
        return new IPredicateDeclaration(){

            public String toString() {
                return "pred " + pred.toString() + "(" + varsStr + ") = " + body;
            }

            @Override
            public IFormula getFormula() {
                return body;
            }

            @Override
            public IVariable[] getParameters() {
                return vars;
            }

            @Override
            public IPredicate getPredicate() {
                return pred;
            }
        };
    }

    @Override
    public IFormulaDeclaration createFormulaDeclaration(final IFormula f) {
        return new IFormulaDeclaration(){

            public String toString() {
                return f.toString();
            }

            @Override
            public IFormula getFormula() {
                return f;
            }
        };
    }

    @Override
    public IPositionSetTerm createSetIntersection(final IPositionSetTerm t1, final IPositionSetTerm t2) {
        return new IPositionSetTerm(){

            public String toString() {
                return "(" + t1.toString() + " inter " + t2.toString() + ")";
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createSetIntersection((IPositionSetTerm)t1.replace(m), (IPositionSetTerm)t2.replace(m));
            }
        };
    }

    @Override
    public IPositionSetTerm createPositionSetMinus(final IPositionSetTerm pos, final int n) {
        return new IPositionSetTerm(){

            public String toString() {
                return "(" + pos.toString() + " - " + n + ")";
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createPositionSetMinus((IPositionSetTerm)pos.replace(m), n);
            }
        };
    }

    @Override
    public IPositionSetTerm createPositionSetPlus(final IPositionSetTerm pos, final int n) {
        return new IPositionSetTerm(){

            public String toString() {
                return "(" + pos.toString() + " + " + n + ")";
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createPositionSetPlus((IPositionSetTerm)pos.replace(m), n);
            }
        };
    }

    @Override
    public IPositionSetTerm createSetSubtraction(final IPositionSetTerm t1, final IPositionSetTerm t2) {
        return new IPositionSetTerm(){

            public String toString() {
                return "(" + t1.toString() + " \\ " + t2.toString() + ")";
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createSetSubtraction((IPositionSetTerm)t1.replace(m), (IPositionSetTerm)t2.replace(m));
            }
        };
    }

    @Override
    public IPositionSetTerm createSetUnion(final IPositionSetTerm t1, final IPositionSetTerm t2) {
        return new IPositionSetTerm(){

            public String toString() {
                return "(" + t1.toString() + " union " + t2.toString() + ")";
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createSetUnion((IPositionSetTerm)t1.replace(m), (IPositionSetTerm)t2.replace(m));
            }
        };
    }

    @Override
    public IPositionSetVariable createPositionSetVariable() {
        final String n = Integer.toString(this.N);
        ++this.N;
        return new IPositionSetVariable(){

            @Override
            public String getName() {
                return "P" + n;
            }

            public String toString() {
                return this.getName();
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return (ITerm)m.apply((Object)this);
            }
        };
    }

    @Override
    public IPositionVariable createPositionVariable() {
        final String n = Integer.toString(this.N);
        ++this.N;
        return new IPositionVariable(){

            @Override
            public String getName() {
                return "p" + n;
            }

            public String toString() {
                return this.getName();
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return (ITerm)m.apply((Object)this);
            }
        };
    }

    @Override
    public IPositionSetVariable createPositionSetVariable(final String name) {
        return new IPositionSetVariable(){

            @Override
            public String getName() {
                return name;
            }

            public String toString() {
                return name;
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return (ITerm)m.apply((Object)this);
            }
        };
    }

    @Override
    public IPositionVariable createPositionVariable(final String name) {
        return new IPositionVariable(){

            @Override
            public String getName() {
                return name;
            }

            public String toString() {
                return name;
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return (ITerm)m.apply((Object)this);
            }
        };
    }

    @Override
    public IFormula createFormulaEqual(final IFormula t1, final IFormula t2) {
        return new IFormula(){

            public String toString() {
                return "(" + t1.toString() + " <=> " + t2.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createFormulaEqual(t1.replaceTerm(m), t2.replaceTerm(m));
            }
        };
    }

    @Override
    public IFormula createPositionEqual(final IPositionTerm t1, final IPositionTerm t2) {
        return new IFormula(){

            public String toString() {
                return "(" + t1.toString() + " = " + t2.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createPositionEqual((IPositionTerm)t1.replace(m), (IPositionTerm)t2.replace(m));
            }
        };
    }

    @Override
    public IFormula createPositionSetEqual(final IPositionSetTerm t1, final IPositionSetTerm t2) {
        return new IFormula(){

            public String toString() {
                return "(" + t1.toString() + " = " + t2.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createPositionSetEqual((IPositionSetTerm)t1.replace(m), (IPositionSetTerm)t2.replace(m));
            }
        };
    }

    @Override
    public IBoolean createFalse() {
        return new IBoolean(){

            public String toString() {
                return FALSE;
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return this;
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return this;
            }
        };
    }

    @Override
    public IBoolean createTrue() {
        return new IBoolean(){

            public String toString() {
                return TRUE;
            }

            @Override
            public ITerm replace(Function<IVariable, ITerm> m) {
                return this;
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return this;
            }
        };
    }

    @Override
    public IPositionSetVariableDefinition createPositionSetVariableDefinition(final IPositionSetVariable v) {
        return new IPositionSetVariableDefinition(){

            @Override
            public IPositionSetVariable getVariable() {
                return v;
            }

            public String toString() {
                return "var2 " + v.toString();
            }
        };
    }

    @Override
    public IPositionVariableDefinition createPositionVariableDefinition(final IPositionVariable v) {
        return new IPositionVariableDefinition(){

            @Override
            public IPositionVariable getVariable() {
                return v;
            }

            public String toString() {
                return "var1 " + v.toString();
            }
        };
    }

    @Override
    public IPositionSetVariableDefinition createPositionSetVariableDefinitionWhere(final IPositionSetVariable v, final IFormula f) {
        return new IPositionSetVariableDefinition(){

            @Override
            public IPositionSetVariable getVariable() {
                return v;
            }

            public String toString() {
                return "var2 " + v.toString() + " where " + f.toString();
            }
        };
    }

    @Override
    public IPositionVariableDefinition createPositionVariableDefinitionWhere(final IPositionVariable v, final IFormula f) {
        return new IPositionVariableDefinition(){

            @Override
            public IPositionVariable getVariable() {
                return v;
            }

            public String toString() {
                return "var1 " + v.toString() + " where " + f.toString();
            }
        };
    }

    @Override
    public IFormula createIsGT(final IPositionTerm pos1, final IPositionTerm pos2) {
        return new IFormula(){

            public String toString() {
                return "(" + pos1.toString() + " > " + pos2.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createIsGT((IPositionTerm)pos1.replace(m), (IPositionTerm)pos2.replace(m));
            }
        };
    }

    @Override
    public IFormula createIsLT(final IPositionTerm pos1, final IPositionTerm pos2) {
        return new IFormula(){

            public String toString() {
                return "(" + pos1.toString() + " < " + pos2.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createIsLT((IPositionTerm)pos1.replace(m), (IPositionTerm)pos2.replace(m));
            }
        };
    }

    @Override
    public IFormula createSubset(final IPositionSetTerm t1, final IPositionSetTerm t2) {
        return new IFormula(){

            public String toString() {
                return "(" + t1.toString() + " sub " + t2.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createSubset((IPositionSetTerm)t1.replace(m), (IPositionSetTerm)t2.replace(m));
            }
        };
    }

    @Override
    public IFormula createIn(final IPositionTerm p1, final IPositionSetTerm s1) {
        return new IFormula(){

            public String toString() {
                return "(" + p1.toString() + " in " + s1.toString() + ")";
            }

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return MONAFormulaFactory.this.createIn((IPositionTerm)p1.replace(m), (IPositionSetTerm)s1.replace(m));
            }
        };
    }

    @Override
    public IFormula createIsConcat(IPositionSetTerm r, IPositionSetTerm ... t) {
        return this.ext.createIsConcat(r, t);
    }

    @Override
    public IFormula createIsStr(String str, IPositionSetTerm t) {
        return this.ext.createIsStr(str, t);
    }

    @Override
    public IFormula createIsConsecutive(IPositionTerm p1, IPositionTerm p2, IPositionSetTerm R) {
        return this.ext.createIsConsecutive(p1, p2, R);
    }

    @Override
    public IFormula createIsStrr(IPositionSetTerm R, IPositionSetTerm S, IPositionTerm p1, IPositionTerm p2) {
        return this.ext.createIsStrr(R, S, p1, p2);
    }

    @Override
    public IFormula createIsSubstr(IPositionSetTerm R, IPositionSetTerm S) {
        return this.ext.createIsSubstr(R, S);
    }

    @Override
    public IFormula createIsSubstrr(IPositionSetTerm R, IPositionSetTerm S, IPositionTerm p1, IPositionTerm p2) {
        return this.ext.createIsSubstrr(R, S, p1, p2);
    }

    @Override
    public IFormula createIsEmpty(IPositionSetTerm t) {
        return this.ext.createIsEmpty(t);
    }

    @Override
    public IFormula createChoice(IPositionSetTerm R, IPositionSetTerm S) {
        return this.ext.createChoice(R, S);
    }

    @Override
    public IFormula createIsSeparator(IPositionTerm p) {
        return this.ext.createIsSeparator(p);
    }

    @Override
    public IFormula createCharset(IPositionTerm r, char min, char max) {
        return this.ext.createCharset(r, min, max);
    }

    @Override
    public IFormula createCharset(IPositionSetTerm R, char min, char max) {
        return this.ext.createCharset(R, min, max);
    }

    @Override
    public IFormula createPos(int n, IPositionTerm p, IPositionSetTerm P) {
        return this.ext.createPos(n, p, P);
    }

    static {
        MONAFormulaFactory.initBitVars();
        predefinedVariables = null;
        FALSE = "false";
        TRUE = "true";
    }
}

