/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.configuration.ase;

import com.hcl.appscan.sdk.auth.IASEAuthenticationProvider;
import com.hcl.appscan.sdk.configuration.ase.IComponent;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.http.HttpsClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class ASEAgentServerProvider
implements IComponent {
    private Map<String, String> m_agentServers;
    private IASEAuthenticationProvider m_authProvider;

    public ASEAgentServerProvider(IASEAuthenticationProvider provider) {
        this.m_authProvider = provider;
    }

    @Override
    public Map<String, String> getComponents() {
        if (this.m_agentServers == null) {
            this.loadAgentServers();
        }
        return this.m_agentServers;
    }

    @Override
    public String getComponentName(String id) {
        return this.getComponents().get(id);
    }

    private void loadAgentServers() {
        if (this.m_authProvider.isTokenExpired()) {
            return;
        }
        this.m_agentServers = new HashMap<String, String>();
        String url = this.m_authProvider.getServer() + "/api/agentServer";
        Map<String, String> headers = this.m_authProvider.getAuthorizationHeader(true);
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.get(url, headers, null);
            if (!response.isSuccess()) {
                return;
            }
            JSONArray array = (JSONArray)response.getResponseBodyAsJSON();
            if (array == null) {
                return;
            }
            for (int i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                String id = object.getString("serverId");
                String path = object.getString("name");
                this.m_agentServers.put(id, path);
            }
        }
        catch (IOException | JSONException e) {
            this.m_agentServers = null;
        }
    }
}

