/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.handlers;

import com.hcl.appscan.common.scm.ScmUtil;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.components.ScanManager;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.CustomTargetInfo;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.config.Configurator;
import java.io.File;
import java.util.Iterator;
import java.util.Map;

public class DiscoveryHandler {
    public int discover(Map<String, Boolean> targets) {
        IScan scan = ScanManager.getInstance().getActiveScan();
        Iterator<String> iter = targets.keySet().iterator();
        ProgressAdapter progress = new ProgressAdapter(scan);
        progress.setStatus(new Message(1, Messages.JOB_DISCOVER));
        int count = 0;
        while (iter.hasNext()) {
            String targetPath = iter.next();
            ScmUtil.initialize((File)new File(targetPath), (IProgress)progress);
            File input = this.getTargetFile(targetPath, scan);
            scan.setTransformed(false);
            Configurator configurator = new Configurator(scan);
            int numFound = configurator.discover(input, targets.get(targetPath).booleanValue(), (IProgress)progress);
            String messageText = numFound == 1 ? Messages.bind(Messages.TARGET_ADDED, input.getName()) : Messages.bind(Messages.SCAN_TARGETS_ADDED, input.getName());
            progress.setStatus(new Message(1, messageText));
            count += numFound;
        }
        return count;
    }

    private File getTargetFile(String path, IScan scan) {
        File input = new File(path);
        if (SystemUtil.isOpenSourceOnly() && input.isFile()) {
            CustomTargetInfo info = scan.getCustomTargetInfo(input.getParent());
            Map buildInfos = scan.getCustomTargetInfo(path).getBuildInfos();
            for (String key : buildInfos.keySet()) {
                info.getBuildInfos().put(key, buildInfos.get(key));
            }
            info.getIncludes().add(new StringPattern(input.getName()));
            input = input.getParentFile();
        }
        return input;
    }
}

