/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.eclipse;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.eclipse.utils.EclipseUtil;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.dir.CrawlingStrategy;
import com.ibm.appscan.discovery.eclipse.Messages;
import com.ibm.appscan.internal.discovery.eclipse.EclipseRunner;
import com.ibm.appscan.internal.discovery.jee.WARStrategy;
import java.io.File;
import java.util.Properties;

public class ProjectStrategy
extends CrawlingStrategy {
    private File m_workspace;
    private String m_project;
    private String m_outputDir;
    private String m_webRoot = null;
    private Properties m_properties = null;

    public ProjectStrategy() {
    }

    ProjectStrategy(File workspace, String project) {
        super.init(new File(project), null);
        this.m_workspace = workspace;
        this.m_project = project;
        this.readProject();
    }

    ProjectStrategy(File workspace, String project, Properties properties) {
        super.init(new File(project), null);
        this.m_workspace = workspace;
        this.m_project = project;
        this.m_properties = properties;
        this.initializeProperties();
    }

    public void init(File root, IStrategyFactoryRegistry registry) {
        super.init(root, registry);
        this.m_project = root.getName();
        this.readProject();
    }

    public String getType() {
        return Messages.getMessage("project", new Object[0]);
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getLanguageType() {
        return "Java";
    }

    protected String[] getCategories(IBuildInfo buildInfo) {
        return new String[]{"category.java"};
    }

    protected File getCrawlRoot(IScanTargetMinProxy proxy) {
        if (this.m_outputDir == null) {
            proxy.getErrorManager().reportError(Messages.getMessage("project.no.output.error", this.m_project));
            return new File("");
        }
        return new File(this.m_outputDir);
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        if (this.m_webRoot != null && !this.m_webRoot.trim().isEmpty()) {
            proxy.newScanTarget((ScanTargetStrategy)new WARStrategy(new File(this.m_webRoot), null));
        }
        for (String key : this.m_properties.stringPropertyNames()) {
            proxy.getBuildInfo().setProperty(key, this.m_properties.getProperty(key));
        }
        proxy.getBuildInfo().setProperty("workspace", this.m_workspace.getAbsolutePath());
    }

    private void readProject() {
        if (EclipseUtil.isWorkspace((File)this.m_workspace)) {
            try {
                this.m_properties = new EclipseRunner(this.m_workspace, this.m_project).run();
            }
            catch (AppScanException e) {
                CommonCore.getLogManager().log(new Message(Messages.getMessage("project.read.error", this.m_project), (Throwable)e));
            }
            this.initializeProperties();
        } else {
            CommonCore.getLogManager().log(new Message(4, Messages.getMessage("workspace.invalid.error", this.m_workspace)));
        }
    }

    private void initializeProperties() {
        if (this.m_properties != null) {
            this.m_outputDir = (String)this.m_properties.remove("output_dir");
            this.m_webRoot = (String)this.m_properties.remove("web_content");
        }
    }
}

