/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.spring3;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.JavaUtils;
import com.ibm.wala.classLoader.ClassLoaderImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeBTMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.TypeReference;
import java.util.Iterator;
import java.util.List;

public class Util {
    public static String getVDBSignature(IClass clazz) {
        String VdbClazzSignature = clazz.getName().toString();
        if ((VdbClazzSignature = VdbClazzSignature.replace("/", ".")).startsWith("L")) {
            VdbClazzSignature = VdbClazzSignature.substring(1, VdbClazzSignature.length());
        }
        return VdbClazzSignature;
    }

    public static String getVDBSignature(TypeReference type) {
        String VdbClazzSignature = type.getName().toString();
        if ((VdbClazzSignature = VdbClazzSignature.replace("/", ".")).startsWith("L")) {
            VdbClazzSignature = VdbClazzSignature.substring(1, VdbClazzSignature.length());
        }
        return VdbClazzSignature;
    }

    static String cleanString(String a) {
        String result = null;
        if (a != null) {
            result = a.substring(a.indexOf("=[") + 2, a.length() - 2);
        }
        return result;
    }

    public static FilePositionInfo getMethodPosition(IMethod method, List<String> sourceDirectoryList) {
        return JavaUtils.getMethodPosition((IMethod)method, sourceDirectoryList);
    }

    public static FilePositionInfo getClassPosition(IClass clazz) {
        String filePath;
        ShrikeClass sc;
        IClassLoader classLoader;
        FilePositionInfo posInfo = null;
        if (clazz instanceof ShrikeClass && (classLoader = (sc = (ShrikeClass)clazz).getClassLoader()) instanceof ClassLoaderImpl && (filePath = ((ClassLoaderImpl)classLoader).getSourceFileName((IClass)sc)) != null) {
            posInfo = FilePositionInfo.make((String)filePath, (int)1, (int)0);
        }
        return posInfo;
    }

    public static FilePositionInfo getMethodLastPosition(IMethod method, IClass currentClass, List<String> sourceDirectoryList) {
        ShrikeClass sc;
        IClassLoader classLoader;
        FilePositionInfo posInfo = null;
        AnalysisCache cache = new AnalysisCache();
        IR ir = LangIndependentWalaUtil.getIR((IMethod)method, (AnalysisCache)cache);
        Iterator instructionIterator = ir.iterateNormalInstructions();
        SSAInstruction currentInstruction = null;
        int returnLineNumber = -1;
        int instructionIndex = -1;
        while (instructionIterator.hasNext()) {
            currentInstruction = (SSAInstruction)instructionIterator.next();
            if (currentInstruction == null) continue;
            instructionIndex = currentInstruction.iindex;
            try {
                int bcIndex;
                int thisLineNumber;
                if (instructionIndex < 0 || !(method instanceof ShrikeBTMethod) || (thisLineNumber = method.getLineNumber(bcIndex = ((ShrikeBTMethod)method).getBytecodeIndex(instructionIndex))) <= returnLineNumber) continue;
                returnLineNumber = thisLineNumber;
            }
            catch (InvalidClassFileException e) {}
        }
        if (returnLineNumber > 0 && method.getDeclaringClass() instanceof ShrikeClass && (classLoader = (sc = (ShrikeClass)method.getDeclaringClass()).getClassLoader()) instanceof ClassLoaderImpl) {
            String sourceFileName = ((ClassLoaderImpl)classLoader).getSourceFileName((IClass)sc);
            if (sourceFileName == null) {
                sourceFileName = Util.getMethodSourceFileName(method);
            }
            String sourceFileNameFullPath = JavaUtils.getSourceFileNameFullPath((String)sourceFileName, sourceDirectoryList);
            posInfo = FilePositionInfo.make((String)sourceFileNameFullPath, (int)method.getLineNumber(0), (int)0);
        }
        return posInfo;
    }

    private static String getMethodSourceFileName(IMethod method) {
        return JavaUtils.getMethodSourceFileName((IMethod)method);
    }
}

