/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.jsf2;

import com.ibm.appscan.frameworks.handlers.jsf2.JSFBeanScope;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfInfoManager;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfNodeInfo;
import com.ibm.appscan.frameworks.handlers.jsf2.ManagedBean;
import com.ibm.appscan.frameworks.handlers.jsf2.NavigationCaseInfo;
import com.ibm.appscan.frameworks.handlers.jsf2.Validator;
import com.ibm.appscan.frameworks.util.DOMParserWithLineNumbers;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FacesConfigParser {
    private JsfInfoManager m_jsfInfoManager;
    private String m_configFileName;
    private String lineSeparator = System.getProperty("line.separator");

    public FacesConfigParser(String configFileName, JsfInfoManager jsfInfoManager) {
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{configFileName}));
        this.m_jsfInfoManager = jsfInfoManager;
        this.m_configFileName = configFileName;
    }

    public void populateAll() {
        try {
            DOMParserWithLineNumbers parser = new DOMParserWithLineNumbers(this.m_configFileName);
            Document document = parser.getDocument();
            this.populate(document, this.m_configFileName);
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.m_configFileName}));
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private void populate(Document document, String configFileName) {
        try {
            Element root = document.getDocumentElement();
            this.recurseNodes(root);
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{configFileName}));
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private void recurseNodes(Node currentNode) {
        this.handleNode(currentNode);
        NodeList nodes = currentNode.getChildNodes();
        if (nodes == null) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            this.recurseNodes(nodes.item(i));
        }
    }

    private void handleNode(Node inNode) {
        if (inNode.getNodeName().equalsIgnoreCase("navigation-rule")) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"navigation-rule"}));
            this.extractNavigationRule(inNode);
        } else if (inNode.getNodeName().equalsIgnoreCase("managed-bean")) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"managed-bean"}));
            this.extractManagedBean(inNode);
        } else if (inNode.getNodeName().equalsIgnoreCase("validator")) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"validator"}));
            this.extractVilidator(inNode);
        }
    }

    private void extractNavigationRule(Node inNode) {
        NodeList childNodes = inNode.getChildNodes();
        String fromViewId = null;
        ArrayList<NavigationCaseInfo> toViewInfoList = new ArrayList<NavigationCaseInfo>();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node child = childNodes.item(index);
            if (child.getNodeName().equalsIgnoreCase("from-view-id")) {
                fromViewId = child.getChildNodes().item(0).getNodeValue();
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"from-view-id = " + fromViewId}));
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("navigation-case")) continue;
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"navigation-case"}));
            NodeList nodeList = child.getChildNodes();
            String fromOutcome = null;
            String toViewId = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeName().equalsIgnoreCase("from-outcome")) {
                    fromOutcome = node.getChildNodes().item(0).getNodeValue();
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"from-outcome = " + fromOutcome}));
                } else if (node.getNodeName().equalsIgnoreCase("to-view-id")) {
                    toViewId = node.getChildNodes().item(0).getNodeValue();
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"to-view-id = " + toViewId}));
                }
                if (fromOutcome == null || toViewId == null) continue;
                JsfNodeInfo nodeInfo = JsfNodeInfo.make(child);
                FilePositionInfo filePosition = FilePositionInfo.make((String)this.m_configFileName, (int)nodeInfo.getLineNumber(), (int)nodeInfo.getColumnNumber());
                NavigationCaseInfo ncInfo = NavigationCaseInfo.make(fromOutcome, toViewId, filePosition);
                toViewInfoList.add(ncInfo);
            }
        }
        if (fromViewId != null && toViewInfoList.size() > 0) {
            this.addForward(fromViewId, toViewInfoList);
            return;
        }
        TaintLogger.i().getLogger().warn((Object)("Failure in extracting navigation rule from XML node: " + inNode.toString() + "  in configuration file : " + this.m_configFileName));
        TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.getting.from", (Object[])new Object[]{"navigation-rule", this.m_configFileName}));
    }

    private void extractManagedBean(Node inNode) {
        NodeList childNodes = inNode.getChildNodes();
        String managedBeanName = null;
        String managedBeanVdbClassName = null;
        JSFBeanScope managedBeanScope = null;
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node child = childNodes.item(index);
            if (child.getNodeName().equalsIgnoreCase("managed-bean-name")) {
                managedBeanName = child.getChildNodes().item(0).getNodeValue();
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"managed-bean-name = " + managedBeanName}));
            }
            if (child.getNodeName().equalsIgnoreCase("managed-bean-class")) {
                managedBeanVdbClassName = child.getChildNodes().item(0).getNodeValue();
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"managed-bean-class = " + managedBeanVdbClassName}));
            }
            if (!child.getNodeName().equalsIgnoreCase("managed-bean-scope")) continue;
            String managedBeanScopeValue = child.getChildNodes().item(0).getNodeValue();
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"managed-bean-scope = " + managedBeanScopeValue}));
            while (managedBeanScopeValue.contains(" ") || managedBeanScopeValue.contains("\n") || managedBeanScopeValue.contains("\r\n") || managedBeanScopeValue.contains(this.lineSeparator)) {
                managedBeanScopeValue = managedBeanScopeValue.replace(" ", "").replace("\n", "").replace("\r\n", "").replace(this.lineSeparator, "");
            }
            managedBeanScope = this.checkBeanScopeValue(managedBeanScopeValue);
        }
        if (managedBeanName != null && managedBeanVdbClassName != null && managedBeanScope != null) {
            while (managedBeanName.contains(" ") || managedBeanName.contains("\n") || managedBeanName.contains("\r\n") || managedBeanName.contains(this.lineSeparator)) {
                managedBeanName = managedBeanName.replace(" ", "").replace("\n", "").replace("\r\n", "").replace(this.lineSeparator, "");
            }
            while (managedBeanVdbClassName.contains(" ") || managedBeanVdbClassName.contains("\n") || managedBeanVdbClassName.contains("\r\n") || managedBeanVdbClassName.contains(this.lineSeparator)) {
                managedBeanVdbClassName = managedBeanVdbClassName.replace(" ", "").replace("\n", "").replace("\r\n", "").replace(this.lineSeparator, "");
            }
            ManagedBean mBean = new ManagedBean(managedBeanName, managedBeanVdbClassName, managedBeanScope);
            this.addBean(mBean);
        } else {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.getting.from", (Object[])new Object[]{"managed-bean", this.m_configFileName}));
        }
    }

    private void extractVilidator(Node inNode) {
        NodeList childNodes = inNode.getChildNodes();
        String validatorId = null;
        String validatorClassName = null;
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node child = childNodes.item(index);
            if (child.getNodeName().equalsIgnoreCase("validator-id")) {
                validatorId = child.getChildNodes().item(0).getNodeValue();
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"validator-id = " + validatorId}));
            }
            if (!child.getNodeName().equalsIgnoreCase("validator-class")) continue;
            validatorClassName = child.getChildNodes().item(0).getNodeValue();
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"validator-class = " + validatorClassName}));
        }
        if (validatorId != null && validatorClassName != null) {
            Validator validator = new Validator(Validator.ValidatorType.VALIDATOR_CUSTOM);
            validator.setValidatorClassName(validatorClassName);
            validator.setValidatorId(validatorId);
            this.addValidator(validator);
        } else {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.getting.from", (Object[])new Object[]{"validator", this.m_configFileName}));
        }
    }

    private JSFBeanScope checkBeanScopeValue(String beanScopeValue) {
        JSFBeanScope[] beanScopes;
        for (JSFBeanScope currBeanScope : beanScopes = JSFBeanScope.values()) {
            if (!currBeanScope.toString().equalsIgnoreCase(beanScopeValue)) continue;
            return currBeanScope;
        }
        TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.getting.from", (Object[])new Object[]{beanScopeValue, this.m_configFileName}));
        return null;
    }

    private void addForward(String fromViewId, List<NavigationCaseInfo> toViewIdList) {
        this.m_jsfInfoManager.addForward(fromViewId, toViewIdList);
    }

    private void addBean(ManagedBean bean) {
        this.m_jsfInfoManager.addManagedBean(bean);
    }

    private void addValidator(Validator validator) {
        this.m_jsfInfoManager.addValidator(validator);
    }
}

