/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.jsf2;

import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.handlers.jsf2.BuiltInValidators;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfConfigurationManager;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfInfoManager;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfViewFileParser;
import com.ibm.appscan.frameworks.handlers.jsf2.ViewWaflGenerator;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.F4FHandler;
import com.ibm.appscan.frameworks.util.DOMParserWithLineNumbers;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class JSF2Handler
extends F4FHandler {
    private static final Logger logger = TaintLogger.i().getLogger();
    private JsfConfigurationManager jsfConfigManager = null;
    private Map<String, JsfViewFileParser> fileNameToJSFViewMap = new HashMap<String, JsfViewFileParser>();

    public void handleApp(F4FApp app, F4FActions actions) {
        logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"JSF2", "handleApp()"}));
        try {
            File webDirectory = new File(super.getFrameworksInput().getFileLocs().getWebContentDir());
            System.out.println("Webcontent directory: " + webDirectory);
            if (this.jsfConfigManager == null) {
                this.jsfConfigManager = new JsfConfigurationManager(webDirectory);
                this.jsfConfigManager.setJsfConfiguration();
            }
            JsfInfoManager jsfInfoManager = new JsfInfoManager(this.jsfConfigManager, app, webDirectory.getCanonicalPath());
            jsfInfoManager.populateBeansForwardsAndValidators();
            BuiltInValidators.make(app, actions);
            List<String> viewFiles = this.jsfConfigManager.getViewFiles();
            for (String viewFileName : viewFiles) {
                JsfViewFileParser jsfViewFileInfo = JsfViewFileParser.make(viewFileName, jsfInfoManager);
                this.fileNameToJSFViewMap.put(viewFileName, jsfViewFileInfo);
            }
            for (String viewFileName : viewFiles) {
                JsfViewFileParser jsfViewFileInfo = this.fileNameToJSFViewMap.get(viewFileName);
                if (jsfViewFileInfo.isEmpty(jsfInfoManager)) continue;
                ViewWaflGenerator waflgen = new ViewWaflGenerator(jsfInfoManager, jsfViewFileInfo, this.fileNameToJSFViewMap, viewFileName);
                waflgen.generateSynthMethod(app, actions);
            }
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"JSF2"}));
    }

    public boolean isApplicable() {
        try {
            logger.info((Object)Messages.getString((String)"framework.handler.running", (Object[])new Object[]{"JSF2", "isApplicable()"}));
            FrameworksInput input = this.getFrameworksInput();
            if (input.getType().equalsIgnoreCase("Java")) {
                int i;
                String webDirectory = super.getFrameworksInput().getFileLocs().getWebContentDir();
                File webDirectoryFile = new File(webDirectory);
                if (!webDirectoryFile.exists()) {
                    logger.info((Object)Messages.getString((String)"framework.missing.folder", (Object[])new Object[]{webDirectoryFile.getCanonicalPath()}));
                    logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
                    logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"JSF2"}));
                    return false;
                }
                String webXmlFileName = webDirectory + File.separator + "WEB-INF" + File.separator + "web.xml";
                File webXmlFile = new File(webXmlFileName);
                if (!webXmlFile.exists()) {
                    Iterator iter = FileUtils.iterateFiles((File)webDirectoryFile, (IOFileFilter)new NameFileFilter("web.xml"), (IOFileFilter)TrueFileFilter.INSTANCE);
                    if (iter.hasNext()) {
                        webXmlFile = (File)iter.next();
                    } else {
                        logger.info((Object)Messages.getString((String)"framework.missing.file", (Object[])new Object[]{webXmlFile.getCanonicalPath()}));
                        logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
                        logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"JSF2"}));
                        return false;
                    }
                }
                DOMParserWithLineNumbers parser = new DOMParserWithLineNumbers(webXmlFile.getCanonicalPath());
                Document document = parser.getDocument();
                logger.info((Object)Messages.getString((String)"framework.handler.searching", (Object[])new Object[]{"servlet-class javax.faces.webapp.FacesServlet", webXmlFile.getCanonicalPath()}));
                NodeList servletClasses = document.getElementsByTagName("servlet-class");
                for (i = 0; i < servletClasses.getLength(); ++i) {
                    if (!servletClasses.item(i).getTextContent().equals("javax.faces.webapp.FacesServlet")) continue;
                    logger.info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{"javax.faces.webapp.FacesServlet"}));
                    logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "true"}));
                    return true;
                }
                logger.info((Object)Messages.getString((String)"framework.handler.searching", (Object[])new Object[]{"servlet-class org.apache.myfaces.webapp.MyFacesServlet", webXmlFile.getCanonicalPath()}));
                for (i = 0; i < servletClasses.getLength(); ++i) {
                    if (!servletClasses.item(i).getTextContent().equals("org.apache.myfaces.webapp.MyFacesServlet")) continue;
                    logger.info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{"org.apache.myfaces.webapp.MyFacesServlet"}));
                    logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "true"}));
                    return true;
                }
                File webDirectoryFolder = new File(webDirectory);
                this.jsfConfigManager = new JsfConfigurationManager(webDirectoryFolder);
                this.jsfConfigManager.setJsfConfiguration();
                List<String> facesConfigFiles = this.jsfConfigManager.getFacesConfigFiles();
                if (facesConfigFiles.size() > 0) {
                    logger.info((Object)"Found JSF faces config file.");
                    logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "true"}));
                    return true;
                }
                logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
                logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"JSF2"}));
                return false;
            }
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            logger.warn((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
            logger.warn((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"JSF2"}));
            return false;
        }
        logger.info((Object)Messages.getString((String)"framework.returns", (Object[])new Object[]{"isApplicable()", "false"}));
        logger.info((Object)Messages.getString((String)"framework.handler.exit", (Object[])new Object[]{"JSF2"}));
        return false;
    }
}

