/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.jsf2;

import com.ibm.appscan.frameworks.handlers.jsf2.JSFViewInputDataInfo;
import com.ibm.appscan.frameworks.handlers.jsf2.JSPFileParser;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfInfoManager;
import com.ibm.appscan.frameworks.handlers.jsf2.JsfNodeInfo;
import com.ibm.appscan.frameworks.handlers.jsf2.Validator;
import com.ibm.appscan.frameworks.util.DOMParserWithLineNumbers;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.util.collections.Pair;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JsfViewFileParser {
    private String m_viewFileName;
    private List<Pair<JSFViewInputDataInfo, JsfNodeInfo>> beanRefInputList = new ArrayList<Pair<JSFViewInputDataInfo, JsfNodeInfo>>();
    private List<Pair<String, JsfNodeInfo>> beanRefOutputList = new ArrayList<Pair<String, JsfNodeInfo>>();
    private List<Pair<String, JsfNodeInfo>> formList = new ArrayList<Pair<String, JsfNodeInfo>>();
    private List<Pair<String, JsfNodeInfo>> actionList = new ArrayList<Pair<String, JsfNodeInfo>>();
    private JsfInfoManager jsfInfoManager;

    public static JsfViewFileParser make(String inFileName, JsfInfoManager inJsfInfoManager) throws IOException, SAXException {
        return new JsfViewFileParser(inFileName, inJsfInfoManager);
    }

    public List<Pair<String, JsfNodeInfo>> getActionList() {
        return this.actionList;
    }

    public List<Pair<String, JsfNodeInfo>> getBeanRefOutputList() {
        return this.beanRefOutputList;
    }

    public List<Pair<JSFViewInputDataInfo, JsfNodeInfo>> getBeanRefInputList() {
        return this.beanRefInputList;
    }

    private JsfViewFileParser(String inFileName, JsfInfoManager inJsfInfoManager) {
        try {
            this.m_viewFileName = inFileName;
            this.jsfInfoManager = inJsfInfoManager;
            if (!inFileName.toLowerCase().endsWith(".xhtml") && !inFileName.toLowerCase().endsWith(".jsp")) {
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{inFileName}));
                return;
            }
            DOMParserWithLineNumbers parser = null;
            if (inFileName.toLowerCase().endsWith(".jsp")) {
                JSPFileParser jspParser = new JSPFileParser(inFileName);
                jspParser.parse();
                String jsfContent = jspParser.getExtractedJSFContent();
                if (jsfContent == null) {
                    return;
                }
                jsfContent = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> <html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:ui=\"http://java.sun.com/jsf/facelets\" xmlns:h=\"http://java.sun.com/jsf/html\" xmlns:f=\"http://java.sun.com/jsf/core\">" + jsfContent + " </html>";
                StringReader sReader = new StringReader(jsfContent);
                InputSource is = new InputSource(sReader);
                parser = new DOMParserWithLineNumbers(is);
            } else {
                parser = new DOMParserWithLineNumbers(inFileName);
            }
            Document document = parser.getDocument();
            this.populate(document);
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{inFileName}));
        }
    }

    private void populate(Document document) {
        try {
            Element root = document.getDocumentElement();
            this.recurseNodes(root);
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.m_viewFileName}));
        }
    }

    private void recurseNodes(Node currentNode) {
        this.handleNode(currentNode);
        NodeList nodes = currentNode.getChildNodes();
        if (nodes == null) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            this.recurseNodes(nodes.item(i));
        }
    }

    private void handleNode(Node inNode) {
        if (inNode.getNodeName().contains("h:input")) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"h:input"}));
            this.handleInputNode(inNode);
            return;
        }
        if (inNode.getNodeName().contains("h:commandButton") || inNode.getNodeName().contains("h:commandLink")) {
            String theAction = this.getStringAttrValue(inNode, "action");
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"h:commandButton/h:commandLink action=" + theAction}));
            if (theAction == null) {
                return;
            }
            JsfNodeInfo theInfo = JsfNodeInfo.make(inNode);
            this.actionList.add((Pair<String, JsfNodeInfo>)Pair.make((Object)theAction, (Object)theInfo));
            return;
        }
        if (inNode.getNodeName().contains("h:output")) {
            String outputValueAttrValue = this.getStringAttrValue(inNode, "value");
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"h:output value=" + outputValueAttrValue}));
            if (outputValueAttrValue == null) {
                return;
            }
            String escapeValue = this.getStringAttrValue(inNode, "escape");
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"h:output value=" + outputValueAttrValue + " escape=" + escapeValue}));
            if (escapeValue == null) {
                return;
            }
            if (escapeValue.equalsIgnoreCase("false")) {
                JsfNodeInfo theInfo = JsfNodeInfo.make(inNode);
                ArrayList<String> outputBeanRefStrList = this.getOutputBeanRefList(outputValueAttrValue);
                for (String outputBeanRefStr : outputBeanRefStrList) {
                    this.beanRefOutputList.add((Pair<String, JsfNodeInfo>)Pair.make((Object)outputBeanRefStr, (Object)theInfo));
                    System.out.println("Found output bean ref: " + outputBeanRefStr);
                }
                return;
            }
            return;
        }
        int beanRef = inNode.toString().indexOf("#{");
        if (beanRef > 0) {
            int endBeanRef = inNode.toString().indexOf("}", beanRef);
            if (endBeanRef < 0) {
                return;
            }
            String theBeanRef = inNode.toString().substring(beanRef + 2, endBeanRef);
            JsfNodeInfo theInfo = JsfNodeInfo.make(inNode);
            this.beanRefOutputList.add((Pair<String, JsfNodeInfo>)Pair.make((Object)theBeanRef, (Object)theInfo));
            System.out.println("Found bean ref: " + theBeanRef);
            return;
        }
    }

    private ArrayList<String> getOutputBeanRefList(String outputValueAttrValue) {
        ArrayList<String> outputBeanRefList = new ArrayList<String>();
        if (outputValueAttrValue == null) {
            return outputBeanRefList;
        }
        int baseIndex = 0;
        int startIndex = outputValueAttrValue.indexOf("#{", baseIndex);
        while (startIndex >= 0) {
            int endIndex = outputValueAttrValue.indexOf("}", baseIndex);
            if (endIndex < 0 || startIndex > endIndex) {
                return outputBeanRefList;
            }
            String expression = outputValueAttrValue.substring(startIndex + 2, endIndex);
            StringBuilder beanRef = new StringBuilder();
            boolean start = false;
            boolean hasAdded = false;
            for (int beanRefIndex = 0; beanRefIndex < expression.length(); ++beanRefIndex) {
                char ch = expression.charAt(beanRefIndex);
                if (!start) {
                    if (!Character.isJavaIdentifierStart(ch)) continue;
                    start = true;
                    beanRef.append(ch);
                    continue;
                }
                if (!start) continue;
                if (Character.isJavaIdentifierPart(ch) || ch == '.') {
                    beanRef.append(ch);
                    continue;
                }
                start = false;
                if (beanRef.toString().contains(".") && !beanRef.toString().endsWith(".")) {
                    outputBeanRefList.add(beanRef.toString());
                    hasAdded = true;
                    continue;
                }
                beanRef.delete(0, beanRef.length());
            }
            if (beanRef.toString().contains(".") && !beanRef.toString().endsWith(".") && !hasAdded) {
                outputBeanRefList.add(beanRef.toString());
            }
            baseIndex = endIndex + 1;
            startIndex = outputValueAttrValue.indexOf("#{", baseIndex);
            endIndex = outputValueAttrValue.indexOf("}", baseIndex);
        }
        return outputBeanRefList;
    }

    private void handleInputNode(Node inNode) {
        String theValue = this.getStringAttrValue(inNode, "value");
        if (theValue == null) {
            return;
        }
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.attribute.found", (Object[])new Object[]{"value=" + theValue}));
        int strLen = theValue.length();
        if (strLen == 0) {
            return;
        }
        String beanPropertyReference = null;
        beanPropertyReference = theValue.startsWith("#{") ? theValue.substring(2, strLen - 1) : theValue;
        JsfNodeInfo theInfo = JsfNodeInfo.make(inNode);
        Pair formInputInfo = Pair.make((Object)beanPropertyReference, (Object)theInfo);
        this.formList.add((Pair<String, JsfNodeInfo>)formInputInfo);
        JSFViewInputDataInfo inputDataInfo = new JSFViewInputDataInfo(beanPropertyReference);
        String beanValidatorValue = this.getStringAttrValue(inNode, "validator");
        if (beanValidatorValue != null) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.attribute.found", (Object[])new Object[]{"validator=" + beanValidatorValue}));
            inputDataInfo.setHasValidator(true);
            Validator validator = new Validator(Validator.ValidatorType.VALIDATOR_BEAN);
            if (!validator.setNamesForBeanValidator(beanValidatorValue)) {
                return;
            }
            validator.setFilePositioninfo(theInfo, this.m_viewFileName);
            inputDataInfo.setValidator(validator);
            inputDataInfo.setNodeInfoForValidatorNode(theInfo);
            Pair inputInfoPair = Pair.make((Object)inputDataInfo, (Object)theInfo);
            this.beanRefInputList.add((Pair<JSFViewInputDataInfo, JsfNodeInfo>)inputInfoPair);
            return;
        }
        NodeList childNodes = inNode.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node child = childNodes.item(index);
            if (child.getNodeName().startsWith("f:validate")) {
                Validator validator = null;
                if (child.getNodeName().equalsIgnoreCase("f:validateLength")) {
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"f:validateLength"}));
                    validator = new Validator(Validator.ValidatorType.VALIDATOR_BUILTIN_LENGTH);
                } else if (child.getNodeName().equalsIgnoreCase("f:validateDoubleRange")) {
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"f:validateDoubleRange"}));
                    validator = new Validator(Validator.ValidatorType.VALIDATOR_BUILTIN_DOUBLERANGE);
                } else if (child.getNodeName().equalsIgnoreCase("f:validateLongRange")) {
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"f:validateLongRange"}));
                    validator = new Validator(Validator.ValidatorType.VALIDATOR_BUILTIN_DOUBLERANGE);
                } else if (child.getNodeName().equalsIgnoreCase("f:validateRegex")) {
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"f:validateRegex"}));
                    validator = new Validator(Validator.ValidatorType.VALIDATOR_BUILTIN_REGEX);
                }
                if (validator != null) {
                    inputDataInfo.setHasValidator(true);
                    inputDataInfo.setValidator(validator);
                    JsfNodeInfo validatorNodeInfo = JsfNodeInfo.make(child);
                    validator.setFilePositioninfo(validatorNodeInfo, this.m_viewFileName);
                    inputDataInfo.setNodeInfoForValidatorNode(validatorNodeInfo);
                    Pair inputInfoPair = Pair.make((Object)inputDataInfo, (Object)theInfo);
                    this.beanRefInputList.add((Pair<JSFViewInputDataInfo, JsfNodeInfo>)inputInfoPair);
                    return;
                }
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.unrecognized", (Object[])new Object[]{child.getNodeName()}));
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{inNode.toString()}));
                inputDataInfo.setHasValidator(false);
                Pair inputInfoPair = Pair.make((Object)inputDataInfo, (Object)theInfo);
                this.beanRefInputList.add((Pair<JSFViewInputDataInfo, JsfNodeInfo>)inputInfoPair);
                return;
            }
            if (!child.getNodeName().startsWith("f:validator")) continue;
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.node.found", (Object[])new Object[]{"f:validator"}));
            String validatorId = this.getStringAttrValue(child, "validatorId");
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.attribute.found", (Object[])new Object[]{"validatorId=" + validatorId}));
            Validator validator = this.jsfInfoManager.getValidator(validatorId);
            if (validator == null) {
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.missing.validator", (Object[])new Object[]{validatorId}));
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{this.m_viewFileName}));
                continue;
            }
            JsfNodeInfo validatorNodeInfo = JsfNodeInfo.make(child);
            validator.setFilePositioninfo(validatorNodeInfo, this.m_viewFileName);
            inputDataInfo.setHasValidator(true);
            inputDataInfo.setValidator(validator);
            inputDataInfo.setNodeInfoForValidatorNode(validatorNodeInfo);
            Pair inputInfoPair = Pair.make((Object)inputDataInfo, (Object)theInfo);
            this.beanRefInputList.add((Pair<JSFViewInputDataInfo, JsfNodeInfo>)inputInfoPair);
            return;
        }
        inputDataInfo.setHasValidator(false);
        Pair inputInfoPair = Pair.make((Object)inputDataInfo, (Object)theInfo);
        this.beanRefInputList.add((Pair<JSFViewInputDataInfo, JsfNodeInfo>)inputInfoPair);
    }

    private String getStringAttrValue(Node item, String attrName) {
        Node value = item.getAttributes().getNamedItem(attrName);
        return value == null ? null : value.getNodeValue();
    }

    public boolean isEmpty(JsfInfoManager jsfInfoManager) {
        return this.getBeanRefInputList().size() == 0 && this.getActionList().size() == 0 && this.getBeanRefOutputList().size() == 0 && jsfInfoManager.findForward(this.m_viewFileName).size() == 0;
    }
}

