/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.handlers;

import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.components.ScanManager;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanModelVisitable;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.validation.CustomRulesValidator;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.RulesUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.config.Configurator;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ValidateHandler {
    private ScanManager m_manager = ScanManager.getInstance();
    private IProgress m_progress;
    private File m_configDir = null;

    public ValidateHandler() {
        this(null);
    }

    public ValidateHandler(IProgress progress) {
        this.m_progress = progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        boolean isValidated;
        block20: {
            isValidated = false;
            IScan currentScan = this.m_manager.getActiveScan();
            IScanTarget currentTarget = this.m_manager.getActiveScanTarget();
            if (this.m_progress == null) {
                this.m_progress = new ProgressAdapter(currentScan);
            }
            if (!this.validateCustomRules()) {
                System.setProperty("DELETE_IRX", "");
                return false;
            }
            try {
                if (currentScan == null) {
                    this.m_progress.setStatus(new Message(2, Messages.NO_SCAN_OPEN));
                } else {
                    Configurator configurator = null;
                    IScanTarget node = currentTarget;
                    if (currentTarget == null) {
                        node = currentScan;
                    }
                    if (currentScan.getSaveLocation() == null && !ScanManager.isTreeTransformed((IScanModelVisitable)node) || currentScan.isDirty()) {
                        this.m_progress.setStatus(new Message(2, Messages.VALIDATE_ERR_UNSAVED));
                    } else if (ScanManager.isTreeTransformed((IScanModelVisitable)currentScan)) {
                        this.m_progress.setStatus(new Message(2, Messages.ERR_TRANSFORMED));
                    } else {
                        this.m_progress.setStatus(new Message(1, Messages.JOB_VALIDATE));
                        if (currentTarget == null) {
                            configurator = new Configurator(currentScan);
                            isValidated = configurator.validate(this.m_progress, SystemUtil.isDryRun());
                        } else if (!currentTarget.isValid()) {
                            currentTarget.findScanFiles(null);
                            isValidated = currentTarget.isValid();
                        }
                    }
                    if (isValidated) {
                        this.m_progress.setStatus(new Message(1, Messages.VALIDATE_COMPLETE));
                    } else {
                        CommonCLICore.getIOConsole().println(new Message(4, Messages.VALIDATE_NOT_OK));
                    }
                }
            }
            catch (Exception e) {
                currentScan.getLogManager().log(new Message((Throwable)e));
            }
            finally {
                int messageCount = currentScan.getLogManager().getMessages().size();
                if (messageCount == -1) break block20;
                List messages = currentScan.getLogManager().getMessages();
                for (int i = 0; i < messages.size(); ++i) {
                    Message message = (Message)messages.get(i);
                    if (message.getSeverity() < 2) continue;
                    CommonCLICore.getIOConsole().println(message);
                }
            }
        }
        return isValidated;
    }

    public void setConfigDir(File configDir) {
        this.m_configDir = configDir;
    }

    private boolean validateCustomRules() {
        boolean isValid = true;
        File customRulesFile = new File(this.m_configDir, RulesUtil.getCustomRulesFileName());
        if (customRulesFile.isFile()) {
            this.m_progress.setStatus(new Message(1, Messages.bind(Messages.VALIDATING_CUSTOM_RULES, customRulesFile.getAbsolutePath())));
            CustomRulesValidator validator = new CustomRulesValidator(customRulesFile);
            if (validator.isValid()) {
                File destination = new File(this.m_manager.getActiveScan().getSaveLocation().getWorkLocation(), RulesUtil.getCustomRulesFileName());
                try {
                    IOUtil.copy((File)customRulesFile, (File)destination);
                }
                catch (IOException e) {
                    this.m_progress.setStatus(new Message(4, Messages.bind(Messages.ERR_COPY_CUSTOM_RULES, customRulesFile.getAbsolutePath(), e.getMessage())));
                    isValid = false;
                }
                this.m_progress.setStatus(new Message(1, Messages.VALIDATE_COMPLETE));
            } else {
                for (String error : validator.getValidationErrors()) {
                    this.m_progress.setStatus(new Message(4, error));
                }
                this.m_progress.setStatus(new Message(4, Messages.bind(Messages.INVALID_CUSTOM_RULES_FILE, customRulesFile.getAbsolutePath())));
                isValid = false;
            }
        }
        return isValid;
    }
}

