/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.util.scopes;

import com.ibm.wala.andromeda.util.io.TaintFileProvider;
import com.ibm.wala.andromeda.util.logging.DebugOutput;
import com.ibm.wala.andromeda.util.scopes.Projects;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.util.config.AnalysisScopeReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScopeUtil {
    public static boolean DEBUG = false;
    private static final String TAINT_RESOURCE_DIR_PROPERTY_NAME = "TaintResources";
    public static final String EXCLUSIONS_JAVA = "exclusions.java.dat";
    private static final Pattern propertyPattern = Pattern.compile("\\$\\{([^\\\\/]*)\\)");

    public static AnalysisScope getScopeForProject(Projects app) throws IOException {
        return ScopeUtil.getScopeForProject(app, false);
    }

    public static AnalysisScope getScopeForProject(Projects app, boolean noExclusions) throws IOException {
        String scopeFileAbsolutePath = ScopeUtil.getScopeFilenameForProject(app);
        File exclusionFile = null;
        if (!noExclusions) {
            exclusionFile = TaintFileProvider.getFile(EXCLUSIONS_JAVA);
        }
        ClassLoader classLoader = ScopeUtil.class.getClassLoader();
        return ScopeUtil.substituteAndCreateJavaAnalysisScope(scopeFileAbsolutePath, exclusionFile, classLoader);
    }

    public static AnalysisScope substituteAndCreateJavaAnalysisScope(String scopeFileAbsolutePath, File exclusionFile, ClassLoader classLoader) throws IOException {
        String modifiedAbsolutePath = ScopeUtil.getFixedAnalysisScope(scopeFileAbsolutePath);
        AnalysisScope scope = AnalysisScopeReader.readJavaScope((String)modifiedAbsolutePath, (File)exclusionFile, (ClassLoader)classLoader);
        new File(modifiedAbsolutePath).delete();
        return scope;
    }

    public static String getScopeFileForProject(Projects app) throws IOException {
        String scopeFileAbsolutePath = ScopeUtil.getScopeFilenameForProject(app);
        String modifiedAbsolutePath = ScopeUtil.getFixedAnalysisScope(scopeFileAbsolutePath);
        return modifiedAbsolutePath;
    }

    public static String getScopeFilenameForProject(Projects app) {
        String projName = app.getProjectName();
        String scopeFileAbsolutePath = ScopeUtil.getScope(projName);
        return scopeFileAbsolutePath;
    }

    public static String getWorkspaceDir() {
        String workspaceDir = System.getProperty("WorkSpace");
        assert (workspaceDir != null) : "should set WorkSpace property";
        return workspaceDir;
    }

    public static String getScope(String projName) {
        String workspaceDir = ScopeUtil.getWorkspaceDir();
        return workspaceDir + File.separatorChar + "com.ibm.wala.andromeda.util" + File.separatorChar + "resources" + File.separatorChar + "scopes" + File.separatorChar + projName + "Scope.txt";
    }

    public static String getFixedAnalysisScope(String initialScopeFile) throws IOException {
        String line;
        File tempAnalysisFile = File.createTempFile("analysisScope", null);
        BufferedReader in = new BufferedReader(new FileReader(initialScopeFile));
        if (!in.ready()) {
            throw new IOException();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(tempAnalysisFile));
        while ((line = in.readLine()) != null) {
            if (line.contains("primordial.jar.model")) {
                DebugOutput.println(DEBUG, "DEBUG");
                line = "Primordial,Java,jarFile," + TaintFileProvider.getFile("primordial.jar.model").getAbsolutePath();
            }
            line = ScopeUtil.replacePropertyRefs(line);
            line = ScopeUtil.adjustFilePathForPlatform(line);
            out.write(line);
            out.newLine();
        }
        in.close();
        out.close();
        return tempAnalysisFile.getAbsolutePath();
    }

    public static String replacePropertyRefs(String line) {
        Matcher matcher = propertyPattern.matcher(line);
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            String propertyValue = System.getProperty(propertyName);
            if (propertyValue == null) continue;
            line = line.replace(matcher.group(), propertyValue);
        }
        return line;
    }

    public static String adjustFilePathForPlatform(String line) {
        line = line.replace('\\', File.separatorChar);
        line = line.replace("R:", ScopeUtil.getTaintResourcesDirName());
        line = line.replace("r:", ScopeUtil.getTaintResourcesDirName());
        return line;
    }

    public static String getTaintResourcesDirName() {
        String taintResourceDir = System.getProperty(TAINT_RESOURCE_DIR_PROPERTY_NAME, "R:");
        return taintResourceDir;
    }
}

