/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.dir;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.DirectoryUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Messages;
import com.ibm.appscan.discovery.dir.FileCollectorStrategy;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class CustomFileCollectorStrategy
extends FileCollectorStrategy {
    protected Set<IScanFile> m_scanFiles;
    private File m_directory;

    public void init(File directory, IStrategyFactoryRegistry registry, Set<IScanFile> scanFiles) {
        this.m_scanFiles = scanFiles;
        this.m_directory = directory;
        super.init(directory, registry);
    }

    @Override
    public boolean stageScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        try {
            this.m_stagingDir = new File(proxy.getWorkingDirectory(), "staging/src");
            this.m_stagingDir.mkdirs();
            for (IScanFile scanFile : this.m_scanFiles) {
                File sourceScanfile = scanFile.getFile();
                String stagePath = this.getStagePath(this.m_directory, sourceScanfile);
                File destFile = new File(this.m_stagingDir, stagePath);
                if (!SystemUtil.isWindows()) {
                    destFile = new File(this.removeInvalidChar(destFile.getAbsolutePath()));
                    scanFile.setFile(this.removeInvalidChar(sourceScanfile.getParent()) + File.separator + destFile.getName());
                }
                destFile.getParentFile().mkdirs();
                IOUtil.copy((File)sourceScanfile, (File)destFile);
            }
        }
        catch (IOException e) {
            proxy.getErrorManager().reportError(Messages.getMessage("err.staging", new Object[0]), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean buildScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        return true;
    }

    @Override
    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        String javaAnalyzeDir = "Java" + File.separator + "analyze" + File.separator;
        LinkedHashSet<IScanFile> ret = new LinkedHashSet<IScanFile>();
        for (IScanFile scanFile : this.m_scanFiles) {
            String stagedPath = this.getStagePath(this.m_directory, scanFile.getFile());
            if (!new File(this.m_stagingDir, stagedPath).isFile()) continue;
            IScanFile added = ScanModelFactory.newScanFile((File)new File("staging/src", stagedPath));
            File stagedFile = new File(this.m_stagingDir, stagedPath);
            if (SystemUtil.isCommonEngine()) {
                String src_path = scanFile.getFile().getPath();
                if (proxy.getBuildInfo().getProperty("src_root") != null && proxy.getBuildInfo().getProperty("src_root").length() > 0) {
                    try {
                        String stagedFilePath = stagedFile.getCanonicalPath();
                        src_path = proxy.getSourceAbsolutePath(this.getRelativeSourcePath(stagedFilePath));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                added.setSourcePath(src_path);
            } else {
                if (stagedPath.contains(javaAnalyzeDir)) {
                    int index = stagedPath.indexOf(javaAnalyzeDir);
                    stagedPath = stagedPath.substring(index + javaAnalyzeDir.length());
                }
                added.setSourcePath(stagedPath);
            }
            if (scanFile.isExcluded() || this.isThirdPartyExclusion(scanFile, proxy)) {
                added.setExcluded(true);
                stagedFile.delete();
            }
            ret.add(added);
        }
        this.createStagingZip(proxy, progress);
        if (this.stagingRequired(this.getParent())) {
            try {
                DirectoryUtil.delete((File)this.m_stagingDir);
            }
            catch (IOException e) {
                proxy.getLogManager().log(new Message(Messages.getMessage("err.delete.staging", new Object[0]), (Throwable)e));
            }
        }
        return ret;
    }

    @Override
    protected File getCrawlRoot(IScanTargetMinProxy proxy) {
        if (this.stagingRequired(this.getParent())) {
            return this.m_stagingDir;
        }
        return this.getRoot(proxy);
    }

    @Override
    protected boolean acceptFile(File file) {
        return true;
    }

    protected boolean stagingRequired(ScanTargetStrategy strategy) {
        return !SystemUtil.isCloudIRGen();
    }

    private String getSourcePath(IScanTargetMinProxy proxy, IScanFile scanFile) {
        String workingDir;
        String sourceFile = scanFile.getSourcePath() != null ? scanFile.getSourcePath() : scanFile.getAnalysisPath();
        if (sourceFile.startsWith(workingDir = proxy.getScanHome().getAbsolutePath())) {
            return (sourceFile = sourceFile.substring(this.m_directory.getAbsolutePath().length())).startsWith(File.separator) ? sourceFile.substring(1) : sourceFile;
        }
        return sourceFile;
    }

    private String getRelativeSourcePath(String stagedPath) {
        String src_path = stagedPath;
        if (stagedPath.contains("staging")) {
            String substr = "staging" + File.separator;
            src_path = stagedPath.substring(stagedPath.indexOf("staging") + substr.length(), stagedPath.length());
        }
        return src_path;
    }

    private void createStagingZip(IScanTargetMinProxy proxy, IProgress progress) {
        if (this.stagingRequired(this.getParent())) {
            super.buildScanTarget(proxy, progress);
        } else {
            try {
                new File(proxy.getScanHome(), ".sources").createNewFile();
            }
            catch (IOException e) {
                proxy.getErrorManager().reportError(Messages.getMessage("err.packaging", new Object[0]), (Throwable)e);
            }
        }
    }
}

