/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.classLoader;

import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.classLoader.NestedJarFileModule;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileSuffixes;
import java.io.InputStream;
import java.util.jar.JarFile;

public class JarFileEntry
implements ModuleEntry {
    private final String classesPrefix = "classes/";
    private final String entryName;
    private final JarFileModule jarFileModule;

    protected JarFileEntry(String entryName, JarFileModule jarFile) {
        this.jarFileModule = jarFile;
        this.entryName = this.jarFileModule.isJmodArchive() && entryName.startsWith("classes/") ? entryName.substring("classes/".length()) : entryName;
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public boolean isClassFile() {
        return FileSuffixes.isClassFile(this.getName());
    }

    @Override
    public InputStream getInputStream() {
        try {
            JarFile jarFile = this.jarFileModule.getJarFile();
            if (this.jarFileModule.isJmodArchive()) {
                return jarFile.getInputStream(jarFile.getEntry("classes/" + this.entryName));
            }
            return jarFile.getInputStream(jarFile.getEntry(this.entryName));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }

    public long getSize() {
        if (this.jarFileModule.isJmodArchive()) {
            return this.jarFileModule.getJarFile().getEntry("classes/" + this.entryName).getSize();
        }
        return this.jarFileModule.getJarFile().getEntry(this.entryName).getSize();
    }

    public String toString() {
        return this.jarFileModule.getJarFile().getName() + ":" + this.getName();
    }

    @Override
    public boolean isModuleFile() {
        return FileSuffixes.isJarFile(this.getName()) || FileSuffixes.isWarFile(this.getName());
    }

    @Override
    public Module asModule() {
        return new NestedJarFileModule(this.jarFileModule, this.jarFileModule.getJarFile().getEntry(this.entryName));
    }

    public JarFile getJarFile() {
        return this.jarFileModule.getJarFile();
    }

    @Override
    public JarFileModule getContainer() {
        return this.jarFileModule;
    }

    public int hashCode() {
        return this.entryName.hashCode() * 5059 + this.jarFileModule.getJarFile().hashCode();
    }

    @Override
    public String getClassName() {
        return FileSuffixes.stripSuffix(this.getName());
    }

    @Override
    public boolean isSourceFile() {
        return FileSuffixes.isSourceFile(this.getName());
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

