/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.analysis.reflection.CloneInterpreter;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.Util;
import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.fixpoint.AbstractOperator;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.HeapModel;
import com.ibm.wala.ipa.callgraph.propagation.IPointerOperator;
import com.ibm.wala.ipa.callgraph.propagation.IPointsToSolver;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.PropagationSystem;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.StandardSolver;
import com.ibm.wala.ipa.callgraph.propagation.ZeroLengthArrayInNode;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractThrowInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.functions.VoidFunction;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import com.ibm.wala.util.ref.ReferenceCleanser;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class SSAPropagationCallGraphBuilder
extends PropagationCallGraphBuilder
implements HeapModel {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_MULTINEWARRAY = false;
    public static final boolean PERIODIC_WIPE_SOFT_CACHES = true;
    public static final int WIPE_SOFT_CACHE_INTERVAL = 2500;
    private static int wipeCount = 0;
    private static final boolean SHORT_CIRCUIT_INVARIANT_SETS = true;
    protected static final boolean SHORT_CIRCUIT_SINGLE_USES = true;
    private final boolean clone2Assign = false;
    private static final Selector cloneSelector = CloneInterpreter.CLONE.getSelector();
    private final Set<IClass> clinitVisited = HashSetFactory.make();
    private final Set<IClass> finalizeVisited = HashSetFactory.make();
    public MonitorUtil.IProgressMonitor monitor;

    protected SSAPropagationCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache, PointerKeyFactory pointerKeyFactory) {
        super(cha, options, cache, pointerKeyFactory);
    }

    public SSAContextInterpreter getCFAContextInterpreter() {
        return (SSAContextInterpreter)this.getContextInterpreter();
    }

    public static InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter x, TypeReference type, InstanceKeyFactory ikFactory) {
        if (ikFactory == null) {
            throw new IllegalArgumentException("ikFactory is null");
        }
        return ikFactory.getInstanceKeyForPEI(node, x, type);
    }

    @Override
    protected boolean addConstraintsFromNode(CGNode node, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        this.monitor = monitor;
        if (this.haveAlreadyVisited(node)) {
            return false;
        }
        this.markAlreadyVisited(node);
        return this.unconditionallyAddConstraintsFromNode(node, monitor);
    }

    @Override
    protected boolean unconditionallyAddConstraintsFromNode(CGNode node, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        IR ir;
        this.monitor = monitor;
        if (++wipeCount >= 2500) {
            wipeCount = 0;
            ReferenceCleanser.clearSoftCaches();
        }
        if ((ir = this.getCFAContextInterpreter().getIR(node)) == null) {
            return false;
        }
        this.addNodeInstructionConstraints(node, monitor);
        DefUse du = this.getCFAContextInterpreter().getDU(node);
        this.addNodePassthruExceptionConstraints(node, ir, du);
        return true;
    }

    protected ConstraintVisitor makeVisitor(CGNode node) {
        return new ConstraintVisitor(this, node);
    }

    protected void addNodeInstructionConstraints(CGNode node, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        this.monitor = monitor;
        ConstraintVisitor v = this.makeVisitor(node);
        IR ir = v.ir;
        SSACFG cfg = ir.getControlFlowGraph();
        Iterator x = cfg.iterator();
        while (x.hasNext()) {
            SSACFG.BasicBlock b = (SSACFG.BasicBlock)x.next();
            this.addBlockInstructionConstraints(node, cfg, b, v, monitor);
            if (!this.wasChanged(node)) continue;
            return;
        }
    }

    protected void addBlockInstructionConstraints(CGNode node, ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, SSACFG.BasicBlock b, ConstraintVisitor v, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        this.monitor = monitor;
        v.setBasicBlock(b);
        Iterator<SSAInstruction> it = b.iterator();
        while (it.hasNext()) {
            MonitorUtil.throwExceptionIfCanceled((MonitorUtil.IProgressMonitor)monitor);
            SSAInstruction s = it.next();
            if (s == null) continue;
            s.visit(v);
            if (!this.wasChanged(node)) continue;
            return;
        }
        this.addPhiConstraints(node, cfg, b, v);
    }

    private void addPhiConstraints(CGNode node, ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, SSACFG.BasicBlock b, ConstraintVisitor v) {
        Iterator sbs = cfg.getSuccNodes(b);
        while (sbs.hasNext()) {
            SSACFG.BasicBlock sb = (SSACFG.BasicBlock)sbs.next();
            if (!sb.hasPhi()) continue;
            int n = 0;
            Iterator back = cfg.getPredNodes(sb);
            while (back.hasNext() && back.next() != b) {
                ++n;
            }
            assert (n < cfg.getPredNodeCount(sb));
            Iterator<SSAPhiInstruction> phis = sb.iteratePhis();
            while (phis.hasNext()) {
                SSAPhiInstruction phi = phis.next();
                if (phi == null) continue;
                PointerKey def = this.getPointerKeyForLocal(node, phi.getDef());
                if (this.hasNoInterestingUses(node, phi.getDef(), v.du)) {
                    this.system.recordImplicitPointsToSet(def);
                    continue;
                }
                if (phi.getUse(n) <= 0) continue;
                PointerKey use = this.getPointerKeyForLocal(node, phi.getUse(n));
                if (this.contentsAreInvariant(v.symbolTable, v.du, phi.getUse(n))) {
                    this.system.recordImplicitPointsToSet(use);
                    InstanceKey[] ik = this.getInvariantContents(v.symbolTable, v.du, node, phi.getUse(n), this);
                    for (int i = 0; i < ik.length; ++i) {
                        this.system.newConstraint(def, ik[i]);
                    }
                    continue;
                }
                this.system.newConstraint(def, assignOperator, use);
            }
        }
    }

    protected void addNodePassthruExceptionConstraints(CGNode node, IR ir, DefUse du) {
        List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(ir, ir.getExitBlock());
        PointerKey exception = this.getPointerKeyForExceptionalReturnValue(node);
        TypeReference throwableType = node.getMethod().getDeclaringClass().getClassLoader().getLanguage().getThrowableType();
        IClass c = node.getClassHierarchy().lookupClass(throwableType);
        this.addExceptionDefConstraints(ir, du, node, peis, exception, Collections.singleton(c));
    }

    private void addExceptionDefConstraints(IR ir, DefUse du, CGNode node, List<ProgramCounter> peis, PointerKey exceptionVar, Set<IClass> catchClasses) {
        for (ProgramCounter peiLoc : peis) {
            Collection<TypeReference> types;
            PointerKey e;
            SSAInstruction s;
            SSAInstruction pei = ir.getPEI(peiLoc);
            if (pei instanceof SSAAbstractInvokeInstruction) {
                s = (SSAAbstractInvokeInstruction)pei;
                e = this.getPointerKeyForLocal(node, ((SSAAbstractInvokeInstruction)s).getException());
                if (!SSAPropagationCallGraphBuilder.hasUniqueCatchBlock((SSAAbstractInvokeInstruction)s, ir)) {
                    this.addAssignmentsForCatchPointerKey(exceptionVar, catchClasses, e);
                }
            } else if (pei instanceof SSAAbstractThrowInstruction) {
                s = (SSAAbstractThrowInstruction)pei;
                e = this.getPointerKeyForLocal(node, ((SSAAbstractThrowInstruction)s).getException());
                if (this.contentsAreInvariant(ir.getSymbolTable(), du, ((SSAAbstractThrowInstruction)s).getException())) {
                    InstanceKey[] ik = this.getInvariantContents(ir.getSymbolTable(), du, node, ((SSAAbstractThrowInstruction)s).getException(), this);
                    for (int i = 0; i < ik.length; ++i) {
                        this.system.findOrCreateIndexForInstanceKey(ik[i]);
                        this.assignInstanceToCatch(exceptionVar, catchClasses, ik[i]);
                    }
                } else {
                    this.addAssignmentsForCatchPointerKey(exceptionVar, catchClasses, e);
                }
            }
            if ((types = pei.getExceptionTypes()) == null) continue;
            for (TypeReference type : types) {
                InstanceKey ik;
                if (type == null || (ik = SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(node, peiLoc, type, this.instanceKeyFactory)) == null) continue;
                assert (ik instanceof ConcreteTypeKey) : "uh oh: need to implement getCaughtException constraints for instance " + ik;
                ConcreteTypeKey ck = (ConcreteTypeKey)ik;
                IClass klass = ck.getType();
                if (!PropagationCallGraphBuilder.catches(catchClasses, klass, this.cha)) continue;
                this.system.newConstraint(exceptionVar, SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(node, peiLoc, type, this.instanceKeyFactory));
            }
        }
    }

    protected static boolean hasUniqueCatchBlock(SSAAbstractInvokeInstruction call, IR ir) {
        Iterator<ISSABasicBlock> it;
        ISSABasicBlock[] bb = ir.getBasicBlocksForCall(call.getCallSite());
        if (bb.length == 1 && (it = ir.getControlFlowGraph().getExceptionalSuccessors(bb[0]).iterator()).hasNext()) {
            ISSABasicBlock sb = it.next();
            return !it.hasNext() && (sb.isExitBlock() || sb instanceof SSACFG.ExceptionHandlerBasicBlock && ((SSACFG.ExceptionHandlerBasicBlock)sb).getCatchInstruction() != null);
        }
        return false;
    }

    public PointerKey getUniqueCatchKey(SSAAbstractInvokeInstruction call, IR ir, CGNode node) throws IllegalArgumentException, IllegalArgumentException {
        if (call == null) {
            throw new IllegalArgumentException("call == null");
        }
        if (ir == null) {
            throw new IllegalArgumentException("ir == null");
        }
        ISSABasicBlock[] bb = ir.getBasicBlocksForCall(call.getCallSite());
        assert (bb.length == 1);
        SSACFG.BasicBlock cb = (SSACFG.BasicBlock)ir.getControlFlowGraph().getExceptionalSuccessors(bb[0]).iterator().next();
        if (cb.isExitBlock()) {
            return this.getPointerKeyForExceptionalReturnValue(node);
        }
        SSACFG.ExceptionHandlerBasicBlock ehbb = (SSACFG.ExceptionHandlerBasicBlock)cb;
        SSAGetCaughtExceptionInstruction ci = ehbb.getCatchInstruction();
        return this.getPointerKeyForLocal(node, ci.getDef());
    }

    public static List<ProgramCounter> getIncomingPEIs(IR ir, ISSABasicBlock bb) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        SSACFG g = ir.getControlFlowGraph();
        ArrayList<ProgramCounter> result = new ArrayList<ProgramCounter>(g.getPredNodeCount(bb));
        Iterator it = g.getPredNodes(bb);
        while (it.hasNext()) {
            SSACFG.BasicBlock pred = (SSACFG.BasicBlock)it.next();
            if (pred.isEntryBlock()) continue;
            int index = pred.getLastInstructionIndex();
            SSAInstruction pei = ir.getInstructions()[index];
            if (pei == null || !pei.isPEI()) continue;
            result.add(new ProgramCounter(g.getProgramCounter(index)));
        }
        return result;
    }

    private void processResolvedCall(CGNode caller, SSAAbstractInvokeInstruction instruction, CGNode target, InstanceKey[][] constParams, PointerKey uniqueCatchKey) {
        caller.addTarget(instruction.getCallSite(), target);
        if (FakeRootMethod.isFakeRootMethod(caller.getMethod().getReference()) && this.entrypointCallSites.contains(instruction.getCallSite())) {
            this.callGraph.registerEntrypoint(target);
        }
        if (!this.haveAlreadyVisited(target)) {
            this.markDiscovered(target);
        }
        this.processCallingConstraints(caller, instruction, target, constParams, uniqueCatchKey);
    }

    protected void processCallingConstraints(CGNode caller, SSAAbstractInvokeInstruction instruction, CGNode target, InstanceKey[][] constParams, PointerKey uniqueCatchKey) {
        int nExpected;
        int nUses = instruction.getNumberOfParameters();
        if (nUses != (nExpected = target.getMethod().getNumberOfParameters())) {
            return;
        }
        for (int i = 0; i < instruction.getNumberOfParameters(); ++i) {
            if (!target.getMethod().getParameterType(i).isReferenceType()) continue;
            PointerKey formal = this.getTargetPointerKey(target, i);
            if (constParams != null && constParams[i] != null) {
                InstanceKey[] ik = constParams[i];
                for (int j = 0; j < ik.length; ++j) {
                    this.system.newConstraint(formal, ik[j]);
                }
                continue;
            }
            if (instruction.getUse(i) < 0) {
                Assertions.UNREACHABLE((String)("unexpected " + instruction + " in " + caller));
            }
            PointerKey actual = this.getPointerKeyForLocal(caller, instruction.getUse(i));
            if (formal instanceof FilteredPointerKey) {
                this.system.newConstraint(formal, this.filterOperator, actual);
                continue;
            }
            this.system.newConstraint(formal, assignOperator, actual);
        }
        if (instruction.hasDef() && instruction.getDeclaredResultType().isReferenceType()) {
            PointerKey result = this.getPointerKeyForLocal(caller, instruction.getDef());
            PointerKey ret = this.getPointerKeyForReturnValue(target);
            this.system.newConstraint(result, assignOperator, ret);
        }
        PointerKey e = this.getPointerKeyForLocal(caller, instruction.getException());
        PointerKey er = this.getPointerKeyForExceptionalReturnValue(target);
        if (uniqueCatchKey != null) {
            this.system.newConstraint(uniqueCatchKey, assignOperator, er);
        } else {
            this.system.newConstraint(e, assignOperator, er);
        }
    }

    protected void iterateCrossProduct(final CGNode caller, final SSAAbstractInvokeInstruction call, IntSet parameters, final InstanceKey[][] invariants, final VoidFunction<InstanceKey[]> f) {
        final int[] params = IntSetUtil.toArray((IntSet)parameters);
        final InstanceKey[] keys = new InstanceKey[call.getNumberOfParameters()];
        final CallSiteReference site = call.getCallSite();
        (new Object(){

            private void rec(final int pi) {
                if (pi == params.length) {
                    f.apply((Object)keys);
                } else {
                    InstanceKey[] ik;
                    final int p = params[pi];
                    int vn = call.getUse(p);
                    PointerKey var = SSAPropagationCallGraphBuilder.this.getPointerKeyForLocal(caller, vn);
                    InstanceKey[] instanceKeyArray = ik = invariants != null ? invariants[p] : null;
                    if (ik != null) {
                        if (ik.length > 0) {
                            for (int i = 0; i < ik.length; ++i) {
                                SSAPropagationCallGraphBuilder.this.system.findOrCreateIndexForInstanceKey(ik[i]);
                                keys[p] = ik[i];
                                this.rec(pi + 1);
                            }
                        } else if (!site.isDispatch() || p != 0) {
                            keys[p] = null;
                            this.rec(pi + 1);
                        }
                    } else {
                        MutableIntSet s = SSAPropagationCallGraphBuilder.this.system.findOrCreatePointsToSet(var).getValue();
                        if (s != null && !s.isEmpty()) {
                            s.foreach(new IntSetAction(){

                                public void act(int x) {
                                    keys[p] = SSAPropagationCallGraphBuilder.this.system.getInstanceKey(x);
                                    this.rec(pi + 1);
                                }
                            });
                        } else if (!site.isDispatch() || p != 0) {
                            keys[p] = null;
                            this.rec(pi + 1);
                        }
                    }
                }
            }
        }).rec(0);
    }

    protected Set<CGNode> getTargetsForCall(final CGNode caller, SSAAbstractInvokeInstruction instruction, InstanceKey[][] invs) {
        final CallSiteReference site = instruction.getCallSite();
        IntSet params = this.contextSelector.getRelevantParameters(caller, site);
        if (!site.isStatic() && !params.contains(0)) {
            params = IntSetUtil.makeMutableCopy((IntSet)params);
            ((MutableIntSet)params).add(0);
        }
        final HashSet targets = HashSetFactory.make();
        VoidFunction<InstanceKey[]> f = new VoidFunction<InstanceKey[]>(){

            public void apply(InstanceKey[] v) {
                CGNode target;
                IClass recv = null;
                if (site.isDispatch()) {
                    recv = v[0].getConcreteType();
                }
                if ((target = SSAPropagationCallGraphBuilder.this.getTargetForCall(caller, site, recv, v)) != null) {
                    targets.add(target);
                }
            }
        };
        this.iterateCrossProduct(caller, instruction, params, invs, f);
        return targets;
    }

    public boolean hasNoInterestingUses(CGNode node, int vn, DefUse du) {
        if (du == null) {
            throw new IllegalArgumentException("du is null");
        }
        if (vn <= 0) {
            throw new IllegalArgumentException("v is invalid: " + vn);
        }
        InterestingVisitor v = this.makeInterestingVisitor(node, vn);
        Iterator<SSAInstruction> it = du.getUses(v.vn);
        while (it.hasNext()) {
            SSAInstruction s = it.next();
            s.visit(v);
            if (!v.bingo) continue;
            return false;
        }
        return true;
    }

    protected InterestingVisitor makeInterestingVisitor(CGNode node, int vn) {
        return new InterestingVisitor(vn);
    }

    private boolean needsFilterForReceiver(SSAAbstractInvokeInstruction instruction, CGNode target) {
        FilteredPointerKey.TypeFilter f = (FilteredPointerKey.TypeFilter)target.getContext().get(ContextKey.PARAMETERS[0]);
        if (f != null) {
            return true;
        }
        if (instruction.getCallSite().isStatic() || instruction.getCallSite().isSpecial()) {
            return false;
        }
        MethodReference declaredTarget = instruction.getDeclaredTarget();
        IMethod resolvedTarget = this.getClassHierarchy().resolveMethod(declaredTarget);
        if (resolvedTarget == null) {
            return true;
        }
        return true;
    }

    private boolean isRootType(IClass klass) {
        return klass.getClassHierarchy().isRootClass(klass);
    }

    private boolean isRootType(FilteredPointerKey.TypeFilter filter) {
        if (filter instanceof FilteredPointerKey.SingleClassFilter) {
            return this.isRootType(((FilteredPointerKey.SingleClassFilter)filter).getConcreteType());
        }
        return false;
    }

    public PointerKey getTargetPointerKey(CGNode target, int index) {
        int vn = target.getIR() != null ? target.getIR().getSymbolTable().getParameter(index) : index + 1;
        FilteredPointerKey.TypeFilter filter = (FilteredPointerKey.TypeFilter)target.getContext().get(ContextKey.PARAMETERS[index]);
        if (filter != null && !filter.isRootFilter()) {
            return this.getFilteredPointerKeyForLocal(target, vn, filter);
        }
        IClass C = index == 0 && !target.getMethod().isStatic() ? this.getReceiverClass(target.getMethod()) : this.cha.lookupClass(target.getMethod().getParameterType(index));
        if (C == null || C.getClassHierarchy().getRootClass().equals(C)) {
            return this.getPointerKeyForLocal(target, vn);
        }
        return this.getFilteredPointerKeyForLocal(target, vn, new FilteredPointerKey.SingleClassFilter(C));
    }

    private IClass getReceiverClass(IMethod method) {
        TypeReference formalType = method.getParameterType(0);
        IClass C = this.getClassHierarchy().lookupClass(formalType);
        if (method.isStatic()) {
            Assertions.UNREACHABLE((String)("asked for receiver of static method " + method));
        }
        if (C == null) {
            Assertions.UNREACHABLE((String)("no class found for " + formalType + " recv of " + method));
        }
        return C;
    }

    protected boolean contentsAreInvariant(SymbolTable symbolTable, DefUse du, int valueNumber) {
        if (this.isConstantRef(symbolTable, valueNumber)) {
            return true;
        }
        SSAInstruction def = du.getDef(valueNumber);
        return def instanceof SSANewInstruction;
    }

    protected boolean contentsAreInvariant(SymbolTable symbolTable, DefUse du, int[] valueNumbers) {
        for (int i = 0; i < valueNumbers.length; ++i) {
            if (this.contentsAreInvariant(symbolTable, du, valueNumbers[i])) continue;
            return false;
        }
        return true;
    }

    public InstanceKey[] getInvariantContents(SymbolTable symbolTable, DefUse du, CGNode node, int valueNumber, HeapModel hm) {
        return this.getInvariantContents(symbolTable, du, node, valueNumber, hm, false);
    }

    protected InstanceKey[] getInvariantContents(SymbolTable symbolTable, DefUse du, CGNode node, int valueNumber, HeapModel hm, boolean ensureIndexes) {
        InstanceKey[] result;
        if (this.isConstantRef(symbolTable, valueNumber)) {
            Object x = symbolTable.getConstantValue(valueNumber);
            if (x instanceof String) {
                String S = (String)x;
                TypeReference type = node.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(S);
                if (type == null) {
                    return new InstanceKey[0];
                }
                InstanceKey ik = hm.getInstanceKeyForConstant(type, S);
                result = ik != null ? new InstanceKey[]{ik} : new InstanceKey[]{};
            } else {
                TypeReference type = node.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(x);
                if (type == null) {
                    return new InstanceKey[0];
                }
                InstanceKey ik = hm.getInstanceKeyForConstant(type, x);
                result = ik != null ? new InstanceKey[]{ik} : new InstanceKey[]{};
            }
        } else {
            InstanceKey[] instanceKeyArray;
            SSANewInstruction def = (SSANewInstruction)du.getDef(valueNumber);
            InstanceKey iKey = hm.getInstanceKeyForAllocation(node, def.getNewSite());
            if (iKey == null) {
                instanceKeyArray = new InstanceKey[]{};
            } else {
                InstanceKey[] instanceKeyArray2 = new InstanceKey[1];
                instanceKeyArray = instanceKeyArray2;
                instanceKeyArray2[0] = iKey;
            }
            result = instanceKeyArray;
        }
        if (ensureIndexes) {
            for (int i = 0; i < result.length; ++i) {
                this.system.findOrCreateIndexForInstanceKey(result[i]);
            }
        }
        return result;
    }

    protected boolean isConstantRef(SymbolTable symbolTable, int valueNumber) {
        if (valueNumber == -1) {
            return false;
        }
        if (symbolTable.isConstant(valueNumber)) {
            Object v = symbolTable.getConstantValue(valueNumber);
            return !(v instanceof Number);
        }
        return false;
    }

    @Override
    public Iterator<PointerKey> iteratePointerKeys() {
        return this.system.iteratePointerKeys();
    }

    public static Set<IClass> getCaughtExceptionTypes(SSAGetCaughtExceptionInstruction instruction, IR ir) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        if (instruction == null) {
            throw new IllegalArgumentException("instruction is null");
        }
        Iterator<TypeReference> exceptionTypes = ((SSACFG.ExceptionHandlerBasicBlock)ir.getControlFlowGraph().getNode(instruction.getBasicBlockNumber())).getCaughtExceptionTypes();
        HashSet types = HashSetFactory.make((int)10);
        while (exceptionTypes.hasNext()) {
            IClass c = ir.getMethod().getClassHierarchy().lookupClass(exceptionTypes.next());
            if (c == null) continue;
            types.add(c);
        }
        return types;
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter instr, TypeReference type) {
        return SSAPropagationCallGraphBuilder.getInstanceKeyForPEI(node, instr, type, this.instanceKeyFactory);
    }

    @Override
    protected IPointsToSolver makeSolver() {
        return new StandardSolver(this.system, this);
    }

    private static class FieldResolutionFailure
    extends Warning {
        final FieldReference field;

        FieldResolutionFailure(FieldReference field) {
            super((byte)2);
            this.field = field;
        }

        @Override
        public String getMsg() {
            return this.getClass().toString() + " : " + this.field;
        }

        public static FieldResolutionFailure create(FieldReference field) {
            return new FieldResolutionFailure(field);
        }
    }

    private static class CheckcastFailure
    extends Warning {
        final TypeReference type;

        CheckcastFailure(TypeReference type) {
            super((byte)2);
            this.type = type;
        }

        @Override
        public String getMsg() {
            return this.getClass().toString() + " : " + this.type;
        }

        public static CheckcastFailure create(TypeReference type) {
            return new CheckcastFailure(type);
        }
    }

    protected static class InterestingVisitor
    extends SSAInstruction.Visitor {
        protected final int vn;
        protected boolean bingo = false;

        public InterestingVisitor(int vn) {
            this.vn = vn;
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            if (!instruction.typeIsPrimitive() && instruction.getArrayRef() == this.vn) {
                this.bingo = true;
            }
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            if (!(instruction.typeIsPrimitive() || instruction.getArrayRef() != this.vn && instruction.getValue() != this.vn)) {
                this.bingo = true;
            }
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
            this.bingo = true;
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            FieldReference field = instruction.getDeclaredField();
            if (!field.getFieldType().isPrimitiveType()) {
                this.bingo = true;
            }
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            this.bingo = true;
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
            this.bingo = true;
        }

        @Override
        public void visitPhi(SSAPhiInstruction instruction) {
            this.bingo = true;
        }

        @Override
        public void visitPi(SSAPiInstruction instruction) {
            this.bingo = true;
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            FieldReference field = instruction.getDeclaredField();
            if (!field.getFieldType().isPrimitiveType()) {
                this.bingo = true;
            }
        }

        @Override
        public void visitReturn(SSAReturnInstruction instruction) {
            this.bingo = true;
        }

        @Override
        public void visitThrow(SSAThrowInstruction instruction) {
            this.bingo = true;
        }
    }

    final class DispatchOperator
    extends AbstractOperator<PointsToSetVariable>
    implements IPointerOperator {
        private final SSAAbstractInvokeInstruction call;
        private final CGNode node;
        private final InstanceKey[][] constParams;
        private final PointerKey uniqueCatch;
        private final int[] dispatchIndices;
        private final MutableIntSet[] previousPtrs;

        DispatchOperator(SSAAbstractInvokeInstruction call, CGNode node, InstanceKey[][] constParams, PointerKey uniqueCatch, IntSet dispatchIndices) {
            this.call = call;
            this.node = node;
            this.constParams = constParams;
            this.uniqueCatch = uniqueCatch;
            this.dispatchIndices = IntSetUtil.toArray((IntSet)dispatchIndices);
            assert (this.dispatchIndices[0] == 0);
            this.previousPtrs = new MutableIntSet[dispatchIndices.size()];
            for (int i = 0; i < this.previousPtrs.length; ++i) {
                this.previousPtrs[i] = IntSetUtil.getDefaultIntSetFactory().make();
            }
        }

        public byte evaluate(PointsToSetVariable lhs, PointsToSetVariable[] rhs) {
            MutableIntSet receiverVals;
            assert (this.dispatchIndices.length >= rhs.length) : "bad operator at " + this.call;
            PropagationCallGraphBuilder.MutableBoolean addedNewTarget = new PropagationCallGraphBuilder.MutableBoolean();
            if (this.constParams != null && this.constParams[0] != null) {
                receiverVals = IntSetUtil.make();
                for (InstanceKey ik : this.constParams[0]) {
                    receiverVals.add(SSAPropagationCallGraphBuilder.this.system.getInstanceIndex(ik));
                }
            } else {
                receiverVals = rhs[0].getValue();
            }
            if (receiverVals == null) {
                return 0;
            }
            InstanceKey[] keys = new InstanceKey[this.constParams == null ? this.dispatchIndices[this.dispatchIndices.length - 1] + 1 : this.constParams.length];
            boolean newReceiver = !receiverVals.isSubset((IntSet)this.previousPtrs[0]);
            int rhsIndex = this.constParams != null && this.constParams[0] != null ? 0 : 1;
            boolean propagatedReceivers = false;
            for (int index = 1; index < this.dispatchIndices.length; ++index) {
                try {
                    MonitorUtil.throwExceptionIfCanceled((MonitorUtil.IProgressMonitor)SSAPropagationCallGraphBuilder.this.monitor);
                }
                catch (CancelException e) {
                    throw new CancelRuntimeException((Exception)((Object)e));
                }
                int paramIndex = this.dispatchIndices[index];
                assert (keys[paramIndex] == null);
                MutableIntSet prevAtIndex = this.previousPtrs[index];
                if (this.constParams != null && this.constParams[paramIndex] != null) {
                    if (newReceiver || prevAtIndex.isEmpty()) {
                        for (int i = 0; i < this.constParams[paramIndex].length; ++i) {
                            keys[paramIndex] = this.constParams[paramIndex][i];
                            this.handleAllReceivers(receiverVals, keys, addedNewTarget);
                            propagatedReceivers = true;
                            int ii = SSAPropagationCallGraphBuilder.this.system.instanceKeys.getMappedIndex((Object)this.constParams[paramIndex][i]);
                            prevAtIndex.add(ii);
                        }
                    }
                } else {
                    PointsToSetVariable v = rhs[rhsIndex];
                    if (v.getValue() != null) {
                        IntIterator ptrs = v.getValue().intIterator();
                        while (ptrs.hasNext()) {
                            int ptr = ptrs.next();
                            if (!newReceiver && prevAtIndex.contains(ptr)) continue;
                            keys[paramIndex] = SSAPropagationCallGraphBuilder.this.system.getInstanceKey(ptr);
                            this.handleAllReceivers(receiverVals, keys, addedNewTarget);
                            propagatedReceivers = true;
                            prevAtIndex.add(ptr);
                        }
                    }
                    ++rhsIndex;
                }
                keys[paramIndex] = null;
            }
            if (newReceiver) {
                if (!propagatedReceivers) {
                    this.handleAllReceivers(receiverVals, keys, addedNewTarget);
                }
                this.previousPtrs[0].addAll((IntSet)receiverVals);
            }
            int sideEffectMask = addedNewTarget.b ? 4 : 0;
            return (byte)(0 | sideEffectMask);
        }

        private void handleAllReceivers(MutableIntSet receiverVals, InstanceKey[] keys, PropagationCallGraphBuilder.MutableBoolean sideEffect) {
            assert (keys[0] == null);
            IntIterator receiverIter = receiverVals.intIterator();
            while (receiverIter.hasNext()) {
                IntSet targets;
                int rcvr = receiverIter.next();
                keys[0] = SSAPropagationCallGraphBuilder.this.system.getInstanceKey(rcvr);
                CGNode target = SSAPropagationCallGraphBuilder.this.getTargetForCall(this.node, this.call.getCallSite(), keys[0].getConcreteType(), keys);
                if (target == null || (targets = SSAPropagationCallGraphBuilder.this.getCallGraph().getPossibleTargetNumbers(this.node, this.call.getCallSite())) != null && targets.contains(target.getGraphNodeId()) && this.noConstParams()) continue;
                sideEffect.b = true;
                SSAPropagationCallGraphBuilder.this.processResolvedCall(this.node, this.call, target, this.constParams, this.uniqueCatch);
                if (SSAPropagationCallGraphBuilder.this.haveAlreadyVisited(target)) continue;
                SSAPropagationCallGraphBuilder.this.markDiscovered(target);
            }
            keys[0] = null;
        }

        private boolean noConstParams() {
            if (this.constParams != null) {
                for (int i = 0; i < this.constParams.length; ++i) {
                    if (this.constParams[i] == null) continue;
                    int j = 0;
                    while (j < this.constParams[i].length) {
                        if (this.constParams[i][j] != null) {
                            return false;
                        }
                        ++i;
                    }
                }
            }
            return true;
        }

        public String toString() {
            return "Dispatch to " + this.call + " in node " + this.node;
        }

        public int hashCode() {
            int h = 1;
            if (this.constParams != null) {
                for (InstanceKey[] cs : this.constParams) {
                    if (cs == null) continue;
                    for (InstanceKey c : cs) {
                        if (c == null) continue;
                        h ^= c.hashCode();
                    }
                }
            }
            return h * this.node.hashCode() + 90289 * this.call.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof DispatchOperator) {
                DispatchOperator other = (DispatchOperator)o;
                return this.node.equals(other.node) && this.call.equals(other.call) && Arrays.deepEquals((Object[])this.constParams, (Object[])other.constParams);
            }
            return false;
        }

        @Override
        public boolean isComplex() {
            return true;
        }
    }

    protected static class ConstraintVisitor
    extends SSAInstruction.Visitor {
        protected final SSAPropagationCallGraphBuilder builder;
        protected final CGNode node;
        private final ExplicitCallGraph callGraph;
        protected final IR ir;
        protected final PropagationSystem system;
        protected ISSABasicBlock basicBlock;
        protected final SymbolTable symbolTable;
        protected final DefUse du;

        public ConstraintVisitor(SSAPropagationCallGraphBuilder builder, CGNode node) {
            this.builder = builder;
            this.node = node;
            this.callGraph = builder.getCallGraph();
            this.system = builder.getPropagationSystem();
            this.ir = builder.getCFAContextInterpreter().getIR(node);
            this.symbolTable = this.ir.getSymbolTable();
            this.du = builder.getCFAContextInterpreter().getDU(node);
            assert (this.symbolTable != null);
        }

        protected SSAPropagationCallGraphBuilder getBuilder() {
            return this.builder;
        }

        protected AnalysisOptions getOptions() {
            return this.builder.options;
        }

        protected AnalysisCache getAnalysisCache() {
            return this.builder.getAnalysisCache();
        }

        public PointerKey getPointerKeyForLocal(int valueNumber) {
            return this.getBuilder().getPointerKeyForLocal(this.node, valueNumber);
        }

        public FilteredPointerKey getFilteredPointerKeyForLocal(int valueNumber, FilteredPointerKey.TypeFilter filter) {
            return this.getBuilder().getFilteredPointerKeyForLocal(this.node, valueNumber, filter);
        }

        public PointerKey getPointerKeyForReturnValue() {
            return this.getBuilder().getPointerKeyForReturnValue(this.node);
        }

        public PointerKey getPointerKeyForExceptionalReturnValue() {
            return this.getBuilder().getPointerKeyForExceptionalReturnValue(this.node);
        }

        public PointerKey getPointerKeyForStaticField(IField f) {
            return this.getBuilder().getPointerKeyForStaticField(f);
        }

        public PointerKey getPointerKeyForInstanceField(InstanceKey I, IField f) {
            return this.getBuilder().getPointerKeyForInstanceField(I, f);
        }

        public PointerKey getPointerKeyForArrayContents(InstanceKey I) {
            return this.getBuilder().getPointerKeyForArrayContents(I);
        }

        public InstanceKey getInstanceKeyForAllocation(NewSiteReference allocation) {
            return this.getBuilder().getInstanceKeyForAllocation(this.node, allocation);
        }

        public InstanceKey getInstanceKeyForMultiNewArray(NewSiteReference allocation, int dim) {
            return this.getBuilder().getInstanceKeyForMultiNewArray(this.node, allocation, dim);
        }

        public <T> InstanceKey getInstanceKeyForConstant(T S) {
            TypeReference type = this.node.getMethod().getDeclaringClass().getClassLoader().getLanguage().getConstantType(S);
            return this.getBuilder().getInstanceKeyForConstant(type, S);
        }

        public InstanceKey getInstanceKeyForPEI(ProgramCounter instr, TypeReference type) {
            return this.getBuilder().getInstanceKeyForPEI(this.node, instr, type);
        }

        public InstanceKey getInstanceKeyForClassObject(Object obj, TypeReference type) {
            return this.getBuilder().getInstanceKeyForMetadataObject(obj, type);
        }

        public CGNode getTargetForCall(CGNode caller, CallSiteReference site, IClass recv, InstanceKey[] iKey) {
            return this.getBuilder().getTargetForCall(caller, site, recv, iKey);
        }

        protected boolean contentsAreInvariant(SymbolTable symbolTable, DefUse du, int valueNumber) {
            return this.getBuilder().contentsAreInvariant(symbolTable, du, valueNumber);
        }

        protected boolean contentsAreInvariant(SymbolTable symbolTable, DefUse du, int[] valueNumber) {
            return this.getBuilder().contentsAreInvariant(symbolTable, du, valueNumber);
        }

        protected InstanceKey[] getInvariantContents(int valueNumber) {
            return this.getInvariantContents(this.ir.getSymbolTable(), this.du, this.node, valueNumber);
        }

        protected InstanceKey[] getInvariantContents(SymbolTable symbolTable, DefUse du, CGNode node, int valueNumber) {
            return this.getBuilder().getInvariantContents(symbolTable, du, node, valueNumber, this.getBuilder());
        }

        protected IClassHierarchy getClassHierarchy() {
            return this.getBuilder().getClassHierarchy();
        }

        protected boolean hasNoInterestingUses(int vn) {
            return this.getBuilder().hasNoInterestingUses(this.node, vn, this.du);
        }

        protected boolean isRootType(IClass klass) {
            return this.getBuilder().isRootType(klass);
        }

        @Override
        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            if (instruction.typeIsPrimitive()) {
                return;
            }
            this.doVisitArrayLoad(instruction.getDef(), instruction.getArrayRef());
        }

        protected void doVisitArrayLoad(int def, int arrayRef) {
            PointerKey result = this.getPointerKeyForLocal(def);
            PointerKey arrayRefPtrKey = this.getPointerKeyForLocal(arrayRef);
            if (this.hasNoInterestingUses(def)) {
                this.system.recordImplicitPointsToSet(result);
            } else if (this.contentsAreInvariant(this.symbolTable, this.du, arrayRef)) {
                this.system.recordImplicitPointsToSet(arrayRefPtrKey);
                InstanceKey[] ik = this.getInvariantContents(arrayRef);
                for (int i = 0; i < ik.length; ++i) {
                    if (PropagationCallGraphBuilder.representsNullType(ik[i])) continue;
                    this.system.findOrCreateIndexForInstanceKey(ik[i]);
                    PointerKey p = this.getPointerKeyForArrayContents(ik[i]);
                    if (p == null) continue;
                    this.system.newConstraint(result, PropagationCallGraphBuilder.assignOperator, p);
                }
            } else {
                assert (!this.system.isUnified(result));
                assert (!this.system.isUnified(arrayRefPtrKey));
                SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                sSAPropagationCallGraphBuilder.getClass();
                this.system.newSideEffect(sSAPropagationCallGraphBuilder.new PropagationCallGraphBuilder.ArrayLoadOperator(this.system.findOrCreatePointsToSet(result)), arrayRefPtrKey);
            }
        }

        public void doVisitArrayStore(int arrayRef, int value) {
            PointerKey valuePtrKey = this.getPointerKeyForLocal(value);
            PointerKey arrayRefPtrKey = this.getPointerKeyForLocal(arrayRef);
            if (this.contentsAreInvariant(this.symbolTable, this.du, arrayRef)) {
                this.system.recordImplicitPointsToSet(arrayRefPtrKey);
                InstanceKey[] ik = this.getInvariantContents(arrayRef);
                for (int i = 0; i < ik.length; ++i) {
                    if (PropagationCallGraphBuilder.representsNullType(ik[i]) || ik[i] instanceof ZeroLengthArrayInNode) continue;
                    this.system.findOrCreateIndexForInstanceKey(ik[i]);
                    PointerKey p = this.getPointerKeyForArrayContents(ik[i]);
                    IClass contents = ((ArrayClass)ik[i].getConcreteType()).getElementClass();
                    if (p == null) continue;
                    if (this.contentsAreInvariant(this.symbolTable, this.du, value)) {
                        this.system.recordImplicitPointsToSet(valuePtrKey);
                        InstanceKey[] vk = this.getInvariantContents(value);
                        for (int j = 0; j < vk.length; ++j) {
                            this.system.findOrCreateIndexForInstanceKey(vk[j]);
                            if (vk[j].getConcreteType() == null || !this.getClassHierarchy().isAssignableFrom(contents, vk[j].getConcreteType())) continue;
                            this.system.newConstraint(p, vk[j]);
                        }
                        continue;
                    }
                    if (this.isRootType(contents)) {
                        this.system.newConstraint(p, PropagationCallGraphBuilder.assignOperator, valuePtrKey);
                        continue;
                    }
                    this.system.newConstraint(p, this.getBuilder().filterOperator, valuePtrKey);
                }
            } else if (this.contentsAreInvariant(this.symbolTable, this.du, value)) {
                this.system.recordImplicitPointsToSet(valuePtrKey);
                InstanceKey[] ik = this.getInvariantContents(value);
                for (int i = 0; i < ik.length; ++i) {
                    this.system.findOrCreateIndexForInstanceKey(ik[i]);
                    assert (!this.system.isUnified(arrayRefPtrKey));
                    SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                    sSAPropagationCallGraphBuilder.getClass();
                    this.system.newSideEffect(sSAPropagationCallGraphBuilder.new PropagationCallGraphBuilder.InstanceArrayStoreOperator(ik[i]), arrayRefPtrKey);
                }
            } else {
                SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                sSAPropagationCallGraphBuilder.getClass();
                this.system.newSideEffect(sSAPropagationCallGraphBuilder.new PropagationCallGraphBuilder.ArrayStoreOperator(this.system.findOrCreatePointsToSet(valuePtrKey)), arrayRefPtrKey);
            }
        }

        @Override
        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            if (instruction.typeIsPrimitive()) {
                return;
            }
            this.doVisitArrayStore(instruction.getArrayRef(), instruction.getValue());
        }

        @Override
        public void visitCheckCast(SSACheckCastInstruction instruction) {
            boolean isRoot = false;
            HashSet types = HashSetFactory.make();
            for (TypeReference t : instruction.getDeclaredResultTypes()) {
                IClass cls = this.getClassHierarchy().lookupClass(t);
                if (cls == null) {
                    Warnings.add(CheckcastFailure.create(t));
                    return;
                }
                if (this.isRootType(cls)) {
                    isRoot = true;
                }
                types.add(cls);
            }
            FilteredPointerKey result = this.getFilteredPointerKeyForLocal(instruction.getResult(), new FilteredPointerKey.MultipleClassesFilter(types.toArray(new IClass[types.size()])));
            PointerKey value = this.getPointerKeyForLocal(instruction.getVal());
            if (this.hasNoInterestingUses(instruction.getDef())) {
                this.system.recordImplicitPointsToSet(result);
            } else if (this.contentsAreInvariant(this.symbolTable, this.du, instruction.getVal())) {
                this.system.recordImplicitPointsToSet(value);
                InstanceKey[] ik = this.getInvariantContents(instruction.getVal());
                for (TypeReference t : instruction.getDeclaredResultTypes()) {
                    int i;
                    IClass cls = this.getClassHierarchy().lookupClass(t);
                    if (cls.isInterface()) {
                        for (i = 0; i < ik.length; ++i) {
                            this.system.findOrCreateIndexForInstanceKey(ik[i]);
                            if (!this.getClassHierarchy().implementsInterface(ik[i].getConcreteType(), cls)) continue;
                            this.system.newConstraint(result, ik[i]);
                        }
                        continue;
                    }
                    for (i = 0; i < ik.length; ++i) {
                        this.system.findOrCreateIndexForInstanceKey(ik[i]);
                        if (!this.getClassHierarchy().isSubclassOf(ik[i].getConcreteType(), cls)) continue;
                        this.system.newConstraint(result, ik[i]);
                    }
                }
            } else if (isRoot) {
                this.system.newConstraint((PointerKey)result, PropagationCallGraphBuilder.assignOperator, value);
            } else {
                this.system.newConstraint((PointerKey)result, this.getBuilder().filterOperator, value);
            }
        }

        @Override
        public void visitReturn(SSAReturnInstruction instruction) {
            if (instruction.returnsPrimitiveType() || instruction.returnsVoid()) {
                return;
            }
            PointerKey returnValue = this.getPointerKeyForReturnValue();
            PointerKey result = this.getPointerKeyForLocal(instruction.getResult());
            if (this.contentsAreInvariant(this.symbolTable, this.du, instruction.getResult())) {
                this.system.recordImplicitPointsToSet(result);
                InstanceKey[] ik = this.getInvariantContents(instruction.getResult());
                for (int i = 0; i < ik.length; ++i) {
                    this.system.newConstraint(returnValue, ik[i]);
                }
            } else {
                this.system.newConstraint(returnValue, PropagationCallGraphBuilder.assignOperator, result);
            }
        }

        @Override
        public void visitGet(SSAGetInstruction instruction) {
            this.visitGetInternal(instruction.getDef(), instruction.getRef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        protected void visitGetInternal(int lval, int ref, boolean isStatic, FieldReference field) {
            IClass klass;
            PointerKey def = this.getPointerKeyForLocal(lval);
            assert (def != null);
            IField f = this.getClassHierarchy().resolveField(field);
            if (f == null && this.callGraph.getFakeRootNode().getMethod().getDeclaringClass().getReference().equals(field.getDeclaringClass())) {
                f = this.callGraph.getFakeRootNode().getMethod().getDeclaringClass().getField(field.getName());
            }
            if (f == null) {
                return;
            }
            if (isStatic && (klass = this.getClassHierarchy().lookupClass(field.getDeclaringClass())) != null) {
                this.processClassInitializer(klass);
            }
            if (field.getFieldType().isPrimitiveType()) {
                return;
            }
            if (this.hasNoInterestingUses(lval)) {
                this.system.recordImplicitPointsToSet(def);
            } else if (isStatic) {
                PointerKey fKey = this.getPointerKeyForStaticField(f);
                this.system.newConstraint(def, PropagationCallGraphBuilder.assignOperator, fKey);
            } else {
                PointerKey refKey = this.getPointerKeyForLocal(ref);
                if (this.contentsAreInvariant(this.symbolTable, this.du, ref)) {
                    this.system.recordImplicitPointsToSet(refKey);
                    InstanceKey[] ik = this.getInvariantContents(ref);
                    for (int i = 0; i < ik.length; ++i) {
                        if (PropagationCallGraphBuilder.representsNullType(ik[i])) continue;
                        this.system.findOrCreateIndexForInstanceKey(ik[i]);
                        PointerKey p = this.getPointerKeyForInstanceField(ik[i], f);
                        this.system.newConstraint(def, PropagationCallGraphBuilder.assignOperator, p);
                    }
                } else {
                    SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                    sSAPropagationCallGraphBuilder.getClass();
                    this.system.newSideEffect(sSAPropagationCallGraphBuilder.new PropagationCallGraphBuilder.GetFieldOperator(f, this.system.findOrCreatePointsToSet(def)), refKey);
                }
            }
        }

        @Override
        public void visitPut(SSAPutInstruction instruction) {
            this.visitPutInternal(instruction.getVal(), instruction.getRef(), instruction.isStatic(), instruction.getDeclaredField());
        }

        public void visitPutInternal(int rval, int ref, boolean isStatic, FieldReference field) {
            if (field.getFieldType().isPrimitiveType()) {
                return;
            }
            IField f = this.getClassHierarchy().resolveField(field);
            if (f == null) {
                Warnings.add(FieldResolutionFailure.create(field));
                return;
            }
            assert (f.getFieldTypeReference().getName().equals(field.getFieldType().getName())) : "name clash of two fields with the same name but different type: " + f.getReference() + " <=> " + field;
            assert (isStatic || !this.symbolTable.isStringConstant(ref)) : "put to string constant shouldn't be allowed?";
            if (isStatic) {
                this.processPutStatic(rval, field, f);
            } else {
                this.processPutField(rval, ref, f);
            }
        }

        public void processPutField(int rval, int ref, IField f) {
            assert (!f.getFieldTypeReference().isPrimitiveType());
            PointerKey refKey = this.getPointerKeyForLocal(ref);
            PointerKey rvalKey = this.getPointerKeyForLocal(rval);
            if (this.contentsAreInvariant(this.symbolTable, this.du, rval)) {
                this.system.recordImplicitPointsToSet(rvalKey);
                InstanceKey[] ik = this.getInvariantContents(rval);
                if (this.contentsAreInvariant(this.symbolTable, this.du, ref)) {
                    this.system.recordImplicitPointsToSet(refKey);
                    InstanceKey[] refk = this.getInvariantContents(ref);
                    for (int j = 0; j < refk.length; ++j) {
                        if (PropagationCallGraphBuilder.representsNullType(refk[j])) continue;
                        this.system.findOrCreateIndexForInstanceKey(refk[j]);
                        PointerKey p = this.getPointerKeyForInstanceField(refk[j], f);
                        for (int i = 0; i < ik.length; ++i) {
                            this.system.newConstraint(p, ik[i]);
                        }
                    }
                } else {
                    for (int i = 0; i < ik.length; ++i) {
                        this.system.findOrCreateIndexForInstanceKey(ik[i]);
                        SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                        sSAPropagationCallGraphBuilder.getClass();
                        this.system.newSideEffect(sSAPropagationCallGraphBuilder.new PropagationCallGraphBuilder.InstancePutFieldOperator(f, ik[i]), refKey);
                    }
                }
            } else if (this.contentsAreInvariant(this.symbolTable, this.du, ref)) {
                this.system.recordImplicitPointsToSet(refKey);
                InstanceKey[] refk = this.getInvariantContents(ref);
                for (int j = 0; j < refk.length; ++j) {
                    if (PropagationCallGraphBuilder.representsNullType(refk[j])) continue;
                    this.system.findOrCreateIndexForInstanceKey(refk[j]);
                    PointerKey p = this.getPointerKeyForInstanceField(refk[j], f);
                    this.system.newConstraint(p, PropagationCallGraphBuilder.assignOperator, rvalKey);
                }
            } else {
                SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                sSAPropagationCallGraphBuilder.getClass();
                this.system.newSideEffect(sSAPropagationCallGraphBuilder.new PropagationCallGraphBuilder.PutFieldOperator(f, this.system.findOrCreatePointsToSet(rvalKey)), refKey);
            }
        }

        protected void processPutStatic(int rval, FieldReference field, IField f) {
            PointerKey fKey = this.getPointerKeyForStaticField(f);
            PointerKey rvalKey = this.getPointerKeyForLocal(rval);
            if (this.contentsAreInvariant(this.symbolTable, this.du, rval)) {
                this.system.recordImplicitPointsToSet(rvalKey);
                InstanceKey[] ik = this.getInvariantContents(rval);
                for (int i = 0; i < ik.length; ++i) {
                    this.system.newConstraint(fKey, ik[i]);
                }
            } else {
                this.system.newConstraint(fKey, PropagationCallGraphBuilder.assignOperator, rvalKey);
            }
            IClass klass = this.getClassHierarchy().lookupClass(field.getDeclaringClass());
            if (klass == null) {
                Warnings.add(FieldResolutionFailure.create(field));
            } else {
                this.processClassInitializer(klass);
            }
        }

        @Override
        public void visitInvoke(SSAInvokeInstruction instruction) {
            this.visitInvokeInternal(instruction, new DefaultInvariantComputer());
        }

        protected void visitInvokeInternal(final SSAAbstractInvokeInstruction instruction, InvariantComputer invs) {
            PointerKey uniqueCatch = null;
            if (SSAPropagationCallGraphBuilder.hasUniqueCatchBlock(instruction, this.ir)) {
                uniqueCatch = this.getBuilder().getUniqueCatchKey(instruction, this.ir, this.node);
            }
            InstanceKey[][] invariantParameters = invs.computeInvariantParameters(instruction);
            if (instruction.getCallSite().isStatic()) {
                for (CGNode n : this.getBuilder().getTargetsForCall(this.node, instruction, invariantParameters)) {
                    this.getBuilder().processResolvedCall(this.node, instruction, n, invariantParameters, uniqueCatch);
                    this.processClassInitializer(n.getMethod().getDeclaringClass());
                }
            } else {
                IntSet params = this.getBuilder().getContextSelector().getRelevantParameters(this.node, instruction.getCallSite());
                if (!params.contains(0)) {
                    params = IntSetUtil.makeMutableCopy((IntSet)params);
                    ((MutableIntSet)params).add(0);
                }
                final int[] vns = new int[params.size()];
                params.foreach(new IntSetAction(){
                    private int i = 0;

                    public void act(int x) {
                        vns[this.i++] = instruction.getUse(x);
                    }
                });
                if (this.contentsAreInvariant(this.symbolTable, this.du, vns)) {
                    for (CGNode n : this.getBuilder().getTargetsForCall(this.node, instruction, invariantParameters)) {
                        this.getBuilder().processResolvedCall(this.node, instruction, n, invariantParameters, uniqueCatch);
                        this.processClassInitializer(n.getMethod().getDeclaringClass());
                    }
                } else {
                    final ArrayList pks = new ArrayList(params.size());
                    params.foreach(new IntSetAction(){

                        public void act(int x) {
                            if (!ConstraintVisitor.this.contentsAreInvariant(ConstraintVisitor.this.symbolTable, ConstraintVisitor.this.du, instruction.getUse(x))) {
                                pks.add(ConstraintVisitor.this.getBuilder().getPointerKeyForLocal(ConstraintVisitor.this.node, instruction.getUse(x)));
                            }
                        }
                    });
                    SSAPropagationCallGraphBuilder sSAPropagationCallGraphBuilder = this.getBuilder();
                    sSAPropagationCallGraphBuilder.getClass();
                    DispatchOperator dispatchOperator = sSAPropagationCallGraphBuilder.new DispatchOperator(instruction, this.node, invariantParameters, uniqueCatch, params);
                    this.system.newSideEffect(dispatchOperator, pks.toArray(new PointerKey[pks.size()]));
                }
            }
        }

        @Override
        public void visitNew(SSANewInstruction instruction) {
            InstanceKey iKey = this.getInstanceKeyForAllocation(instruction.getNewSite());
            if (iKey == null) {
                return;
            }
            PointerKey def = this.getPointerKeyForLocal(instruction.getDef());
            IClass klass = iKey.getConcreteType();
            if (klass == null) {
                return;
            }
            if (!this.contentsAreInvariant(this.symbolTable, this.du, instruction.getDef())) {
                this.system.newConstraint(def, iKey);
            } else {
                this.system.findOrCreateIndexForInstanceKey(iKey);
                this.system.recordImplicitPointsToSet(def);
            }
            this.processClassInitializer(klass);
            this.processFinalizeMethod(klass);
            int dim = 0;
            InstanceKey lastInstance = iKey;
            while (klass != null && klass.isArrayClass()) {
                Integer c;
                if ((klass = ((ArrayClass)klass).getElementClass()) == null || !klass.isArrayClass()) continue;
                if (instruction.getNumberOfUses() <= dim + 1) break;
                int sv = instruction.getUse(dim + 1);
                if (this.ir.getSymbolTable().isIntegerConstant(sv) && (c = (Integer)this.ir.getSymbolTable().getConstantValue(sv)) == 0) break;
                InstanceKey ik = this.getInstanceKeyForMultiNewArray(instruction.getNewSite(), dim);
                PointerKey pk = this.getPointerKeyForArrayContents(lastInstance);
                this.system.newConstraint(pk, ik);
                lastInstance = ik;
                ++dim;
            }
        }

        @Override
        public void visitThrow(SSAThrowInstruction instruction) {
        }

        @Override
        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            List<ProgramCounter> peis = SSAPropagationCallGraphBuilder.getIncomingPEIs(this.ir, this.getBasicBlock());
            PointerKey def = this.getPointerKeyForLocal(instruction.getDef());
            Set<IClass> types = SSAPropagationCallGraphBuilder.getCaughtExceptionTypes(instruction, this.ir);
            this.getBuilder().addExceptionDefConstraints(this.ir, this.du, this.node, peis, def, types);
        }

        private int booleanConstantTest(SSAConditionalBranchInstruction c, int v) {
            int result = 0;
            if (this.symbolTable.isZeroOrFalse(c.getUse(0)) && c.getUse(1) == v || this.symbolTable.isZeroOrFalse(c.getUse(1)) && c.getUse(0) == v) {
                result = -1;
            } else if (this.symbolTable.isOneOrTrue(c.getUse(0)) && c.getUse(1) == v || this.symbolTable.isOneOrTrue(c.getUse(1)) && c.getUse(0) == v) {
                result = 1;
            }
            if (c.getOperator() == IConditionalBranchInstruction.Operator.NE) {
                result = -result;
            }
            return result;
        }

        private int nullConstantTest(SSAConditionalBranchInstruction c, int v) {
            if (this.symbolTable.isNullConstant(c.getUse(0)) && c.getUse(1) == v || this.symbolTable.isNullConstant(c.getUse(1)) && c.getUse(0) == v) {
                if (c.getOperator() == IConditionalBranchInstruction.Operator.EQ) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        @Override
        public void visitPhi(SSAPhiInstruction instruction) {
            if (this.ir.getMethod() instanceof AbstractRootMethod) {
                PointerKey dst = this.getPointerKeyForLocal(instruction.getDef());
                if (this.hasNoInterestingUses(instruction.getDef())) {
                    this.system.recordImplicitPointsToSet(dst);
                } else {
                    for (int i = 0; i < instruction.getNumberOfUses(); ++i) {
                        PointerKey use = this.getPointerKeyForLocal(instruction.getUse(i));
                        if (this.contentsAreInvariant(this.symbolTable, this.du, instruction.getUse(i))) {
                            this.system.recordImplicitPointsToSet(use);
                            InstanceKey[] ik = this.getInvariantContents(instruction.getUse(i));
                            for (int j = 0; j < ik.length; ++j) {
                                this.system.newConstraint(dst, ik[j]);
                            }
                            continue;
                        }
                        this.system.newConstraint(dst, PropagationCallGraphBuilder.assignOperator, use);
                    }
                }
            }
        }

        @Override
        public void visitPi(SSAPiInstruction instruction) {
            if (this.hasNoInterestingUses(instruction.getDef())) {
                PointerKey dst = this.getPointerKeyForLocal(instruction.getDef());
                this.system.recordImplicitPointsToSet(dst);
            } else {
                SSACFG cfg = this.ir.getControlFlowGraph();
                int val = instruction.getVal();
                if (Util.endsWithConditionalBranch(cfg, this.getBasicBlock()) && cfg.getSuccNodeCount(this.getBasicBlock()) == 2) {
                    SSAConditionalBranchInstruction cond = (SSAConditionalBranchInstruction)Util.getLastInstruction(cfg, this.getBasicBlock());
                    SSAInstruction cause = instruction.getCause();
                    SSACFG.BasicBlock target = (SSACFG.BasicBlock)cfg.getNode(instruction.getSuccessor());
                    if (cause instanceof SSAInstanceofInstruction) {
                        int direction = this.booleanConstantTest(cond, cause.getDef());
                        if (direction != 0) {
                            TypeReference type = ((SSAInstanceofInstruction)cause).getCheckedType();
                            IClass cls = this.getClassHierarchy().lookupClass(type);
                            if (cls == null) {
                                PointerKey dst = this.getPointerKeyForLocal(instruction.getDef());
                                this.addPiAssignment(dst, val);
                            } else {
                                FilteredPointerKey dst = this.getFilteredPointerKeyForLocal(instruction.getDef(), new FilteredPointerKey.SingleClassFilter(cls));
                                boolean useFilter = target == Util.getTakenSuccessor(cfg, this.getBasicBlock()) && direction == 1 || target == Util.getNotTakenSuccessor(cfg, this.getBasicBlock()) && direction == -1;
                                PointerKey src = this.getPointerKeyForLocal(val);
                                if (this.contentsAreInvariant(this.symbolTable, this.du, val)) {
                                    this.system.recordImplicitPointsToSet(src);
                                    InstanceKey[] ik = this.getInvariantContents(val);
                                    for (int j = 0; j < ik.length; ++j) {
                                        boolean assignable = this.getClassHierarchy().isAssignableFrom(cls, ik[j].getConcreteType());
                                        if ((!assignable || !useFilter) && (assignable || useFilter)) continue;
                                        this.system.newConstraint(dst, ik[j]);
                                    }
                                } else {
                                    PropagationCallGraphBuilder.FilterOperator op = useFilter ? this.getBuilder().filterOperator : this.getBuilder().inverseFilterOperator;
                                    this.system.newConstraint((PointerKey)dst, op, src);
                                }
                            }
                        }
                    } else {
                        int dir = this.nullConstantTest(cond, val);
                        if (dir != 0) {
                            if (target == Util.getTakenSuccessor(cfg, this.getBasicBlock()) && dir == -1 || target == Util.getNotTakenSuccessor(cfg, this.getBasicBlock()) && dir == 1) {
                                PointerKey dst = this.getPointerKeyForLocal(instruction.getDef());
                                this.addPiAssignment(dst, val);
                            }
                        } else {
                            PointerKey dst = this.getPointerKeyForLocal(instruction.getDef());
                            this.addPiAssignment(dst, val);
                        }
                    }
                } else {
                    PointerKey dst = this.getPointerKeyForLocal(instruction.getDef());
                    this.addPiAssignment(dst, val);
                }
            }
        }

        private void addPiAssignment(PointerKey dst, int src) {
            PointerKey srcKey = this.getPointerKeyForLocal(src);
            if (this.contentsAreInvariant(this.symbolTable, this.du, src)) {
                this.system.recordImplicitPointsToSet(srcKey);
                InstanceKey[] ik = this.getInvariantContents(src);
                for (int j = 0; j < ik.length; ++j) {
                    this.system.newConstraint(dst, ik[j]);
                }
            } else {
                this.system.newConstraint(dst, PropagationCallGraphBuilder.assignOperator, srcKey);
            }
        }

        public ISSABasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public void setBasicBlock(ISSABasicBlock block) {
            this.basicBlock = block;
        }

        @Override
        public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
            IClass klass;
            PointerKey def = this.getPointerKeyForLocal(instruction.getDef());
            InstanceKey iKey = this.getInstanceKeyForClassObject(instruction.getToken(), instruction.getType());
            if (instruction.getToken() instanceof TypeReference && (klass = this.getClassHierarchy().lookupClass((TypeReference)instruction.getToken())) != null) {
                this.processClassInitializer(klass);
            }
            if (!this.contentsAreInvariant(this.symbolTable, this.du, instruction.getDef())) {
                this.system.newConstraint(def, iKey);
            } else {
                this.system.findOrCreateIndexForInstanceKey(iKey);
                this.system.recordImplicitPointsToSet(def);
            }
        }

        private void processFinalizeMethod(final IClass klass) {
            if (!this.getBuilder().finalizeVisited.contains(klass)) {
                this.getBuilder().finalizeVisited.add(klass);
                IMethod finalizer = klass.getMethod(MethodReference.finalizeSelector);
                if (finalizer != null && !finalizer.getDeclaringClass().getReference().equals(TypeReference.JavaLangObject)) {
                    DefaultEntrypoint ef = new DefaultEntrypoint(finalizer, this.getClassHierarchy()){

                        @Override
                        protected TypeReference[] makeParameterTypes(IMethod method, int i) {
                            if (i == 0) {
                                return new TypeReference[]{klass.getReference()};
                            }
                            return super.makeParameterTypes(method, i);
                        }
                    };
                    ef.addCall((AbstractRootMethod)this.callGraph.getFakeRootNode().getMethod());
                    this.getBuilder().markChanged(this.callGraph.getFakeRootNode());
                }
            }
        }

        protected void processClassInitializer(IClass klass) {
            IClass sc;
            assert (klass != null);
            if (!this.getBuilder().getOptions().getHandleStaticInit()) {
                return;
            }
            if (this.getBuilder().clinitVisited.contains(klass)) {
                return;
            }
            this.getBuilder().clinitVisited.add(klass);
            if (klass.getClassInitializer() != null) {
                CGNode target;
                MethodReference m = klass.getClassInitializer().getReference();
                CallSiteReference site = CallSiteReference.make(1, m, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
                IMethod targetMethod = this.getOptions().getMethodTargetSelector().getCalleeTarget(this.callGraph.getFakeRootNode(), site, null);
                if (targetMethod != null && (target = this.getTargetForCall(this.callGraph.getFakeRootNode(), site, null, null)) != null && this.callGraph.getPredNodeCount(target) == 0) {
                    AbstractRootMethod fakeWorldClinitMethod = (AbstractRootMethod)this.callGraph.getFakeWorldClinitNode().getMethod();
                    SSAInvokeInstruction s = fakeWorldClinitMethod.addInvocation(new int[0], site);
                    PointerKey uniqueCatch = this.getBuilder().getPointerKeyForExceptionalReturnValue(this.callGraph.getFakeRootNode());
                    this.getBuilder().processResolvedCall(this.callGraph.getFakeWorldClinitNode(), s, target, null, uniqueCatch);
                }
            }
            if ((sc = klass.getSuperclass()) != null) {
                this.processClassInitializer(sc);
            }
        }

        public class DefaultInvariantComputer
        implements InvariantComputer {
            @Override
            public InstanceKey[][] computeInvariantParameters(SSAAbstractInvokeInstruction call) {
                InstanceKey[][] constParams = null;
                for (int i = 0; i < call.getNumberOfUses(); ++i) {
                    if (call.getUse(i) <= 0 || !ConstraintVisitor.this.contentsAreInvariant(ConstraintVisitor.this.symbolTable, ConstraintVisitor.this.du, call.getUse(i))) continue;
                    ConstraintVisitor.this.system.recordImplicitPointsToSet(ConstraintVisitor.this.getPointerKeyForLocal(call.getUse(i)));
                    if (constParams == null) {
                        constParams = new InstanceKey[call.getNumberOfUses()][];
                    }
                    constParams[i] = ConstraintVisitor.this.getInvariantContents(call.getUse(i));
                    for (int j = 0; j < constParams[i].length; ++j) {
                        ConstraintVisitor.this.system.findOrCreateIndexForInstanceKey(constParams[i][j]);
                    }
                }
                return constParams;
            }
        }

        protected static interface InvariantComputer {
            public InstanceKey[][] computeInvariantParameters(SSAAbstractInvokeInstruction var1);
        }
    }
}

