/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.types;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MemberReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.shrike.ShrikeUtil;
import com.ibm.wala.util.strings.Atom;
import java.util.HashMap;

public final class MethodReference
extends MemberReference {
    private static final HashMap<Key, MethodReference> dictionary = HashMapFactory.make();
    public static final Atom newInstanceAtom = Atom.findOrCreateUnicodeAtom("newInstance");
    private static final Descriptor newInstanceDesc = Descriptor.findOrCreateUTF8(Language.JAVA, "()Ljava/lang/Object;");
    public static final MethodReference JavaLangClassNewInstance = MethodReference.findOrCreate(TypeReference.JavaLangClass, newInstanceAtom, newInstanceDesc);
    private static final Atom ctorNewInstanceAtom = Atom.findOrCreateUnicodeAtom("newInstance");
    private static final Descriptor ctorNewInstanceDesc = Descriptor.findOrCreateUTF8(Language.JAVA, "([Ljava/lang/Object;)Ljava/lang/Object;");
    public static final MemberReference JavaLangReflectCtorNewInstance = MethodReference.findOrCreate(TypeReference.JavaLangReflectConstructor, ctorNewInstanceAtom, ctorNewInstanceDesc);
    public static final Atom forNameAtom = Atom.findOrCreateUnicodeAtom("forName");
    private static final Descriptor forNameDesc = Descriptor.findOrCreateUTF8(Language.JAVA, "(Ljava/lang/String;)Ljava/lang/Class;");
    public static final MethodReference JavaLangClassForName = MethodReference.findOrCreate(TypeReference.JavaLangClass, forNameAtom, forNameDesc);
    public static final Atom initAtom = Atom.findOrCreateUnicodeAtom("<init>");
    public static final Descriptor defaultInitDesc = Descriptor.findOrCreateUTF8(Language.JAVA, "()V");
    public static final Selector initSelector = new Selector(initAtom, defaultInitDesc);
    public static final Atom clinitName = Atom.findOrCreateUnicodeAtom("<clinit>");
    public static final Selector clinitSelector = new Selector(clinitName, defaultInitDesc);
    public static final Atom finalizeName = Atom.findOrCreateUnicodeAtom("finalize");
    public static final Selector finalizeSelector = new Selector(finalizeName, defaultInitDesc);
    public static final Atom runAtom = Atom.findOrCreateUnicodeAtom("run");
    public static final Descriptor runDesc = Descriptor.findOrCreateUTF8(Language.JAVA, "()Ljava/lang/Object;");
    public static final Selector runSelector = new Selector(runAtom, runDesc);
    public static final Atom equalsAtom = Atom.findOrCreateUnicodeAtom("equals");
    public static final Descriptor equalsDesc = Descriptor.findOrCreateUTF8(Language.JAVA, "(Ljava/lang/Object;)Z");
    public static final Selector equalsSelector = new Selector(equalsAtom, equalsDesc);
    public static final MethodReference lambdaMetafactory = MethodReference.findOrCreate(TypeReference.LambdaMetaFactory, Atom.findOrCreateUnicodeAtom("metafactory"), Descriptor.findOrCreateUTF8("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;"));
    private final TypeReference[] parameterTypes;
    private final TypeReference returnType;
    private final Selector selector;

    public static synchronized MethodReference findOrCreate(TypeReference tref, Atom mn, Descriptor md) {
        if (tref == null) {
            throw new IllegalArgumentException("null tref");
        }
        Key key = new Key(tref, mn, md);
        MethodReference val = dictionary.get(key);
        if (val != null) {
            return val;
        }
        val = new MethodReference(key);
        dictionary.put(key, val);
        return val;
    }

    public static synchronized MethodReference findOrCreate(TypeReference tref, Selector selector) {
        if (selector == null) {
            throw new IllegalArgumentException("selector is null");
        }
        return MethodReference.findOrCreate(tref, selector.getName(), selector.getDescriptor());
    }

    public static MethodReference findOrCreate(TypeReference t, String methodName, String descriptor) throws IllegalArgumentException {
        return MethodReference.findOrCreate(Language.JAVA, t, methodName, descriptor);
    }

    public static MethodReference findOrCreate(Language l, TypeReference t, String methodName, String descriptor) throws IllegalArgumentException {
        Descriptor d = Descriptor.findOrCreateUTF8(l, descriptor);
        return MethodReference.findOrCreate(t, Atom.findOrCreateUnicodeAtom(methodName), d);
    }

    public static MethodReference findOrCreate(ClassLoaderReference loader, String methodClass, String methodName, String methodSignature) throws IllegalArgumentException {
        return MethodReference.findOrCreate(Language.JAVA, loader, methodClass, methodName, methodSignature);
    }

    public static MethodReference findOrCreate(Language l, ClassLoaderReference loader, String methodClass, String methodName, String methodSignature) throws IllegalArgumentException {
        TypeReference t = ShrikeUtil.makeTypeReference(loader, methodClass);
        Atom name = Atom.findOrCreateUnicodeAtom(methodName);
        Descriptor d = Descriptor.findOrCreateUTF8(l, methodSignature);
        return MethodReference.findOrCreate(t, name, d);
    }

    public final Descriptor getDescriptor() {
        return this.selector.getDescriptor();
    }

    public final String toString() {
        return "< " + this.getDeclaringClass().getClassLoader().getName() + ", " + this.getDeclaringClass().getName() + ", " + this.selector + " >";
    }

    MethodReference(Key key) {
        super(key.type, key.name, key.hashCode());
        this.selector = new Selector(key.name, key.descriptor);
        TypeName[] parameterNames = key.descriptor.getParameters();
        this.parameterTypes = parameterNames != null ? new TypeReference[parameterNames.length] : null;
        ClassLoaderReference loader = this.getDeclaringClass().getClassLoader();
        if (parameterNames != null) {
            for (int i = 0; i < parameterNames.length; ++i) {
                this.parameterTypes[i] = TypeReference.findOrCreate(loader, parameterNames[i]);
            }
        }
        TypeName r = key.descriptor.getReturnType();
        this.returnType = TypeReference.findOrCreate(this.getDeclaringClass().getClassLoader(), r);
    }

    public final TypeReference getReturnType() {
        return this.returnType;
    }

    public final TypeReference getParameterType(int i) throws IllegalArgumentException {
        if (this.parameterTypes == null || i >= this.parameterTypes.length) {
            throw new IllegalArgumentException("illegal parameter number " + i + " for " + this);
        }
        return this.parameterTypes[i];
    }

    public boolean isInit() {
        return this.getName().equals(initAtom);
    }

    @Override
    public String getSignature() {
        String s = this.getDeclaringClass().getName().toString().substring(1).replace('/', '.') + "." + this.getName() + this.getDescriptor();
        return s;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public int getNumberOfParameters() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    protected static class Key {
        private final TypeReference type;
        private final Atom name;
        private final Descriptor descriptor;

        Key(TypeReference type, Atom name, Descriptor descriptor) {
            this.type = type;
            this.name = name;
            this.descriptor = descriptor;
        }

        public final int hashCode() {
            return 7001 * this.type.hashCode() + 7013 * this.name.hashCode() + this.descriptor.hashCode();
        }

        public final boolean equals(Object other) {
            assert (other != null && this.getClass().equals(other.getClass()));
            Key that = (Key)other;
            return this.type.equals(that.type) && this.name.equals(that.name) && this.descriptor.equals(that.descriptor);
        }
    }
}

