/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.ssa.ParameterAccessor;
import com.ibm.wala.util.ssa.SSAValue;
import com.ibm.wala.util.strings.Atom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SSAValueManager {
    private static final boolean DEBUG = false;
    private final boolean AUTOMAKE_NAMES = true;
    private int nextLocal;
    private int currentScope = 0;
    private String description;
    private MethodReference forMethod;
    public String breadCrumb = "";
    private Map<SSAValue.VariableKey, List<Managed<? extends SSAValue>>> seenTypes = HashMapFactory.make();
    private List<SSAValue> unmanaged = new ArrayList<SSAValue>();

    public SSAValueManager(ParameterAccessor acc) {
        this.nextLocal = acc.getFirstAfter();
        this.description = " based on ParameterAccessor " + acc;
        this.forMethod = acc.forMethod();
        for (SSAValue sSAValue : acc.all()) {
            this.setAllocation(sSAValue, null);
        }
    }

    public void setAllocation(SSAValue value, SSAInstruction setBy) {
        if (value == null) {
            throw new IllegalArgumentException("The SSA-Variable may not be null");
        }
        if (this.seenTypes.containsKey(value.key)) {
            for (Managed<? extends SSAValue> param : this.seenTypes.get(value.key)) {
                if (param.status != ValueStatus.UNALLOCATED) continue;
                assert (((SSAValue)param.value).getType().equals(value.getType())) : "Inequal types";
                if (((SSAValue)param.value).getNumber() + 1 > this.nextLocal) {
                    this.nextLocal = ((SSAValue)param.value).getNumber() + 1;
                }
                SSAValueManager.debug("reSetting SSA {} to allocated", value);
                param.status = ValueStatus.ALLOCATED;
                param.setInScope = this.currentScope;
                param.setBy = setBy;
                return;
            }
            System.out.println("Keys for " + value + ":");
            for (Managed<? extends SSAValue> param : this.seenTypes.get(value.key)) {
                System.out.println("\tKey " + param.key + "\t=>" + (Object)((Object)param.status));
            }
            throw new IllegalStateException("The parameter " + value + " using Key " + value.key + " has already been allocated");
        }
        SSAValueManager.info("New variable in management: {}", value);
        Managed<SSAValue> param = new Managed<SSAValue>(value, value.key);
        param.status = ValueStatus.ALLOCATED;
        param.setInScope = this.currentScope;
        param.setBy = setBy;
        ArrayList<Managed<SSAValue>> aParam = new ArrayList<Managed<SSAValue>>();
        aParam.add(param);
        this.seenTypes.put(value.key, aParam);
    }

    public void setPhi(SSAValue value, SSAInstruction setBy) {
        if (value == null) {
            throw new IllegalArgumentException("The SSA-Variable may not be null.");
        }
        boolean didPhi = false;
        if (this.seenTypes.containsKey(value.key)) {
            for (Managed<? extends SSAValue> param : this.seenTypes.get(value.key)) {
                if (param.status == ValueStatus.FREE || param.status == ValueStatus.FREE_INVALIDATED || param.status == ValueStatus.FREE_CLOSED) {
                    assert (((SSAValue)param.value).getType().equals(value.getType())) : "Unequal types";
                    if (((SSAValue)param.value).getNumber() != value.getNumber()) {
                        if (param.status != ValueStatus.FREE || param.setInScope != this.currentScope) continue;
                        param.status = ValueStatus.FREE_CLOSED;
                        continue;
                    }
                    if (param.status == ValueStatus.FREE) {
                        param.status = ValueStatus.ALLOCATED;
                    } else if (param.status == ValueStatus.FREE_INVALIDATED) {
                        param.status = ValueStatus.INVALIDATED;
                    } else if (param.status == ValueStatus.FREE_CLOSED) {
                        param.status = ValueStatus.CLOSED;
                    }
                    param.setInScope = this.currentScope;
                    param.setBy = setBy;
                    SSAValueManager.info("Setting SSA {} to phi! now {}", new Object[]{value, param.status});
                    didPhi = true;
                    continue;
                }
                if (param.setInScope == this.currentScope) {
                    if (param.status == ValueStatus.INVALIDATED) {
                        SSAValueManager.info("Closing SSA Value {} in scope {}", param.value, param.setInScope);
                        param.status = ValueStatus.CLOSED;
                        continue;
                    }
                    if (param.status != ValueStatus.FREE_INVALIDATED) continue;
                    SSAValueManager.info("Closing free SSA Value {} in scope {}", param.value, param.setInScope);
                    param.status = ValueStatus.FREE_CLOSED;
                    continue;
                }
                if (param.setInScope >= this.currentScope) continue;
            }
            assert (didPhi);
            return;
        }
        throw new IllegalStateException("This should not be reached!");
    }

    public SSAValue getFree(TypeReference type, SSAValue.VariableKey key) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("The argument key may not be null");
        }
        SSAValue var = new SSAValue(this.nextLocal++, type, this.forMethod, key);
        Managed<SSAValue> param = new Managed<SSAValue>(var, key);
        param.status = ValueStatus.FREE;
        param.setInScope = this.currentScope;
        if (this.seenTypes.containsKey(key)) {
            this.seenTypes.get(key).add(param);
        } else {
            ArrayList<Managed<SSAValue>> aParam = new ArrayList<Managed<SSAValue>>();
            aParam.add(param);
            this.seenTypes.put(key, aParam);
        }
        SSAValueManager.debug("Returning as Free SSA: {}", param);
        return var;
    }

    public SSAValue getUnallocated(TypeReference type, SSAValue.VariableKey key) {
        if (type == null) {
            throw new IllegalArgumentException("The argument type may not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("The argument key may not be null");
        }
        if (this.seenTypes.containsKey(key)) {
            for (Managed<? extends SSAValue> p : this.seenTypes.get(key)) {
                if (p.status != ValueStatus.UNALLOCATED) continue;
                throw new IllegalStateException("There may be only one unallocated instance to a kay (" + key + ") at a time");
            }
        }
        SSAValue var = new SSAValue(this.nextLocal++, type, this.forMethod, key);
        Managed<SSAValue> param = new Managed<SSAValue>(var, key);
        param.status = ValueStatus.UNALLOCATED;
        param.setInScope = this.currentScope;
        if (this.seenTypes.containsKey(key)) {
            this.seenTypes.get(key).add(param);
        } else {
            ArrayList<Managed<SSAValue>> aParam = new ArrayList<Managed<SSAValue>>();
            aParam.add(param);
            this.seenTypes.put(key, aParam);
        }
        SSAValueManager.debug("Returning as Unallocated SSA: {}", param);
        return var;
    }

    public SSAValue getUnmanaged(TypeReference type, SSAValue.VariableKey key) {
        SSAValue var = new SSAValue(this.nextLocal++, type, this.forMethod, key);
        this.unmanaged.add(var);
        return var;
    }

    public SSAValue getUnmanaged(TypeReference type, String name) {
        return this.getUnmanaged(type, new SSAValue.NamedKey(type.getName(), name));
    }

    public SSAValue getCurrent(SSAValue.VariableKey key) {
        if (key == null) {
            throw new IllegalArgumentException("The argument key may not be null");
        }
        Managed<? extends SSAValue> candidate = null;
        if (this.seenTypes.containsKey(key)) {
            for (Managed<? extends SSAValue> param : this.seenTypes.get(key)) {
                if (param.status == ValueStatus.FREE || param.status == ValueStatus.ALLOCATED) {
                    if (param.setInScope > this.currentScope) {
                        SSAValueManager.debug("SSA Value {} is out of scope {}", param, this.currentScope);
                        continue;
                    }
                    if (param.setInScope == this.currentScope) {
                        SSAValueManager.debug("Returning SSA Value {} is {}", new Object[]{param.value, param.status});
                        return param.value;
                    }
                    if (candidate != null && param.setInScope <= candidate.setInScope) continue;
                    candidate = param;
                    continue;
                }
                SSAValueManager.debug("SSA Value {} is {}", new Object[]{param, param.status});
            }
        } else {
            throw new IllegalArgumentException("Key " + key + " has never been seen before! Known keys are " + this.seenTypes.keySet());
        }
        if (candidate != null) {
            SSAValueManager.debug("Returning inherited (from {}) SSA Value {}", candidate.setInScope, candidate);
            return candidate.value;
        }
        throw new IllegalStateException("No suitable candidate has been found for Key " + key);
    }

    public SSAValue getSuper(SSAValue.VariableKey key) {
        if (key == null) {
            throw new IllegalArgumentException("The argument key may not be null");
        }
        --this.currentScope;
        assert (this.currentScope >= 0);
        SSAValue cand = this.getCurrent(key);
        ++this.currentScope;
        return cand;
    }

    public List<SSAValue> getAllForPhi(SSAValue.VariableKey key) {
        if (key == null) {
            throw new IllegalArgumentException("The argument key may not be null");
        }
        ArrayList<SSAValue> ret = new ArrayList<SSAValue>();
        if (this.seenTypes.containsKey(key)) {
            for (Managed<? extends SSAValue> param : this.seenTypes.get(key)) {
                if (param.status == ValueStatus.FREE || param.status == ValueStatus.ALLOCATED) {
                    ret.add((SSAValue)param.value);
                    continue;
                }
                if (param.status != ValueStatus.INVALIDATED || param.setInScope <= this.currentScope) continue;
                ret.add((SSAValue)param.value);
            }
        } else {
            throw new IllegalArgumentException("Key " + key + " has never been seen before!");
        }
        return ret;
    }

    public boolean isSeen(SSAValue.VariableKey key, boolean withSuper) {
        if (key == null) {
            throw new IllegalArgumentException("The argument key may not be null");
        }
        if (withSuper) {
            return this.seenTypes.containsKey(key);
        }
        if (this.seenTypes.containsKey(key)) {
            // empty if block
        }
        return false;
    }

    public boolean isSeen(SSAValue.VariableKey key) {
        return this.isSeen(key, true);
    }

    public boolean needsAllocation(SSAValue.VariableKey key) {
        if (key == null) {
            throw new IllegalArgumentException("The argument key may not be null");
        }
        if (this.seenTypes.containsKey(key)) {
            if (this.seenTypes.get(key).size() > 1) {
                return false;
            }
            return this.seenTypes.get((Object)key).get((int)0).status == ValueStatus.UNALLOCATED;
        }
        return true;
    }

    public boolean needsPhi(SSAValue.VariableKey key) {
        if (key == null) {
            throw new IllegalArgumentException("The argument key may not be null");
        }
        boolean seenLive = false;
        if (this.seenTypes.containsKey(key)) {
            for (Managed<? extends SSAValue> param : this.seenTypes.get(key)) {
                if (param.status == ValueStatus.FREE) {
                    return true;
                }
                if (param.status != ValueStatus.ALLOCATED) continue;
                if (seenLive) {
                    return true;
                }
                seenLive = true;
            }
        } else {
            throw new IllegalArgumentException("Key " + key + " has never been seen before!");
        }
        throw new IllegalStateException("No suitable candidate has been found");
    }

    public void invalidate(SSAValue.VariableKey key) {
        if (key == null) {
            throw new IllegalArgumentException("The argument key may not be null");
        }
        if (this.seenTypes.containsKey(key)) {
            for (Managed<? extends SSAValue> param : this.seenTypes.get(key)) {
                if (param.status == ValueStatus.CLOSED || param.status == ValueStatus.FREE_CLOSED || param.status == ValueStatus.FREE_INVALIDATED || param.status == ValueStatus.INVALIDATED || param.setInScope != this.currentScope) continue;
                param.status = param.status == ValueStatus.FREE ? ValueStatus.FREE_INVALIDATED : ValueStatus.INVALIDATED;
                SSAValueManager.info("Invalidated SSA {} for key {}", param, key);
            }
        }
    }

    public int scopeDown(boolean doesLoop) {
        ++this.currentScope;
        return this.currentScope;
    }

    public int scopeUp() {
        for (List<Managed<? extends SSAValue>> plist : this.seenTypes.values()) {
            for (Managed<? extends SSAValue> param : plist) {
                if (param.setInScope == this.currentScope) {
                    this.invalidate(((SSAValue)param.value).key);
                    continue;
                }
                if (param.setInScope <= this.currentScope || param.status == ValueStatus.INVALIDATED || param.status == ValueStatus.CLOSED) continue;
                throw new IllegalStateException("A parameter was in wrong status when leaving a sub-subordinate scope: " + param + " should have been invalidated or closed by an other scope.");
            }
        }
        --this.currentScope;
        return this.currentScope;
    }

    public String toString() {
        return "<AndroidModelParameterManager " + this.description + ">";
    }

    public SSAValue getException() {
        SSAValue exc = new SSAValue(this.nextLocal++, TypeReference.JavaLangException, this.forMethod, "exception_" + this.nextLocal);
        this.unmanaged.add(exc);
        return exc;
    }

    public Map<Integer, Atom> makeLocalNames() {
        HashMap<Integer, Atom> names = new HashMap<Integer, Atom>();
        HashMap<SSAValue.VariableKey, Integer> suffix = new HashMap<SSAValue.VariableKey, Integer>();
        int currentSuffix = 0;
        for (List<Managed<? extends SSAValue>> manageds : this.seenTypes.values()) {
            for (Managed<? extends SSAValue> managed : manageds) {
                int mySuffix;
                Object val = managed.value;
                String name = ((SSAValue)val).getVariableName();
                if (name != null) {
                    Atom nameAtom = Atom.findOrCreateAsciiAtom(name);
                    names.put(((SSAValue)val).getNumber(), nameAtom);
                    continue;
                }
                String autoName = ((SSAValue)val).getType().getName().toString();
                if (autoName.contains("/")) {
                    autoName = autoName.substring(autoName.lastIndexOf("/") + 1);
                }
                if (autoName.contains("$")) {
                    autoName = autoName.substring(autoName.lastIndexOf("$") + 1);
                }
                autoName = autoName.replace("[", "Ar");
                if (suffix.containsKey(((SSAValue)val).key)) {
                    mySuffix = (Integer)suffix.get(((SSAValue)val).key);
                } else {
                    mySuffix = currentSuffix++;
                    suffix.put(((SSAValue)val).key, mySuffix);
                }
                autoName = "m" + autoName + "_" + mySuffix;
                Atom nameAtom = Atom.findOrCreateAsciiAtom(autoName);
                names.put(((SSAValue)val).getNumber(), nameAtom);
            }
        }
        for (SSAValue val : this.unmanaged) {
            int mySuffix;
            String name = val.getVariableName();
            if (name != null) {
                Atom nameAtom = Atom.findOrCreateAsciiAtom(name);
                names.put(val.getNumber(), nameAtom);
                continue;
            }
            String autoName = val.getType().getName().toString();
            if (autoName.contains("/")) {
                autoName = autoName.substring(autoName.lastIndexOf("/") + 1);
            }
            if (autoName.contains("$")) {
                autoName = autoName.substring(autoName.lastIndexOf("$") + 1);
            }
            autoName = autoName.replace("[", "Ar");
            if (suffix.containsKey(val.key)) {
                mySuffix = (Integer)suffix.get(val.key);
            } else {
                mySuffix = currentSuffix++;
                suffix.put(val.key, mySuffix);
            }
            autoName = "m" + autoName + "_" + mySuffix;
            Atom nameAtom = Atom.findOrCreateAsciiAtom(autoName);
            names.put(val.getNumber(), nameAtom);
        }
        return names;
    }

    private static void debug(String s, Object ... args) {
    }

    private static void info(String s, Object ... args) {
    }

    private static class Managed<T extends SSAValue> {
        public ValueStatus status = ValueStatus.UNUSED;
        public SSAInstruction setBy = null;
        public int setInScope = -1;
        public final SSAValue.VariableKey key;
        public final T value;

        public Managed(T value, SSAValue.VariableKey key) {
            this.value = value;
            this.key = key;
        }

        public String toString() {
            return "<Managed " + this.value + " key=\"" + this.key + "\" status=\"" + (Object)((Object)this.status) + " setIn=\"" + this.setInScope + "\" setBy=\"" + this.setBy + "\" />";
        }
    }

    private static enum ValueStatus {
        UNUSED,
        UNALLOCATED,
        ALLOCATED,
        FREE,
        INVALIDATED,
        CLOSED,
        FREE_INVALIDATED,
        FREE_CLOSED;

    }
}

