/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.strings;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class StringStuff {
    private static final HashMap<String, String> primitiveClassNames = HashMapFactory.make((int)10);

    public static void padWithSpaces(StringBuffer b, int length) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.length() < length) {
            for (int i = b.length(); i < length; ++i) {
                b.append(" ");
            }
        }
    }

    public static String deployment2CanonicalTypeString(String dString) {
        if (dString == null) {
            throw new IllegalArgumentException("dString is null");
        }
        int arrayIndex = (dString = dString.replace('.', '/')).indexOf("[]");
        if (arrayIndex > -1) {
            String baseType = dString.substring(0, arrayIndex);
            int dim = (dString.length() - arrayIndex) / 2;
            baseType = StringStuff.deployment2CanonicalTypeString(baseType);
            StringBuffer result = new StringBuffer("[");
            for (int i = 1; i < dim; ++i) {
                result.append("[");
            }
            result.append(baseType);
            return result.toString();
        }
        if (primitiveClassNames.get(dString) != null) {
            return primitiveClassNames.get(dString);
        }
        return "L" + dString;
    }

    public static String deployment2CanonicalDescriptorTypeString(String dString) {
        if (dString == null) {
            throw new IllegalArgumentException("dString is null");
        }
        int arrayIndex = (dString = dString.replace('.', '/')).indexOf("[]");
        if (arrayIndex > -1) {
            String baseType = dString.substring(0, arrayIndex);
            int dim = (dString.length() - arrayIndex) / 2;
            baseType = StringStuff.deployment2CanonicalDescriptorTypeString(baseType);
            StringBuffer result = new StringBuffer("[");
            for (int i = 1; i < dim; ++i) {
                result.append("[");
            }
            result.append(baseType);
            return result.toString();
        }
        if (primitiveClassNames.get(dString) != null) {
            return primitiveClassNames.get(dString);
        }
        return "L" + dString + ";";
    }

    public static final TypeName parseForReturnTypeName(String desc) throws IllegalArgumentException {
        return StringStuff.parseForReturnTypeName((Language)Language.JAVA, ImmutableByteArray.make(desc));
    }

    public static final TypeName parseForReturnTypeName(Language l, String desc) throws IllegalArgumentException {
        return StringStuff.parseForReturnTypeName(l, ImmutableByteArray.make(desc));
    }

    public static final TypeName parseForReturnTypeName(Language l, ImmutableByteArray b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.length() <= 2) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        if (b.get(0) != 40) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        int i = 0;
        while (b.get(i++) != 41) {
        }
        if (b.length() < i + 1) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        switch (b.get(i)) {
            case 86: {
                return TypeReference.Void.getName();
            }
            case 90: {
                return TypeReference.Boolean.getName();
            }
            case 66: {
                return TypeReference.Byte.getName();
            }
            case 83: {
                return TypeReference.Short.getName();
            }
            case 73: {
                return TypeReference.Int.getName();
            }
            case 74: {
                return TypeReference.Long.getName();
            }
            case 70: {
                return TypeReference.Float.getName();
            }
            case 68: {
                return TypeReference.Double.getName();
            }
            case 67: {
                return TypeReference.Char.getName();
            }
            case 80: {
                if (b.get(b.length() - 1) == 59) {
                    return l.lookupPrimitiveType(new String(b.substring(i + 1, b.length() - i - 2)));
                }
                return l.lookupPrimitiveType(new String(b.substring(i + 1, b.length() - i - 1)));
            }
            case 38: 
            case 42: 
            case 76: 
            case 91: {
                if (b.get(b.length() - 1) == 59) {
                    return TypeName.findOrCreate(b, i, b.length() - i - 1);
                }
                return TypeName.findOrCreate(b, i, b.length() - i);
            }
        }
        throw new IllegalArgumentException("unexpected type in descriptor " + b);
    }

    public static final TypeName[] parseForParameterNames(String descriptor) throws IllegalArgumentException {
        return StringStuff.parseForParameterNames((Language)Language.JAVA, ImmutableByteArray.make(descriptor));
    }

    public static final TypeName[] parseForParameterNames(Language l, String descriptor) throws IllegalArgumentException {
        return StringStuff.parseForParameterNames(l, ImmutableByteArray.make(descriptor));
    }

    public static final TypeName[] parseForParameterNames(Language l, ImmutableByteArray b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (b.length() <= 2) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        if (b.get(0) != 40) {
            throw new IllegalArgumentException("invalid descriptor: " + b);
        }
        ArrayList<TypeName> sigs = new ArrayList<TypeName>(10);
        int i = 1;
        block15: while (true) {
            switch (b.get(i++)) {
                case 86: {
                    sigs.add(TypeReference.VoidName);
                    continue block15;
                }
                case 90: {
                    sigs.add(TypeReference.BooleanName);
                    continue block15;
                }
                case 66: {
                    sigs.add(TypeReference.ByteName);
                    continue block15;
                }
                case 83: {
                    sigs.add(TypeReference.ShortName);
                    continue block15;
                }
                case 73: {
                    sigs.add(TypeReference.IntName);
                    continue block15;
                }
                case 74: {
                    sigs.add(TypeReference.LongName);
                    continue block15;
                }
                case 70: {
                    sigs.add(TypeReference.FloatName);
                    continue block15;
                }
                case 68: {
                    sigs.add(TypeReference.DoubleName);
                    continue block15;
                }
                case 67: {
                    sigs.add(TypeReference.CharName);
                    continue block15;
                }
                case 80: {
                    int off = i - 1;
                    while (b.get(i++) != 59) {
                    }
                    sigs.add(l.lookupPrimitiveType(new String(b.substring(off + 1, i - off - 2))));
                    continue block15;
                }
                case 76: {
                    int off = i - 1;
                    while (b.get(i++) != 59) {
                    }
                    sigs.add(TypeName.findOrCreate(b, off, i - off - 1));
                    continue block15;
                }
                case 38: 
                case 42: 
                case 91: {
                    byte c;
                    int off = i - 1;
                    while (StringStuff.isTypeCodeChar(b, i)) {
                        ++i;
                    }
                    TypeName T = null;
                    if ((c = b.get(i++)) == 76 || c == 80) {
                        while (b.get(i++) != 59) {
                        }
                        T = TypeName.findOrCreate(b, off, i - off - 1);
                    } else {
                        T = TypeName.findOrCreate(b, off, i - off);
                    }
                    sigs.add(T);
                    continue block15;
                }
                case 41: {
                    int size = sigs.size();
                    if (size == 0) {
                        return null;
                    }
                    Iterator it = sigs.iterator();
                    TypeName[] result = new TypeName[size];
                    for (int j = 0; j < size; ++j) {
                        result[j] = (TypeName)it.next();
                    }
                    return result;
                }
            }
            if (!$assertionsDisabled) break;
        }
        throw new AssertionError((Object)("bad descriptor " + b));
    }

    public static boolean isTypeCodeChar(ImmutableByteArray name, int i) {
        return name.b[i] == 91 || name.b[i] == 42 || name.b[i] == 38;
    }

    public static ImmutableByteArray parseForPackage(ImmutableByteArray name, int start, int length) throws IllegalArgumentException {
        try {
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            int lastSlash = -1;
            for (int i = start; i < start + length; ++i) {
                if (name.b[i] != 47) continue;
                lastSlash = i;
            }
            if (lastSlash == -1) {
                return null;
            }
            int dim = 0;
            while (StringStuff.isTypeCodeChar(name, start + dim)) {
                dim = (short)(dim + 1);
            }
            return new ImmutableByteArray(name.b, start + 1 + dim, lastSlash - start - 1 - dim);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid name " + name + " start: " + start + " length: " + length);
        }
    }

    public static ImmutableByteArray parseForPackage(ImmutableByteArray name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return StringStuff.parseForPackage(name, 0, name.length());
    }

    public static ImmutableByteArray parseForClass(ImmutableByteArray name, int start, int length) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("invalid class name: zero length");
        }
        try {
            if (StringStuff.parseForPackage(name, start, length) == null) {
                while (StringStuff.isTypeCodeChar(name, start)) {
                    ++start;
                    --length;
                }
                if (name.b[start] == 76) {
                    ++start;
                    --length;
                }
                return new ImmutableByteArray(name.b, start, length);
            }
            int lastSlash = 0;
            for (int i = start; i < start + length; ++i) {
                if (name.b[i] != 47) continue;
                lastSlash = i;
            }
            int L = length - (lastSlash - start + 1);
            return new ImmutableByteArray(name.b, lastSlash + 1, L);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Malformed name: " + name + " " + start + " " + length);
        }
    }

    public static ImmutableByteArray parseForClass(ImmutableByteArray name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return StringStuff.parseForClass(name, 0, name.length());
    }

    public static int parseForArrayDimensionality(ImmutableByteArray b, int start, int length) throws IllegalArgumentException, IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        try {
            int code = 0;
            block7: for (int i = start; i < start + length && StringStuff.isTypeCodeChar(b, i); ++i) {
                code <<= 3;
                switch (b.b[i]) {
                    case 91: {
                        code |= 1;
                        continue block7;
                    }
                    case 42: {
                        code |= 2;
                        continue block7;
                    }
                    case 38: {
                        code |= 3;
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("ill-formed array descriptor " + b);
                    }
                }
            }
            return code;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("ill-formed array descriptor " + b);
        }
    }

    public static ImmutableByteArray parseForInnermostArrayElementDescriptor(ImmutableByteArray b, int start, int length) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        try {
            int i;
            for (i = start; i < start + length && StringStuff.isTypeCodeChar(b, i); ++i) {
            }
            return new ImmutableByteArray(b.b, i, length - (i - start));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid element desciptor: " + b);
        }
    }

    public static ImmutableByteArray parseForInnermostArrayElementDescriptor(Atom a) {
        if (a == null) {
            throw new IllegalArgumentException("a is null");
        }
        ImmutableByteArray b = new ImmutableByteArray(a.getValArray());
        return StringStuff.parseForInnermostArrayElementDescriptor(b, 0, b.length());
    }

    public static boolean classIsPrimitive(ImmutableByteArray name, int start, int length) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        try {
            while (length > 0 && StringStuff.isTypeCodeChar(name, start)) {
                ++start;
                --length;
            }
            if (start >= name.b.length) {
                throw new IllegalArgumentException("ill-formed type name: " + name);
            }
            return name.b[start] != 76;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(name.toString());
        }
    }

    public static MethodReference makeMethodReference(String methodSig) throws IllegalArgumentException {
        return StringStuff.makeMethodReference(Language.JAVA, methodSig);
    }

    public static MethodReference makeMethodReference(Language l, String methodSig) throws IllegalArgumentException {
        if (methodSig == null) {
            throw new IllegalArgumentException("methodSig is null");
        }
        if (methodSig.lastIndexOf(46) < 0) {
            throw new IllegalArgumentException("ill-formed sig " + methodSig);
        }
        String type = methodSig.substring(0, methodSig.lastIndexOf(46));
        type = StringStuff.deployment2CanonicalTypeString(type);
        TypeReference t = TypeReference.findOrCreate(ClassLoaderReference.Application, type);
        String methodName = methodSig.substring(methodSig.lastIndexOf(46) + 1, methodSig.indexOf(40));
        String desc = methodSig.substring(methodSig.indexOf(40));
        return MethodReference.findOrCreate(l, t, methodName, desc);
    }

    public static String jvmToReadableType(String jvmType) throws IllegalArgumentException {
        if (jvmType == null) {
            throw new IllegalArgumentException("jvmType is null");
        }
        StringBuffer readable = new StringBuffer();
        int numberOfDimensions = 0;
        if (jvmType.length() == 0) {
            throw new IllegalArgumentException("ill-formed type : " + jvmType);
        }
        char prefix = jvmType.charAt(0);
        while (prefix == '[') {
            prefix = jvmType.charAt(++numberOfDimensions);
        }
        if (prefix == 'V') {
            readable.append("void");
        } else if (prefix == 'B') {
            readable.append("byte");
        } else if (prefix == 'C') {
            readable.append("char");
        } else if (prefix == 'D') {
            readable.append("double");
        } else if (prefix == 'F') {
            readable.append("float");
        } else if (prefix == 'I') {
            readable.append("int");
        } else if (prefix == 'J') {
            readable.append("long");
        } else if (prefix == 'S') {
            readable.append("short");
        } else if (prefix == 'Z') {
            readable.append("boolean");
        } else if (prefix == 'L') {
            readable.append(jvmType.substring(numberOfDimensions + 1, jvmType.length()));
            readable = new StringBuffer(StringStuff.slashToDot(readable.toString()));
            readable = new StringBuffer(StringStuff.dollarToDot(readable.toString()));
        }
        for (int i = 0; i < numberOfDimensions; ++i) {
            readable.append("[]");
        }
        return readable.toString();
    }

    public static String jvmToBinaryName(String jvmType) throws IllegalArgumentException {
        if (jvmType == null) {
            throw new IllegalArgumentException("jvmType is null");
        }
        StringBuffer readable = new StringBuffer();
        int numberOfDimensions = 0;
        if (jvmType.length() == 0) {
            throw new IllegalArgumentException("ill-formed type : " + jvmType);
        }
        char prefix = jvmType.charAt(0);
        while (prefix == '[') {
            prefix = jvmType.charAt(++numberOfDimensions);
        }
        if (prefix == 'V') {
            readable.append("void");
        } else if (prefix == 'B') {
            readable.append("byte");
        } else if (prefix == 'C') {
            readable.append("char");
        } else if (prefix == 'D') {
            readable.append("double");
        } else if (prefix == 'F') {
            readable.append("float");
        } else if (prefix == 'I') {
            readable.append("int");
        } else if (prefix == 'J') {
            readable.append("long");
        } else if (prefix == 'S') {
            readable.append("short");
        } else if (prefix == 'Z') {
            readable.append("boolean");
        } else if (prefix == 'L') {
            readable.append(jvmType.substring(numberOfDimensions + 1, jvmType.length()));
            readable = new StringBuffer(StringStuff.slashToDot(readable.toString()));
        }
        for (int i = 0; i < numberOfDimensions; ++i) {
            readable.append("[]");
        }
        return readable.toString();
    }

    public static String slashToDot(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        StringBuffer dotForm = new StringBuffer(path);
        for (int i = 0; i < dotForm.length(); ++i) {
            if (dotForm.charAt(i) != '/') continue;
            dotForm.setCharAt(i, '.');
        }
        return dotForm.toString();
    }

    public static String dollarToDot(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        StringBuffer dotForm = new StringBuffer(path);
        for (int i = 0; i < dotForm.length(); ++i) {
            if (dotForm.charAt(i) != '$') continue;
            dotForm.setCharAt(i, '.');
        }
        return dotForm.toString();
    }

    public static String dotToDollar(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        StringBuffer dotForm = new StringBuffer(path);
        for (int i = 0; i < dotForm.length(); ++i) {
            if (dotForm.charAt(i) != '.') continue;
            dotForm.setCharAt(i, '$');
        }
        return dotForm.toString();
    }

    public static String toBasename(String typeName) {
        int start = 0;
        int stop = typeName.length() - 1;
        if (typeName.contains(".")) {
            start = typeName.lastIndexOf(".");
        } else if (typeName.contains("/")) {
            start = typeName.lastIndexOf("/");
        }
        if (typeName.endsWith(";")) {
            --stop;
        }
        return typeName.substring(start, stop);
    }

    static {
        primitiveClassNames.put("int", "I");
        primitiveClassNames.put("long", "J");
        primitiveClassNames.put("short", "S");
        primitiveClassNames.put("byte", "B");
        primitiveClassNames.put("char", "C");
        primitiveClassNames.put("double", "D");
        primitiveClassNames.put("float", "F");
        primitiveClassNames.put("boolean", "Z");
        primitiveClassNames.put("void", "V");
    }
}

