/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.highlevelapi.synthmethod;

import com.ibm.appscan.frameworks.highlevelapi.Global;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FActionProcessor;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Local;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Taint;
import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.LocalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.TaintExpr;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HighLevelSyntheticMethod {
    private final String vdbSignature;
    private int localCounter = 0;
    private final Collection<Local> declaredLocals = new ArrayList<Local>();
    private final List<Statement> statements = new ArrayList<Statement>();
    private Param returnedValue;
    private static int synthMethodCounter = 0;

    public static HighLevelSyntheticMethod make(String vdbSignature) {
        return new HighLevelSyntheticMethod(vdbSignature);
    }

    public static HighLevelSyntheticMethod make() {
        String methodSig = "AppScan.Synthetic.__highLevelSynth__" + synthMethodCounter + "():void";
        ++synthMethodCounter;
        return HighLevelSyntheticMethod.make(methodSig);
    }

    private HighLevelSyntheticMethod(String vdbSignature) {
        this.vdbSignature = vdbSignature;
    }

    public Local newLocal(String vdbType) {
        Local result = new Local(this.generateLocalName(), vdbType);
        this.declaredLocals.add(result);
        return result;
    }

    public Local newLocal(IClass klass) {
        return this.newLocal(F4FActionProcessor.getVDBTypeName(klass));
    }

    private String generateLocalName() {
        String result = "local" + this.localCounter;
        ++this.localCounter;
        return result;
    }

    public Local addCall(String vdbSig, FilePositionInfo filePositionInfo, Param ... params) {
        this.checkCallValidity(vdbSig, params);
        String vdbReturnType = this.getReturnType(vdbSig);
        Local returnLocal = null;
        if (!vdbReturnType.equals("void") && !vdbReturnType.equals("System.Void")) {
            returnLocal = this.newLocal(vdbReturnType);
        }
        Call call = new Call(vdbSig, params, returnLocal, filePositionInfo);
        this.statements.add(call);
        return returnLocal;
    }

    public Local addCallWithReturnType(String vdbSig, FilePositionInfo filePositionInfo, String returnTypeString, Param ... params) {
        this.checkCallValidity(vdbSig, params);
        String vdbReturnType = this.getReturnType(vdbSig);
        Local returnLocal = null;
        if (!vdbReturnType.equals("void") && !vdbReturnType.equals("System.Void")) {
            returnLocal = this.newLocal(returnTypeString);
        }
        Call call = new Call(vdbSig, params, returnLocal, filePositionInfo);
        this.statements.add(call);
        return returnLocal;
    }

    public Local addCall(IMethod targetMethod, FilePositionInfo filePositionInfo, Param ... params) {
        String vdbSig = F4FActionProcessor.getVDBSig(targetMethod);
        if (vdbSig != null) {
            return this.addCall(vdbSig, filePositionInfo, params);
        }
        TaintLogger.i().getLogger().info((Object)"Inside HighLevelSyntheticMethod#addCall(), vdbSig is null!!  Skipping ");
        return null;
    }

    public void addGlobalWrite(Global global, Local value, FilePositionInfo filePositionInfo) {
        this.statements.add(new GlobalWrite(global, value, filePositionInfo));
    }

    public void addInstanceVariableWrite(Local clazzInstance, IField instanceVariable, Param instanceVariableValue, FilePositionInfo filePositionInfo) {
        this.statements.add(new InstanceFieldWrite(clazzInstance, instanceVariableValue, instanceVariable, filePositionInfo));
    }

    public void addInstanceVariableRead(Param classInstance, IField readFrom, Param writeTo, FilePositionInfo filePositionInfo) {
        if (!(classInstance instanceof Local) && !(classInstance instanceof Global) || !(writeTo instanceof Local) && !(writeTo instanceof Global)) {
            return;
        }
        this.statements.add(new InstanceFieldRead(classInstance, writeTo, readFrom, filePositionInfo));
    }

    public void setReturnedValue(Param returnedValue) {
        if (returnedValue instanceof Taint) {
            throw new IllegalArgumentException("cannot return a value of type Taint");
        }
        this.returnedValue = returnedValue;
    }

    private String getReturnType(String vdbSig) {
        return vdbSig.substring(vdbSig.indexOf(":") + 1);
    }

    private void checkCallValidity(String vdbSig, Param[] params) {
    }

    public String getVdbSignature() {
        return this.vdbSignature;
    }

    public Collection<Local> getDeclaredLocals() {
        return this.declaredLocals;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public Param getReturnedValue() {
        return this.returnedValue;
    }

    public static class InstanceFieldRead
    extends InstanceFieldStatement {
        private final Param clazzInstance;
        private final Param writeTo;
        private final IField readFrom;
        private final FilePositionInfo filePositionInfo;

        public InstanceFieldRead(Param clazzInstance, Param writeTo, IField readFrom, FilePositionInfo filePositionInfo) {
            this.clazzInstance = clazzInstance;
            this.writeTo = writeTo;
            this.readFrom = readFrom;
            this.filePositionInfo = filePositionInfo;
        }

        @Override
        public AssignmentExpr getExpr() {
            String readFromVariableName = this.readFrom.getName().toString();
            ObjectRefExpr leftSideExpr = null;
            ObjectRefExpr rightSideExpr = null;
            if (this.writeTo instanceof Local) {
                leftSideExpr = ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)((Local)this.writeTo).getName()), (String)"");
            } else if (this.writeTo instanceof Global) {
                leftSideExpr = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)((Global)this.writeTo).getName()), (String)"");
            }
            if (this.clazzInstance instanceof Local) {
                rightSideExpr = ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)((Local)this.clazzInstance).getName()), (String)readFromVariableName);
            } else if (this.clazzInstance instanceof Global) {
                rightSideExpr = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)((Global)this.clazzInstance).getName()), (String)readFromVariableName);
            }
            AssignmentExpr assingExpr = AssignmentExpr.make((FilePositionInfo)this.filePositionInfo, (AssignableSyntheticExpr)leftSideExpr, (NonVoidSyntheticExpr)rightSideExpr);
            return assingExpr;
        }
    }

    public static class InstanceFieldWrite
    extends InstanceFieldStatement {
        private final Local clazzInstance;
        private final Param value;
        private final IField instanceVariable;
        private final FilePositionInfo filePositionInfo;

        public InstanceFieldWrite(Local clazzInstance, Param value, IField instanceVariable, FilePositionInfo filePositionInfo) {
            this.clazzInstance = clazzInstance;
            this.value = value;
            this.instanceVariable = instanceVariable;
            this.filePositionInfo = filePositionInfo;
        }

        public Local getClazzIntance() {
            return this.clazzInstance;
        }

        public Param getInstanceVaraibleValue() {
            return this.value;
        }

        public IField getInstanceVaraible() {
            return this.instanceVariable;
        }

        public FilePositionInfo getFilePositionInfo() {
            return this.filePositionInfo;
        }

        @Override
        public AssignmentExpr getExpr() {
            String instanceVariableName = this.getInstanceVaraible().getName().toString();
            TaintExpr valueExpr = null;
            if (this.value instanceof Taint) {
                valueExpr = TaintExpr.makeForParameter((String)"");
            } else if (this.value instanceof Local) {
                valueExpr = LocalRefExpr.make((String)((Local)this.value).getName());
            }
            AssignmentExpr assingExpr = AssignmentExpr.make((FilePositionInfo)this.getFilePositionInfo(), (AssignableSyntheticExpr)ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)this.getClazzIntance().getName()), (String)instanceVariableName), (NonVoidSyntheticExpr)valueExpr);
            return assingExpr;
        }
    }

    public static abstract class InstanceFieldStatement
    implements Statement {
        public abstract AssignmentExpr getExpr();
    }

    public static class GlobalWrite
    implements Statement {
        private final Global global;
        private final Local value;
        private final FilePositionInfo filePositionInfo;

        public GlobalWrite(Global global, Local value, FilePositionInfo filePositionInfo) {
            this.global = global;
            this.value = value;
            this.filePositionInfo = filePositionInfo;
        }

        public Global getGlobal() {
            return this.global;
        }

        public Local getValue() {
            return this.value;
        }

        public FilePositionInfo getFilePositionInfo() {
            return this.filePositionInfo;
        }
    }

    public static class Call
    implements Statement {
        private final String vdbSig;
        private final Param[] params;
        private final Local returnLocal;
        private final FilePositionInfo filePositionInfo;

        public Call(String vdbSig, Param[] params, Local returnLocal, FilePositionInfo filePositionInfo) {
            this.vdbSig = vdbSig;
            this.params = params;
            this.returnLocal = returnLocal;
            this.filePositionInfo = filePositionInfo;
        }

        public String getCalleeVdbSig() {
            return this.vdbSig;
        }

        public Param[] getParams() {
            return this.params;
        }

        public Local getReturnLocal() {
            return this.returnLocal;
        }

        public FilePositionInfo getFilePositionInfo() {
            return this.filePositionInfo;
        }
    }

    public static interface Statement {
    }
}

