/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee.jsp;

import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEOptions;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.ITagLibDefInfo;
import com.ibm.appscan.frameworks.util.JavaUtils;
import com.ibm.wala.ipa.cfg.ExplodedInterproceduralCFG;
import com.ibm.wala.types.Selector;
import com.ibm.wala.util.collections.Pair;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;

public class WebSphereInfo
implements IJSPPrecompilerInfo {
    private final String packageName;
    private static final Selector JSP_SERVICE_SELECTOR = Selector.make((String)"_jspService(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V");
    private static final Pair<String, Integer> JSP_RUNTIME_INCLUDE_SIG = Pair.make((Object)"org.apache.jasper.runtime.JspRuntimeLibrary.include(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;Ljava/lang/String;Ljavax/servlet/jsp/JspWriter;Z)V", (Object)2);
    private static final Pair<String, Integer> JSP_EL_EVALUATE_SIG = Pair.make((Object)"org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate(Ljava/lang/String;Ljava/lang/Class;Ljavax/servlet/jsp/PageContext;Lorg/apache/jasper/runtime/ProtectedFunctionMapper;Z)Ljava/lang/Object;", (Object)0);

    public static WebSphereInfo make(Properties options) {
        return new WebSphereInfo(options);
    }

    private WebSphereInfo(Properties options) {
        String packageNameOpt = options.getProperty(JavaEEOptions.JSP_PACKAGE_NAME.getName());
        if (packageNameOpt == null) {
            throw new IllegalArgumentException(JavaEEOptions.JSP_PACKAGE_NAME.getName() + " option must be set");
        }
        this.packageName = packageNameOpt;
    }

    @Override
    public Pair<String, Integer> getELEvaluateMethodSig() {
        return JSP_EL_EVALUATE_SIG;
    }

    @Override
    public Set<Selector> getEntrypointSelectors() {
        return Collections.singleton(JSP_SERVICE_SELECTOR);
    }

    @Override
    public String getPrecompiledClassNameForJSP(String jspPath) {
        return this.packageName + "." + WebSphereInfo.getJavaClassForJSPFile(jspPath);
    }

    @Override
    public Pair<String, Integer> getRuntimeIncludeMethodSig() {
        return JSP_RUNTIME_INCLUDE_SIG;
    }

    private static String getJavaClassForJSPFile(String forwardPath) {
        String ext;
        int extStartIndex;
        int jspNameStartIndex = forwardPath.lastIndexOf(47) + 1;
        String packageName = "";
        if (jspNameStartIndex > 1) {
            packageName = WebSphereInfo.makeJavaPackage(forwardPath.substring(1, jspNameStartIndex - 1)) + ".";
        }
        String className = (extStartIndex = forwardPath.lastIndexOf(46)) > 0 ? ((ext = forwardPath.substring(extStartIndex + 1)).equals("jsp") ? "_" + WebSphereInfo.escapeIllegalCharacters(forwardPath.substring(jspNameStartIndex, extStartIndex)) : "_" + WebSphereInfo.escapeIllegalCharacters(forwardPath.substring(jspNameStartIndex, extStartIndex)) + "_" + ext) : "_" + WebSphereInfo.escapeIllegalCharacters(forwardPath.substring(jspNameStartIndex));
        return packageName + className;
    }

    private static final String makeJavaPackage(String path) {
        String[] classNameComponents = path.split("/");
        StringBuffer legalClassNames = new StringBuffer();
        for (int i = 0; i < classNameComponents.length; ++i) {
            legalClassNames.append(WebSphereInfo.canonicalizeDir(classNameComponents[i]));
            if (i >= classNameComponents.length - 1) continue;
            legalClassNames.append('.');
        }
        return legalClassNames.toString();
    }

    private static String canonicalizeDir(String text) {
        String name = new String();
        if (text.length() > 0) {
            char first = text.charAt(0);
            name = !Character.isLetter(first) ? WebSphereInfo.mangleChar(first) + WebSphereInfo.escapeIllegalCharacters(text.substring(1)) : (JavaUtils.isJavaKeyword(name.toString()) ? WebSphereInfo.mangleChar(first) + WebSphereInfo.escapeIllegalCharacters(text.substring(1)) : WebSphereInfo.escapeIllegalCharacters(text));
        }
        return name;
    }

    private static String escapeIllegalCharacters(String text) {
        StringBuffer modifiedIdentifier = new StringBuffer(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '/') {
                modifiedIdentifier.append(ch);
                continue;
            }
            modifiedIdentifier.append(WebSphereInfo.mangleChar(ch));
        }
        if (JavaUtils.isJavaKeyword(modifiedIdentifier.toString())) {
            modifiedIdentifier.append('_');
        }
        return modifiedIdentifier.toString();
    }

    private static final String mangleChar(char ch) {
        char[] result = new char[]{'_', Character.toUpperCase(Character.forDigit(ch >> 4 & 0xF, 16)), Character.toUpperCase(Character.forDigit(ch & 0xF, 16)), '_'};
        return new String(result);
    }

    @Override
    public boolean tagLibAnalysisSupported() {
        return false;
    }

    @Override
    public ITagLibDefInfo getTagLibDefInfo(ExplodedInterproceduralCFG icfg) {
        throw new UnsupportedOperationException();
    }
}

