/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import com.ibm.appscan.frameworks.analyzers.spring.ExtendsAbstractFormControllerInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.FormalParameterExpr;
import com.ibm.appscan.frameworks.specinfo.LocalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExtendsSimpleFormControllerInfo
extends ExtendsAbstractFormControllerInfo {
    private static final TypeReference SPRING_SIMPLE_FORM_CONTROLLER = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)"org.springframework.web.servlet.mvc.SimpleFormController"));
    private static final Selector ON_SUBMIT_SELECTOR_FULL = Selector.make((String)"onSubmit(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;Ljava/lang/Object;Lorg/springframework/validation/BindException;)Lorg/springframework/web/servlet/ModelAndView;");
    private static final Selector ON_SUBMIT_SELECTOR_SIMPLER = Selector.make((String)"onSubmit(Ljava/lang/Object;Lorg/springframework/validation/BindException;)Lorg/springframework/web/servlet/ModelAndView;");
    private static final Selector ON_SUBMIT_SELECTOR_SIMPLEST = Selector.make((String)"onSubmit(Ljava/lang/Object;)Lorg/springframework/web/servlet/ModelAndView;");
    private static final Selector DO_SUBMIT_ACTION = Selector.make((String)"doSubmitAction(Ljava/lang/Object;)V");
    private static final Logger logger = TaintLogger.i().getLogger();

    @Override
    public boolean isApplicable(IClass klass, IClassHierarchy cha) {
        logger.info((Object)Messages.getString("framework.handler.searching", "org.springframework.web.servlet.mvc.SimpleFormController", ""));
        IClass simpleFormControllerKlass = cha.lookupClass(SPRING_SIMPLE_FORM_CONTROLLER);
        if (simpleFormControllerKlass == null) {
            logger.info((Object)Messages.getString("framework.missing", "org.springframework.web.servlet.mvc.SimpleFormController"));
            return false;
        }
        boolean result = cha.isAssignableFrom(simpleFormControllerKlass, klass);
        if (!result) {
            logger.info((Object)Messages.getString("framework.missing", "org.springframework.web.servlet.mvc.SimpleFormController"));
        }
        return result;
    }

    @Override
    protected IMethod doControllerEntryInvoke(IClass klass, SpringConfigFileInfo.SpringBeanInfo beanInfo, IClassHierarchy cha, Collection<SyntheticExpr> statements, String formObjectLocalName, BeanDecl localBeanDecl) {
        HashMap actualParameterPos2Value = HashMapFactory.make();
        IMethod controllerEntryMethod = null;
        controllerEntryMethod = this.tryFindingOnSubmitFull(klass, cha, formObjectLocalName, localBeanDecl, actualParameterPos2Value, ON_SUBMIT_SELECTOR_FULL);
        if (controllerEntryMethod == null) {
            controllerEntryMethod = this.tryFindingOtherOnSubmit(klass, cha, formObjectLocalName, localBeanDecl, actualParameterPos2Value, ON_SUBMIT_SELECTOR_SIMPLER);
        }
        if (controllerEntryMethod == null) {
            controllerEntryMethod = this.tryFindingOtherOnSubmit(klass, cha, formObjectLocalName, localBeanDecl, actualParameterPos2Value, ON_SUBMIT_SELECTOR_SIMPLEST);
        }
        if (controllerEntryMethod == null) {
            controllerEntryMethod = this.tryFindingOtherOnSubmit(klass, cha, formObjectLocalName, localBeanDecl, actualParameterPos2Value, DO_SUBMIT_ACTION);
        }
        if (controllerEntryMethod != null) {
            logger.info((Object)Messages.getString("framework.generate.call", controllerEntryMethod.getSignature()));
            statements.add((SyntheticExpr)VDBJavaUtil.invokeFromJVMSig(beanInfo.getFilePosInfo(), controllerEntryMethod.getSignature(), actualParameterPos2Value));
            return controllerEntryMethod;
        }
        return null;
    }

    private IMethod tryFindingOtherOnSubmit(IClass klass, IClassHierarchy cha, String formObjectLocalName, BeanDecl localBeanDecl, Map<Integer, NonVoidSyntheticExpr> actualParameterPos2Value, Selector selector) {
        MethodReference methodRef = MethodReference.findOrCreate((TypeReference)klass.getReference(), (Selector)selector);
        IMethod method = cha.resolveMethod(methodRef);
        IMethod controllerEntryMethod = null;
        if (method != null && !method.getDeclaringClass().getName().equals((Object)SPRING_SIMPLE_FORM_CONTROLLER.getName())) {
            controllerEntryMethod = method;
            if (localBeanDecl != null) {
                actualParameterPos2Value.put(1, (NonVoidSyntheticExpr)ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)formObjectLocalName), (String)""));
            }
        }
        return controllerEntryMethod;
    }

    private IMethod tryFindingOnSubmitFull(IClass klass, IClassHierarchy cha, String formObjectLocalName, BeanDecl localBeanDecl, Map<Integer, NonVoidSyntheticExpr> actualParameterPos2Value, Selector selector) {
        MethodReference onSubmitFullRef = MethodReference.findOrCreate((TypeReference)klass.getReference(), (Selector)selector);
        IMethod onSubmitFullMethod = cha.resolveMethod(onSubmitFullRef);
        IMethod controllerEntryMethod = null;
        if (onSubmitFullMethod != null && !onSubmitFullMethod.getDeclaringClass().getName().equals((Object)SPRING_SIMPLE_FORM_CONTROLLER.getName())) {
            controllerEntryMethod = onSubmitFullMethod;
            actualParameterPos2Value.put(1, (NonVoidSyntheticExpr)ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)0), (String)""));
            actualParameterPos2Value.put(2, (NonVoidSyntheticExpr)ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)1), (String)""));
            if (localBeanDecl != null) {
                actualParameterPos2Value.put(3, (NonVoidSyntheticExpr)ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)formObjectLocalName), (String)""));
            }
        }
        return controllerEntryMethod;
    }
}

