/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.struts1;

import com.ibm.appscan.frameworks.parsers.strutsParser.IPlugin;
import com.ibm.appscan.frameworks.parsers.strutsParser.IStrutsInfo;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StrutsPluginInfo {
    public static Set<String> getPluginEntrypoints(List<IStrutsInfo> parsers, IClassHierarchy cha) {
        HashSet result = HashSetFactory.make();
        for (IStrutsInfo parser : parsers) {
            List<IPlugin> plugins = parser.getPlugins();
            for (IPlugin plugin : plugins) {
                String pluginClassName = plugin.getClassName();
                result.addAll(StrutsPluginInfo.getEntrypointsForPlugin(pluginClassName, cha));
            }
        }
        return result;
    }

    private static Set<String> getEntrypointsForPlugin(String pluginClassName, IClassHierarchy cha) {
        IClass pluginKlass = cha.lookupClass(WalaUtil.createTypeRefForJavaClassName(pluginClassName));
        if (pluginKlass == null) {
            return Collections.emptySet();
        }
        IClass strutsPluginKlass = cha.lookupClass(WalaUtil.createTypeRefForJavaClassName("org.apache.struts.action.PlugIn"));
        if (strutsPluginKlass == null || !cha.implementsInterface(pluginKlass, strutsPluginKlass)) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make();
        for (IMethod m : strutsPluginKlass.getDeclaredMethods()) {
            IMethod curMethod = pluginKlass.getMethod(m.getSelector());
            assert (curMethod != null);
            result.add(curMethod.getSignature());
        }
        return result;
    }
}

