/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.parsers.strutsValidatorParser;

import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.FieldImpl;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.FormImpl;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.FormSetImpl;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IField;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IFormSet;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IStrutsValidatorInfo;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IValidationForm;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IValidator;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.StrutsValidatorVersion;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.ValidatorImpl;
import com.ibm.appscan.frameworks.util.DOMParserWithLineNumbers;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMBasedStrutsValidatorInfo
implements IStrutsValidatorInfo {
    private static final Logger logger = TaintLogger.i().getLogger();
    public static boolean verbose = true;
    private final Map<String, IValidator> validators = HashMapFactory.make();
    private final List<IFormSet> formSets = new ArrayList<IFormSet>();
    private StrutsValidatorVersion strutsVersion;

    public DOMBasedStrutsValidatorInfo(Map<String, InputStream> validationConfigurations) throws IOException, SAXException {
        for (Map.Entry<String, InputStream> entry : validationConfigurations.entrySet()) {
            DOMParserWithLineNumbers parser = new DOMParserWithLineNumbers(entry.getValue());
            this.populateValidators(parser.getDocument(), entry.getKey());
            this.populateFormSets(parser.getDocument());
        }
        if (verbose) {
            logger.info((Object)("Loaded struts validation configuration file: " + validationConfigurations.entrySet() + "\n" + this.toString()));
        }
    }

    public static IStrutsValidatorInfo getStrutsValidatorParser(Map<String, InputStream> validationConfigurations) throws IOException, SAXException {
        if (verbose) {
            logger.info((Object)("Finding parser for struts configuration files at " + validationConfigurations));
        }
        return new DOMBasedStrutsValidatorInfo(validationConfigurations);
    }

    @Override
    public Collection<IValidator> getValidators() {
        return this.validators.values();
    }

    @Override
    public List<IFormSet> getFormSets() {
        return this.formSets;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Struts Parser for " + (Object)((Object)this.strutsVersion) + "\n");
        sb.append("Validators:" + this.validators.size() + "\n");
        sb.append("FormSets:" + this.formSets.size() + "\n");
        return sb.toString();
    }

    public String toDetailString() {
        StringBuffer sb = new StringBuffer(this.toString());
        sb.append("Validators:\n");
        for (IValidator validator : this.validators.values()) {
            sb.append(validator + "\n");
        }
        sb.append("FormSets:\n");
        for (IFormSet formSet : this.formSets) {
            sb.append("formset: " + formSet.getLanguage() + " " + formSet.getCountry() + "\n");
            for (IValidationForm form : formSet.getForms()) {
                sb.append(form + "\n");
            }
        }
        return sb.toString();
    }

    private void populateValidators(Document doc, String fileName) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            this.populateValidator(doc, xpath, fileName);
            this.populateStrutsValidatorVersion(doc, xpath);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void populateFormSets(Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression validatorXpath = xpath.compile("/form-validation/*");
            NodeList nodes = (NodeList)validatorXpath.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                IFormSet formSet = this.populateFormSet(nodes.item(i), xpath);
                if (formSet == null) continue;
                this.formSets.add(formSet);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void populateStrutsValidatorVersion(Document doc, XPath xpath) {
        if (this.strutsVersion != null) {
            return;
        }
        DocumentType doctype = doc.getDoctype();
        if (doctype == null) {
            return;
        }
        String publicId = doctype.getPublicId();
        if (publicId != null) {
            this.strutsVersion = StrutsValidatorVersion.UNKNOWN_GLOBAL;
            if (publicId.startsWith("-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.1.3")) {
                this.strutsVersion = StrutsValidatorVersion.DTD1_1_3;
            }
            if (publicId.startsWith("-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.0.1")) {
                this.strutsVersion = StrutsValidatorVersion.DTD1_0_1;
            }
            if (publicId.startsWith("-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.0")) {
                this.strutsVersion = StrutsValidatorVersion.DTD1_0;
            }
            if (publicId.startsWith("-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.1")) {
                this.strutsVersion = StrutsValidatorVersion.DTD1_1;
            }
            if (publicId.startsWith("-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.2.0")) {
                this.strutsVersion = StrutsValidatorVersion.DTD1_2_0;
            }
            if (publicId.startsWith("-//Apache Software Foundation//DTD Commons Validator Rules Configuration 1.3.0")) {
                this.strutsVersion = StrutsValidatorVersion.DTD1_3_0;
            }
            if (this.strutsVersion.equals((Object)StrutsValidatorVersion.UNKNOWN_GLOBAL)) {
                logger.warn((Object)"Can't detect the struts configuration type of alobal struts configuration");
            }
            return;
        }
        String systemId = doctype.getSystemId();
        if (systemId != null) {
            this.strutsVersion = StrutsValidatorVersion.UNKNOWN_LOCAL;
            if (systemId.equals("http://jakarta.apache.org/commons/dtds/validator_1_1_3.dtd")) {
                this.strutsVersion = StrutsValidatorVersion.DTD1_1_3;
            }
            if (systemId.equals("http://jakarta.apache.org/commons/dtds/validator_1_3_0.dtd")) {
                this.strutsVersion = StrutsValidatorVersion.DTD1_2_0;
            }
            if (systemId.equals("http://jakarta.apache.org/commons/dtds/validator_1_2_0.dtd")) {
                this.strutsVersion = StrutsValidatorVersion.DTD1_3_0;
            }
            if (systemId.equals("http://jakarta.apache.org/commons/dtds/validator_1_0_1.dtd")) {
                this.strutsVersion = StrutsValidatorVersion.DTD1_0_1;
            }
            if (systemId.equals("http://jakarta.apache.org/commons/dtds/validator_1_1.dtd")) {
                this.strutsVersion = StrutsValidatorVersion.DTD1_1;
            }
            if (systemId.equals("http://jakarta.apache.org/commons/dtds/validator_1_0.dtd")) {
                this.strutsVersion = StrutsValidatorVersion.DTD1_0;
            }
        } else {
            this.strutsVersion = StrutsValidatorVersion.UNKNOWN;
            logger.warn((Object)"Can't detect the struts configuration type. Public and System keys are missing");
        }
    }

    private void populateValidator(Document doc, XPath xpath, String fileName) throws XPathExpressionException {
        XPathExpression validatorXpath = xpath.compile("/form-validation/global/*");
        NodeList nodes = (NodeList)validatorXpath.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IValidator validator = this.getValidator(nodes.item(i), xpath, fileName);
            if (validator == null) continue;
            this.validators.put(validator.getName(), validator);
        }
    }

    private IValidator getValidator(Node item, XPath xpath, String fileName) throws XPathExpressionException {
        if (item.getNodeName().equals("validator")) {
            if (item.getAttributes() == null) {
                logger.warn((Object)"Found form bean with no attributes");
                return null;
            }
            String name = this.getStringAttrValue(item, "name");
            String className = this.getStringAttrValue(item, "classname");
            String method = this.getStringAttrValue(item, "method");
            String methodParams = this.getStringAttrValue(item, "methodParams");
            int lineNumber = Integer.valueOf((String)item.getUserData("startLine"));
            int columnNumber = Integer.valueOf((String)item.getUserData("startColumn"));
            return new ValidatorImpl(name, className, method, methodParams, FilePositionInfo.make((String)fileName, (int)lineNumber, (int)columnNumber));
        }
        return null;
    }

    private IFormSet populateFormSet(Node item, XPath xpath) throws XPathExpressionException {
        if (item.getNodeName().equals("formset")) {
            if (item.getAttributes() == null) {
                logger.warn((Object)"Found form set with no attributes");
                return null;
            }
            List<IValidationForm> forms = this.getFormsFromFormSet(item, xpath);
            String language = this.getStringAttrValue(item, "language");
            String country = this.getStringAttrValue(item, "country");
            return new FormSetImpl(country, language, forms);
        }
        return null;
    }

    private List<IValidationForm> getFormsFromFormSet(Node item, XPath xpath) throws XPathExpressionException {
        ArrayList<IValidationForm> result = new ArrayList<IValidationForm>();
        NodeList nodes = (NodeList)xpath.compile("form").evaluate(item, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IValidationForm form = this.getForm(nodes.item(i), xpath);
            if (form == null) continue;
            result.add(form);
        }
        return result;
    }

    private IValidationForm getForm(Node item, XPath xpath) throws XPathExpressionException {
        String name = this.getStringAttrValue(item, "name");
        List<IField> fields = this.getFieldsFromForm(item, xpath);
        return new FormImpl(name, fields);
    }

    private List<IField> getFieldsFromForm(Node item, XPath xpath) throws XPathExpressionException {
        ArrayList<IField> result = new ArrayList<IField>();
        NodeList nodes = (NodeList)xpath.compile("field").evaluate(item, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IField field = this.getField(nodes.item(i), xpath);
            if (field == null) continue;
            result.add(field);
        }
        return result;
    }

    private IField getField(Node item, XPath xpath) {
        if (item.getNodeName().equals("field")) {
            if (item.getAttributes() == null) {
                logger.warn((Object)"Found form field with no attributes");
                return null;
            }
            String property = this.getStringAttrValue(item, "property");
            String depends = this.getStringAttrValue(item, "depends");
            return new FieldImpl(property, depends);
        }
        return null;
    }

    private String getStringAttrValue(Node item, String attrName) {
        Node value = item.getAttributes().getNamedItem(attrName);
        return value == null ? null : value.getNodeValue();
    }

    @Override
    public StrutsValidatorVersion getStrutsValidationVersion() {
        return this.strutsVersion;
    }

    @Override
    public void removeUnresolvedValidators(IClassHierarchy cha) {
        HashSet cantResolveValidators = HashSetFactory.make();
        for (Map.Entry<String, IValidator> validPair : this.validators.entrySet()) {
            IValidator validator = validPair.getValue();
            if (validator.getResolvedMethodReference(cha) != null) continue;
            cantResolveValidators.add(validPair.getKey());
        }
        for (String validatorToRemoveName : cantResolveValidators) {
            this.validators.remove(validatorToRemoveName);
        }
    }
}

