/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Files {
    private Files() {
        throw new IllegalStateException("no instances");
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Files.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static List<String> findFilesInDir(File dir, String startsWith, String endsWith) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + dir.getAbsolutePath());
        }
        File currentDir = dir;
        ArrayList<String> retval = new ArrayList<String>();
        for (String fileName : currentDir.list()) {
            if (!fileName.startsWith(startsWith) || !fileName.endsWith(endsWith)) continue;
            retval.add(fileName);
        }
        return retval;
    }

    public static void writeToFile(String s, File file) throws IOException {
        Files.writeToFile(s, file, (Boolean)false);
    }

    public static void writeToFile(String s, String fileName) throws IOException {
        Files.writeToFile(s, fileName, (Boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String s, File file, Boolean append) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file, (boolean)append));){
            writer.append(s);
        }
    }

    public static void writeToFile(String s, String fileName, Boolean append) throws IOException {
        Files.writeToFile(s, new File(fileName), append);
    }

    public static List<String> readWhole(BufferedReader reader) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            result.add(line);
            line = reader.readLine();
        }
        return Collections.unmodifiableList(result);
    }

    public static List<String> readWhole(String fileName) throws IOException {
        return Files.readWhole(new File(fileName));
    }

    public static List<String> readWhole(File file) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            List<String> list = Files.readWhole(in);
            return list;
        }
    }

    public static List<String> readWhole(InputStream is) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        return Files.readWhole(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContents(File file) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            int c;
            while ((c = ((Reader)in).read()) != -1) {
                result.append((char)c);
            }
            ((Reader)in).close();
            String string = result.toString();
            return string;
        }
    }

    public static String getFileContents(String path) throws IOException {
        return Files.getFileContents(new File(path));
    }

    public static LineNumberReader getFileReader(String fileName) {
        return Files.getFileReader(new File(fileName));
    }

    public static LineNumberReader getFileReader(File fileName) {
        LineNumberReader reader;
        try {
            reader = new LineNumberReader(new BufferedReader(new FileReader(fileName)));
        }
        catch (FileNotFoundException e1) {
            throw new IllegalStateException("File was not found " + fileName + " " + e1.getMessage());
        }
        return reader;
    }

    public static String addProjectPath(String string) {
        return System.getProperty("user.dir") + File.separator + string;
    }

    public static boolean deleteFile(String path) {
        File f = new File(path);
        return f.delete();
    }

    public static Long readLongFromFile(File file) {
        List<String> lines;
        if (!file.exists()) {
            return null;
        }
        try {
            lines = Files.readWhole(file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem reading file " + file + " ", e);
        }
        if (lines.size() != 1) {
            throw new IllegalStateException("Expected exactly 1 line in " + file + " but found " + lines.size());
        }
        try {
            return Long.valueOf(lines.get(0));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Expected a number (type long) in " + file + " but found " + lines.get(0));
        }
    }

    public static List<File> recursiveFindFilesInDir(File dir, String startsWith, String endsWith) {
        ArrayList<File> retval = new ArrayList<File>();
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                retval.addAll(Files.recursiveFindFilesInDir(new File(dir, children[i]), startsWith, endsWith));
            }
        } else if (dir.getPath().startsWith(startsWith) && dir.getPath().endsWith(endsWith)) {
            retval.add(dir);
        }
        return retval;
    }

    public static List<File> recursiveFindFilesWithPattern(File dir, String includeFileNamePattern) {
        ArrayList<File> retval = new ArrayList<File>();
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                retval.addAll(Files.recursiveFindFilesWithPattern(new File(dir, children[i]), includeFileNamePattern));
            }
        } else if (dir.getName().matches(includeFileNamePattern)) {
            retval.add(dir);
        }
        return retval;
    }

    public static boolean exist(String path) {
        File f = new File(path);
        return f.exists();
    }
}

