/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.appscan.frameworks.util.messages", Locale.getDefault());

    private Messages() {
    }

    public static String getString(String key, Object ... params) {
        String result;
        try {
            String resourceLookup = RESOURCE_BUNDLE.getString(key);
            result = MessageFormat.format(resourceLookup, params);
        }
        catch (MissingResourceException e) {
            result = '!' + key + '!';
        }
        return result;
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getTraceFromException(Exception e) {
        if (e != null) {
            StringBuffer sb = new StringBuffer();
            for (StackTraceElement s : e.getStackTrace()) {
                sb.append("\n\t\t" + s.toString());
            }
            return sb.toString();
        }
        return null;
    }
}

