/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee;

import com.ibm.appscan.frameworks.analyzers.javaee.BeanId;
import com.ibm.appscan.frameworks.analyzers.javaee.BeanScope;
import com.ibm.appscan.frameworks.analyzers.javaee.BeanSeed;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.HashMap;
import java.util.Set;

public class BeanScopeResolver {
    Set<BeanSeed> beanSeeds = HashSetFactory.make();
    HashMap<BeanId, TypeReference> globalMap = HashMapFactory.make();

    public HashMap<BeanId, TypeReference> getGlobalMap() {
        return this.globalMap;
    }

    public BeanScopeResolver(Set<BeanSeed> preProcessedBeanSeeds) {
        this.processSeeds(preProcessedBeanSeeds);
    }

    private void processSeeds(Set<BeanSeed> preProcessedBeanSeeds) {
        HashMap nameToScope = HashMapFactory.make();
        for (BeanSeed seed : preProcessedBeanSeeds) {
            BeanScope beanScope = (BeanScope)((Object)nameToScope.get(seed.name));
            BeanId id = new BeanId(seed.scope, seed.name);
            if (beanScope == null) {
                nameToScope.put(seed.name, seed.scope);
            } else if (seed.scope.compareTo(beanScope) > 0) {
                nameToScope.put(seed.name, seed.scope);
            }
            this.globalMap.put(id, seed.typeOfBean);
            this.beanSeeds.add(seed);
        }
    }

    public Set<BeanSeed> getBeanSeeds() {
        return this.beanSeeds;
    }
}

