/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.MapUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class JavaEEDeploymentDescriptorInfo {
    private final Map<String, String> servletClassName2ServletName = HashMapFactory.make();
    private final Map<String, String> servletName2servletClassName = HashMapFactory.make();
    private final Map<String, List<String>> servletMappings = HashMapFactory.make();
    private final Map<String, String> url2ServletName = HashMapFactory.make();
    private final File webContentDir;

    public static JavaEEDeploymentDescriptorInfo make(File webDotXMLFile) throws SAXException, IOException {
        return JavaEEDeploymentDescriptorInfo.make(webDotXMLFile, null);
    }

    public static JavaEEDeploymentDescriptorInfo make(File webDotXMLFile, File webContentDir) throws SAXException, IOException {
        return new JavaEEDeploymentDescriptorInfo(webDotXMLFile, webContentDir);
    }

    private JavaEEDeploymentDescriptorInfo(File webDotXMLFile, File webContentDir) throws SAXException, IOException {
        this.webContentDir = webContentDir;
        this.parse(webDotXMLFile);
    }

    private void parse(File webDotXMLFile) throws SAXException, IOException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        ParseEventHandler handler = new ParseEventHandler();
        reader.setContentHandler(handler);
        FileReader fReader = new FileReader(webDotXMLFile);
        reader.parse(new InputSource(fReader));
    }

    public Map<String, List<String>> getServletMappings() {
        return this.servletMappings;
    }

    public String getServletClassForURL(String url) {
        return this.servletName2servletClassName.get(this.url2ServletName.get(url));
    }

    public String getServletNameForServletClass(String servletClassName) {
        return this.servletClassName2ServletName.get(servletClassName);
    }

    private String trimWhitespace(String str) {
        return str.replaceAll("^\\s+", "").replaceAll("\\s+$", "");
    }

    public File getWebContentDirectory() {
        return this.webContentDir;
    }

    public Collection<String> getAllServletClassNames() {
        return this.servletClassName2ServletName.keySet();
    }

    private class ParseEventHandler
    extends DefaultHandler {
        String curServletName = null;
        String curServletClass = null;
        String curURLPattern = null;
        StringBuilder curChars = null;

        private ParseEventHandler() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes atts) {
            if (qName.equals("servlet-name") || qName.equals("servlet-class") || qName.equals("url-pattern")) {
                this.curChars = new StringBuilder();
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            if (qName.equals("servlet")) {
                assert (this.curServletName != null);
                if (this.curServletClass != null) {
                    JavaEEDeploymentDescriptorInfo.this.servletClassName2ServletName.put(JavaEEDeploymentDescriptorInfo.this.trimWhitespace(this.curServletClass), JavaEEDeploymentDescriptorInfo.this.trimWhitespace(this.curServletName));
                    JavaEEDeploymentDescriptorInfo.this.servletName2servletClassName.put(JavaEEDeploymentDescriptorInfo.this.trimWhitespace(this.curServletName), JavaEEDeploymentDescriptorInfo.this.trimWhitespace(this.curServletClass));
                    this.curServletClass = null;
                }
                this.curServletName = null;
            }
            if (qName.equals("servlet-mapping")) {
                assert (this.curServletName != null);
                assert (this.curURLPattern != null);
                MapUtil.findOrCreateList((Map)JavaEEDeploymentDescriptorInfo.this.servletMappings, (Object)JavaEEDeploymentDescriptorInfo.this.trimWhitespace(this.curServletName)).add(JavaEEDeploymentDescriptorInfo.this.trimWhitespace(this.curURLPattern));
                JavaEEDeploymentDescriptorInfo.this.url2ServletName.put(JavaEEDeploymentDescriptorInfo.this.trimWhitespace(this.curURLPattern), JavaEEDeploymentDescriptorInfo.this.trimWhitespace(this.curServletName));
                this.curServletName = null;
                this.curURLPattern = null;
            }
            if (qName.equals("servlet-name")) {
                this.curServletName = this.curChars.toString();
                this.curChars = null;
            }
            if (qName.equals("servlet-class")) {
                this.curServletClass = this.curChars.toString();
                this.curChars = null;
            }
            if (qName.equals("url-pattern")) {
                this.curURLPattern = this.curChars.toString();
                this.curChars = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.curChars != null) {
                this.curChars.append(ch, start, length);
            }
        }
    }
}

