/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee.jsp;

import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEOptions;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.JSPFile;
import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.IJavaEEDeploymentDescriptorInfo;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.ref.ReferenceCleanser;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class JSPAnalyzer {
    private final String webContentDir;
    private final Map<String, JSPFile> accessibleJspFiles = HashMapFactory.make();
    private final Map<String, JSPFile> allJspFiles = HashMapFactory.make();
    private final IClassHierarchy cha;
    private final AnalysisCache cache;
    private final IJSPPrecompilerInfo precompilerInfo;
    private static final Collection<String> inaccessibleDirs = HashSetFactory.make();

    public String toString() {
        StringBuffer sb = new StringBuffer("JSPAnalyzer [webContentDir=" + this.webContentDir + ", jspFiles=");
        for (JSPFile jsp : this.accessibleJspFiles.values()) {
            sb.append(jsp + "\n");
        }
        return sb.toString();
    }

    public JSPAnalyzer(AnalysisCache cache, IClassHierarchy cha, String webContentDir, Properties options) {
        this.webContentDir = webContentDir;
        this.cha = cha;
        this.cache = cache;
        ReferenceCleanser.registerClassHierarchy((IClassHierarchy)cha);
        ReferenceCleanser.registerCache((AnalysisCache)cache);
        this.precompilerInfo = JavaEEOptions.getPrecompilerInfo(options);
        this.collectAllJSPFiles("", true);
        this.buildJSPIncludeHierarchy();
    }

    private void collectAllJSPFiles(String curSubDir, boolean isAccessible) {
        File dirFile = new File(this.webContentDir + File.separatorChar + curSubDir);
        String[] jspsInDir = dirFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jsp");
            }
        });
        String urlPrefix = curSubDir.replace('\\', '/');
        for (String fileName : jspsInDir) {
            JSPFile jspFile = !urlPrefix.isEmpty() ? new JSPFile(urlPrefix + '/' + fileName, this.cha, this.precompilerInfo, this.cache) : new JSPFile(fileName, this.cha, this.precompilerInfo, this.cache);
            if (jspFile.getPrecompiledClass() == null) continue;
            if (isAccessible) {
                this.accessibleJspFiles.put(jspFile.getPath(), jspFile);
            }
            this.allJspFiles.put(jspFile.getPath(), jspFile);
        }
        for (File f : dirFile.listFiles()) {
            if (!f.isDirectory()) continue;
            String newSubDir = curSubDir + File.separatorChar + f.getName();
            if (!inaccessibleDirs.contains(newSubDir)) {
                this.collectAllJSPFiles(newSubDir, isAccessible);
                continue;
            }
            this.collectAllJSPFiles(newSubDir, false);
        }
    }

    private void buildJSPIncludeHierarchy() {
        int howOftenToCleanse = 10;
        int i = 1;
        for (JSPFile jspFile : this.accessibleJspFiles.values()) {
            jspFile.findIncludedFiles(this.accessibleJspFiles);
            if (i % howOftenToCleanse == 0) {
                ReferenceCleanser.clearSoftCaches();
            }
            ++i;
        }
        for (JSPFile jspFile : this.accessibleJspFiles.values()) {
            jspFile.addRecursiveIncludes();
        }
    }

    public void handleAllJSPs(Map<String, Set<String>> sig2url) {
        for (JSPFile jspFile : this.accessibleJspFiles.values()) {
            Set<String> entrypointSigsForJSP = jspFile.getEntrypointSigs();
            for (String sig : entrypointSigsForJSP) {
                TaintLogger.i().getLogger().info((Object)Messages.getString("framework.method.url", sig, jspFile.getUrl()));
                MapUtil.findOrCreateSet(sig2url, (Object)sig).add(jspFile.getUrl());
                for (JSPFile included : jspFile.getIncludes()) {
                    TaintLogger.i().getLogger().info((Object)Messages.getString("framework.method.url", sig, included.getUrl()));
                    MapUtil.findOrCreateSet(sig2url, (Object)sig).add(included.getUrl());
                }
            }
        }
    }

    public void handleMappedJSPs(IJavaEEDeploymentDescriptorInfo ddInfo, Map<String, Set<String>> sig2url) {
        Collection<String> mappedJSPPaths = ddInfo.getMappedJSPPaths();
        for (String jspPath : mappedJSPPaths) {
            JSPFile jspFile = this.accessibleJspFiles.get(jspPath);
            if (jspFile == null) {
                TaintLogger.i().getLogger().warn((Object)("could not find JSP  " + jspPath));
                continue;
            }
            Set<String> curEntrypointSigs = jspFile.getEntrypointSigs();
            String servletNameForJSPPath = ddInfo.getServletNameForJSPPath(jspPath);
            JSPAnalyzer.addSig2URLMappings(ddInfo, sig2url, curEntrypointSigs, servletNameForJSPPath);
        }
    }

    private static void addSig2URLMappings(IJavaEEDeploymentDescriptorInfo ddInfo, Map<String, Set<String>> sig2URL, Set<String> sigs, String servletName) {
        List<String> urls = ddInfo.getServletMappings().get(servletName);
        if (urls != null) {
            for (String sig : sigs) {
                if (!urls.isEmpty()) {
                    TaintLogger.i().getLogger().info((Object)Messages.getString("framework.method.url", sig, urls.get(0)));
                }
                MapUtil.findOrCreateSet(sig2URL, (Object)sig).addAll(urls);
            }
        } else {
            for (String sig : sigs) {
                TaintLogger.i().getLogger().info((Object)Messages.getString("framework.method.url", sig, ""));
                MapUtil.findOrCreateSet(sig2URL, (Object)sig);
            }
        }
    }

    public Map<String, JSPFile> getJSPFiles() {
        return this.accessibleJspFiles;
    }

    public Map<String, Set<CallSiteReplacement>> getMethodToReplacementsMapping() {
        HashMap methodToReplacements = HashMapFactory.make();
        for (JSPFile jspFile : this.allJspFiles.values()) {
            Map<String, Set<CallSiteReplacement>> curMethodToReplacementsMapping = jspFile.getMethodToReplacementsMapping();
            for (String vdbMethodSig : curMethodToReplacementsMapping.keySet()) {
                MapUtil.findOrCreateSet((Map)methodToReplacements, (Object)vdbMethodSig).addAll((Collection)curMethodToReplacementsMapping.get(vdbMethodSig));
            }
        }
        return methodToReplacements;
    }

    public Set<BeanDecl> getGlobalBeanDecl() {
        HashSet result = HashSetFactory.make();
        for (JSPFile jspFile : this.allJspFiles.values()) {
            result.addAll(jspFile.getGlobalBeanDecl());
        }
        return result;
    }

    static {
        inaccessibleDirs.add(File.separatorChar + "WEB-INF");
    }
}

