/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee.jsp;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.ElAccess;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.UnhandledELException;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.ITagLibDefInfo;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.util.MethodAndCallSiteReference;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cfg.ExplodedInterproceduralCFG;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JSPFile {
    private final String path;
    private final Collection<JSPFile> includes = HashSetFactory.make();
    private final IClass klass;
    private final IJSPPrecompilerInfo precompilerInfo;
    private final IClassHierarchy cha;
    private final Set<String> entryPointSig = HashSetFactory.make();
    private final AnalysisCache cache;
    private final Set<ElAccess> accessPaths = HashSetFactory.make();
    private final Set<BeanDecl> globalBeanDeclarations = HashSetFactory.make();
    boolean computedRecInclude = false;

    public JSPFile(String path, IClassHierarchy cha, IJSPPrecompilerInfo precompilerInfo, AnalysisCache cache) {
        this.path = path;
        this.precompilerInfo = precompilerInfo;
        this.cha = cha;
        this.cache = cache;
        String precompiledClassNameForJSP = precompilerInfo.getPrecompiledClassNameForJSP(path);
        TypeReference typeRef = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)precompiledClassNameForJSP));
        this.klass = cha.lookupClass(typeRef);
        if (this.klass == null) {
            TaintLogger.i().getLogger().warn((Object)("could not find precompiled JSP class " + precompiledClassNameForJSP));
        } else {
            this.initEntryPointSig();
            this.findAccessPathsInELExpressions();
        }
    }

    public IClass getPrecompiledClass() {
        return this.klass;
    }

    private void findAccessPathsInELExpressions() {
        if (this.klass == null) {
            return;
        }
        Pair<String, Integer> elEvaluateMethodSigAndArgPos = this.precompilerInfo.getELEvaluateMethodSig();
        if (elEvaluateMethodSigAndArgPos == null) {
            return;
        }
        ITagLibDefInfo tagLibDefInfo = null;
        ExplodedInterproceduralCFG icfg = null;
        CallGraph cg = null;
        if (this.precompilerInfo.tagLibAnalysisSupported()) {
            cg = WalaUtil.buildCallGraphForClass(this.klass, new AnalysisOptions(), this.cache);
            icfg = ExplodedInterproceduralCFG.make((CallGraph)cg);
            tagLibDefInfo = this.precompilerInfo.getTagLibDefInfo(icfg);
        }
        for (MethodAndCallSiteReference jspEvaluateCall : this.getCalls(WalaUtil.getResolvedMethodReference((String)elEvaluateMethodSigAndArgPos.fst, this.cha))) {
            IMethod method = jspEvaluateCall.getMethod();
            IR ir = LangIndependentWalaUtil.getIR((IMethod)method, (AnalysisCache)this.cache);
            DefUse du = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)this.cache);
            SSAAbstractInvokeInstruction callInstr = WalaUtil.getSingleInstructionForCallSite(jspEvaluateCall.getSite(), ir);
            Set<ITagLibDefInfo.ReachingDef> reachingNames = Collections.emptySet();
            if (tagLibDefInfo != null) {
                reachingNames = this.getReachingNames(tagLibDefInfo, icfg, cg, method, callInstr);
            }
            Collection<String> expressions = JSPFile.getStringsPassed(callInstr, ir, du, (Integer)elEvaluateMethodSigAndArgPos.snd);
            for (String elExpression : expressions) {
                try {
                    ElAccess elAccess = ElAccess.getElAccess(this.cha, elExpression, (IMethod)jspEvaluateCall.fst, callInstr.getCallSite(), WalaUtil.getSourceLine(method, callInstr.getCallSite()), reachingNames);
                    this.accessPaths.add(elAccess);
                    this.globalBeanDeclarations.addAll(elAccess.getGlobalBeanDecls());
                }
                catch (UnhandledELException e) {
                    TaintLogger.i().getLogger().debug((Object)("could not handle EL expression " + elExpression));
                }
            }
        }
    }

    private Set<ITagLibDefInfo.ReachingDef> getReachingNames(ITagLibDefInfo tagLibDefInfo, ExplodedInterproceduralCFG icfg, CallGraph cg, IMethod method, SSAAbstractInvokeInstruction callInstr) {
        IExplodedBasicBlock desiredBB = null;
        CGNode cgNode = cg.getNode(method, (Context)Everywhere.EVERYWHERE);
        for (IExplodedBasicBlock ebb : icfg.getCFG(cgNode)) {
            SSAAbstractInvokeInstruction invoke;
            SSAInstruction lastInstruction = ebb.getLastInstruction();
            if (!(lastInstruction instanceof SSAAbstractInvokeInstruction) || !(invoke = (SSAAbstractInvokeInstruction)lastInstruction).getCallSite().equals((Object)callInstr.getCallSite())) continue;
            desiredBB = ebb;
            break;
        }
        assert (desiredBB != null);
        BasicBlockInContext blockInContext = new BasicBlockInContext(cgNode, desiredBB);
        Set<ITagLibDefInfo.ReachingDef> reachingNames = tagLibDefInfo.getNamesReachingBlock((BasicBlockInContext<IExplodedBasicBlock>)blockInContext);
        return reachingNames;
    }

    public String getPath() {
        return this.path;
    }

    public void addIncludedFile(JSPFile jspFile) {
        if (!jspFile.equals(this)) {
            this.includes.add(jspFile);
        }
    }

    private void initEntryPointSig() {
        Set<Selector> entrypointSelectors = this.precompilerInfo.getEntrypointSelectors();
        for (Selector selector : entrypointSelectors) {
            MethodReference ref = MethodReference.findOrCreate((TypeReference)this.klass.getReference(), (Selector)selector);
            IMethod method = this.cha.resolveMethod(ref);
            assert (method != null);
            this.entryPointSig.add(VDBJavaUtil.jvmToVDBSignature(method.getSignature()));
        }
    }

    public String getUrl() {
        return this.path.startsWith("/") ? this.path : "/" + this.path;
    }

    public Collection<JSPFile> getIncludes() {
        return this.includes;
    }

    public Collection<MethodAndCallSiteReference> getCalls(MethodReference methodReference) {
        return WalaUtil.getMatchingCallSites(this.klass, methodReference, this.cache, this.cha);
    }

    public Set<String> getEntrypointSigs() {
        return this.entryPointSig;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSPFile other = (JSPFile)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        return "JSPFile [path=" + this.path + ", includes=" + this.includes + "]";
    }

    public String getNonRelativePath(String relativeJSPPath) {
        if (!this.path.contains("/")) {
            return relativeJSPPath;
        }
        return this.path.substring(0, this.path.lastIndexOf("/") + 1) + relativeJSPPath;
    }

    public void addRecursiveIncludes() {
        if (this.computedRecInclude) {
            return;
        }
        this.computedRecInclude = true;
        HashSet newIncludes = HashSetFactory.make();
        for (JSPFile includedJSP : this.includes) {
            if (includedJSP.computedRecInclude) {
                includedJSP.addRecursiveIncludes();
            }
            newIncludes.addAll(includedJSP.includes);
        }
        this.includes.addAll(newIncludes);
    }

    public void findIncludedFiles(Map<String, JSPFile> jspFiles) {
        Pair<String, Integer> runtimeIncludeMethodSigAndArgPos = this.precompilerInfo.getRuntimeIncludeMethodSig();
        for (MethodAndCallSiteReference includeCall : this.getCalls(StringStuff.makeMethodReference((String)((String)runtimeIncludeMethodSigAndArgPos.fst)))) {
            IMethod method = includeCall.getMethod();
            IR ir = LangIndependentWalaUtil.getIR((IMethod)method, (AnalysisCache)this.cache);
            DefUse du = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)this.cache);
            SSAAbstractInvokeInstruction callInstr = WalaUtil.getSingleInstructionForCallSite(includeCall.getSite(), ir);
            Collection<String> includedFiles = JSPFile.getStringsPassed(callInstr, ir, du, (Integer)runtimeIncludeMethodSigAndArgPos.snd);
            for (String includedFile : includedFiles) {
                String nonRelativeIncludePath = this.getNonRelativePath(includedFile);
                JSPFile includedJSP = jspFiles.get(nonRelativeIncludePath);
                if (includedJSP == null && (includedJSP = jspFiles.get("/" + nonRelativeIncludePath)) == null) {
                    TaintLogger.i().getLogger().warn((Object)("could not find included jsp file  " + nonRelativeIncludePath + " included from " + this));
                    continue;
                }
                this.addIncludedFile(includedJSP);
            }
        }
    }

    public Map<String, Set<CallSiteReplacement>> getMethodToReplacementsMapping() {
        HashMap methodToReplacements = HashMapFactory.make();
        for (ElAccess elAccess : this.accessPaths) {
            MapUtil.findOrCreateSet((Map)methodToReplacements, (Object)WalaUtil.method2ResolvedVDBSignature(elAccess.getCallerMethod())).add(elAccess.getCallSiteReplacement());
        }
        return methodToReplacements;
    }

    public Collection<? extends BeanDecl> getGlobalBeanDecl() {
        return this.globalBeanDeclarations;
    }

    private static Collection<String> getStringsPassed(SSAAbstractInvokeInstruction callInstr, IR ir, DefUse du, int use) {
        int valUse = callInstr.getUse(use);
        StringConstantFlow constantFlow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
        return constantFlow.findIntraprocStringsFlowingToVar(valUse);
    }
}

