/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee.taglibs;

import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.JasperInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.ElExpUtil;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.ITagLibDefInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.TagLibraryInfo;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.InvokeExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class CForEachInfo
implements TagLibraryInfo {
    private static final String DO_START_TAG_SIG = "org.apache.taglibs.standard.tag.rt.core.ForEachTag.doStartTag()I";
    private static final String SET_VAR_SIG = "org.apache.taglibs.standard.tag.rt.core.ForEachTag.setVar(Ljava/lang/String;)V";
    private static final String SET_ITEMS_SIG = "org.apache.taglibs.standard.tag.rt.core.ForEachTag.setItems(Ljava/lang/Object;)V";

    @Override
    public boolean understands(MethodReference declaredTarget) {
        return declaredTarget.getSignature().equals(DO_START_TAG_SIG);
    }

    @Override
    public ITagLibDefInfo.ReachingDef getFact(SSAAbstractInvokeInstruction invoke, CGNode node, int i) {
        DefUse du;
        IR ir;
        int receiver = invoke.getReceiver();
        ITagLibDefInfo.ReachingDef baseReachingDef = this.getVarNameAndBaseExpr(receiver, ir = node.getIR(), du = node.getDU(), node);
        if (baseReachingDef == null) {
            TaintLogger.i().getLogger().debug((Object)("failed for c:forEach usage in " + node));
            return null;
        }
        NonVoidSyntheticExpr exprForVar = this.getExprForVar(baseReachingDef.getExpr());
        if (exprForVar == null) {
            TaintLogger.i().getLogger().debug((Object)("failed for c:forEach usage in " + node));
            return null;
        }
        return new ITagLibDefInfo.ReachingDef(baseReachingDef.getName(), exprForVar, baseReachingDef.getGlobalDecls());
    }

    private NonVoidSyntheticExpr getExprForVar(NonVoidSyntheticExpr baseExpr) {
        if (baseExpr instanceof InvokeExpr) {
            InvokeExpr invokeExpr = (InvokeExpr)baseExpr;
            String calleeSignature = invokeExpr.getCalleeVDBSignature();
            MethodReference methodRef = StringStuff.makeMethodReference((String)VDBJavaUtil.vdb2JVMSignature(calleeSignature));
            TypeReference returnType = methodRef.getReturnType();
            if (returnType.getName().toString().equals("Ljava/util/Collection")) {
                InvokeExpr iteratorCall = VDBJavaUtil.invokeFromJVMSig(null, "java.util.Collection.iterator()Ljava/util/Iterator;", Collections.singletonMap(0, baseExpr));
                InvokeExpr nextCall = VDBJavaUtil.invokeFromJVMSig(null, "java.util.Iterator.next()Ljava/lang/Object;", Collections.singletonMap(0, iteratorCall));
                return nextCall;
            }
            TaintLogger.i().getLogger().info((Object)("unhandled type for c:forEach items " + returnType));
        }
        return null;
    }

    private ITagLibDefInfo.ReachingDef getVarNameAndBaseExpr(int receiver, IR ir, DefUse du, CGNode node) {
        String varName = null;
        Pair<NonVoidSyntheticExpr, Set<BeanDecl>> baseExprAndBeanDecls = null;
        for (SSAInstruction use : Iterator2Iterable.make((Iterator)du.getUses(receiver))) {
            if (!(use instanceof SSAAbstractInvokeInstruction)) continue;
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)use;
            MethodReference declaredTarget = invoke.getDeclaredTarget();
            if (declaredTarget.getSignature().equals(SET_VAR_SIG)) {
                int setVarArg = invoke.getUse(1);
                varName = this.getSingleStringFlowingToValNum(ir, du, setVarArg);
                continue;
            }
            if (!declaredTarget.getSignature().equals(SET_ITEMS_SIG)) continue;
            int setItemsArg = invoke.getUse(1);
            baseExprAndBeanDecls = this.getExprForSetItemsArg(setItemsArg, ir, du, node);
        }
        if (varName == null) {
            TaintLogger.i().getLogger().debug((Object)"could not discover var name for c:forEach tag usage");
            return null;
        }
        if (baseExprAndBeanDecls == null) {
            TaintLogger.i().getLogger().debug((Object)"could not discover items expression for c:forEach tag usage");
            return null;
        }
        return new ITagLibDefInfo.ReachingDef(varName, (NonVoidSyntheticExpr)baseExprAndBeanDecls.fst, (Set)baseExprAndBeanDecls.snd);
    }

    private String getSingleStringFlowingToValNum(IR ir, DefUse du, int setVarArg) {
        StringConstantFlow flow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
        Collection possibleStrings = flow.findIntraprocStringsFlowingToVar(setVarArg);
        assert (possibleStrings.size() == 1);
        String varName = (String)possibleStrings.iterator().next();
        return varName;
    }

    private Pair<NonVoidSyntheticExpr, Set<BeanDecl>> getExprForSetItemsArg(int setItemsArg, IR ir, DefUse du, CGNode node) {
        SSAInstruction def = du.getDef(setItemsArg);
        if (def instanceof SSAAbstractInvokeInstruction) {
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)def;
            Pair<String, Integer> elEvaluateMethodSig = JasperInfo.makeDefault().getELEvaluateMethodSig();
            if (invoke.getDeclaredTarget().getSignature().equals(elEvaluateMethodSig.fst)) {
                int elExpArg = invoke.getUse(((Integer)elEvaluateMethodSig.snd).intValue());
                String elExp = this.getSingleStringFlowingToValNum(ir, du, elExpArg);
                return ElExpUtil.getSyntheticExprForElExp(node.getClassHierarchy(), node.getMethod(), invoke.getCallSite(), WalaUtil.getSourceLine(node.getMethod(), invoke.getCallSite()), elExp);
            }
        }
        return null;
    }
}

