/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.struts1;

import com.ibm.appscan.frameworks.analyzers.struts1.StrutsConfiguration;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsV1FrameworkHandler;
import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.IJavaEEDeploymentDescriptorInfo;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DeploymentDescriptorAnalyzer {
    private static final Logger logger = TaintLogger.i().getLogger();
    private final IJavaEEDeploymentDescriptorInfo ddInfo;
    private final IClassHierarchy cha;

    public DeploymentDescriptorAnalyzer(IJavaEEDeploymentDescriptorInfo ddInfo, IClassHierarchy cha) {
        this.ddInfo = ddInfo;
        this.cha = cha;
    }

    public Set<StrutsConfiguration> getStrutsConfigPaths() {
        String servletName = this.getStrutsServletName();
        List<Pair<String, String>> initParams = this.ddInfo.getInitParamsForServletName(servletName);
        HashSet result = HashSetFactory.make();
        boolean foundConfigParam = false;
        for (Pair<String, String> initParam : initParams) {
            if (!((String)initParam.fst).startsWith("config")) continue;
            result.add(new StrutsConfiguration((String)initParam.fst, (String)initParam.snd));
            foundConfigParam = true;
        }
        if (!foundConfigParam) {
            result.add(new StrutsConfiguration("config", "/WEB-INF/struts-config.xml"));
        }
        return result;
    }

    private String getStrutsServletName() {
        String servletClassName;
        if (this.cha != null) {
            Collection<String> strutsServletClassNames = StrutsV1FrameworkHandler.getStrutsServletNames(this.ddInfo, this.cha);
            assert (strutsServletClassNames.size() > 0);
            if (strutsServletClassNames.size() > 1) {
                logger.info((Object)("strange: multiple Struts ActionServlet sub-classes mapped in web.xml " + strutsServletClassNames));
            }
            servletClassName = strutsServletClassNames.iterator().next();
        } else {
            servletClassName = "org.apache.struts.action.ActionServlet";
        }
        Collection<String> servletNames = this.ddInfo.getServletNamesForServletClass(servletClassName);
        assert (servletNames.size() > 0);
        if (servletNames.size() > 1) {
            logger.info((Object)("strange: Struts servlet class mapped number times to names " + servletNames));
        }
        String servletName = servletNames.iterator().next();
        return servletName;
    }

    public String getStrutsURLPattern() {
        String servletName = this.getStrutsServletName();
        List<String> servletMappings = this.ddInfo.getServletMappings().get(servletName);
        if (servletMappings == null) {
            logger.warn((Object)"no servlet mapping for Struts servlet class");
            return null;
        }
        if (servletMappings.size() > 1) {
            logger.warn((Object)"multiple servlet mappings for Struts servlet class");
        }
        return servletMappings.get(0);
    }
}

