/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.parsers.strutsTilesParser;

import com.ibm.appscan.frameworks.parsers.strutsTilesParser.DefinitionImpl;
import com.ibm.appscan.frameworks.parsers.strutsTilesParser.IDefinition;
import com.ibm.appscan.frameworks.parsers.strutsTilesParser.IPut;
import com.ibm.appscan.frameworks.parsers.strutsTilesParser.IPutList;
import com.ibm.appscan.frameworks.parsers.strutsTilesParser.IStrutsTilesInfo;
import com.ibm.appscan.frameworks.parsers.strutsTilesParser.PutImpl;
import com.ibm.appscan.frameworks.parsers.strutsTilesParser.PutListImpl;
import com.ibm.appscan.frameworks.parsers.strutsTilesParser.StrutsTilesVersion;
import com.ibm.appscan.frameworks.util.DOMParserWithLineNumbers;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMBasedStrutsTilesInfo
implements IStrutsTilesInfo {
    private static final Logger logger = TaintLogger.i().getLogger();
    public static boolean verbose = true;
    private final List<IDefinition> definitions = new ArrayList<IDefinition>();
    private StrutsTilesVersion strutsTilesVersion;

    private DOMBasedStrutsTilesInfo(String fileName) throws IOException, SAXException {
        DOMParserWithLineNumbers parser = new DOMParserWithLineNumbers(fileName);
        Document document = parser.getDocument();
        this.populate(document);
        if (verbose) {
            logger.info((Object)("Loaded struts tiles configuration file: " + fileName + "\n" + this.toString()));
        }
    }

    @Override
    public List<IDefinition> getDefinitions() {
        return this.definitions;
    }

    public static IStrutsTilesInfo getStrutsParser(String strutsConfigPath) throws IOException, SAXException {
        if (verbose) {
            logger.info((Object)("Finding parser for struts tiles configuration file at " + strutsConfigPath));
        }
        return new DOMBasedStrutsTilesInfo(strutsConfigPath);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Struts Tiles Parser for " + (Object)((Object)this.strutsTilesVersion) + "\n");
        sb.append("Definitions:" + this.definitions.size() + "\n");
        return sb.toString();
    }

    @Override
    public String toDetailedString() {
        StringBuffer sb = new StringBuffer(this.toString());
        sb.append("Defintions:\n");
        for (IDefinition definition : this.definitions) {
            sb.append(definition + "\n");
        }
        return sb.toString();
    }

    private void populate(Document doc) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            this.populateDefinitions(doc, xpath);
            this.populateStrutsTilesVersion(doc, xpath);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void populateStrutsTilesVersion(Document doc, XPath xpath) {
        DocumentType doctype = doc.getDoctype();
        if (doctype == null) {
            this.strutsTilesVersion = StrutsTilesVersion.UNKNOWN;
            logger.warn((Object)"can't detect struts tiles configuration type.  no doctype in struts tiles config file");
            return;
        }
        String publicId = doctype.getPublicId();
        if (publicId != null) {
            this.strutsTilesVersion = StrutsTilesVersion.UNKNOWN_GLOBAL;
            if (publicId.startsWith("-//Apache Software Foundation//DTD Tiles Configuration 1.3")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD1_3;
            }
            if (publicId.startsWith("-//Apache Software Foundation//DTD Tiles Configuration 1.1")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD1_1;
            }
            if (publicId.equals("-//Apache Software Foundation//DTD Tiles Configuration")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD1_0;
            }
            if (publicId.equals("-//Apache Software Foundation//DTD Tiles Configuration//EN")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD1_0;
            }
            if (publicId.startsWith("-//Apache Software Foundation//DTD Tiles Configuration 2.0")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD2_0;
            }
            if (this.strutsTilesVersion.equals((Object)StrutsTilesVersion.UNKNOWN_GLOBAL)) {
                logger.warn((Object)"Can't detect the struts tiles configuration type of alobal struts configuration");
            }
            return;
        }
        String systemId = doctype.getSystemId();
        if (systemId != null) {
            this.strutsTilesVersion = StrutsTilesVersion.UNKNOWN_LOCAL;
            if (systemId.equals("http://struts.apache.org/dtds/tiles-config_2_0.dtd")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD2_0;
            }
            if (systemId.equals("http://struts.apache.org/dtds/tiles-config_1_3.dtd")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD1_3;
            }
            if (systemId.equals("http://struts.apache.org/dtds/tiles-config_1_1.dtd")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD1_1;
            }
            if (systemId.equals("http://struts.apache.org/dtds/tiles-config.dtd")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD1_0;
            }
            if (systemId.equals("http://jakarta.apache.org/struts/dtds/tiles-config_2_0.dtd")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD2_0;
            }
            if (systemId.equals("http://jakarta.apache.org/struts/dtds/tiles-config_1_3.dtd")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD1_3;
            }
            if (systemId.equals("http://jakarta.apache.org/struts/dtds/tiles-config_1_1.dtd")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD1_1;
            }
            if (systemId.equals("http://jakarta.apache.org/struts/dtds/tiles-config.dtd")) {
                this.strutsTilesVersion = StrutsTilesVersion.DTD1_0;
            }
        } else {
            this.strutsTilesVersion = StrutsTilesVersion.UNKNOWN;
            logger.warn((Object)"Can't detect the struts tiles configuration type. Public and System keys are missing");
        }
    }

    private void populateDefinitions(Document doc, XPath xpath) throws XPathExpressionException {
        XPathExpression definitionsXPath = xpath.compile("/tiles-definitions/*");
        NodeList nodes = (NodeList)definitionsXPath.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IDefinition definition = this.getDefinition(nodes.item(i), xpath);
            if (definition == null) continue;
            this.definitions.add(definition);
        }
    }

    private IDefinition getDefinition(Node item, XPath xpath) throws XPathExpressionException {
        if (item.getNodeName().equals("definition")) {
            List<IPut> putAttributes = this.getPutAttributesFromDefinition(item, xpath);
            List<IPutList> putListAttributes = this.getPutListAttributesFromDefinition(item, xpath);
            String name = this.getStringAttrValue(item, "name");
            String path = this.getStringAttrValue(item, "path");
            String extendsProp = this.getStringAttrValue(item, "extends");
            return new DefinitionImpl(name, extendsProp, path, putAttributes, putListAttributes);
        }
        return null;
    }

    private List<IPutList> getPutListAttributesFromDefinition(Node item, XPath xpath) throws XPathExpressionException {
        ArrayList<IPutList> result = new ArrayList<IPutList>();
        NodeList nodes = (NodeList)xpath.compile("putList").evaluate(item, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IPutList putlistAttribute = this.getPutListAttribute(nodes.item(i), xpath);
            if (putlistAttribute == null) continue;
            result.add(putlistAttribute);
        }
        return result;
    }

    private IPutList getPutListAttribute(Node item, XPath xpath) throws XPathExpressionException {
        if (item.getNodeName().equals("putList")) {
            if (item.getAttributes() == null) {
                logger.warn((Object)"Found put attribute with no attributes");
                return null;
            }
            String name = this.getStringAttrValue(item, "name");
            ArrayList<String> values = new ArrayList<String>();
            NodeList nodes = (NodeList)xpath.compile("add").evaluate(item, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node addItem = nodes.item(i);
                String value = this.getStringAttrValue(addItem, "value");
                values.add(value);
            }
            return new PutListImpl(name, values);
        }
        return null;
    }

    private List<IPut> getPutAttributesFromDefinition(Node item, XPath xpath) throws XPathExpressionException {
        ArrayList<IPut> result = new ArrayList<IPut>();
        NodeList nodes = (NodeList)xpath.compile("put").evaluate(item, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            IPut putAttribute = this.getPutAttribute(nodes.item(i), xpath);
            if (putAttribute == null) continue;
            result.add(putAttribute);
        }
        return result;
    }

    private IPut getPutAttribute(Node item, XPath xpath) throws XPathExpressionException {
        if (item.getNodeName().equals("put")) {
            if (item.getAttributes() == null) {
                logger.warn((Object)"Found put attribute with no attributes");
                return null;
            }
            String name = this.getStringAttrValue(item, "name");
            String value = this.getStringAttrValue(item, "value");
            return new PutImpl(name, value);
        }
        return null;
    }

    private String getStringAttrValue(Node item, String attrName) {
        Node value = item.getAttributes().getNamedItem(attrName);
        return value == null ? null : value.getNodeValue();
    }

    @Override
    public StrutsTilesVersion getStrutsTilesVersion() {
        return this.strutsTilesVersion;
    }
}

