/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.analysis.typeInference;

import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;

public class PointType
extends TypeAbstraction {
    private final IClass type;

    public PointType(IClass type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.type = type;
        assert (type.getReference().isReferenceType());
    }

    @Override
    public TypeAbstraction meet(TypeAbstraction rhs) {
        if (rhs == TOP) {
            return this;
        }
        if (rhs instanceof PointType) {
            PointType other = (PointType)rhs;
            if (this.type.equals(other.type)) {
                return this;
            }
            if (this.type.isArrayClass() || other.type.isArrayClass()) {
                return new ConeType(this.type.getClassHierarchy().getRootClass());
            }
            return new ConeType(this.type.getClassHierarchy().getLeastCommonSuperclass(this.type, other.type));
        }
        if (rhs instanceof ConeType) {
            ConeType other = (ConeType)rhs;
            if (this.type.equals(other.getType())) {
                return other;
            }
            TypeReference T = other.getType().getReference();
            if (this.type.isArrayClass() || T.isArrayType()) {
                return new ConeType(this.type.getClassHierarchy().getRootClass());
            }
            IClass typeKlass = this.type;
            if (this.type.getClassHierarchy().isSubclassOf(typeKlass, other.getType())) {
                return other;
            }
            if (other.isInterface() && this.type.getClassHierarchy().implementsInterface(typeKlass, other.getType())) {
                return other;
            }
            return other.meet(new ConeType(this.getType()));
        }
        Assertions.UNREACHABLE((String)("Unexpected type: " + rhs.getClass()));
        return null;
    }

    public String toString() {
        return "point: " + this.type.toString();
    }

    @Override
    public IClass getType() {
        return this.type;
    }

    @Override
    public TypeReference getTypeReference() {
        return this.type.getReference();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PointType)) {
            return false;
        }
        PointType other = (PointType)obj;
        if (!this.type.getClassHierarchy().equals(other.type.getClassHierarchy())) {
            Assertions.UNREACHABLE((String)("different chas " + this + " " + other));
        }
        return this.type.equals(other.type);
    }

    @Override
    public int hashCode() {
        return 37 * this.type.hashCode();
    }

    public boolean isArrayType() {
        return this.getType().isArrayClass();
    }

    public IClass getIClass() {
        return this.type;
    }
}

