/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cfg.exc.inter;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.exc.ExceptionPruningAnalysis;
import com.ibm.wala.cfg.exc.InterprocAnalysisResult;
import com.ibm.wala.cfg.exc.NullPointerAnalysis;
import com.ibm.wala.cfg.exc.inter.AnalysisUtil;
import com.ibm.wala.cfg.exc.inter.DelegatingMethodState;
import com.ibm.wala.cfg.exc.inter.InterprocAnalysisResultWrapper;
import com.ibm.wala.cfg.exc.inter.InterprocMethodState;
import com.ibm.wala.cfg.exc.inter.IntraprocAnalysisState;
import com.ibm.wala.cfg.exc.intra.MethodState;
import com.ibm.wala.cfg.exc.intra.NullPointerState;
import com.ibm.wala.cfg.exc.intra.ParameterState;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.PartialCallGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.graph.GraphIntegrity;
import com.ibm.wala.util.strings.Atom;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class InterprocNullPointerAnalysis {
    private CallGraph cgFiltered = null;
    private final TypeReference[] ignoredExceptions;
    private final MethodState defaultMethodState;
    private final Map<CGNode, IntraprocAnalysisState> states;
    private final boolean optHasExceptions;

    public static InterprocNullPointerAnalysis compute(TypeReference[] ignoredExceptions, CallGraph cg, MethodState defaultMethodState, MonitorUtil.IProgressMonitor progress, boolean optHasExceptions) throws WalaException, GraphIntegrity.UnsoundGraphException, CancelException {
        InterprocNullPointerAnalysis inpa = new InterprocNullPointerAnalysis(ignoredExceptions, defaultMethodState, optHasExceptions);
        inpa.run(cg, progress);
        return inpa;
    }

    private InterprocNullPointerAnalysis(TypeReference[] ignoredExceptions, MethodState defaultMethodState, boolean optHasExceptions) {
        this.ignoredExceptions = ignoredExceptions;
        this.defaultMethodState = defaultMethodState;
        this.states = new HashMap<CGNode, IntraprocAnalysisState>();
        this.optHasExceptions = optHasExceptions;
    }

    private void run(CallGraph cg, MonitorUtil.IProgressMonitor progress) throws WalaException, GraphIntegrity.UnsoundGraphException, CancelException {
        if (this.cgFiltered != null) {
            throw new IllegalStateException("This analysis has already been computed.");
        }
        this.cgFiltered = InterprocNullPointerAnalysis.computeFilteredCallgraph(cg);
        CGNode firstNode = (CGNode)this.cgFiltered.getNode(0);
        this.findAndInjectInvokes(firstNode, new ParameterState(), new HashSet<CGNode>(), progress);
    }

    private void findAndInjectInvokes(CGNode startNode, ParameterState paramState, Set<CGNode> visited, MonitorUtil.IProgressMonitor progress) throws GraphIntegrity.UnsoundGraphException, CancelException, WalaException {
        assert (paramState != null);
        if (visited.contains(startNode)) {
            return;
        }
        visited.add(startNode);
        MonitorUtil.throwExceptionIfCanceled((MonitorUtil.IProgressMonitor)progress);
        Map<CGNode, Map<SSAAbstractInvokeInstruction, ParameterState>> firstPass = this.analysisFirstPass(startNode, paramState, progress);
        for (Map.Entry<CGNode, Map<SSAAbstractInvokeInstruction, ParameterState>> nodeEntry : firstPass.entrySet()) {
            MonitorUtil.throwExceptionIfCanceled((MonitorUtil.IProgressMonitor)progress);
            CGNode node = nodeEntry.getKey();
            Map<SSAAbstractInvokeInstruction, ParameterState> invokes = nodeEntry.getValue();
            for (Map.Entry<SSAAbstractInvokeInstruction, ParameterState> instructionEntry : invokes.entrySet()) {
                this.findAndInjectInvokes(node, instructionEntry.getValue(), visited, progress);
            }
        }
        MonitorUtil.throwExceptionIfCanceled((MonitorUtil.IProgressMonitor)progress);
        this.analysisSecondPass(startNode, paramState, progress);
    }

    private void analysisSecondPass(CGNode startNode, ParameterState paramState, MonitorUtil.IProgressMonitor progress) throws GraphIntegrity.UnsoundGraphException, CancelException {
        IR ir = startNode.getIR();
        if (!AnalysisUtil.isFakeRoot(startNode) && ir != null && !ir.isEmptyIR()) {
            InterprocMethodState ims = new InterprocMethodState(startNode, this.cgFiltered, this.states);
            MethodState mState = this.defaultMethodState != null ? new DelegatingMethodState(this.defaultMethodState, ims) : ims;
            ExceptionPruningAnalysis<SSAInstruction, IExplodedBasicBlock> intra2 = NullPointerAnalysis.createIntraproceduralExplodedCFGAnalysis(this.ignoredExceptions, ir, paramState, mState, this.optHasExceptions);
            int deletedEdges2 = intra2.compute(progress);
            ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> cfg2 = intra2.getCFG();
            IntraprocAnalysisState singleState1 = this.states.get(startNode);
            int deletedEdges1 = singleState1.compute(progress);
            IntraprocAnalysisState singleState2 = new IntraprocAnalysisState(intra2, startNode, cfg2, deletedEdges2 + deletedEdges1);
            singleState2.setHasExceptions(intra2.hasExceptions());
            this.states.put(startNode, singleState2);
        }
    }

    private Map<CGNode, Map<SSAAbstractInvokeInstruction, ParameterState>> analysisFirstPass(CGNode startNode, ParameterState paramState, MonitorUtil.IProgressMonitor progress) throws GraphIntegrity.UnsoundGraphException, CancelException {
        HashMap<CGNode, Map<SSAAbstractInvokeInstruction, ParameterState>> result = new HashMap<CGNode, Map<SSAAbstractInvokeInstruction, ParameterState>>();
        IR ir = startNode.getIR();
        if (!startNode.getMethod().isStatic()) {
            paramState.setState(0, NullPointerState.State.NOT_NULL);
        }
        if (ir == null || ir.isEmptyIR()) {
            this.states.put(startNode, new IntraprocAnalysisState());
        } else {
            ExceptionPruningAnalysis<SSAInstruction, IExplodedBasicBlock> intra = NullPointerAnalysis.createIntraproceduralExplodedCFGAnalysis(this.ignoredExceptions, ir, paramState, this.defaultMethodState, this.optHasExceptions);
            int deletedEdges = intra.compute(progress);
            ControlFlowGraph<SSAInstruction, IExplodedBasicBlock> cfg = intra.getCFG();
            IntraprocAnalysisState info = new IntraprocAnalysisState(intra, startNode, cfg, deletedEdges);
            info.setHasExceptions(intra.hasExceptions());
            this.states.put(startNode, info);
            Set<IExplodedBasicBlock> invokeBlocks = AnalysisUtil.extractInvokeBlocks(cfg);
            for (IExplodedBasicBlock invokeBlock : invokeBlocks) {
                NullPointerState state = intra.getState(invokeBlock);
                SSAAbstractInvokeInstruction invokeInstruction = (SSAAbstractInvokeInstruction)invokeBlock.getInstruction();
                int[] parameterNumbers = AnalysisUtil.getParameterNumbers(invokeInstruction);
                ParameterState paramStateOfInvokeBlock = new ParameterState(state, parameterNumbers);
                Set<CGNode> targets = this.cgFiltered.getPossibleTargets(startNode, invokeInstruction.getCallSite());
                for (CGNode target : targets) {
                    HashMap<SSAAbstractInvokeInstruction, ParameterState> stateMap = new HashMap<SSAAbstractInvokeInstruction, ParameterState>();
                    stateMap.put(invokeInstruction, paramStateOfInvokeBlock);
                    result.put(target, stateMap);
                }
            }
        }
        return result;
    }

    public InterprocAnalysisResult<SSAInstruction, IExplodedBasicBlock> getResult() {
        return new InterprocAnalysisResultWrapper(this.states);
    }

    private static CallGraph computeFilteredCallgraph(CallGraph cg) {
        HashSet<Atom> filterSet = new HashSet<Atom>();
        Atom worldClinit = Atom.findOrCreateAsciiAtom("fakeWorldClinit");
        filterSet.add(worldClinit);
        filterSet.add(MethodReference.initAtom);
        CallGraphFilter filter = new CallGraphFilter(filterSet);
        return filter.filter(cg);
    }

    private static class CallGraphFilter {
        private Set<Atom> filter;

        private CallGraphFilter(HashSet<Atom> filterSet) {
            this.filter = filterSet;
        }

        private CallGraph filter(CallGraph fullCG) {
            HashSet<CGNode> nodes = new HashSet<CGNode>();
            Iterator iterator = fullCG.iterator();
            while (iterator.hasNext()) {
                CGNode n = (CGNode)iterator.next();
                nodes.add(n);
            }
            HashSet<CGNode> nodesToRemove = new HashSet<CGNode>();
            for (CGNode node : nodes) {
                for (Atom method : this.filter) {
                    if (!node.getMethod().getName().equals(method)) continue;
                    nodesToRemove.add(node);
                }
            }
            nodes.removeAll(nodesToRemove);
            HashSet<CGNode> partialRoots = new HashSet<CGNode>();
            partialRoots.add(fullCG.getFakeRootNode());
            PartialCallGraph partialCG1 = PartialCallGraph.make(fullCG, partialRoots, nodes);
            PartialCallGraph partialCG2 = PartialCallGraph.make(partialCG1, partialRoots);
            return partialCG2;
        }
    }
}

