/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.classLoader.ArrayClass;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.propagation.ClassBasedInstanceKeys;
import com.ibm.wala.ipa.callgraph.propagation.ConcreteTypeKey;
import com.ibm.wala.ipa.callgraph.propagation.ConstantKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.MultiNewArrayInNode;
import com.ibm.wala.ipa.callgraph.propagation.NormalAllocationInNode;
import com.ibm.wala.ipa.callgraph.propagation.ReceiverInstanceContext;
import com.ibm.wala.ipa.callgraph.propagation.ZeroLengthArrayInNode;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerContext;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ContainerContextSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.types.TypeReference;

public class AllocationSiteInNodeFactory
implements InstanceKeyFactory {
    private final AnalysisOptions options;
    private final IClassHierarchy cha;
    private final ClassBasedInstanceKeys classBased;

    public AllocationSiteInNodeFactory(AnalysisOptions options, IClassHierarchy cha) {
        this.options = options;
        this.cha = cha;
        this.classBased = new ClassBasedInstanceKeys(options, cha);
    }

    @Override
    public InstanceKey getInstanceKeyForAllocation(CGNode node, NewSiteReference allocation) {
        IMethod m;
        CGNode n;
        IClass type = this.options.getClassTargetSelector().getAllocatedTarget(node, allocation);
        if (type == null) {
            return null;
        }
        CGNode nodeToUse = node;
        if ((node.getContext() instanceof ReceiverInstanceContext || node.getContext() instanceof CallerContext) && (n = ContainerContextSelector.findNodeRecursiveMatchingContext(m = node.getMethod(), node.getContext())) != null) {
            nodeToUse = n;
        }
        if (type.isArrayClass()) {
            Integer c;
            IR ir = node.getIR();
            SSANewInstruction newInstruction = ir.getNew(allocation);
            int lengthVN = newInstruction.getUse(0);
            if (ir.getSymbolTable().isIntegerConstant(lengthVN) && (c = (Integer)ir.getSymbolTable().getConstantValue(lengthVN)) == 0) {
                return new ZeroLengthArrayInNode(nodeToUse, allocation, type);
            }
        }
        NormalAllocationInNode key = new NormalAllocationInNode(nodeToUse, allocation, type);
        return key;
    }

    @Override
    public InstanceKey getInstanceKeyForMultiNewArray(CGNode node, NewSiteReference allocation, int dim) {
        ArrayClass type = (ArrayClass)this.options.getClassTargetSelector().getAllocatedTarget(node, allocation);
        if (type == null) {
            return null;
        }
        MultiNewArrayInNode key = new MultiNewArrayInNode(node, allocation, type, dim);
        return key;
    }

    @Override
    public <T> InstanceKey getInstanceKeyForConstant(TypeReference type, T S) {
        if (this.options.getUseConstantSpecificKeys()) {
            return new ConstantKey<T>(S, this.cha.lookupClass(type));
        }
        return new ConcreteTypeKey(this.cha.lookupClass(type));
    }

    @Override
    public InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter pei, TypeReference type) {
        return this.classBased.getInstanceKeyForPEI(node, pei, type);
    }

    @Override
    public InstanceKey getInstanceKeyForMetadataObject(Object obj, TypeReference objType) {
        return this.classBased.getInstanceKeyForMetadataObject(obj, objType);
    }
}

