/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.properties;

import com.ibm.wala.util.PlatformUtil;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;

public final class WalaProperties {
    public static final String WALA_REPORT = "WALA_report";
    public static final String INPUT_DIR = "input_dir";
    public static final String OUTPUT_DIR = "output_dir";
    public static final String J2SE_DIR = "java_runtime_dir";
    public static final String J2EE_DIR = "j2ee_runtime_dir";
    public static final String ECLIPSE_PLUGINS_DIR = "eclipse_plugins_dir";
    public static final String ANDROID_RT_DEX_DIR = "android_rt_dir";
    public static final String ANDROID_RT_JAVA_JAR = "android_rt_jar";
    public static final String ANDROID_DEX_TOOL = "android_dx_tool";
    static final String PROPERTY_FILENAME = "wala.properties";

    public static String[] getJ2SEJarFiles() {
        Properties p = null;
        try {
            p = WalaProperties.loadProperties();
        }
        catch (WalaException e) {
            return PlatformUtil.getBootClassPathJars();
        }
        String dir = p.getProperty(J2SE_DIR);
        Assertions.productionAssertion((dir != null ? 1 : 0) != 0);
        return WalaProperties.getJarsInDirectory(dir);
    }

    public static String[] getJ2EEJarFiles() {
        Properties p = null;
        try {
            p = WalaProperties.loadProperties();
        }
        catch (WalaException e) {
            e.printStackTrace();
            throw new IllegalStateException("problem loading wala.properties");
        }
        String dir = p.getProperty(J2EE_DIR);
        if (dir == null) {
            throw new IllegalStateException("No J2EE directory specified");
        }
        return WalaProperties.getJarsInDirectory(dir);
    }

    public static String[] getJarsInDirectory(String dir) {
        File f = new File(dir);
        Assertions.productionAssertion((boolean)f.isDirectory(), (String)("not a directory: " + dir));
        Collection col = FileUtil.listFiles((String)dir, (String)".*\\.jar$", (boolean)true);
        String[] result = new String[col.size()];
        int i = 0;
        for (File jarFile : col) {
            result[i++] = jarFile.getAbsolutePath();
        }
        return result;
    }

    public static Properties loadProperties() throws WalaException {
        try {
            Properties result = WalaProperties.loadPropertiesFromFile(WalaProperties.class.getClassLoader(), PROPERTY_FILENAME);
            String outputDir = result.getProperty(OUTPUT_DIR, "results");
            result.setProperty(OUTPUT_DIR, WalaProperties.convertToAbsolute(outputDir));
            String walaReport = result.getProperty(WALA_REPORT, "wala_report.txt");
            result.setProperty(WALA_REPORT, WalaProperties.convertToAbsolute(walaReport));
            return result;
        }
        catch (Exception e) {
            throw new WalaException("Unable to set up wala properties ", (Throwable)e);
        }
    }

    static String convertToAbsolute(String path) {
        File file = new File(path);
        return file.isAbsolute() ? file.getAbsolutePath() : WalaProperties.getWalaHomeDir().concat(File.separator).concat(path);
    }

    public static Properties loadPropertiesFromFile(ClassLoader loader, String fileName) throws IOException {
        if (loader == null) {
            throw new IllegalArgumentException("loader is null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        InputStream propertyStream = loader.getResourceAsStream(fileName);
        if (propertyStream == null) {
            Properties defprop = new Properties();
            defprop.setProperty(OUTPUT_DIR, "./out");
            defprop.setProperty(INPUT_DIR, "./in");
            defprop.setProperty(ECLIPSE_PLUGINS_DIR, "./plugins");
            defprop.setProperty(WALA_REPORT, "./wala_report.txt");
            defprop.setProperty(J2EE_DIR, "./j2ee");
            String j2selib = WalaProperties.guessJavaLib();
            defprop.setProperty(J2SE_DIR, j2selib);
            return defprop;
        }
        Properties result = new Properties();
        result.load(propertyStream);
        if (!result.containsKey(J2SE_DIR)) {
            String j2selib = WalaProperties.guessJavaLib();
            result.setProperty(J2SE_DIR, j2selib);
        }
        return result;
    }

    public static String guessJavaLib() throws IOException {
        Properties p = System.getProperties();
        String home = System.getProperty("java.home");
        String bestGuess = home + File.separator + "lib";
        String os = p.getProperty("os.name");
        if (os.contains("Mac OS X")) {
            File rt;
            File f = new File(bestGuess);
            if (f.exists() && f.isDirectory() && (rt = new File(bestGuess + File.separator + "rt.jar")).exists() && rt.isFile()) {
                return bestGuess;
            }
            File guess1 = new File("/System/Library/Frameworks/JavaVM.framework/Classes");
            if (guess1.exists() && guess1.isDirectory()) {
                return "/System/Library/Frameworks/JavaVM.framework/Classes";
            }
            throw new IOException("Could not guess java.home for OSX. Please create a wala.properties file and set it manually.");
        }
        return bestGuess;
    }

    @Deprecated
    public static String getWalaHomeDir() {
        String envProperty = System.getProperty("WALA_HOME");
        if (envProperty != null) {
            return envProperty;
        }
        URL url = WalaProperties.class.getClassLoader().getResource(PROPERTY_FILENAME);
        if (url == null) {
            return System.getProperty("user.dir");
        }
        return new File(new FileProvider().filePathFromURL(url)).getParentFile().getParentFile().getPath();
    }
}

