/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;

public abstract class SSANewInstruction
extends SSAInstruction {
    private final int result;
    private final NewSiteReference site;
    private final int[] params;

    protected SSANewInstruction(int iindex, int result, NewSiteReference site) throws IllegalArgumentException {
        super(iindex);
        if (site == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        this.result = result;
        this.site = site;
        this.params = null;
    }

    protected SSANewInstruction(int iindex, int result, NewSiteReference site, int[] params) {
        super(iindex);
        if (params == null) {
            throw new IllegalArgumentException("params is null");
        }
        if (site == null) {
            throw new IllegalArgumentException("site is null");
        }
        assert (site.getDeclaredType().isArrayType() || site.getDeclaredType().getClassLoader().getLanguage() != ClassLoaderReference.Java);
        this.result = result;
        this.site = site;
        this.params = new int[params.length];
        System.arraycopy(params, 0, this.params, 0, params.length);
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (this.params == null) {
            return insts.NewInstruction(this.iindex, defs == null ? this.result : defs[0], this.site);
        }
        return insts.NewInstruction(this.iindex, defs == null ? this.result : defs[0], this.site, uses == null ? this.params : uses);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return this.getValueString(symbolTable, this.result) + " = new " + this.site.getDeclaredType() + "@" + this.site.getProgramCounter() + (this.params == null ? "" : this.array2String(this.params, symbolTable));
    }

    private String array2String(int[] params, SymbolTable symbolTable) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            result.append(this.getValueString(symbolTable, params[i]));
            result.append(" ");
        }
        return result.toString();
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitNew(this);
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public int getDef(int i) {
        assert (i == 0);
        return this.result;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    public TypeReference getConcreteType() {
        return this.site.getDeclaredType();
    }

    public NewSiteReference getNewSite() {
        return this.site;
    }

    @Override
    public int hashCode() {
        return this.result * 7529 + this.site.getDeclaredType().hashCode();
    }

    @Override
    public int getNumberOfUses() {
        return this.params == null ? 0 : this.params.length;
    }

    @Override
    public int getUse(int j) {
        assert (this.params != null) : "expected params but got null in " + this.toString();
        assert (this.params.length > j) : "found too few parameters";
        return this.params[j];
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }
}

