/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.warnings;

import com.ibm.wala.util.debug.Assertions;

public abstract class Warning
implements Comparable {
    public static final byte MILD = 0;
    public static final byte MODERATE = 1;
    public static final byte SEVERE = 2;
    public static final byte CLIENT_MILD = 3;
    public static final byte CLIENT_MODERATE = 4;
    public static final byte CLIENT_SEVERE = 5;
    public static final byte N_LEVELS = 6;
    private byte level;

    public Warning(byte level) {
        this.level = level;
    }

    public Warning() {
        this.level = 0;
    }

    public int compareTo(Object o) throws ClassCastException {
        if (o == null) {
            return -1;
        }
        Warning other = (Warning)o;
        if (this.level < other.level) {
            return -1;
        }
        if (this.level > other.level) {
            return 1;
        }
        return this.getMsg().compareTo(other.getMsg());
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Warning) {
            Warning other = (Warning)obj;
            return this.getMsg().equals(other.getMsg()) && this.getLevel() == other.getLevel();
        }
        return false;
    }

    public final int hashCode() {
        return 1499 * this.getMsg().hashCode() + this.getLevel();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[").append(this.severityString()).append("] ");
        result.append(this.getMsg());
        return result.toString();
    }

    protected String severityString() {
        switch (this.level) {
            case 0: {
                return "mild";
            }
            case 1: {
                return "Moderate";
            }
            case 2: {
                return "SEVERE";
            }
            case 3: {
                return "Client mild";
            }
            case 4: {
                return "Client moderate";
            }
            case 5: {
                return "Client severe";
            }
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public byte getLevel() {
        return this.level;
    }

    public abstract String getMsg();

    public void setLevel(byte b) {
        this.level = b;
    }
}

