/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.aspdotnetmvc3;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.aspdotnet.util.DotNetVDBUtil;
import com.ibm.appscan.frameworks.aspdotnet.util.Utils;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FActionProcessor;
import com.ibm.appscan.frameworks.specinfo.ArgToOrigCallExpr;
import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.TaintExpr;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.MapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CallReplacementCreator {
    private F4FApp app;
    private F4FActions actions;
    private final Map<String, WriteToGlobalInfo> callReplacementSig2WriteToGlobalInfo = HashMapFactory.make();
    private final Map<Pattern, Integer> callReplacementSig4TaintParam = HashMapFactory.make();
    private final List<Pattern> callReplacementSig4ReadFromGlobalInfo = new ArrayList<Pattern>();
    private final List<String> methodsWithoutViews = new ArrayList<String>();
    private final Logger taintLogger = TaintLogger.i().getLogger();

    public CallReplacementCreator(F4FApp app, F4FActions actions) {
        this.app = app;
        this.actions = actions;
    }

    public boolean addMethodWithoutViews(String signature) {
        return this.methodsWithoutViews.add(signature);
    }

    public void generateCallReplacements() {
        this.addCallReplacementForModelUpdate();
        this.replaceCallsWithWriteToGlobals();
        this.replaceCallsWithReadFromGlobals();
        this.createWAFLForCallReplacements();
    }

    private void addCallReplacementForModelUpdate() {
        String paramVdbSigRegx = ".+";
        String vdbSigRegx4TryUpdateModel = "System\\.Web\\.Mvc\\.Controller\\.TryUpdateModel(" + paramVdbSigRegx + "):System.Boolean";
        Pattern vdbSigPattern4TryUpdateModel = Pattern.compile(vdbSigRegx4TryUpdateModel);
        this.callReplacementSig4TaintParam.put(vdbSigPattern4TryUpdateModel, new Integer(1));
        String vdbSigRegx4UpdateModel = "System\\.Web\\.Mvc\\.Controller\\.UpdateModel(" + paramVdbSigRegx + "):System.Void";
        Pattern vdbSigPattern4UpdateModel = Pattern.compile(vdbSigRegx4UpdateModel);
        this.callReplacementSig4TaintParam.put(vdbSigPattern4UpdateModel, new Integer(1));
    }

    private void replaceCallsWithWriteToGlobals() {
        String vdbSigForViewCtor1 = "System.Web.Mvc.Controller.View(System.Object):System.Web.Mvc.ViewResult";
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{vdbSigForViewCtor1, "request"}));
        this.addCallReplacementWithWritingToGlobal(vdbSigForViewCtor1, "request", 1, 1);
        String vdbSigForViewCtor2 = "System.Web.Mvc.Controller.View(System.String;System.Object):System.Web.Mvc.ViewResult";
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{vdbSigForViewCtor2, "request"}));
        this.addCallReplacementWithWritingToGlobal(vdbSigForViewCtor2, "request", 2, 2);
        String vdbSigForViewCtor3 = "System.Web.Mvc.Controller.View(System.Web.Mvc.IView;System.Object):System.Web.Mvc.ViewResult";
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{vdbSigForViewCtor3, "request"}));
        this.addCallReplacementWithWritingToGlobal(vdbSigForViewCtor3, "request", 2, 2);
        String vdbSigForViewCtor4 = "System.Web.Mvc.Controller.View(System.String;System.String;System.Object):System.Web.Mvc.ViewResult";
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{vdbSigForViewCtor4, "request"}));
        this.addCallReplacementWithWritingToGlobal(vdbSigForViewCtor4, "request", 3, 3);
        String vdbSigForPartialviewCtor1 = "System.Web.Mvc.Controller.PartialView(System.Object):System.Web.Mvc.PartialViewResult";
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{vdbSigForPartialviewCtor1, "request"}));
        this.addCallReplacementWithWritingToGlobal(vdbSigForPartialviewCtor1, "request", 1, 1);
        String vdbSigForPartialviewCtor2 = "System.Web.Mvc.Controller.PartialView(System.String;System.Object):System.Web.Mvc.PartialViewResult";
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.replace.call.write", (Object[])new Object[]{vdbSigForPartialviewCtor2, "request"}));
        this.addCallReplacementWithWritingToGlobal(vdbSigForPartialviewCtor2, "request", 2, 2);
    }

    private void replaceCallsWithReadFromGlobals() {
        String paramVdbSigRegx = ".+";
        String vdbSigRegx4GetModel = "System\\.Web\\.Mvc\\.WebViewPage&lt;" + paramVdbSigRegx + "&gt;\\.get_Model\\(\\):" + paramVdbSigRegx;
        Pattern vdbSigPattern4GetModel = Pattern.compile(vdbSigRegx4GetModel);
        this.callReplacementSig4ReadFromGlobalInfo.add(vdbSigPattern4GetModel);
    }

    private void addCallReplacementWithWritingToGlobal(String VdbSigForTheCall, String globalNamePrefix, int paraIndexToGetGlobalNameSuffix, int paraIndex4RSE) {
        if (this.callReplacementSig2WriteToGlobalInfo.containsKey(VdbSigForTheCall)) {
            throw new IllegalArgumentException("already have a replaceCallsWithWritingToGlobals for calls to " + VdbSigForTheCall);
        }
        this.callReplacementSig2WriteToGlobalInfo.put(VdbSigForTheCall, new WriteToGlobalInfo(globalNamePrefix, paraIndexToGetGlobalNameSuffix, paraIndex4RSE));
    }

    private void createWAFLForCallReplacements() {
        if (this.callReplacementSig2WriteToGlobalInfo.isEmpty()) {
            return;
        }
        AnalysisCache cache = new AnalysisCache();
        IClassHierarchy cha = this.app.getClassHierarchy();
        HashSet globalBeans = HashSetFactory.make();
        HashMap callReplacements = HashMapFactory.make();
        for (IClass klass : cha) {
            if (klass.isInterface()) continue;
            Language lang = klass.getClassLoader().getLanguage();
            if (!cha.getScope().isApplicationLoader(klass.getClassLoader())) continue;
            Collection declaredMethods = null;
            try {
                declaredMethods = klass.getDeclaredMethods();
            }
            catch (Exception e) {
                TaintLogger.i().getLogger().info((Object)("Cannot get declared methods from class " + klass.toString() + ".  Skip."));
                continue;
            }
            for (IMethod m : declaredMethods) {
                if (m.isAbstract()) continue;
                IR ir = null;
                try {
                    ir = LangIndependentWalaUtil.getIR((IMethod)m, (AnalysisCache)cache);
                }
                catch (Exception e) {
                    TaintLogger.i().getLogger().info((Object)("Cannot retrieve IR for method: " + m.toString() + ".  Skip."));
                }
                TypeInference ti = null;
                if (ir == null) continue;
                block12: for (SSAInstruction instr : Iterator2Iterable.make((Iterator)ir.iterateNormalInstructions())) {
                    CallSiteReplacement replacement;
                    boolean skipReplacement;
                    if (!(instr instanceof SSAAbstractInvokeInstruction)) continue;
                    SSAAbstractInvokeInstruction call = (SSAAbstractInvokeInstruction)instr;
                    CallSiteReference callSiteRef = call.getCallSite();
                    MethodReference targetRef = callSiteRef.getDeclaredTarget();
                    String vdbTargetName = null;
                    try {
                        vdbTargetName = F4FActionProcessor.getVDBSig((MethodReference)targetRef, (Language)lang, (IClassHierarchy)cha);
                    }
                    catch (Exception e) {
                        this.taintLogger.info((Object)("AspDotNetMvc3Handler::Failed to get targetName for targetRef " + targetRef.toString()));
                    }
                    if (vdbTargetName == null) continue;
                    boolean bl = skipReplacement = this.methodsWithoutViews.contains(m.getSignature()) && (vdbTargetName.startsWith("System.Web.Mvc.Controller.View") || vdbTargetName.startsWith("System.Web.Mvc.Controller.PartialView"));
                    if (!skipReplacement) {
                        if (this.callReplacementSig2WriteToGlobalInfo.containsKey(vdbTargetName)) {
                            WriteToGlobalInfo write2GlobalInfo = this.callReplacementSig2WriteToGlobalInfo.get(vdbTargetName);
                            if (ti == null) {
                                ti = TypeInference.make((IR)ir, (boolean)true);
                            }
                            TypeReference storedObjType = ti.getType(call.getUse(write2GlobalInfo.getParaIndex4RightSideExpr())).getTypeReference();
                            String typeName = "System.Object";
                            if (storedObjType != null) {
                                try {
                                    typeName = DotNetVDBUtil.convertWalaDotNetGenericSig2VDB((TypeReference)storedObjType, (IClassHierarchy)cha);
                                }
                                catch (Exception e) {
                                    this.taintLogger.warn((Object)("AspDotNetMvc3Handler::Failed to convert WALA .NET generic Signature to VDB signature. Exception: " + e.toString()));
                                }
                            }
                            if (typeName.startsWith("System.Collections.Generic.")) {
                                typeName = "System.Object";
                            }
                            String globalId = write2GlobalInfo.globalNamePrefix + "." + typeName;
                            ObjectRefExpr lval = null;
                            lval = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)globalId), (String)"");
                            ArgToOrigCallExpr rval = ArgToOrigCallExpr.make((int)write2GlobalInfo.getParaIndex4RightSideExpr());
                            FilePositionInfo filePosInfo = Utils.getMethodPosition((IMethod)m);
                            AssignmentExpr assignment = AssignmentExpr.make((FilePositionInfo)filePosInfo, (AssignableSyntheticExpr)lval, (NonVoidSyntheticExpr)rval);
                            int bcIndex = callSiteRef.getProgramCounter();
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call.replacement", (Object[])new Object[]{vdbTargetName, m.getName().toString()}));
                            CallSiteReplacement replacement2 = CallSiteReplacement.make((String)vdbTargetName, (int)bcIndex, (int)WalaUtil.getSourceLine((IMethod)m, (CallSiteReference)callSiteRef), (SyntheticExpr)assignment);
                            MapUtil.findOrCreateSet((Map)callReplacements, (Object)F4FActionProcessor.getVDBSig((MethodReference)m.getReference(), (Language)lang, (IClassHierarchy)cha)).add(replacement2);
                            globalBeans.add(BeanDecl.makeWithConcreteType((String)globalId, (String)typeName, (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.ENTRYPOINT));
                        }
                        for (int i = 0; i < this.callReplacementSig4ReadFromGlobalInfo.size(); ++i) {
                            Pattern currPattern = this.callReplacementSig4ReadFromGlobalInfo.get(i);
                            if (vdbTargetName == null) break;
                            Matcher currMatcher = currPattern.matcher(vdbTargetName);
                            if (!currMatcher.matches()) continue;
                            ArgToOrigCallExpr lhs = ArgToOrigCallExpr.make((int)-1);
                            if (ti == null) {
                                ti = TypeInference.make((IR)ir, (boolean)true);
                            }
                            String returnParamType = vdbTargetName.substring(vdbTargetName.lastIndexOf(":") + 1);
                            String globalVariableName = "request." + returnParamType;
                            ObjectRefExpr rhs = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)globalVariableName), (String)"");
                            FilePositionInfo filePosInfo = Utils.getMethodPosition((IMethod)m);
                            AssignmentExpr assignment = AssignmentExpr.make((FilePositionInfo)filePosInfo, (AssignableSyntheticExpr)lhs, (NonVoidSyntheticExpr)rhs);
                            int bcIndex = callSiteRef.getProgramCounter();
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call.replacement", (Object[])new Object[]{vdbTargetName, m.getName().toString()}));
                            replacement = CallSiteReplacement.make((String)vdbTargetName, (int)bcIndex, (int)WalaUtil.getSourceLine((IMethod)m, (CallSiteReference)callSiteRef), (SyntheticExpr)assignment);
                            MapUtil.findOrCreateSet((Map)callReplacements, (Object)F4FActionProcessor.getVDBSig((MethodReference)m.getReference(), (Language)lang, (IClassHierarchy)cha)).add(replacement);
                            TypeReference storedObjType = ti.getType(call.getReturnValue(0)).getTypeReference();
                            String typeName = "System.Object";
                            if (storedObjType != null) {
                                try {
                                    typeName = DotNetVDBUtil.convertWalaDotNetGenericSig2VDB((TypeReference)storedObjType, (IClassHierarchy)cha);
                                }
                                catch (Exception e) {
                                    this.taintLogger.warn((Object)("AspDotNetMvc3Handler::Failed to convert WALA .NET generic Signature to VDB signature. Exception: " + e.toString()));
                                }
                            }
                            if (typeName.startsWith("System.Collections.Generic.")) {
                                typeName = "System.Object";
                            }
                            globalBeans.add(BeanDecl.makeWithConcreteType((String)globalVariableName, (String)typeName, (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.ENTRYPOINT));
                        }
                    }
                    Set<Pattern> PatternSet = this.callReplacementSig4TaintParam.keySet();
                    for (Pattern currPattern : PatternSet) {
                        String tModelTypeVdbSig;
                        int end;
                        if (vdbTargetName == null) continue block12;
                        Matcher currMatcher = currPattern.matcher(vdbTargetName);
                        Integer taintedParamIndex = this.callReplacementSig4TaintParam.get(currPattern);
                        if (!currMatcher.matches()) continue;
                        FilePositionInfo filePosInfo = Utils.getMethodPosition((IMethod)m);
                        ArgToOrigCallExpr lhs = ArgToOrigCallExpr.make((int)taintedParamIndex);
                        TaintExpr rhs = TaintExpr.makeForParameter((String)"model");
                        AssignmentExpr assignment = AssignmentExpr.make((FilePositionInfo)filePosInfo, (AssignableSyntheticExpr)lhs, (NonVoidSyntheticExpr)rhs);
                        int bcIndex = callSiteRef.getProgramCounter();
                        if (vdbTargetName.startsWith("System.Web.Mvc.Controller.TryUpdateModel")) {
                            int start = "System.Web.Mvc.Controller.TryUpdateModel".length();
                            end = vdbTargetName.indexOf(";");
                            int n = end = end <= 0 ? vdbTargetName.indexOf(")") : end;
                            if (start > 0 && end > 0 && start + 1 < end) {
                                tModelTypeVdbSig = vdbTargetName.substring(start + 1, end);
                                vdbTargetName = "System.Web.Mvc.Controller.TryUpdateModel&lt;" + tModelTypeVdbSig + ">" + vdbTargetName.substring(start);
                                System.out.println("update vdbTargetName for TryUpdateModel = " + vdbTargetName);
                            } else {
                                this.taintLogger.warn((Object)("AspDotNetMvc3Handler::Failed to upate the VDB signature for TryUpdateModel(). Its VdbSig = " + vdbTargetName));
                            }
                        }
                        if (vdbTargetName.startsWith("System.Web.Mvc.Controller.UpdateModel")) {
                            int start = "System.Web.Mvc.Controller.UpdateModel".length();
                            end = vdbTargetName.indexOf(";");
                            int n = end = end <= 0 ? vdbTargetName.indexOf(")") : end;
                            if (start > 0 && end > 0 && start + 1 < end) {
                                tModelTypeVdbSig = vdbTargetName.substring(start + 1, end);
                                vdbTargetName = "System.Web.Mvc.Controller.UpdateModel&lt;" + tModelTypeVdbSig + ">" + vdbTargetName.substring(start);
                                System.out.println("update vdbTargetName for UpdateModel = " + vdbTargetName);
                            } else {
                                this.taintLogger.warn((Object)("AspDotNetMvc3Handler::Failed to upate the VDB signature for UpdateModel(). Its VdbSig = " + vdbTargetName));
                            }
                        }
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call.replacement", (Object[])new Object[]{vdbTargetName, m.getName().toString()}));
                        replacement = CallSiteReplacement.make((String)vdbTargetName, (int)bcIndex, (int)WalaUtil.getSourceLine((IMethod)m, (CallSiteReference)callSiteRef), (SyntheticExpr)assignment);
                        MapUtil.findOrCreateSet((Map)callReplacements, (Object)F4FActionProcessor.getVDBSig((MethodReference)m.getReference(), (Language)lang, (IClassHierarchy)cha)).add(replacement);
                    }
                }
            }
        }
        F4FActionProcessor.addCallReplacements((Map)callReplacements);
        for (BeanDecl global : globalBeans) {
            this.taintLogger.info((Object)Messages.getString((String)"framework.generate.global", (Object[])new Object[]{global.getId()}));
            this.actions.createGlobal(global.getId(), global.getType(), global.getLifespan() == BeanDecl.BeanLifespan.ENTRYPOINT);
        }
    }

    public class WriteToGlobalInfo {
        private String globalNamePrefix;
        private int paraIndexToGetGlobalNameSuffix;
        private int paraIndex4RightSideExpr;

        public WriteToGlobalInfo(String globalNamePrefix, int paraIndexToGetGlobalNameSuffix, int paraIndex4RightSideExpr) {
            this.globalNamePrefix = globalNamePrefix;
            this.paraIndexToGetGlobalNameSuffix = paraIndexToGetGlobalNameSuffix;
            this.paraIndex4RightSideExpr = paraIndex4RightSideExpr;
        }

        public String getGlobalNamePrefix() {
            return this.globalNamePrefix;
        }

        public int getParaIndexToGetGlobalNameSuffix() {
            return this.paraIndexToGetGlobalNameSuffix;
        }

        public int getParaIndex4RightSideExpr() {
            return this.paraIndex4RightSideExpr;
        }
    }
}

