/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.model;

import com.hcl.appscan.common.error.ComponentException;
import com.ibm.appscan.common.utils.functional.Lazy;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.model.AbstractRemoteIcaModel;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.ao.ActionObject;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class IcaSinkVulnModel
extends AbstractRemoteIcaModel {
    private Lazy<HashMap<String, VDBEnums.SEVERITY>> m_vulnSeverity = Lazy.of(IcaSinkVulnModel::getVulnSeverityMap);

    IcaSinkVulnModel() {
        this.m_batchSize = 1;
        this.m_parallelRequests = 4;
        this.m_serviceName = "ica-vuln-service";
        this.m_path = "/v2/models/ica-sink-vuln";
    }

    @Override
    public JSONObject toJson(Collection<Method> batch) throws ComponentException {
        ArrayList<Integer> shape = new ArrayList<Integer>(2);
        shape.add(batch.size());
        shape.add(1);
        try {
            return new JSONObject().put("inputs", (Object[])new JSONObject[]{new JSONObject().put("name", (Object)"signature").put("shape", shape).put("datatype", (Object)"BYTES").put("parameters", (Map)new JSONObject().put("content_type", (Object)"str")).put("data", (Collection)batch.stream().map(m -> m.getSignature()).collect(Collectors.toList()))});
        }
        catch (JSONException e) {
            throw new ComponentException((Throwable)e);
        }
    }

    @Override
    void applyMarkup(Method m, String prediction) throws MarkupException {
        try {
            if (VdbProvider.getPropertyProvider().getPropertyId(prediction) != 0) {
                try {
                    if (!((HashMap)this.m_vulnSeverity.get()).keySet().contains(prediction)) {
                        prediction = "Vulnerability.Validation.Required";
                    }
                    VDBEnums.SEVERITY severity = (VDBEnums.SEVERITY)((HashMap)this.m_vulnSeverity.get()).get(prediction);
                    for (ActionObject ao : m.getSinks()) {
                        ao.setVulnerability(prediction);
                        ao.setSeverity(severity);
                    }
                    m.addComment("Vulnerability Type: " + prediction);
                    m.addComment("Severity: " + severity);
                    return;
                }
                catch (BadMarkupException badMarkupException) {}
            }
        }
        catch (VDBGeneralException vDBGeneralException) {
            // empty catch block
        }
        m.addComment("Vulnerability Type: Vulnerability.Validation.Required");
        m.addComment("Severity: MEDIUM");
    }

    private static HashMap<String, VDBEnums.SEVERITY> getVulnSeverityMap() {
        HashMap<String, VDBEnums.SEVERITY> map = new HashMap<String, VDBEnums.SEVERITY>(26);
        map.put("Vulnerability.AppDOS", VDBEnums.SEVERITY.Low);
        map.put("Vulnerability.Injection.DBConnectionString", VDBEnums.SEVERITY.Low);
        map.put("Vulnerability.Injection.HttpRequestSplitting", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.Injection.HttpResponseSplitting", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.Injection.LDAP", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.Injection.Mail", VDBEnums.SEVERITY.Low);
        map.put("Vulnerability.Injection.NoSQL", VDBEnums.SEVERITY.High);
        map.put("Vulnerability.Injection.OS", VDBEnums.SEVERITY.High);
        map.put("Vulnerability.Injection.SQL", VDBEnums.SEVERITY.High);
        map.put("Vulnerability.Injection.SecondOrder", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.Injection.XML", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.Injection.XPath", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.JSON.Hijacking", VDBEnums.SEVERITY.Low);
        map.put("Vulnerability.Logging.Forge", VDBEnums.SEVERITY.Low);
        map.put("Vulnerability.Malicious.DynamicCode.Construction", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.Malicious.DynamicCode.Execution", VDBEnums.SEVERITY.High);
        map.put("Vulnerability.Malicious.DynamicCode.Loading", VDBEnums.SEVERITY.High);
        map.put("Vulnerability.Phishing.Email", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.Quality.TestCode", VDBEnums.SEVERITY.Low);
        map.put("Vulnerability.Validation.EncodingRequired", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.Validation.Required.DBConnectionStringManipulation", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.Validation.Required.URL.Domain", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.Validation.Required.URL.Port", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.Validation.Required.URL.Redirect", VDBEnums.SEVERITY.Medium);
        map.put("Vulnerability.Validation.Required.WriteToSocket", VDBEnums.SEVERITY.High);
        map.put("Vulnerability.Validation.Required", VDBEnums.SEVERITY.Medium);
        return map;
    }
}

