/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.weblogic.compilers;

import com.ibm.appscan.common.build.BuilderDefinition;
import com.ibm.appscan.common.model.xml.IModelXMLConstants;
import com.ibm.appscan.common.xml.XMLFileReader;
import com.ibm.appscan.internal.discovery.weblogic.compilers.WeblogicJSPCompiler;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.stream.events.StartElement;

public class WeblogicJSPCompilerDefinition
extends BuilderDefinition {
    private File m_weblogic;
    private String m_version;
    private String[] m_classpathEntries;
    private static final String WLSERVER_12 = "wlserver";
    private static final String WLSERVER_10 = "wlserver_10.3";
    private static final String WEBLOGIC_JAR = "weblogic.jar";
    private static final String LIB_PATH = File.separator + "server" + File.separator + "lib" + File.separator;
    private static final String MODULE_PATH = File.separator + "modules";

    private boolean initClasspathEntries(String classpathFile) {
        File cpFile = new File(classpathFile);
        String wls_path = this.m_weblogic.getPath() + File.separator;
        ArrayList<String> entries = new ArrayList<String>();
        if (!cpFile.exists()) {
            return false;
        }
        entries.add(cpFile.getPath());
        if (this.m_version.equals("12")) {
            entries.add(wls_path + "oracle_common" + MODULE_PATH);
            entries.add(wls_path + WLSERVER_12 + MODULE_PATH);
            entries.add(wls_path + WLSERVER_12 + LIB_PATH);
        } else if (this.m_version.equals("10")) {
            entries.add(wls_path + WLSERVER_10 + LIB_PATH);
            entries.add(wls_path + MODULE_PATH);
        }
        this.m_classpathEntries = entries.toArray(new String[entries.size()]);
        return true;
    }

    protected boolean init(Map<String, String> properties) {
        String suffix;
        this.m_version = properties.get(VERSION);
        String weblogic = properties.get("path");
        if (weblogic == null || !(this.m_weblogic = new File(weblogic)).exists()) {
            return false;
        }
        File registry = new File(weblogic, "registry.xml");
        if (!registry.exists()) {
            registry = Paths.get(weblogic, "inventory", "registry.xml").toFile();
        }
        String jar_path = null;
        if (registry.exists()) {
            try {
                WeblogicRegistryReader reader = new WeblogicRegistryReader(registry);
                reader.read();
                jar_path = reader.getInstallPath();
            }
            catch (Exception reader) {
                // empty catch block
            }
        }
        if (jar_path == null && !new File(jar_path = Paths.get(weblogic, WLSERVER_10).toString()).exists()) {
            jar_path = Paths.get(weblogic, WLSERVER_12).toString();
        }
        if (!jar_path.endsWith(suffix = this.m_version.equals("10") ? WLSERVER_10 : WLSERVER_12)) {
            jar_path = jar_path + File.separator;
            jar_path = jar_path + suffix;
        }
        String weblogicJar = LIB_PATH + WEBLOGIC_JAR;
        return this.initClasspathEntries(new File(jar_path, weblogicJar).getAbsolutePath());
    }

    public String getVersion() {
        return this.m_version;
    }

    public Object newBuilder() {
        return new WeblogicJSPCompiler(this.m_classpathEntries);
    }

    private class WeblogicRegistryReader
    extends XMLFileReader
    implements IModelXMLConstants {
        private String m_install_path;

        protected WeblogicRegistryReader(File file) {
            super(file);
        }

        public String getInstallPath() {
            return this.m_install_path;
        }

        protected boolean process(StartElement element) {
            String name = element.getName().getLocalPart();
            if (name.equals("release")) {
                this.m_install_path = this.getAttribute(element, "InstallDir");
            }
            return super.process(element);
        }
    }
}

