/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.stage.java;

import com.hcl.clazz.info.ClassInfo;
import com.hcl.irx.stage.StageEventManager;
import com.hcl.irx.stage.java.JarAnalyzer;
import com.hcl.irx.stage.java.JavaStager;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.json.JSONObject;

public class FileJarAnalyzer
extends JarAnalyzer {
    private File m_file;

    public FileJarAnalyzer(File file, JSONObject memory_stats) throws IOException, ExclusionException {
        super(file.getName(), memory_stats, new FileInputStream(file));
        this.m_file = file;
    }

    public FileJarAnalyzer(String parent_name, JSONObject memory_stats, File file) throws IOException, ExclusionException {
        super(parent_name, memory_stats, new FileInputStream(file));
        this.m_file = file;
    }

    @Override
    protected void tearDownProcess() throws IOException, ExclusionException {
        try {
            this.resetStreamToNewStream(new FileInputStream(this.m_file));
            if (this.hasUserCode()) {
                this.extractUserCodeFromJar();
                this.close();
                if (this.get3rdPartyClassesAndExtraFilesIdentified().size() > 0) {
                    this.resetStreamToNewStream(new FileInputStream(this.m_file));
                    this.extract3rdPartyCodeFromJar();
                    this.close();
                }
            } else {
                this.close();
                if (JavaStager.isJavaJar(this.getNameOfArchive()) && this.get3rdPartyClassesAndExtraFilesIdentified().size() > 0) {
                    StageEventManager.fireAddDependencyFileReferenceEvent(this.m_file);
                }
            }
        }
        finally {
            this.close();
        }
    }

    private void extractUserCodeFromJar() throws IOException, ExclusionException {
        ZipEntry entry;
        ZipInputStream stream = null;
        stream = new ZipInputStream(this.getStream());
        while ((entry = stream.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            if (JavaStager.isJavaClass(entry.getName())) {
                if (!this.getUserClassesIdentified().contains(entry.getName())) continue;
                ClassInfo ci = new ClassInfo(JavaStager.getDataFromStream(stream), entry.toString());
                StageEventManager.fireStageClassInfoEvent(ci);
                continue;
            }
            if (!this.get3rdPartyClassesAndExtraFilesIdentified().contains(entry.getName())) continue;
            StageEventManager.fireStageExtraFileEvent(this.getNameOfArchive() + ".child", entry.getName(), stream);
        }
    }

    private void extract3rdPartyCodeFromJar() throws IOException, ExclusionException {
        ZipEntry entry;
        ZipInputStream stream = null;
        stream = new ZipInputStream(this.getStream());
        while ((entry = stream.getNextEntry()) != null) {
            if (entry.isDirectory() || !JavaStager.isJavaClass(entry.getName()) || !this.get3rdPartyClassesAndExtraFilesIdentified().contains(entry.getName())) continue;
            ClassInfo ci = new ClassInfo(JavaStager.getDataFromStream(stream), entry.toString());
            StageEventManager.fireStageLooseClassInfoEvent(ci);
        }
    }
}

