/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.stage.java;

import com.hcl.clazz.info.ClassInfo;
import com.hcl.irx.stage.Messages;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.NullProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class Jar {
    private JarOutputStream m_jar;
    private int m_entries;
    private File m_file;
    private IProgress m_progress;
    private Set<String> m_classes_added = new HashSet<String>();

    public Jar(File out, IProgress progress) throws FileNotFoundException, IOException {
        if (out.getParentFile() != null) {
            out.getParentFile().mkdirs();
        }
        if (!out.getPath().endsWith(".jar")) {
            out = new File(out.getPath() + ".jar");
        }
        this.m_file = out;
        this.m_jar = new JarOutputStream((OutputStream)new FileOutputStream(this.m_file), new Manifest());
        this.m_progress = progress;
        if (this.m_progress == null) {
            this.m_progress = new NullProgress();
        }
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean closeJar() {
        IOUtil.close((Closeable)this.m_jar);
        if (this.m_entries == 0) {
            this.m_file.delete();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassToJar(ClassInfo ca) throws IOException {
        if (this.m_classes_added.contains(ca.getClassName())) {
            this.m_progress.setStatus(new Message(1, Messages.getMessage("stage.duplicate.jar.entry", ca.getClassName())));
        } else {
            ByteArrayInputStream in = null;
            try {
                int read;
                this.m_classes_added.add(ca.getClassName());
                JarEntry jarAdd = new JarEntry(ca.getClassName().replaceAll("\\.", "/") + ".class");
                this.m_jar.putNextEntry(jarAdd);
                in = new ByteArrayInputStream(ca.getData());
                byte[] buffer = new byte[32768];
                while ((read = in.read(buffer, 0, buffer.length)) > 0) {
                    this.m_jar.write(buffer, 0, read);
                }
                in.close();
                this.m_jar.closeEntry();
                ++this.m_entries;
            }
            finally {
                this.m_jar.flush();
            }
        }
    }
}

